/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.common.data;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.annotation.FieldInfo;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.User;
import java.text.Normalizer;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class UserOpToolBasicData {
    private static final String OPENHELPFILE = "1";
    private static final String NOTOPENHELPFILE = "0";
    private static final String NO_PROXY = "0";
    private static final String SSH_FORWARD = "1";
    private static final String SOCKET5 = "2";
    private static final String PWSSWORD = "0";
    private static final String PUBLIC_KEY_PSD = "2";
    private static final String PUBLIC_KEY = "1";
    private static final String NO_AUTHWAY = "-1";
    private static final String IPV4 = "ipv4";
    private static final String IPV6 = "ipv6";
    private static final Pattern PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
    @FieldInfo(index=4, desc="\u4efb\u52a1\u5f00\u59cb\u65f6\u95f4", name="taskStartTime", isMust=true)
    private long taskStartTime;
    @FieldInfo(index=5, desc="\u4efb\u52a1\u7ed3\u675f\u65f6\u95f4", name="taskEndTime", isMust=true)
    private long taskEndTime;
    @FieldInfo(index=9, desc="\u8bbe\u5907SN", name="deviceSn", isMust=true)
    private String deviceSn;
    @FieldInfo(index=10, desc="\u8bbe\u5907\u7c7b\u578b", name="deviceType", isMust=true)
    private String deviceType;
    @FieldInfo(index=11, desc="\u8bbe\u5907\u7248\u672c", name="deviceVersion", isMust=true)
    private String deviceVersion;
    @FieldInfo(index=12, desc="\u4ee3\u7406\u65b9\u5f0f", name="proxyWay", isMust=true)
    private String proxyWay;
    @FieldInfo(index=13, desc="\u9274\u6743\u65b9\u5f0f", name="authWay", isMust=true)
    private String authWay;
    @FieldInfo(index=14, desc="\u4efb\u52a1\u7ed3\u679c", name="taskResult", isMust=true)
    private UserOpTaskResult taskResult = UserOpTaskResult.FAILED;
    @FieldInfo(index=32, desc="IP\u7c7b\u578b", name="ipv", isMust=false)
    private String ipv;
    @FieldInfo(index=30, desc="\u662f\u5426\u70b9\u51fb\u8054\u673a\u5e2e\u52a9", name="openHelpFile", isMust=false)
    private String openHelpFile;
    private DevNode devNode;
    private Map<String, Object> dynamicAttr = new TreeMap<String, Object>();

    public Map<String, Object> getDynamicAttr() {
        return this.dynamicAttr;
    }

    public void addDynamicAttr(String key, Object val) {
        this.dynamicAttr.put(key, val);
    }

    public void setDynamicAttr(Map<String, Object> dynamicAttr) {
        this.dynamicAttr = dynamicAttr;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public String getDeviceVersion() {
        return this.deviceVersion;
    }

    public void setDeviceVersion(String deviceVersion) {
        this.deviceVersion = deviceVersion;
    }

    public String getProxyWay() {
        return this.proxyWay;
    }

    public void setProxyWay(String proxyWay) {
        this.proxyWay = proxyWay;
    }

    public String getAuthWay() {
        return this.authWay;
    }

    public void setAuthWay(String authWay) {
        this.authWay = authWay;
    }

    public void setDevNode(DevNode devNode) {
        if (devNode != null) {
            this.devNode = devNode;
            this.setAuthWay(devNode);
            this.setProxyWay(devNode);
            this.setDeviceSn(devNode.getDeviceSerialNumber());
            this.setDeviceVersion(devNode.getProductVersion());
            this.setDeviceType(devNode.getDeviceType() == null ? "" : devNode.getDeviceType().toString());
            this.setIpv(devNode.getIp());
        }
    }

    private void setProxyWay(DevNode deNode) {
        this.proxyWay = null != deNode.getSocks5Proxy() ? "2" : (null != deNode.getSshForwardList() && !deNode.getSshForwardList().isEmpty() ? "1" : "0");
    }

    private void setAuthWay(DevNode deNode) {
        User user = deNode.getLoginUser();
        if (null == user) {
            this.authWay = NO_AUTHWAY;
            return;
        }
        if (deNode.getPriKey() != null && StringUtils.isNULLStr(user.getPassword())) {
            this.authWay = "1";
        }
        if (deNode.getPriKey() != null && !StringUtils.isNULLStr(user.getPassword())) {
            this.authWay = "2";
        }
        if (deNode.getPriKey() == null && !StringUtils.isNULLStr(user.getPassword())) {
            this.authWay = "0";
        }
    }

    public long getTaskStartTime() {
        return this.taskStartTime;
    }

    public void setTaskStartTime(long taskStartTime) {
        this.taskStartTime = taskStartTime;
    }

    public void setTaskStartTime(Date taskStartTime) {
        this.taskStartTime = DateUtil.toBeiJingTimeMillis(taskStartTime);
    }

    public long getTaskEndTime() {
        return this.taskEndTime;
    }

    public void setTaskEndTime(long taskEndTime) {
        this.taskEndTime = taskEndTime;
    }

    public void setTaskEndTime(Date taskEndTime) {
        this.taskEndTime = DateUtil.toBeiJingTimeMillis(taskEndTime);
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public void setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
    }

    public UserOpTaskResult getTaskResult() {
        return this.taskResult;
    }

    public void setTaskResult(UserOpTaskResult taskResult) {
        this.taskResult = taskResult;
    }

    public String getIpv() {
        return this.ipv;
    }

    public void setIpv(String ipv) {
        if (StringUtils.isNULLStr(ipv)) {
            this.ipv = "";
        } else {
            this.ipv = Normalizer.normalize(ipv, Normalizer.Form.NFKC);
            this.ipv = PATTERN.matcher(ipv).matches() ? IPV4 : IPV6;
        }
    }

    public String getOpenHelpFile() {
        return this.openHelpFile;
    }

    public void setOpenHelpFile(String openHelpFile) {
        this.openHelpFile = openHelpFile;
    }

    public void setOpenHelpFile(boolean isOpenHelpFile) {
        this.openHelpFile = isOpenHelpFile ? "1" : "0";
    }
}

