/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.impl;

import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.reflection.ReflectionUtils;
import com.huawei.ism.tool.framework.platform.common.annotation.FieldInfo;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolBasicData;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolData;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.impl.AbstractUserOpDataSev;
import com.huawei.ism.tool.framework.pubservice.service.IUserOpDataServ;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class UserOpDataServImpl
extends AbstractUserOpDataSev {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UserOpDataServImpl.class);
    private static IUserOpDataServ instance = null;

    private UserOpDataServImpl() {
    }

    public static synchronized IUserOpDataServ getInstance() {
        if (instance == null) {
            instance = new UserOpDataServImpl();
        }
        return instance;
    }

    @Override
    public <T extends UserOpToolBasicData> TaskResult batchSaveUserOpdata(List<T> userOpDatas) {
        return this.batchSaveUserOpdata(userOpDatas, null);
    }

    private <T extends UserOpToolBasicData> String saveOpDatas(List<T> userOpDatas, TaskResult tr, UserOpToolData commonData) throws IOException {
        String logFile = UserOpDataSaveUtil.lockAndGetLogWriteFile();
        this.execSave(userOpDatas, logFile, commonData);
        tr.setResult(TaskResult.Result.SUCCESS);
        return logFile;
    }

    private <T extends UserOpToolBasicData> void execSave(List<T> userOpDatas, String logFile, UserOpToolData commonData) throws IOException {
        UserOpToolData opCommonData = commonData != null ? commonData : ApplicationContext.getInstance().getUserOpData();
        List<Field> fileds = this.getAllFields(opCommonData, (UserOpToolBasicData)userOpDatas.get(0));
        this.refreshUser(opCommonData);
        String logs = this.appendLogs(userOpDatas, opCommonData, fileds);
        this.writeToFile(logFile, logs);
    }

    private void refreshUser(UserOpToolData opCommonData) {
        if ("unKnown".equals(opCommonData.getUserAccount())) {
            opCommonData.setUserAccount(ApplicationContext.getInstance().getSupportUser());
        }
    }

    private <T extends UserOpToolBasicData> String appendLogs(List<T> userOpDatas, UserOpToolData opCommonData, List<Field> fileds) {
        StringBuilder logs = new StringBuilder();
        for (UserOpToolBasicData opData : userOpDatas) {
            try {
                logs.append(this.getOpDataInJson(opData, opCommonData, fileds));
            }
            catch (Exception e) {
                LOGGER.error("append data error\uff1a" + opData.getDeviceSn(), (Throwable)e);
            }
        }
        return logs.toString();
    }

    private <T extends UserOpToolBasicData> void saveSingleOpData(T userOpData, String logFile, UserOpToolData commonData) {
        UserOpToolData opCommonData = commonData != null ? commonData : ApplicationContext.getInstance().getUserOpData();
        try {
            List<Field> fileds = this.getAllFields(opCommonData, userOpData);
            String logStr = this.getOpDataInJson(userOpData, opCommonData, fileds);
            this.writeToFile(logFile, logStr);
        }
        catch (Exception e) {
            LOGGER.error("save opdata error!", (Throwable)e);
        }
    }

    private <T extends UserOpToolBasicData> List<Field> getAllFields(UserOpToolData opCommonData, T userOpData) {
        LinkedList<Field> fieldList = new LinkedList<Field>();
        List<Field> commFields = UserOpDataSaveUtil.getFieldsNeed2Save(opCommonData);
        this.addFieldToList(fieldList, commFields);
        List<Field> toolFields = UserOpDataSaveUtil.getFieldsNeed2Save(userOpData);
        this.addFieldToList(fieldList, toolFields);
        this.sortFields(fieldList);
        return fieldList;
    }

    private void sortFields(List<Field> fieldList) {
        Collections.sort(fieldList, new MyFieldCompartor());
    }

    private void addFieldToList(List<Field> fieldList, List<Field> commFields) {
        for (Field field : commFields) {
            FieldInfo fieldInfo = field.getAnnotation(FieldInfo.class);
            if (fieldInfo == null || !fieldInfo.isSaveToFile()) continue;
            fieldList.add(field);
        }
    }

    private <T extends UserOpToolBasicData> String getOpDataInJson(T userOpData, UserOpToolData opCommonData, List<Field> fields) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder logBuilder = new StringBuilder().append('{');
        for (Field field : fields) {
            this.appendLogData(userOpData, opCommonData, logBuilder, field);
        }
        this.appendDynamicColumn(userOpData, logBuilder);
        this.removeLastChar(logBuilder);
        logBuilder.append("}\r\n");
        return logBuilder.toString();
    }

    private <T extends UserOpToolBasicData> void appendDynamicColumn(T userOpData, StringBuilder logBuilder) {
        Map<String, Object> dynamicAttr = userOpData.getDynamicAttr();
        for (Map.Entry<String, Object> entry : dynamicAttr.entrySet()) {
            this.appendKeyVal(logBuilder, entry.getKey(), entry.getValue());
        }
    }

    private <T extends UserOpToolBasicData> void appendLogData(T userOpData, UserOpToolData opCommonData, StringBuilder logBuilder, Field field) throws IllegalAccessException {
        FieldInfo fieldInfo = field.getAnnotation(FieldInfo.class);
        if (fieldInfo != null && fieldInfo.isSaveToFile()) {
            ReflectionUtils.setAccessable(field, true);
            Object val = this.getFieldVal(userOpData, field, opCommonData);
            this.appendKeyVal(logBuilder, UserOpDataSaveUtil.getFiledName(field), val);
        }
    }

    private void appendKeyVal(StringBuilder logBuilder, String key, Object val) {
        logBuilder.append("\"").append(key).append("\"").append(':').append(this.getValOfObj(val)).append(',');
    }

    private Object getValOfObj(Object val) {
        Class[] clazzs;
        if (val == null) {
            return "\"\"";
        }
        if (val instanceof Date) {
            return DateUtil.toBeiJingTimeMillis((Date)val);
        }
        Class<?> clazz = val.getClass();
        for (Class clazzTemp : clazzs = new Class[]{Integer.class, Long.class}) {
            if (!clazzTemp.getName().equals(clazz.getName())) continue;
            return val;
        }
        if (val instanceof JSONArray || val instanceof JSONObject) {
            return val;
        }
        return "\"" + val.toString() + "\"";
    }

    private void removeLastChar(StringBuilder logBuilder) {
        int idxOfComma = logBuilder.lastIndexOf(String.valueOf(','));
        if (idxOfComma > 0) {
            logBuilder.deleteCharAt(idxOfComma);
        }
    }

    private <T extends UserOpToolBasicData> Object getFieldVal(T userOpData, Field field, UserOpToolData opCommonData) throws IllegalAccessException {
        ReflectionUtils.setAccessable(field, true);
        if (UserOpToolData.isFieldsOfOwn(field)) {
            return field.get(opCommonData);
        }
        return field.get(userOpData);
    }

    private <T extends UserOpToolBasicData> boolean isParamsValid(List<T> userOpDatas) throws IllegalArgumentException, IllegalAccessException {
        if (userOpDatas.isEmpty()) {
            LOGGER.warn("Param list is empty");
            return false;
        }
        if (this.isAnnotationInValid((UserOpToolBasicData)userOpDatas.get(0))) {
            LOGGER.warn("annotation is invalid");
            return false;
        }
        return this.checkParamsInfo(userOpDatas);
    }

    private <T> boolean checkParamsInfo(List<T> userOpDatas) throws IllegalAccessException {
        for (T opData : userOpDatas) {
            if (this.checkParanInfoIsValid(opData)) continue;
            return false;
        }
        return true;
    }

    private <T> boolean checkParanInfoIsValid(T opData) throws IllegalAccessException {
        List<Field> filds = UserOpDataSaveUtil.getFieldsNeed2Save(opData);
        for (Field field : filds) {
            FieldInfo fieldInfo = field.getAnnotation(FieldInfo.class);
            if (fieldInfo == null || !fieldInfo.isMust() || !ReflectionUtils.isFieldNull(field, opData)) continue;
            LOGGER.warn("must input param:" + fieldInfo.name() + " is null!");
            return false;
        }
        return true;
    }

    private <T extends UserOpToolBasicData> boolean isAnnotationInValid(T opData) {
        HashSet<Integer> indexSet = new HashSet<Integer>();
        HashSet<String> nameSet = new HashSet<String>();
        List<Field> filds = UserOpDataSaveUtil.getFieldsNeed2Save(opData);
        for (Field field : filds) {
            FieldInfo fieldInfo = field.getAnnotation(FieldInfo.class);
            if (fieldInfo == null) continue;
            String fName = UserOpDataSaveUtil.getFiledName(field);
            if (indexSet.contains(fieldInfo.index()) || nameSet.contains(fName)) {
                LOGGER.error("there exists duplicated index or name in annotation!");
                return true;
            }
            indexSet.add(fieldInfo.index());
            nameSet.add(fName);
        }
        return false;
    }

    @Override
    public <T extends UserOpToolBasicData> TaskResult saveUserOpData(T userOpData) {
        return this.saveUserOpData(userOpData, null);
    }

    private <T extends UserOpToolBasicData> boolean isParamValid(T userOpData) throws IllegalAccessException {
        if (this.isAnnotationInValid(userOpData)) {
            LOGGER.warn("annotation is invalid");
            return false;
        }
        return this.checkParanInfoIsValid(userOpData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends UserOpToolBasicData> TaskResult batchSaveUserOpdata(List<T> userOpDatas, UserOpToolData commonData) {
        TaskResult tr;
        block9: {
            tr = new TaskResult();
            String logFile = null;
            FileLock lock = null;
            RandomAccessFile raf = null;
            try {
                if (!this.preSaveCheck(userOpDatas) || !this.isParamsValid(userOpDatas)) {
                    TaskResult taskResult = tr;
                    return taskResult;
                }
                this.setToolCloseDate(commonData);
                logFile = UserOpDataSaveUtil.lockAndGetLogWriteFile();
                raf = new RandomAccessFile(UserOpDataSaveUtil.getLockFileName(logFile), "rw");
                lock = FileUtils.getFileLock(new File(UserOpDataSaveUtil.getLockFileName(logFile)), raf);
                logFile = this.saveOpDatas(userOpDatas, tr, commonData);
                StreamUtils.closeResource(null, raf);
            }
            catch (RuntimeException e) {
                LOGGER.error("Write file error!", (Throwable)e);
                break block9;
            }
            catch (Exception e) {
                LOGGER.error("Write file error!", (Throwable)e);
                break block9;
            }
            finally {
                StreamUtils.closeResource(null, raf);
                UserOpDataSaveUtil.releaseLock(lock, logFile);
            }
            UserOpDataSaveUtil.releaseLock(lock, logFile);
        }
        return tr;
    }

    private void setToolCloseDate(UserOpToolData commonData) {
        if (commonData != null) {
            commonData.setCloseToolTime(DateUtil.toBeiJingTimeMillis(new Date()));
        } else {
            UserOpDataSaveUtil.setCloseToolTime(new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends UserOpToolBasicData> TaskResult saveUserOpData(T userOpData, UserOpToolData commonData) {
        RandomAccessFile raf;
        FileLock lock;
        String logFile;
        TaskResult tr;
        block5: {
            tr = new TaskResult();
            logFile = null;
            lock = null;
            raf = null;
            if (this.isParamValid(userOpData) && this.preSaveCheck(userOpData)) break block5;
            TaskResult taskResult = tr;
            StreamUtils.closeResource(null, raf);
            UserOpDataSaveUtil.releaseLock(lock, logFile);
            return taskResult;
        }
        try {
            logFile = UserOpDataSaveUtil.lockAndGetLogWriteFile();
            raf = new RandomAccessFile(UserOpDataSaveUtil.getLockFileName(logFile), "rw");
            lock = FileUtils.getFileLock(new File(UserOpDataSaveUtil.getLockFileName(logFile)), raf);
            this.saveSingleOpData(userOpData, logFile, commonData);
            tr.setResult(TaskResult.Result.SUCCESS);
        }
        catch (Exception e) {
            try {
                LOGGER.error("save opdata error!", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, raf);
                UserOpDataSaveUtil.releaseLock(lock, logFile);
                throw throwable;
            }
            StreamUtils.closeResource(null, raf);
            UserOpDataSaveUtil.releaseLock(lock, logFile);
        }
        StreamUtils.closeResource(null, raf);
        UserOpDataSaveUtil.releaseLock(lock, logFile);
        return tr;
    }

    private static final class MyFieldCompartor
    implements Comparator<Field>,
    Serializable {
        private static final long serialVersionUID = -1629578428137101460L;

        private MyFieldCompartor() {
        }

        @Override
        public int compare(Field o1, Field o2) {
            FieldInfo field1Info = o1.getAnnotation(FieldInfo.class);
            FieldInfo field2Info = o2.getAnnotation(FieldInfo.class);
            if (field1Info == null || field2Info == null) {
                return 0;
            }
            return field1Info.index() - field2Info.index();
        }
    }
}

