/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.tool.framwork.util.func;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.ProperUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.common.data.ToolLoginUser;
import com.huawei.ism.tool.framework.platform.common.data.ToolUserRole;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.json.JSONObject;
import java.io.File;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Objects;
import java.util.ResourceBundle;
import org.slf4j.Logger;

public class RightCtlUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RightCtlUtils.class);
    private static final long ONE_MINUTE = 60000L;
    private static final long ONE_DAY = 86400000L;
    private static final String ROLE = "role";
    private static final String USER_ID = "userId";
    private static final String FILE_NAME = "timeRecord.dat";
    private static final String PATH_FILE = "rightControl";
    public static final String START_TIME = "startTime";
    public static final String AUTH_FILE_PATH = "AuthFilePath";
    public static final String TIME_REC_PATH = "TimeRecordFilePath";
    public static final String LATEST_TIME = "lastTime";
    public static final String GUEST = "Guest";
    public static final String TOOLS_FOLDER = "tools";
    public static final String ALL_RIGHT = "all";
    public static final String VALID_TIME = "validTime";
    public static final String TOOL_RUN_ROLE = "toolRunRole";
    public static final String FAILED_NO_OPER = "{\"failedAction\":\"none\"}";
    public static final String FAILED_REACTIVE = "{\"failedAction\":\"reActive\"}";
    private static final String RELEASE_TIME_MARK = "20220610";
    private static final String CONFIGURATION = "configuration";

    private static String getFilePath() {
        String path = new StringBuffer().append(ApplicationContext.getInstance().getUserDataPath()).append(File.separator).append(PATH_FILE).append(File.separator).append(FILE_NAME).toString();
        return path;
    }

    public static JSONObject analysisDataFile(String filePath) {
        try {
            String path = filePath == null ? RightCtlUtils.getFilePath() : filePath;
            File file = new File(path);
            if (!file.exists()) {
                return null;
            }
            String originalContext = StreamUtils.readStringFormFile(file);
            String decryptContext = AESEncrypt.decrypt(originalContext);
            return new JSONObject(decryptContext);
        }
        catch (Exception e) {
            LOGGER.error("desc time file error!", (Throwable)e);
            return null;
        }
    }

    public static ToolLoginUser handleLoginUser(JSONObject authObj, JSONObject recordTimeObj) {
        if (authObj == null) {
            return null;
        }
        ToolLoginUser tu = ApplicationContext.getInstance().getToolLoginUser();
        try {
            String userId = authObj.getString(USER_ID);
            tu.setUserAccount(userId);
            ToolUserRole userRunRole = ToolUserRole.getToolRoleInfo(authObj.getString(ROLE));
            tu.setUserRunRole(userRunRole);
            tu.setUserRole(ToolUserRole.getRoleInfo(authObj.getString(ROLE)));
            tu.setAuthStartTime(authObj, recordTimeObj);
            long lastTimeLong = DateUtil.convertStringToDate("yyyy-MM-dd HH:mm:ss", recordTimeObj.getString(LATEST_TIME)).getTime();
            long curUseTime = Math.max(lastTimeLong, new Date().getTime());
            long usedTime = curUseTime - tu.getAuthStartTime();
            int daysToUse = Integer.parseInt(authObj.getString(VALID_TIME));
            tu.setLeftDays(RightCtlUtils.getRemainTimeInDays(daysToUse, usedTime));
            tu.setOverTime(RightCtlUtils.isOverTime(daysToUse, usedTime));
            String currentRole = System.getenv(TOOL_RUN_ROLE);
            if (null == currentRole) {
                currentRole = "not detected on environment";
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("user:" + tu.toString() + "  runrole:" + StringUtils.getCleanMessage(currentRole));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("error occered while getUserInfo!", (Throwable)e);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("isOverTime:" + tu.toString());
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("error occered while getUserInfo!", (Throwable)e);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("isOverTime:" + tu.toString());
            }
            return null;
        }
        return tu;
    }

    private static boolean isOverTime(long daysToUse, long usedTime) {
        return usedTime > 86400000L * daysToUse;
    }

    public static boolean isAllCanRun(String toolRunRight) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)toolRunRight) || ALL_RIGHT.equalsIgnoreCase(toolRunRight);
    }

    public static boolean isRoleCanRun(String toolRunRight, int runRoleCode) {
        return RightCtlUtils.isAllCanRun(toolRunRight) || toolRunRight.indexOf(String.valueOf(runRoleCode)) > -1;
    }

    public static boolean isCurToolSupportTrial() {
        String isSupportTrial = UserOpDataSaveUtil.getToolIniProp("tool.trial.not.support");
        return !"true".equalsIgnoreCase(isSupportTrial);
    }

    public static long getRemainTimeInMills(int daysToUse, long usedTime) {
        return (long)daysToUse * 86400000L - usedTime;
    }

    public static long getRemainTimeInMinutes(int daysToUse, long usedTime) {
        return RightCtlUtils.getRemainTimeInMills(daysToUse, usedTime) / 60000L;
    }

    public static int getRemainTimeInDays(int daysToUse, long usedTime) {
        return (int)(RightCtlUtils.getRemainTimeInMills(daysToUse, usedTime) / 86400000L);
    }

    public static boolean isEServiceRun() {
        String tolBoxSysProp = Paths.get(UserOpDataSaveUtil.getToolBoxPath(), CONFIGURATION, "system.properties").toString();
        String appName = ProperUtils.getInstance().getValue(new File(tolBoxSysProp), "app.name");
        String toolId = ResourceBundle.getBundle("application").getString("no.need.check.tools");
        return Objects.nonNull(appName) && toolId.contains(appName);
    }

    public static boolean isNewToolboxAndOldTool() {
        String tolBoxSysProp = Paths.get(UserOpDataSaveUtil.getToolBoxPath(), CONFIGURATION, "system.properties").toString();
        String tolToolIni = Paths.get(ApplicationContext.getInstance().getWorkPath(), "tool.ini").toString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("system config properties = {}", (Object)tolBoxSysProp);
        }
        String tolBoxReleaseDate = ProperUtils.getInstance().getValue(new File(tolBoxSysProp), "app.release.date").substring(0, 8);
        String tolReleaseDate = ProperUtils.getInstance().getValue(new File(tolToolIni), "date").replaceAll("-", "");
        LOGGER.info("the current toolBox release date is: {}, the current tool release date is: {}", (Object)tolBoxReleaseDate, (Object)tolReleaseDate);
        return tolBoxReleaseDate.compareTo(RELEASE_TIME_MARK) >= 0 && tolReleaseDate.compareTo(RELEASE_TIME_MARK) < 0;
    }

    public static boolean isOldToolboxAndNewTool() {
        String tolBoxSysProp = Paths.get(UserOpDataSaveUtil.getToolBoxPath(), CONFIGURATION, "system.properties").toString();
        String tolToolIni = Paths.get(ApplicationContext.getInstance().getWorkPath(), "tool.ini").toString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("system config properties = {}", (Object)tolBoxSysProp);
        }
        String tolBoxReleaseDate = ProperUtils.getInstance().getValue(new File(tolBoxSysProp), "app.release.date").substring(0, 8);
        String tolReleaseDate = ProperUtils.getInstance().getValue(new File(tolToolIni), "date").replaceAll("-", "");
        LOGGER.info("the current toolBox release date is: {}, the current tool release date is: {}", (Object)tolBoxReleaseDate, (Object)tolReleaseDate);
        return tolBoxReleaseDate.compareTo(RELEASE_TIME_MARK) < 0 && tolReleaseDate.compareTo(RELEASE_TIME_MARK) >= 0;
    }
}

