/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.parser;

import com.huawei.ism.tool.archivecollect.entity.ArchiveBizPackage;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.IBizPackageExtParser;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.wizardparse.util.PackagesResource;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ArchiveBizpackageParser
implements IBizPackageExtParser {
    private static final Logger log = LoggerFactory.getLogger(ArchiveBizpackageParser.class);
    private static final String STEP_ID_PREPARE = "prepare";
    private static final String STEP_ID_COLLECTSTANDARD = "collectStandard";
    private static final String STEP_ID_COLLECTEXTEND = "collectExtend";
    private static final String STEP_ID_COLLECT_FILE_FORM_ARRAY = "collectRunningData";
    private static final String STEP_ID_CLEAN = "clean";
    private static final Map<String, String> STEP_DESCRIPTION_MAP = new HashMap<String, String>();
    private static final String ARCHIVE_CFG_XML = "excelarchivecfg.xml";
    private static final String XML_TAG_SHEET = "sheet";
    private static final String XML_TAG_TABLE = "table";
    private static final List<String> STORAGE_LIST = Collections.unmodifiableList(Arrays.asList("Dstorage", "FusionCube"));

    public boolean parse(BizPackage bizPackage) {
        ArchiveBizPackage archiveBizPackage = (ArchiveBizPackage)bizPackage;
        this.initStepDescription(archiveBizPackage);
        if (STORAGE_LIST.contains(bizPackage.getName())) {
            return true;
        }
        try {
            this.initExcelSheetInfo(bizPackage, archiveBizPackage);
        }
        catch (ToolException e) {
            return false;
        }
        return true;
    }

    private void initExcelSheetInfo(BizPackage bizPackage, ArchiveBizPackage archiveBizPackage) throws ToolException {
        ArrayList<String> sheetNameList = new ArrayList<String>();
        HashMap<String, List<String>> sheetTableMap = new HashMap<String, List<String>>();
        this.initSheetTableMap(sheetNameList, sheetTableMap, bizPackage.getAbsolutPath());
        archiveBizPackage.setSheetNameList(sheetNameList);
        archiveBizPackage.setSheetTableMap(sheetTableMap);
    }

    private void initStepDescription(ArchiveBizPackage archiveBizPackage) {
        List processInfoList = archiveBizPackage.getProcessInfoes();
        for (ProcessInfo processInfo : processInfoList) {
            List nodeItemList = processInfo.getNodeItems();
            for (NodeItem nodeItem : nodeItemList) {
                String nodeItemId = nodeItem.getId();
                if (STEP_DESCRIPTION_MAP.containsKey(nodeItemId)) {
                    nodeItem.setDescription(STEP_DESCRIPTION_MAP.get(nodeItemId));
                    continue;
                }
                String descriptionKey = nodeItem.getDescription();
                PackagesResource packageResource = new PackagesResource(archiveBizPackage.getAbsolutPath());
                nodeItem.setDescription(packageResource.getString(descriptionKey));
            }
        }
    }

    private String getArchiveCfgPath(String packagePath) {
        StringBuffer sbFilePath = new StringBuffer();
        sbFilePath.append(packagePath);
        sbFilePath.append(File.separator);
        sbFilePath.append(ARCHIVE_CFG_XML);
        return sbFilePath.toString();
    }

    private void initSheetTableMap(List<String> sheetNameList, Map<String, List<String>> sheetTableMap, String packagePath) throws ToolException {
        FileInputStream fin;
        Document doc;
        block7: {
            doc = null;
            fin = null;
            String cfgPath = this.getArchiveCfgPath(packagePath);
            File cfgFile = new File(cfgPath);
            fin = new FileInputStream(cfgFile);
            doc = XmlUtils.parseDocument((InputStream)fin);
            if (doc != null) break block7;
            log.error("doc is null!");
            StreamUtils.closeStream(null, fin);
            return;
        }
        try {
            Element rootEle = doc.getDocumentElement();
            Collection sheetEleList = XmlUtils.getChildren((Element)rootEle, (String)XML_TAG_SHEET);
            for (Element sheetEle : sheetEleList) {
                String sheetName = sheetEle.getAttribute("name");
                sheetNameList.add(sheetName);
                ArrayList<String> tableNameList = new ArrayList<String>();
                Collection tableEleList = XmlUtils.getChildren((Element)sheetEle, (String)XML_TAG_TABLE);
                for (Element tableEle : tableEleList) {
                    String tableName = tableEle.getAttribute("name");
                    tableNameList.add(tableName);
                }
                sheetTableMap.put(sheetName, tableNameList);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new ToolException("file not found.");
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, fin);
                throw throwable;
            }
        }
        StreamUtils.closeStream(null, fin);
    }

    static {
        STEP_DESCRIPTION_MAP.put(STEP_ID_PREPARE, ResourceUtil.getString("archivecollect.step.desc.prepare"));
        STEP_DESCRIPTION_MAP.put(STEP_ID_COLLECTSTANDARD, ResourceUtil.getString("archivecollect.step.desc.collectStandard"));
        STEP_DESCRIPTION_MAP.put(STEP_ID_COLLECTEXTEND, ResourceUtil.getString("archivecollect.step.desc.collectExtend"));
        STEP_DESCRIPTION_MAP.put(STEP_ID_CLEAN, ResourceUtil.getString("archivecollect.step.desc.clean"));
        STEP_DESCRIPTION_MAP.put(STEP_ID_COLLECT_FILE_FORM_ARRAY, ResourceUtil.getString("archivecollect.step.desc.collectRunningData"));
    }
}

