/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.task;

import com.huawei.baize.cbb.gtsib.api.collector.IbCollector;
import com.huawei.ism.tool.archivecollect.context.DeviceArchiveContext;
import com.huawei.ism.tool.archivecollect.entity.CollectInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectResult;
import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.entity.CollectStepEnum;
import com.huawei.ism.tool.archivecollect.entity.CollectStepInfo;
import com.huawei.ism.tool.archivecollect.listener.ICollectListener;
import com.huawei.ism.tool.archivecollect.listener.IRefleshProgressListener;
import com.huawei.ism.tool.archivecollect.task.ArchiveEnvCreator;
import com.huawei.ism.tool.archivecollect.task.CollectTaskManager;
import com.huawei.ism.tool.archivecollect.utils.CompressFile;
import com.huawei.ism.tool.archivecollect.worktaker.IResultHandler;
import com.huawei.ism.tool.archivecollect.worktaker.impl.ArchiveCollectProcess;
import com.huawei.ism.tool.archivecollect.worktaker.impl.ExcelHandler;
import com.huawei.ism.tool.archivecollect.worktaker.impl.XmlHandler;
import com.huawei.ism.tool.base.utils.DateUtil;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.BizPackageService;
import com.huawei.ism.tool.bizpack.IProcessEnvCreator;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.ProcessInstance;
import com.huawei.ism.tool.bizpack.ProcessInstanceBuilder;
import com.huawei.ism.tool.bizpack.wizardparse.factory.ConnectorFactory;
import com.huawei.ism.tool.framework.platform.common.data.UserOpTaskResult;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolBasicData;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.util.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class CollectTask
implements Runnable,
IRefleshProgressListener {
    private static final Logger log = LoggerFactory.getLogger(CollectTask.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CollectTask.class);
    private static final int FINISH_PROGRESS = 100;
    private static final String PARAM_LANG = "lang";
    private static final String PARAM_DEV = "dev";
    private static final String PARAM_PATH = "path";
    private static final String PARAM_LISTENER = "listener";
    private static final String PARAM_RUNNING_DATA_LOCAL_PATH = "configFileLocalPath";
    private static final String PARAM_DEV_RESULT_PATH = "currentDevResultDir";
    private static final String PARAM_SITE_NAME = "siteName";
    private static final String PARAM_CONNECTION = "connectorFactory";
    private static final String TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String PARAM_LOGGER = "logger";
    private static final String COLLECT_FLOW_ID = "archivecollect";
    private static final String COMPRESS_FILE_PREFIX = "archive";
    private static final String UNDERLINE = "_";
    private static final String EXTENSION_ZIP = ".zip";
    private static final String IB_SMARTKITT_PREFIX = "IB_SmartKit_";
    private static final String IB_SMARTKITT_STORAGE_PREFIX = "IB_SmartKit_Storage_";
    private ICollectListener collectUiListener = null;
    private ICollectListener detailUiListener = null;
    private FileLock fileLock = null;
    private FileOutputStream fos = null;
    private CollectInfo collectInfo = null;
    private CollectProgressInfo collectProgressInfo = new CollectProgressInfo();
    private int totalProgress = 0;
    private DevNode devNode = null;
    private Map<String, CollectResult> resultMap = null;
    private ProcessInstance processInstance = null;
    private BizPackage bizPackage = null;
    private ArchiveCollectProcess collectProcessListener = new ArchiveCollectProcess();
    private DeviceArchiveContext context = DeviceArchiveContext.getInstance();
    private UserOpToolBasicData userOpData = new UserOpToolBasicData();

    public CollectTask(CollectInfo collectInfo, DevNode devNode, ICollectListener collectUiListener) {
        this.collectInfo = collectInfo;
        this.devNode = devNode;
        this.collectUiListener = collectUiListener;
    }

    public void initEnv() throws ToolException {
        this.totalProgress = 0;
        this.collectProgressInfo.setProcess(this.totalProgress);
        this.collectProgressInfo.setStatus(CollectStatusEnum.COLLECTING);
        this.collectProgressInfo.setDevNode(this.devNode);
        this.refleshUi();
        this.bizPackage = BizPackageService.getInstance().getBizPackage(this.devNode.getDeviceType().toString(), this.devNode.getProductVersion());
        if (null == this.bizPackage) {
            LOGGER.error("The biz package is null.");
            throw new ToolException("archivecollect.task.no.bizpackage");
        }
        HashMap<String, Object> paramsEnv = new HashMap<String, Object>();
        paramsEnv.put(PARAM_PATH, this.bizPackage.getAbsolutPath());
        paramsEnv.put(PARAM_LANG, LanguageManager.getInstance().getCurrentLanguage().getLanguage());
        paramsEnv.put(PARAM_DEV, this.devNode);
        paramsEnv.put(PARAM_LISTENER, this);
        paramsEnv.put(PARAM_CONNECTION, ConnectorFactory.getInstance());
        paramsEnv.put(PARAM_RUNNING_DATA_LOCAL_PATH, this.collectInfo.getReportSavePath());
        paramsEnv.put(PARAM_DEV_RESULT_PATH, this.getSavePath());
        paramsEnv.put(PARAM_SITE_NAME, this.collectInfo.getCustomerInfo().getSiteName());
        String loggerFileName = "archive_collect_py_" + this.devNode.getIp().replace(":", ".");
        paramsEnv.put(PARAM_LOGGER, ToolLoggerFactory.getLoggerInStandAlone((String)loggerFileName));
        ProcessInstanceBuilder instanceBuilder = new ProcessInstanceBuilder();
        instanceBuilder.addProcessListener((IProcessListener)this.collectProcessListener);
        instanceBuilder.setEnvCreator((IProcessEnvCreator)new ArchiveEnvCreator(paramsEnv));
        ProcessInfo processInfo = this.bizPackage.getProcessInfoByID(COLLECT_FLOW_ID);
        if (processInfo == null) {
            LOGGER.error("processInfo is null!");
            return;
        }
        this.processInstance = instanceBuilder.construct(processInfo);
        this.collectProcessListener.setProcessInstance(this.processInstance);
        this.collectProcessListener.setProcessInfo(processInfo);
        this.collectProcessListener.setCollectTask(this);
    }

    @Override
    public void refleshProgress(int progress) {
        int stepTotalProgress = this.collectProcessListener.getStepTotalProgress(progress);
        this.collectProgressInfo.setProcess(stepTotalProgress);
        this.refleshUi();
    }

    public void clean() {
    }

    public void initData() {
        this.totalProgress = 0;
        if (this.collectProgressInfo != null) {
            this.collectProgressInfo.setProcess(this.totalProgress);
            this.collectProgressInfo.setStatus(CollectStatusEnum.COLLECTING);
            this.collectProgressInfo.getCollectStepList().clear();
            this.collectProgressInfo.getCollectStepMap().clear();
        }
        if (this.resultMap != null) {
            this.resultMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.initData();
        this.userOpData.setDevNode(this.devNode);
        this.userOpData.setTaskStartTime(DateUtil.toBeiJingTimeMillis(new Date()));
        this.userOpData.setTaskResult(UserOpTaskResult.IN_COMPLETE);
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName("Thread_" + this.devNode.getDeviceSerialNumber());
        try {
            this.executeCollect();
            this.createReport();
            this.inStep(CollectStepEnum.COLLEC_FINISH.toString(), CollectStepEnum.COLLEC_FINISH.getStepId());
            this.outStep(CollectStepEnum.COLLEC_FINISH.getStepId(), CollectStepEnum.COLLEC_FINISH.getTotalProgress() + this.collectProgressInfo.getProcess(), CollectStatusEnum.COLLECT_FINISHED, "", null);
            String compressFileName = this.getCompressFileName();
            String sn = this.devNode.getDeviceSerialNumber();
            FilesUtil.copyFiles((File[])this.getTargetFiles(), (String)this.collectInfo.getIbmsSavePath());
            CompressFile.compressFileTo7z(compressFileName, DeviceArchiveContext.RESULT_SAVEPATH.get(sn));
            this.setFinalStatus();
            this.refleshUi();
        }
        catch (ToolException e) {
            LOGGER.error("Execute Archieve Task fail , error id is :" + e.getErrorId());
        }
        catch (Exception e) {
            LOGGER.error("Collect Archieve task run fail.");
        }
        finally {
            this.buildCollectMap(this.devNode, this.getCompressFileName());
            this.hasAllCollectOver();
            Thread.currentThread().setName(name);
            this.context.getNodeStatusMap().put(this.devNode, false);
            this.userOpData.setTaskEndTime(DateUtil.toBeiJingTimeMillis(new Date()));
            this.context.getUserOpData().add(this.userOpData);
        }
    }

    private File[] getTargetFiles() {
        File[] listFiles = new File(this.getSavePath()).listFiles();
        if (listFiles == null) {
            return new File[0];
        }
        return Arrays.stream(listFiles).filter(file -> file.getName().contains(IB_SMARTKITT_PREFIX) && file.getName().contains("xml")).collect(Collectors.toList()).toArray(new File[0]);
    }

    private String getCompressFileName() {
        String curDateStr = this.dateToStr(TIME_FORMAT);
        curDateStr = curDateStr.replaceAll(":", "");
        curDateStr = curDateStr.replaceAll("-", "");
        curDateStr = curDateStr.replaceAll(" ", "");
        StringBuffer sbReportPath = new StringBuffer();
        sbReportPath.append(this.getSavePath());
        sbReportPath.append(File.separator);
        sbReportPath.append(COMPRESS_FILE_PREFIX);
        sbReportPath.append(UNDERLINE);
        sbReportPath.append(curDateStr);
        sbReportPath.append(UNDERLINE);
        sbReportPath.append(this.devNode.getDeviceSerialNumber());
        sbReportPath.append(EXTENSION_ZIP);
        return sbReportPath.toString();
    }

    private String dateToStr(String format) {
        Date curDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String curDateStr = dateFormat.format(curDate);
        return curDateStr;
    }

    private List<String> getFilePathList(String newReportSavePath) {
        File file = new File(newReportSavePath);
        File[] listFiles = file.listFiles();
        ArrayList<String> filePathList = new ArrayList<String>();
        if (null != listFiles) {
            for (File listfile : listFiles) {
                try {
                    filePathList.add(listfile.getCanonicalPath());
                }
                catch (Exception e) {
                    LOGGER.error("get path error.", (Throwable)e);
                }
            }
        }
        return filePathList;
    }

    private List<String> getDifferentFileList(List<String> list1, List<String> list2) {
        ArrayList<String> list = new ArrayList<String>();
        if (list1.size() == list2.size()) {
            return list;
        }
        if (list2.size() < list1.size()) {
            for (String str : list1) {
                if (list2.contains(str)) continue;
                list.add(str);
            }
        } else {
            for (String str : list2) {
                if (list1.contains(str)) continue;
                list.add(str);
            }
        }
        return list;
    }

    public void inStep(String desc, String stepId) {
        CollectStepInfo collectStepInfo = new CollectStepInfo();
        collectStepInfo.setDate(new Date());
        collectStepInfo.setIp(this.devNode.getIp());
        collectStepInfo.setStatus(CollectStatusEnum.COLLECTING);
        collectStepInfo.setStepDesc(desc);
        this.collectProgressInfo.getCollectStepMap().put(stepId, collectStepInfo);
        this.collectProgressInfo.getCollectStepList().add(collectStepInfo);
        this.refleshUi();
    }

    public void outStep(String stepId, int progress, CollectStatusEnum collectStatus, String errMsg, Object resultDetail) {
        CollectStepInfo collectStepInfo = this.collectProgressInfo.getCollectStepMap().get(stepId);
        collectStepInfo.setDate(new Date());
        collectStepInfo.setStatus(collectStatus);
        collectStepInfo.setErrMsg(errMsg);
        collectStepInfo.setResultDetail(resultDetail);
        this.totalProgress = progress;
        this.collectProgressInfo.setProcess(this.totalProgress);
        this.refleshUi();
    }

    public void setDetailUiListener(ICollectListener detailUiListener) {
        this.detailUiListener = detailUiListener;
    }

    public CollectInfo getCollectInfo() {
        return this.collectInfo;
    }

    public void setResultMap(Map<String, CollectResult> resultMap) {
        this.resultMap = resultMap;
    }

    public Map<String, CollectResult> getResultMap() {
        return this.resultMap;
    }

    public CollectProgressInfo getCollectProgressInfo() {
        return this.collectProgressInfo;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    private void refleshUi() {
        if (this.collectUiListener != null) {
            this.collectUiListener.fireCollectProcess(this.collectProgressInfo);
        }
        if (this.detailUiListener != null) {
            this.detailUiListener.fireCollectProcess(this.collectProgressInfo);
        }
    }

    private void setFinalStatus() {
        List<CollectStepInfo> collectStepList = this.collectProgressInfo.getCollectStepList();
        for (CollectStepInfo collectStepInfo : collectStepList) {
            if (!collectStepInfo.getStatus().equals((Object)CollectStatusEnum.COLLECT_FAILED)) continue;
            LOGGER.info("Collection complete >> Device {} collect end][Failed", (Object)collectStepInfo.getIp());
            this.collectProgressInfo.setStatus(CollectStatusEnum.COLLECT_FAILED);
            this.userOpData.setTaskResult(UserOpTaskResult.FAILED);
            return;
        }
        for (CollectStepInfo collectStepInfo : collectStepList) {
            if (!collectStepInfo.getStatus().equals((Object)CollectStatusEnum.COLLECT_FINISHED_NOTALL)) continue;
            LOGGER.info("Collection complete >> Device {} collect end][Success", (Object)collectStepInfo.getIp());
            this.collectProgressInfo.setStatus(CollectStatusEnum.COLLECT_FINISHED_NOTALL);
            this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
            return;
        }
        this.collectProgressInfo.setStatus(CollectStatusEnum.COLLECT_FINISHED);
        this.userOpData.setTaskResult(UserOpTaskResult.SUCCESS);
        LOGGER.info("Collection complete >> Device {} collect end][Success", (Object)this.collectProgressInfo.getDevNode().getIp());
    }

    private void buildCollectMap(DevNode devNode, String compressFileName) {
        if (!CollectStatusEnum.COLLECT_FAILED.equals((Object)this.collectProgressInfo.getStatus())) {
            return;
        }
        HashMap<String, String> collectMap = new HashMap<String, String>();
        String errDetails = this.collectProgressInfo.getCollectStepList().stream().filter(collectStepInfo -> CollectStatusEnum.COLLECT_FAILED.equals((Object)collectStepInfo.getStatus())).map(CollectStepInfo::getErrMsg).collect(Collectors.joining("\n"));
        collectMap.put("deviceName", devNode.getDeviceName());
        collectMap.put("deviceType", devNode.getDeviceType().toString());
        collectMap.put("status", this.collectProgressInfo.getStatus().toString());
        collectMap.put("NE_Version", devNode.getProductVersion());
        collectMap.put("NE_Patch", devNode.getHotPatchVersion());
        collectMap.put("SN", devNode.getDeviceSerialNumber());
        collectMap.put("Details", errDetails);
        this.collectInfo.getCollectFailedInfos().add(collectMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hasAllCollectOver() {
        Class<CollectTask> clazz = CollectTask.class;
        synchronized (CollectTask.class) {
            CollectTaskManager taskManager = CollectTaskManager.getInstance();
            if (this.hasAllTaskDeviceCollectOver(taskManager)) {
                this.collectForEnterpriseStorage();
                this.compressIbms();
            }
            if (taskManager.hasAllDeviceCollectOver()) {
                this.collectUiListener.fireAllCollectOver();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void collectForEnterpriseStorage() {
        try {
            IbCollector collector = (IbCollector)IbCollector.INSTANCE.get();
            collector.collectWithResultList(this.collectInfo.getIbmsSavePath(), new File(this.collectInfo.getIbmsSavePath()).getParentFile().getCanonicalPath(), CollectTask.getLanguageParam(), this.collectInfo.getCollectFailedInfos());
        }
        catch (Exception e) {
            log.error("Build ib result for enterprise storage failed.", (Throwable)e);
        }
    }

    @NonNull
    private static String getLanguageParam() {
        return ApplicationContext.getInstance().isEnglishEnv() ? "en_US" : "zh_CN";
    }

    private boolean hasAllTaskDeviceCollectOver(CollectTaskManager taskManager) {
        List<DevNode> devNodeList = this.collectInfo.getDevNodeList();
        if (Utils.isNullList(devNodeList)) {
            log.error("The devNodeList is empty.");
            return false;
        }
        return devNodeList.stream().allMatch(devNode -> this.deviceCollectOver(taskManager.getCollectTask(devNode.getDeviceSerialNumber()).getCollectProgressInfo().getStatus()));
    }

    private boolean deviceCollectOver(CollectStatusEnum status) {
        return !status.equals((Object)CollectStatusEnum.NOT_COLLECT) && !status.equals((Object)CollectStatusEnum.COLLECTING);
    }

    private void compressIbms() {
        String filePath = this.collectInfo.getIbmsSavePath();
        File file = new File(filePath);
        if (!file.exists()) {
            log.warn("The IBMS root directory does not exist.");
            return;
        }
        CompressFile.compressFileTo7z(this.getCompressIbmsFileName(), this.getFilePathList(filePath));
        log.info("delete the directory : {}", (Object)file.getName());
        FileUtils.deleteFile(file);
    }

    private String getCompressIbmsFileName() {
        String curDateStr = this.dateToStr(TIME_FORMAT);
        curDateStr = curDateStr.replace(":", "").replace("-", "").replace(" ", "");
        return new StringBuffer(this.collectInfo.getReportSavePath()).append(File.separator).append(IB_SMARTKITT_STORAGE_PREFIX).append(curDateStr).append(EXTENSION_ZIP).toString();
    }

    private void executeCollect() throws ToolException {
        String newReportSavePath = this.getSavePath();
        List<String> fileList1 = this.getFilePathList(newReportSavePath);
        try {
            this.processInstance.process();
        }
        catch (Exception e) {
            this.collectProgressInfo.setStatus(CollectStatusEnum.COLLECT_FAILED);
            this.outStep(CollectStepEnum.CREATE_REPORT.getStepId(), 100, CollectStatusEnum.COLLECT_FAILED, ResourceUtil.getString("archivecollect.exception.script"), null);
            throw new ToolException(e.getMessage(), false, (Throwable)e);
        }
        finally {
            this.resultMap = this.collectProcessListener.getCollectResultMap();
            List<String> fileList2 = this.getFilePathList(newReportSavePath);
            List<String> defferentList = this.getDifferentFileList(fileList1, fileList2);
            if (!defferentList.isEmpty()) {
                List<String> filePathList = DeviceArchiveContext.RESULT_SAVEPATH.get(this.devNode.getIp());
                if (null == filePathList) {
                    filePathList = defferentList;
                } else {
                    filePathList.addAll(defferentList);
                }
                DeviceArchiveContext.RESULT_SAVEPATH.put(this.devNode.getDeviceSerialNumber(), filePathList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReport() throws ToolException {
        Class<CollectTask> clazz = CollectTask.class;
        synchronized (CollectTask.class) {
            this.inStep(CollectStepEnum.CREATE_REPORT.toString(), CollectStepEnum.CREATE_REPORT.getStepId());
            try {
                String newReportSavePath = this.getSavePath();
                String packagePath = this.bizPackage.getAbsolutPath();
                IResultHandler resultHandler = new XmlHandler(this.resultMap, this.collectInfo, this.devNode, packagePath, newReportSavePath);
                resultHandler.createResult();
                CollectResult extendResult = this.resultMap.get("collectExtend");
                if (extendResult != null) {
                    resultHandler = new ExcelHandler(extendResult.getReturnData(), this.devNode, newReportSavePath, this.bizPackage, this.collectInfo.getCustomerInfo());
                    resultHandler.createResult();
                }
            }
            catch (Exception e) {
                this.collectProgressInfo.setStatus(CollectStatusEnum.COLLECT_FAILED);
                this.outStep(CollectStepEnum.CREATE_REPORT.getStepId(), 100, CollectStatusEnum.COLLECT_FAILED, ResourceUtil.getString("archivecollect.exception.report"), null);
                throw new ToolException(e.getMessage(), false, (Throwable)e);
            }
            this.outStep(CollectStepEnum.CREATE_REPORT.getStepId(), CollectStepEnum.CREATE_REPORT.getTotalProgress() + this.collectProgressInfo.getProcess(), CollectStatusEnum.COLLECT_FINISHED, "", null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private String getSavePath() {
        String oldReportSavePath = this.collectInfo.getReportSavePath();
        String devIpStr = this.devNode.getIp().replaceAll(":", ".");
        String newReportSavePath = oldReportSavePath + File.separator + devIpStr;
        FileUtils.createDir(newReportSavePath);
        return newReportSavePath;
    }
}

