/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.task;

import com.huawei.ism.tool.archivecollect.entity.CollectInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.listener.ICollectListener;
import com.huawei.ism.tool.archivecollect.task.CollectTask;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.LoggerFactory;

public final class CollectTaskManager {
    private static CollectTaskManager instance = new CollectTaskManager();
    private static final int MAX_DEVICE_COUNT = 20;
    private ExecutorService executorService = Executors.newFixedThreadPool(20);
    private Map<String, CollectTask> devCollectTaskMap = new HashMap<String, CollectTask>();

    private CollectTaskManager() {
    }

    public static CollectTaskManager getInstance() {
        return instance;
    }

    public void addCollectTask(CollectInfo collectInfo, DevNode devNode, ICollectListener collectUiListener) throws ToolException {
        LoggerFactory.getLogger(CollectTaskManager.class).info("Collection start >> device " + devNode.getIp() + " collect begin][Success");
        CollectTask collectTask = new CollectTask(collectInfo, devNode, collectUiListener);
        this.devCollectTaskMap.put(devNode.getDeviceSerialNumber(), collectTask);
        collectTask.initEnv();
        this.executorService.execute(collectTask);
    }

    public CollectTask getCollectTask(String devNodeSn) {
        return this.devCollectTaskMap.get(devNodeSn);
    }

    public Collection<CollectTask> getAllCollectTask() {
        return this.devCollectTaskMap.values();
    }

    public boolean hasAllDeviceCollectOver() {
        Collection<CollectTask> collectTaskList = this.devCollectTaskMap.values();
        boolean hasAllOver = true;
        for (CollectTask collectTask : collectTaskList) {
            CollectProgressInfo collectProgress = collectTask.getCollectProgressInfo();
            CollectStatusEnum collectStatus = collectProgress.getStatus();
            if (!collectStatus.equals((Object)CollectStatusEnum.NOT_COLLECT) && !collectStatus.equals((Object)CollectStatusEnum.COLLECTING)) continue;
            hasAllOver = false;
            break;
        }
        return hasAllOver;
    }
}

