/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.action;

import com.huawei.ism.tool.archivecollect.context.DeviceArchiveContext;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.bizpack.PackProduct;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.framework.pubui.entity.DeviceDialogType;
import com.huawei.ism.tool.framework.pubui.entity.DeviceManageSetting;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDeviceAction
extends ToolHyperLinkLabel.ClickAdapter
implements INodeSupport {
    private static final long serialVersionUID = -6511589706213142361L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AddDeviceAction.class);
    private JDialog parent;
    private DeviceManageSetting manageSetting;

    public AddDeviceAction(JDialog parent) {
        this.parent = parent;
    }

    public void actionPerformed(ActionEvent e) {
        DeviceArchiveContext.getInstance().setSupport(true);
        DeviceArchiveContext.getInstance().getUnSupportDevs().clear();
        IDeviceManageUI connUi = PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        this.initManageSetting();
        boolean flag = connUi.showAddDeviceDialog(this.parent, this.getSupportTypeVersions(), this, DeviceDialogType.All, this.manageSetting);
        if (!flag) {
            LOGGER.error("show add device dialog err.");
        }
        if (!DeviceArchiveContext.getInstance().isSupport()) {
            StringBuilder ips = new StringBuilder();
            for (String ip : DeviceArchiveContext.getInstance().getUnSupportDevs()) {
                ips.append(ip);
                ips.append(",");
            }
            String unSupportIps = ips.substring(0, ips.length() - 1);
            DialogUtils.showErrorDialog((JDialog)this.parent, (String)ResourceUtil.getStringWithParams("archivecollect.remind.product.notsupport", unSupportIps));
        }
    }

    private void initManageSetting() {
        this.manageSetting = new DeviceManageSetting(false, true, true);
        ArrayList<ItDeviceType> itDeviceList = new ArrayList<ItDeviceType>();
        HashMap<ItDeviceType, List<String>> deviceTypeView = new HashMap<ItDeviceType, List<String>>();
        itDeviceList.addAll(Arrays.asList(ItDeviceType.Storage, ItDeviceType.FUSIONCUBE));
        deviceTypeView.put(ItDeviceType.Storage, null);
        deviceTypeView.put(ItDeviceType.FUSIONCUBE, null);
        this.manageSetting.setItDeviceList(itDeviceList);
        this.manageSetting.setDeviceTypel2(deviceTypeView);
    }

    private List<String> getSupportTypeVersions() {
        ArrayList<String> supportTypeVersions = new ArrayList<String>();
        List packProductList = BizPackageContext.getInstance().getPackProducts();
        for (PackProduct packProduct : packProductList) {
            List versionList = packProduct.getVersions();
            for (String version : versionList) {
                String typeVersion = packProduct.getProductName() + " " + version;
                supportTypeVersions.add(typeVersion);
            }
        }
        return supportTypeVersions;
    }

    @Override
    public boolean isNodeSupport(DevNode dev) {
        return BizPackageContext.getInstance().isSupportDev(dev);
    }
}

