/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.context.DeviceArchiveContext;
import com.huawei.ism.tool.archivecollect.entity.CollectInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.entity.CustomerInfo;
import com.huawei.ism.tool.archivecollect.listener.ICollectListener;
import com.huawei.ism.tool.archivecollect.ui.action.AddDeviceAction;
import com.huawei.ism.tool.archivecollect.ui.action.DetailLinkAction;
import com.huawei.ism.tool.archivecollect.ui.dialog.ArchiveCollectMainDialogLayout;
import com.huawei.ism.tool.archivecollect.ui.dialog.CollectTaskAction;
import com.huawei.ism.tool.archivecollect.ui.dialog.ExploreButtonListener;
import com.huawei.ism.tool.archivecollect.ui.dialog.FlashRowTaskRunnable;
import com.huawei.ism.tool.archivecollect.ui.listener.CollectMainWindowListener;
import com.huawei.ism.tool.archivecollect.ui.listener.DirSetupButtonListener;
import com.huawei.ism.tool.archivecollect.utils.ArchiveCollectSceneUtil;
import com.huawei.ism.tool.archivecollect.utils.FilesUtil;
import com.huawei.ism.tool.archivecollect.worktaker.ICollectWorktaker;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.ui.tablecompositer.IpAddressStrategy;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.bizpack.BizPackageService;
import com.huawei.ism.tool.bizpack.wizardparse.context.BizPackageContext;
import com.huawei.ism.tool.bizpack.wizardparse.ui.action.QuerySupportProductAction;
import com.huawei.ism.tool.devicemanager.service.implement.BaseExecuter;
import com.huawei.ism.tool.devicemanager.ui.action.support.SubDialogUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.IDeviceManage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.listener.INodeObserver;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IDeviceManageUI;
import com.huawei.ism.tool.obase.entity.CheckDevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.plaf.RootPaneUI;
import org.slf4j.Logger;

public class ArchiveCollectMainDialog
extends JDialog
implements ICollectListener,
INodeObserver,
IHelpActionCallBack {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ArchiveCollectMainDialog.class);
    private static final int MIN_CAPACITY = 128;
    private static final ImageIcon SUCCESS_IMAGE = ResourceUtil.getImage("success.png");
    private static final ImageIcon SUCCESS_NOTALL_IMAGE = ResourceUtil.getImage("warning.png");
    private static final ImageIcon FAILED_IMAGE = ResourceUtil.getImage("failed.png");
    private static final ImageIcon PROCESSING_IMAGE = ResourceUtil.getImage("loading.gif");
    private ArchiveCollectMainDialogLayout mainDialogLayout = null;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private Map<String, String> failMap = new HashMap<String, String>();
    private DeviceArchiveContext context = DeviceArchiveContext.getInstance();
    private ArrayList<List<Object>> failRet = new ArrayList();

    public ArchiveCollectMainDialog(Window parent) {
        super(parent);
        this.initUI();
        this.initData();
        this.addListener();
    }

    private void initUI() {
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.rootPaneUI.setHelpActionCallBack((IHelpActionCallBack)this);
        this.mainDialogLayout = new ArchiveCollectMainDialogLayout();
        this.mainDialogLayout.setCompName();
        this.setLayout(new BorderLayout());
        this.add(this.mainDialogLayout);
        this.setTitle(ResourceUtil.getString("archivecollect.title"));
        this.setIconImage(ResourceUtil.getImage("archivecollect.png").getImage());
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
    }

    private void initData() {
        this.mainDialogLayout.getDeviceTable().removeAll();
        IDeviceManage deviceManage = PublicServiceManage.getInstance().getService(IDeviceManage.class);
        List<DevNode> devs = deviceManage.getNodeList();
        this.saveDeviceInfo(devs);
        if (!this.failRet.isEmpty()) {
            SubDialogUtils.showMultiInfoDialogOnTop((String)ResourceUtil.getString("devicemanager.layout.initdate.nosupportdev"), (String[])new String[]{ResourceUtil.getString("devicemanager.layout.initdate.nosupportdevip"), ResourceUtil.getString("devicemanager.layout.initdate.nosupportdevsn")}, this.failRet);
        }
    }

    private void saveDeviceInfo(List<DevNode> devs) {
        for (DevNode dev : devs) {
            BizPackage bizPkg = BizPackageService.getInstance().getBizPackage(dev.getDeviceType().toString(), dev.getProductVersion());
            if (null != bizPkg) {
                this.mainDialogLayout.getDeviceTableModel().addRow(new TableRow[]{this.createTableRow(dev)});
                if (!ArchiveCollectSceneUtil.isScene() || !ArchiveCollectSceneUtil.needSelectedDev(dev.getDeviceSerialNumber())) continue;
                int rowNum = this.mainDialogLayout.getDeviceTable().getRowCount() - 1;
                this.mainDialogLayout.getDeviceTable().addRowSelectionInterval(rowNum, rowNum);
                continue;
            }
            ArrayList<String> unSupportDev = new ArrayList<String>();
            unSupportDev.add(dev.getIp());
            unSupportDev.add(dev.getDeviceSerialNumber());
            this.failRet.add(unSupportDev);
            LOGGER.info("{} is not support.", (Object)dev.getIp());
        }
    }

    private TableRow<DevNode, String> createTableRow(DevNode dev) {
        DefaultTableRow row = new DefaultTableRow(this.mainDialogLayout.getTableColumn(), (Object)dev, (Object)dev.getDeviceSerialNumber());
        int num = 0;
        String deviceName = dev.getDeviceName();
        row.setValueAt(num++, (Object)deviceName);
        row.setValueAt(num++, (Object)(dev.getDeviceType() + " " + dev.getProductVersion()));
        row.setValueAt(num++, (Object)new IpAddressStrategy(dev.getIp()));
        int currentProgress = 0;
        row.setValueAt(num++, (Object)new IsmTableCell.ProgressCell(currentProgress));
        CollectStatusEnum status = CollectStatusEnum.NOT_COLLECT;
        row.setValueAt(num++, (Object)this.getStatusCell(status));
        String cellName = ResourceUtil.getString("archivecollect.devicetable.head.checkdetail");
        IsmTableCell.HyperlinkCell detailCell = new IsmTableCell.HyperlinkCell(cellName, (ActionListener)new DetailLinkAction(this, dev));
        row.setValueAt(num++, (Object)detailCell);
        return row;
    }

    public IsmTableCell getStatusCell(CollectStatusEnum status) {
        switch (status) {
            case COLLECTING: {
                PROCESSING_IMAGE.setImageObserver(this);
                return new IsmTableCell.IconCell((Icon)PROCESSING_IMAGE, status.toString());
            }
            case COLLECT_FAILED: {
                return new IsmTableCell.IconCell((Icon)FAILED_IMAGE, status.toString());
            }
            case COLLECT_FINISHED: {
                return new IsmTableCell.IconCell((Icon)SUCCESS_IMAGE, status.toString());
            }
            case COLLECT_FINISHED_NOTALL: {
                return new IsmTableCell.IconCell((Icon)SUCCESS_NOTALL_IMAGE, status.toString());
            }
        }
        return new IsmTableCell.TextCell(status.toString());
    }

    private void addListener() {
        this.addWindowListener(new CollectMainWindowListener(this));
        this.mainDialogLayout.getAddDeviceLabel().addClickListener((ToolHyperLinkLabel.ClickListener)new AddDeviceAction(this));
        this.addNodeObserver();
        this.mainDialogLayout.getSupportProductLabel().addClickListener((ToolHyperLinkLabel.ClickListener)new QuerySupportProductAction((JDialog)this));
        this.mainDialogLayout.getExploreButton().addActionListener(new ExploreButtonListener(this));
        this.mainDialogLayout.getSetPathButton().addActionListener(new DirSetupButtonListener(this));
        this.mainDialogLayout.getCollectButton().addActionListener(new CollectTaskAction(this));
    }

    private void addNodeObserver() {
        IDeviceManage devMng = PublicServiceManage.getInstance().getService(IDeviceManage.class);
        devMng.addNodeObservers(this);
    }

    public boolean isSelectedDevCollecting() {
        ConcurrentHashMap<DevNode, Boolean> currStatusMap = this.context.getNodeStatusMap();
        for (Map.Entry<DevNode, Boolean> entry : currStatusMap.entrySet()) {
            if (!Boolean.TRUE.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public void changeNodeStatus(DevNode devNode, Boolean flag) {
        this.context.getNodeStatusMap().put(devNode, flag);
    }

    public Boolean findNodeStatus(DevNode devNode) {
        Boolean flag = this.context.getNodeStatusMap().get(devNode);
        if (flag == null) {
            return Boolean.FALSE;
        }
        return flag;
    }

    public void unableUiInput() {
        this.mainDialogLayout.getSiteNameText().setEditable(false);
        this.mainDialogLayout.getContactorText().setEditable(false);
        this.mainDialogLayout.getCellPhoneText().setEditable(false);
        this.mainDialogLayout.getTelePhoneText().setEditable(false);
        this.mainDialogLayout.getEmailText().setEditable(false);
        this.mainDialogLayout.getSiteAdressText().setEditable(false);
    }

    public CollectInfo generateColletInfo() {
        CollectInfo collectInfo = new CollectInfo();
        CustomerInfo cusInfo = this.generateCostumerInfo();
        collectInfo.setCustomerInfo(cusInfo);
        collectInfo.setReportSavePath(this.mainDialogLayout.getCollectPathText().getText());
        return collectInfo;
    }

    private CustomerInfo generateCostumerInfo() {
        CustomerInfo customerInfo = new CustomerInfo();
        customerInfo.setSiteName(this.mainDialogLayout.getSiteNameText().getText());
        customerInfo.setContractName(this.mainDialogLayout.getContactorText().getText());
        customerInfo.setCellPhoneNumber(this.mainDialogLayout.getCellPhoneText().getText());
        customerInfo.setTelephoneNumber(this.mainDialogLayout.getTelePhoneText().getText());
        customerInfo.setEmail(this.mainDialogLayout.getEmailText().getText());
        customerInfo.setSiteAddress(this.mainDialogLayout.getSiteAdressText().getText());
        return customerInfo;
    }

    public List<DevNode> getSelectedDevNode() {
        ArrayList<DevNode> selectedDevs = new ArrayList<DevNode>();
        DevNode devNode = null;
        int[] rowIndexs = this.mainDialogLayout.getDeviceTable().getSelectedRows();
        if (rowIndexs == null || rowIndexs.length == 0) {
            return selectedDevs;
        }
        for (int index : rowIndexs) {
            index = this.mainDialogLayout.getDeviceTable().convertRowIndexToModel(index);
            TableRow row = this.mainDialogLayout.getDeviceTableModel().getRow(index);
            devNode = (DevNode)row.getUserObject();
            selectedDevs.add(devNode);
        }
        return selectedDevs;
    }

    public boolean isDevsCanCollect(List<DevNode> devs) {
        return this.queryDevStatus(devs);
    }

    private boolean queryDevStatus(List<DevNode> devs) {
        ArrayList<CheckDevNode> checkDevNodes = new ArrayList<CheckDevNode>();
        IDeviceManageUI connUi = PublicUiManage.getInstance().getUi(IDeviceManageUI.class);
        String language = ApplicationContext.getInstance().getCurrentLanguage().toString();
        for (DevNode devNode : devs) {
            String devType = devNode.getDeviceType().toString();
            BizPackage bizPackage = BizPackageService.getInstance().getBizPackage(devType, devNode.getProductVersion());
            if (null == bizPackage) {
                LOGGER.error("Get package of " + devType + " error!");
                continue;
            }
            String path = bizPackage.getAbsolutPath();
            File file = new File(path, "queryDevStatus.py");
            LOGGER.info("query py file :{} queryDevStatus.py", (Object)bizPackage.getAbsolutPath());
            if (!file.exists()) continue;
            com.huawei.ism.tool.obase.entity.DevNode node = EntityUtils.toOldDev((DevNode)devNode);
            CheckDevNode checkDevNode = new CheckDevNode();
            checkDevNode.setDevNode(node);
            checkDevNode.setScriptDir(new File(path));
            checkDevNodes.add(checkDevNode);
        }
        Map deviceMap = new HashMap();
        if (!checkDevNodes.isEmpty()) {
            BaseExecuter executer = new BaseExecuter(language, checkDevNodes);
            deviceMap = executer.queryDevStatus();
        }
        return connUi.showMultiInfoDialog(this, EntityUtils.toShowMsg(deviceMap), true);
    }

    public boolean isInputOk() {
        String siteName = this.mainDialogLayout.getSiteNameText().getText();
        siteName = Normalizer.normalize(siteName, Normalizer.Form.NFKC);
        String emailText = this.mainDialogLayout.getEmailText().getText();
        emailText = Normalizer.normalize(emailText, Normalizer.Form.NFKC);
        String collectPath = this.mainDialogLayout.getCollectPathText().getText();
        File collectPathFile = null;
        try {
            collectPathFile = new File(collectPath).getCanonicalFile();
        }
        catch (IOException e) {
            LOGGER.error("Can not create Collect File by path input!");
        }
        if (StringUtils.isNULLStr(siteName)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString("archivecollect.remind.sitenameempty"));
            return false;
        }
        if (!StringUtils.isNULLStr(emailText) && !this.isEmailAddress(emailText)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString("archivecollect.remind.emailnotleggal"));
            return false;
        }
        if (!FilesUtil.isValidPath(collectPathFile, 128)) {
            DialogUtils.showInfoDialog((JDialog)this, (String)ResourceUtil.getString("archivecollect.remind.collectptheleggal"));
            return false;
        }
        return true;
    }

    private boolean isEmailAddress(String email) {
        if (email.contains("..")) {
            return false;
        }
        return email.matches("^[\\w-_\\/]+[\\w-_\\/.]*+@([\\w-_\\/]+[.])+[-_\\/\\w]+$");
    }

    public boolean isCollecting(List<DevNode> devs) {
        for (DevNode dev : devs) {
            CollectStatusEnum collectStatus = WorktakerUtil.getWorktaker(ICollectWorktaker.class).getDevCollectStatus(dev);
            if (CollectStatusEnum.COLLECTING.ordinal() != collectStatus.ordinal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void fireCollectProcess(CollectProgressInfo collectProcessInfo) {
        if (null == collectProcessInfo) {
            return;
        }
        FlashRowTaskRunnable flashTask = new FlashRowTaskRunnable(collectProcessInfo, this);
        SwingUtilities.invokeLater(flashTask);
    }

    public TableRow<DevNode, String> getTableRow(String id) {
        List tableRows = this.mainDialogLayout.getDeviceTableModel().getAllRows();
        for (TableRow row : tableRows) {
            if (!id.equals(row.getIdentifier())) continue;
            return row;
        }
        return null;
    }

    public void setMainDialogLayout(ArchiveCollectMainDialogLayout mainDialogLayout) {
        this.mainDialogLayout = mainDialogLayout;
    }

    public ArchiveCollectMainDialogLayout getMainDialogLayout() {
        return this.mainDialogLayout;
    }

    @Override
    public void fireNodeAdd(DevNode dev) {
        BizPackageContext allContext = BizPackageContext.getInstance();
        String ipTmp = dev.getIp();
        LOGGER.info("devs ip={}", (Object)ipTmp);
        if (!"".equals(ipTmp)) {
            LOGGER.info("devs ip={}", (Object)ipTmp);
        }
        if (!allContext.isSupportDev(dev) || dev.getLoginUser().getUserName().startsWith("domain/")) {
            LOGGER.info("devs ip={} is ignored", (Object)ipTmp);
            DeviceArchiveContext.getInstance().setSupport(false);
            DeviceArchiveContext.getInstance().getUnSupportDevs().add(ipTmp);
            return;
        }
        this.mainDialogLayout.getDeviceTableModel().addRow(new TableRow[]{this.createTableRow(dev)});
    }

    @Override
    public void fireNodeDelete(DevNode dev) {
    }

    @Override
    public void fireNodeModify(DevNode dev) {
    }

    @Override
    public void fireAllCollectOver() {
        this.enableUiInput();
    }

    private void enableUiInput() {
        this.mainDialogLayout.getSiteNameText().setEditable(true);
        this.mainDialogLayout.getContactorText().setEditable(true);
        this.mainDialogLayout.getCellPhoneText().setEditable(true);
        this.mainDialogLayout.getTelePhoneText().setEditable(true);
        this.mainDialogLayout.getEmailText().setEditable(true);
        this.mainDialogLayout.getSiteAdressText().setEditable(true);
    }

    public void doHelpActionWork() {
        if (LanguageManager.getInstance().getCurrentLanguage() == Locale.ENGLISH) {
            OSCmdUtils.explorerFile("help" + File.separator + "ArchiveCollect" + File.separator + "ArchiveCollect_en.chm");
        } else {
            OSCmdUtils.explorerFile("help" + File.separator + "ArchiveCollect" + File.separator + "ArchiveCollect_zh.chm");
        }
    }

    public String getListenerName() {
        return "Open Archive Collect Tool Help";
    }
}

