/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.ui.dialog.UIUtils;
import com.huawei.ism.tool.archivecollect.utils.ArchiveCollectSceneUtil;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class ArchiveCollectMainDialogLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ArchiveCollectMainDialogLayout.class);
    private static final Dimension DEFAULT_SIZE = new Dimension(950, 350);
    private static final Dimension DEFAULT_COSTUMERINFO_SIZE = new Dimension(700, 35);
    private static final int INT5 = 5;
    private static final int INT8 = 8;
    private static final int INT10 = 10;
    private static final int INT12 = 12;
    private static final int INT15 = 15;
    private static final int INT20 = 20;
    private static final int INT30 = 30;
    private static final int INT145 = 145;
    private static final int INT25 = 25;
    private static final int INT35 = 35;
    private static final int INT50 = 50;
    private static final int INT64 = 64;
    private static final int INT256 = 256;
    private ToolHyperLinkLabel addDeviceLabel = null;
    private ToolHyperLinkLabel supportProductLabel = null;
    private ToolHyperLinkLabel packageImportLabel = null;
    private JComponent siteNameLabel = null;
    private IsmTextField siteNameText = null;
    private JComponent contactorNameLabel = null;
    private IsmTextField contactorText = null;
    private JComponent cellPhoneLabel = null;
    private IsmTextField cellPhoneText = null;
    private JComponent telePhoneLabel = null;
    private IsmTextField telePhoneText = null;
    private JComponent emailLabel = null;
    private IsmTextField emailText = null;
    private JComponent siteAdressLabel = null;
    private IsmTextField siteAdressText = null;
    private JButton collectButton = null;
    private JButton exploreButton = null;
    private JButton setPathButton = null;
    private IsmTable deviceTable = null;
    private DefaultTableModel deviceTableModel = null;
    private IsmTextField collectPathText = null;
    private JComponent collectPathLabel = null;
    private String[] tableHeaders = new String[]{ResourceUtil.getString("archivecollect.devicetable.head.hostname"), ResourceUtil.getString("archivecollect.devicetable.head.devicetype"), ResourceUtil.getString("archivecollect.devicetable.head.ip"), ResourceUtil.getString("archivecollect.devicetable.head.progress"), ResourceUtil.getString("archivecollect.devicetable.head.status"), ResourceUtil.getString("archivecollect.devicetable.head.detail")};

    public ArchiveCollectMainDialogLayout() {
        this.initComponent();
        this.layoutComponents();
    }

    public int getTableColumn() {
        return this.tableHeaders.length;
    }

    private void initComponentPersonalInfo() {
        this.setContactorNameLabel(UIUtils.createRequiredLabel(ResourceUtil.getString("archivecollect.customer.info.contactor"), false));
        this.setContactorText(IsmTextField.getNameLengthTextField((String)"^[^<>&'\"=\\-+@][^<>&'\"]{0,255}$", (String)"", (int)256, (int)20));
        this.setCellPhoneLabel(UIUtils.createRequiredLabel(ResourceUtil.getString("archivecollect.customer.info.mobilephone"), false));
        this.setCellPhoneText(IsmTextField.getNameTextField((String)"[\\+]?[0-9\\-]*", (String)"", (int)64, (int)20));
        this.setTelePhoneLabel(UIUtils.createRequiredLabel(ResourceUtil.getString("archivecollect.customer.info.phone"), false));
        this.setTelePhoneText(IsmTextField.getNameTextField((String)"[\\+]?[0-9\\-]*", (String)"", (int)64, (int)20));
        this.setEmailLabel(UIUtils.createRequiredLabel(ResourceUtil.getString("archivecollect.customer.info.email"), false));
        this.setEmailText(IsmTextField.getNameTextField((String)"^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$", (String)"", (int)256, (int)20));
    }

    private void initComponentOther() {
        this.setSiteAdressLabel(UIUtils.createRequiredLabel(ResourceUtil.getString("archivecollect.customer.info.siteAdress"), false));
        this.setSiteAdressText(IsmTextField.getNameTextField((String)"^[^<>&'\"=\\-+@][^<>&'\"]{0,255}$", (String)"", (int)256, (int)20, (boolean)true));
        this.addDeviceLabel = new ToolHyperLinkLabel(ResourceUtil.getString("archivecollect.superlink.adddevice"));
        this.setSupportProductLabel(new ToolHyperLinkLabel(ResourceUtil.getString("archivecollect.superlink.supportdevice")));
        this.setPackageImportLabel(new ToolHyperLinkLabel(ResourceUtil.getString("archivecollect.superlink.importpackage")));
        this.collectPathLabel = UIUtils.createRequiredLabel(ResourceUtil.getString("archivecollect.collectpath"), true);
        String defaultPath = "";
        try {
            defaultPath = FileSystemView.getFileSystemView().getDefaultDirectory().getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get default path error.", (Throwable)e);
        }
        String userPath = ArchiveCollectSceneUtil.isScene() ? ArchiveCollectSceneUtil.getSceneResultPath() : defaultPath;
        this.setCollectPathText(IsmTextField.getNameTextField((String)".*", (String)userPath, (int)256, (int)35, (boolean)true));
        this.collectPathText.setToolTipText(userPath);
        this.collectPathText.setEditable(false);
        this.setCollectButton(UiMethod.createButton((String)ResourceUtil.getString("archivecollect.button.collect"), (char)'E'));
        this.setExploreButton(UiMethod.createButton((String)ResourceUtil.getString("archivecollect.button.explore"), (char)'O'));
    }

    private void initComponent() {
        this.setSiteNameLabel(UIUtils.createRequiredLabel(ResourceUtil.getString("archivecollect.customer.info.sitename"), true));
        this.setSiteNameText(IsmTextField.getNameLengthTextField((String)"^[^<>&'\"=\\-+@][^<>&'\"]{0,255}$", (String)"", (int)256, (int)20));
        this.initComponentPersonalInfo();
        this.initComponentOther();
        if (LanguageManager.getInstance().getCurrentLanguage() == Locale.ENGLISH) {
            UiMethod.setComponentSize((Dimension)new Dimension(145, 25), (Component[])new Component[]{this.exploreButton});
        }
        this.setSetPathButton(UiMethod.createButton((String)ResourceUtil.getString("archivecollect.button.setup"), (char)'A'));
        if (ArchiveCollectSceneUtil.isScene()) {
            this.addDeviceLabel.setEnabled(false);
            this.setPathButton.setEnabled(false);
        }
        this.createDeviceTable();
    }

    private void createDeviceTable() {
        this.setDeviceTableModel(new DefaultTableModel(this.tableHeaders, new int[0]));
        this.setDeviceTable(new IsmTable((TableModel)this.getDeviceTableModel()));
    }

    private void layoutComponents() {
        JComponent customerInfoPane = this.layoutCustomorInfoArea();
        JComponent collectPathArea = this.layoutcollectPathArea();
        JComponent descriptionArea = this.layoutDescrptionArea();
        JComponent tableArea = this.layoutTableArea();
        JComponent buttonArea = this.layoutButtonArea();
        JComponent contentArea = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{customerInfoPane}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{collectPathArea}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionArea}), UCD.buildHorizotalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalGlue()}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{tableArea})}), UiMethod.buildFrameSpace((JComponent)buttonArea, (int)12)});
        this.setLayout(new BorderLayout());
        this.add(this.buildFrameSpace(contentArea, 20, 30, 15, 35));
    }

    private JComponent buildFrameSpace(JComponent contentArea, int left, int right, int up, int down) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(left));
        hBox.add(contentArea);
        hBox.add(Box.createHorizontalStrut(right));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(up));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(down));
        return vBox;
    }

    private JComponent layoutcollectPathArea() {
        JPanel collectPathArea = new JPanel();
        collectPathArea.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        collectPathArea.add((Component)this.collectPathLabel, constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 10, 0, 0);
        collectPathArea.add((Component)this.getCollectPathText(), constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 5, 0, 0);
        collectPathArea.add((Component)this.getSetPathButton(), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        collectPathArea.add((Component)new JLabel(), constraints);
        return collectPathArea;
    }

    private JComponent layoutCustomorInfoArea() {
        JPanel customerInfoPane = new JPanel();
        customerInfoPane.setPreferredSize(DEFAULT_COSTUMERINFO_SIZE);
        customerInfoPane.setMaximumSize(DEFAULT_COSTUMERINFO_SIZE);
        customerInfoPane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 8, 0);
        customerInfoPane.add((Component)this.getSiteNameLabel(), constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 0, 8, 0);
        customerInfoPane.add((Component)this.getSiteNameText(), constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 50, 8, 0);
        customerInfoPane.add((Component)this.getSiteAdressLabel(), constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 0, 8, 0);
        customerInfoPane.add((Component)this.getSiteAdressText(), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        customerInfoPane.add((Component)new JLabel(), constraints);
        return customerInfoPane;
    }

    private JComponent layoutDescrptionArea() {
        JLabel descriptionLabelA = new JLabel(ResourceUtil.getString("archivecollect.adddevice.description"));
        JLabel descriptionLabelA1 = new JLabel(ResourceUtil.getString("archivecollect.adddevice.selecdevice"));
        JLabel descriptionLabelB = new JLabel(ResourceUtil.getString("archivecollect.fullstop"));
        JLabel descriptionLabelC = new JLabel(ResourceUtil.getString("archivecollect.importpackage.descriptionA"));
        JComponent view = null;
        view = ApplicationContext.getInstance().isSpecificDeviceMode() ? UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionLabelA1})}) : UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionLabelA, this.addDeviceLabel, descriptionLabelB}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionLabelC, this.getSupportProductLabel(), new JLabel(ResourceUtil.getString("archivecollect.importpackage.descriptionB")), new JLabel(ResourceUtil.getString("archivecollect.fullstop"))}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{new JLabel(ResourceUtil.getString("archivecollect.not.support"))})});
        return view;
    }

    private JComponent layoutButtonArea() {
        Box buttonArea = Box.createHorizontalBox();
        buttonArea.add(this.getCollectButton());
        buttonArea.add(Box.createHorizontalStrut(8));
        buttonArea.add(this.getExploreButton());
        buttonArea.add(Box.createHorizontalGlue());
        return buttonArea;
    }

    private JComponent layoutTableArea() {
        TableScrollPane pane = new TableScrollPane(this.getDeviceTable(), true, true, true);
        pane.setPreferredSize(DEFAULT_SIZE);
        return pane;
    }

    public JButton getCollectButton() {
        return this.collectButton;
    }

    public JButton getExploreButton() {
        return this.exploreButton;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public ToolHyperLinkLabel getAddDeviceLabel() {
        return this.addDeviceLabel;
    }

    public void setAddDeviceLabel(ToolHyperLinkLabel addDeviceLabel) {
        this.addDeviceLabel = addDeviceLabel;
    }

    public ToolHyperLinkLabel getSupportProductLabel() {
        return this.supportProductLabel;
    }

    public ToolHyperLinkLabel getPackageImportLabel() {
        return this.packageImportLabel;
    }

    public void setSetPathButton(JButton setPathButton) {
        this.setPathButton = setPathButton;
    }

    public JButton getSetPathButton() {
        return this.setPathButton;
    }

    public void setSiteNameLabel(JComponent siteNameLabel) {
        this.siteNameLabel = siteNameLabel;
    }

    public JComponent getSiteNameLabel() {
        return this.siteNameLabel;
    }

    public void setSiteNameText(IsmTextField siteNameText) {
        this.siteNameText = siteNameText;
    }

    public JTextField getSiteNameText() {
        return this.siteNameText;
    }

    public void setContactorNameLabel(JComponent contactorNameLabel) {
        this.contactorNameLabel = contactorNameLabel;
    }

    public JComponent getContactorNameLabel() {
        return this.contactorNameLabel;
    }

    public void setContactorText(IsmTextField contactorText) {
        this.contactorText = contactorText;
    }

    public IsmTextField getContactorText() {
        return this.contactorText;
    }

    public void setCellPhoneLabel(JComponent cellPhoneLabel) {
        this.cellPhoneLabel = cellPhoneLabel;
    }

    public JComponent getCellPhoneLabel() {
        return this.cellPhoneLabel;
    }

    public void setCellPhoneText(IsmTextField cellPhoneText) {
        this.cellPhoneText = cellPhoneText;
    }

    public JTextField getCellPhoneText() {
        return this.cellPhoneText;
    }

    public void setTelePhoneLabel(JComponent telePhoneLabel) {
        this.telePhoneLabel = telePhoneLabel;
    }

    public JComponent getTelePhoneLabel() {
        return this.telePhoneLabel;
    }

    public void setTelePhoneText(IsmTextField telePhoneText) {
        this.telePhoneText = telePhoneText;
    }

    public JTextField getTelePhoneText() {
        return this.telePhoneText;
    }

    public void setEmailLabel(JComponent emailLabel) {
        this.emailLabel = emailLabel;
    }

    public JComponent getEmailLabel() {
        return this.emailLabel;
    }

    public void setEmailText(IsmTextField emailText) {
        this.emailText = emailText;
    }

    public JTextField getEmailText() {
        return this.emailText;
    }

    public void setSiteAdressLabel(JComponent siteAdressLabel) {
        this.siteAdressLabel = siteAdressLabel;
    }

    public JComponent getSiteAdressLabel() {
        return this.siteAdressLabel;
    }

    public void setSiteAdressText(IsmTextField siteAdressText) {
        this.siteAdressText = siteAdressText;
    }

    public JTextField getSiteAdressText() {
        return this.siteAdressText;
    }

    public void setSupportProductLabel(ToolHyperLinkLabel supportProductLabel) {
        this.supportProductLabel = supportProductLabel;
    }

    public void setPackageImportLabel(ToolHyperLinkLabel packageImportLabel) {
        this.packageImportLabel = packageImportLabel;
    }

    public void setExploreButton(JButton exploreButton) {
        this.exploreButton = exploreButton;
    }

    public void setCollectButton(JButton collectButton) {
        this.collectButton = collectButton;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    public void setDeviceTableModel(DefaultTableModel deviceTableModel) {
        this.deviceTableModel = deviceTableModel;
    }

    public void setCollectPathText(IsmTextField collectPathText) {
        this.collectPathText = collectPathText;
    }

    public JTextField getCollectPathText() {
        return this.collectPathText;
    }

    public void setCompName() {
        this.addDeviceLabel.setName("_ToolHyperLinkLabel_addDeviceLabel");
        this.supportProductLabel.setName("_ToolHyperLinkLabel_supportProductLabel");
        this.packageImportLabel.setName("_ToolHyperLinkLabel_packageImportLabel");
        this.siteNameText.setName("_IsmTextField_siteNameText");
        this.contactorText.setName("_IsmTextField_contactorText");
        this.cellPhoneText.setName("_IsmTextField_cellPhoneText");
        this.telePhoneText.setName("_IsmTextField_telePhoneText");
        this.emailText.setName("_IsmTextField_emailText");
        this.siteAdressText.setName("_IsmTextField_siteAdressText");
        this.collectButton.setName("_JButton_collectButton");
        this.exploreButton.setName("_JButton_exploreButton");
        this.setPathButton.setName("_JButton_setPathButton");
        this.collectPathText.setName("_IsmTextField_collectPathText");
    }
}

