/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.listener.ICollectListener;
import com.huawei.ism.tool.archivecollect.ui.dialog.CollectDetailDialogLayout;
import com.huawei.ism.tool.archivecollect.ui.dialog.CollectDetailDialogListener;
import com.huawei.ism.tool.archivecollect.ui.dialog.ListMouseAdapter;
import com.huawei.ism.tool.archivecollect.ui.dialog.RefreshDetailListTask;
import com.huawei.ism.tool.archivecollect.ui.listener.CollectDetailWindowListener;
import com.huawei.ism.tool.archivecollect.worktaker.ICollectWorktaker;
import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class CollectDetailDialog
extends JDialog
implements ICollectListener {
    private static final long serialVersionUID = 1L;
    private static final Dimension DEFAULT_SIZE = new Dimension(950, 250);
    private CollectDetailDialogLayout layout = null;
    private DevNode dev = null;

    public CollectDetailDialogLayout getCollectDetailLayout() {
        return this.layout;
    }

    public DevNode getDev() {
        return this.dev;
    }

    public CollectDetailDialog(DevNode device, JDialog parent) {
        super(parent);
        this.dev = device;
        this.initUI();
        this.addListener();
    }

    private void initUI() {
        this.layout = new CollectDetailDialogLayout();
        this.layout.setCompName();
        this.setLayout(new BorderLayout());
        this.add(this.layout);
        this.setTitle(ResourceUtil.getString("archivecollect.detail.title"));
        this.setModal(true);
        this.setResizable(false);
        this.validate();
        this.pack();
        this.setDefaultCloseOperation(0);
        UiMethod.setComponentSize((Dimension)DEFAULT_SIZE, (Component[])new Component[]{this});
        SwingUtil.putScreenCenter((Window)this);
    }

    @Override
    public void fireCollectProcess(CollectProgressInfo collectProcessInf) {
        RefreshDetailListTask task = new RefreshDetailListTask(collectProcessInf, this);
        SwingUtilities.invokeLater(task);
    }

    private void addListener() {
        WorktakerUtil.getWorktaker(ICollectWorktaker.class).setDetailListener(this.dev, this);
        this.layout.getDetailList().addMouseListener(new ListMouseAdapter(this));
        this.addWindowListener(new CollectDetailWindowListener(this, this.dev));
        CollectDetailDialogListener listener = new CollectDetailDialogListener(this);
        this.layout.getCloseBtn().addActionListener(listener);
    }

    @Override
    public void fireAllCollectOver() {
    }
}

