/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.entity.CollectStepInfo;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailListCellRenderer
implements ListCellRenderer {
    private static final Logger log = LoggerFactory.getLogger(DetailListCellRenderer.class);
    private static final long serialVersionUID = 1L;
    private static final int INT100 = 100;
    private static final int INT180 = 180;
    private static final int INT280 = 280;
    private static final int INT39 = 39;
    private static final int INT70 = 70;
    private static final int INT520 = 520;
    private static final int INT18 = 18;
    private static final int INT130 = 130;
    private static final ImageIcon SUCCESS_IMAGE = ResourceUtil.getImage("success.png");
    private static final ImageIcon PART_SUCCESS_IMAGE = ResourceUtil.getImage("warning.png");
    private static final ImageIcon FAILED_IMAGE = ResourceUtil.getImage("failed.png");
    private static final ImageIcon PROCESSING_IMAGE = ResourceUtil.getImage("loading.gif");

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Color bg = null;
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = UIManager.getColor("List.dropCellBackground");
            isSelected = true;
        }
        JPanel viewPan = new JPanel();
        this.createCollectStepInfoView(list, value, viewPan);
        viewPan.setComponentOrientation(list.getComponentOrientation());
        viewPan.setEnabled(list.isEnabled());
        viewPan.setFont(list.getFont());
        if (isSelected) {
            viewPan.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty((String)"setForeground", (Object[])new Object[]{Color.WHITE}, (JComponent[])new JComponent[]{viewPan});
        } else {
            viewPan.setBackground(list.getBackground());
            viewPan.setForeground(list.getForeground());
        }
        return viewPan;
    }

    private void createCollectStepInfoView(JList list, Object value, JPanel viewPan) {
        if (value instanceof CollectStepInfo) {
            CollectStepInfo result = (CollectStepInfo)value;
            JLabel devNodeLabel = new JLabel();
            devNodeLabel.setPreferredSize(new Dimension(100, devNodeLabel.getPreferredSize().height));
            int dLength = 0;
            if (result.getIp() != null) {
                String ip = result.getIp();
                int len = ip.length();
                int n = dLength = 280 * len / 39 - 100 > 180 ? 180 : 280 * len / 39 - 100;
                if (StringUtils.isIpv6Address((String)ip) && dLength > 0) {
                    devNodeLabel.setPreferredSize(new Dimension(dLength + 100, devNodeLabel.getPreferredSize().height));
                }
                devNodeLabel.setText(result.getIp());
            }
            JLabel descLabel = new JLabel(result.getStepDesc());
            Dimension descLabelSize = new Dimension(520 - dLength, 18);
            UiMethod.setComponentSize((Dimension)descLabelSize, (Component[])new Component[]{descLabel});
            Date data = result.getDate();
            if (data == null) {
                log.error("data is null!");
                return;
            }
            String formatedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(data);
            JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), new JLabel(formatedDate)});
            JLabel resultLabel = this.setResultLabel(list, result);
            JComponent view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, devNodeLabel, descLabel, Box.createGlue(), resultLabel, Box.createHorizontalStrut(8)});
            viewPan.setLayout(new BorderLayout());
            viewPan.setToolTipText(result.getStepDesc());
            viewPan.add((Component)view, "North");
        }
    }

    private JLabel setResultLabel(JList list, CollectStepInfo result) {
        JLabel resultLabel = new JLabel("");
        Dimension resultSize = null;
        resultSize = LanguageManager.getInstance().getCurrentLanguage() == Locale.ENGLISH ? new Dimension(130, 18) : new Dimension(70, 18);
        resultLabel.setPreferredSize(resultSize);
        if (result.getStatus().ordinal() == CollectStatusEnum.COLLECTING.ordinal()) {
            resultLabel.setIcon(PROCESSING_IMAGE);
            PROCESSING_IMAGE.setImageObserver(list);
            resultLabel.setText(ResourceUtil.getString("archivecollect.detail.processing"));
        } else if (result.getStatus().ordinal() == CollectStatusEnum.COLLECT_FINISHED.ordinal()) {
            resultLabel.setIcon(SUCCESS_IMAGE);
            resultLabel.setText(ResourceUtil.getString("archivecollect.detail.success"));
        } else if (result.getStatus().ordinal() == CollectStatusEnum.COLLECT_FAILED.ordinal()) {
            resultLabel.setIcon(FAILED_IMAGE);
            resultLabel.setText(ResourceUtil.getString("archivecollect.detail.fail"));
        } else {
            resultLabel.setIcon(PART_SUCCESS_IMAGE);
            resultLabel.setText(ResourceUtil.getString("archivecollect.detail.notallsuccess"));
        }
        return resultLabel;
    }
}

