/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.entity.CollectInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.ui.dialog.ArchiveCollectMainDialog;
import com.huawei.ism.tool.archivecollect.worktaker.ICollectWorktaker;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JDialog;

public class DoCollectJobThread
implements Runnable {
    private static Lock lock = new ReentrantLock();
    private ArchiveCollectMainDialog dialog;

    public DoCollectJobThread(ArchiveCollectMainDialog dialog) {
        this.dialog = dialog;
    }

    private void updateUICollectStart(ArchiveCollectMainDialog dialog, DevNode dev) {
        CollectProgressInfo temp = new CollectProgressInfo();
        temp.setProcess(0);
        temp.setStatus(CollectStatusEnum.COLLECTING);
        temp.setDevNode(dev);
        dialog.fireCollectProcess(temp);
    }

    private void updateUINoCollect(ArchiveCollectMainDialog dialog, DevNode dev) {
        CollectProgressInfo temp = new CollectProgressInfo();
        temp.setProcess(0);
        temp.setStatus(CollectStatusEnum.NOT_COLLECT);
        temp.setDevNode(dev);
        dialog.fireCollectProcess(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName("Thread_collectaction");
        List<DevNode> devs = this.dialog.getSelectedDevNode();
        if (devs.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString("archivecollect.remind.selectnodevice"));
            return;
        }
        if (!this.dialog.isInputOk()) {
            return;
        }
        try {
            lock.lock();
            for (DevNode dev : devs) {
                if (!this.dialog.findNodeStatus(dev).booleanValue() || !this.dialog.isSelectedDevCollecting()) continue;
                DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString("archivecollect.remind.itemiscollecting"));
                return;
            }
            for (DevNode dev : devs) {
                this.dialog.changeNodeStatus(dev, true);
            }
        }
        finally {
            lock.unlock();
        }
        if (this.dialog.isCollecting(devs)) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString("archivecollect.remind.itemiscollecting"));
            return;
        }
        for (DevNode dev : devs) {
            this.updateUICollectStart(this.dialog, dev);
        }
        if (!this.dialog.isDevsCanCollect(devs)) {
            for (DevNode dev : devs) {
                this.dialog.changeNodeStatus(dev, false);
                this.updateUINoCollect(this.dialog, dev);
            }
            return;
        }
        CollectInfo collectInfo = this.dialog.generateColletInfo();
        WorktakerUtil.getWorktaker(ICollectWorktaker.class).startCollect(collectInfo, devs, this.dialog);
        this.dialog.unableUiInput();
        Thread.currentThread().setName(name);
    }
}

