/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.entity.CollectStepInfo;
import com.huawei.ism.tool.archivecollect.ui.dialog.ErrorDetailListMouseAdapter;
import com.huawei.ism.tool.archivecollect.ui.dialog.OkBtnListener;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.IsmList;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;

public class ErrorDetailInfoDialog
extends PublicDialog {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ErrorDetailInfoDialog.class);
    private static final long serialVersionUID = 8218275154634607967L;
    private static final Dimension SIZE = new Dimension(500, 300);
    private String detailInfo = ResourceUtil.getString("archivecollect.detail.error.sus.info");
    private JTextArea detailArea;
    private IsmList detailList;
    private CollectStepInfo stepInfo;
    private Map<String, String> detailMap;

    public IsmList getDetailList() {
        return this.detailList;
    }

    public Map<String, String> getDetailMap() {
        return this.detailMap;
    }

    public ErrorDetailInfoDialog(CollectStepInfo stepInfo, JDialog parent) {
        super(parent, true);
        this.setModal(true);
        this.stepInfo = stepInfo;
        this.detailMap = (Map)stepInfo.getResultDetail();
        if (this.detailMap != null) {
            LOGGER.info(this.detailMap.toString());
        }
        if (!StringUtils.isNULLStr(stepInfo.getErrMsg())) {
            this.detailInfo = stepInfo.getErrMsg();
        }
        this.setTitle(ResourceUtil.getString("archivecollect.error.archivecollectdetail.title"));
        this.setSize(SIZE);
        this.initUI();
        this.initOkBtnListener();
        SwingUtil.putParentCenter((Window)((Object)this), (Window)parent);
        SwingUtil.setCloseWhenEscKeyPressed((JDialog)((Object)this));
    }

    private void initUI() {
        JScrollPane detailPan;
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
        this.setCancelButtonVisible(false);
        if (this.detailMap != null && !this.detailMap.isEmpty()) {
            this.detailList = new IsmList(this.detailMap.keySet().toArray());
            this.detailList.addMouseListener((MouseListener)new ErrorDetailListMouseAdapter(this));
            detailPan = new JScrollPane((Component)this.detailList);
        } else {
            this.detailArea = UiMethod.createJTextArea((String)this.detailInfo);
            this.detailArea.setFocusable(true);
            this.detailArea.setMargin(new Insets(5, 5, 5, 5));
            detailPan = new JScrollPane(this.detailArea);
            this.detailArea.setCaretPosition(0);
        }
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)UiMethod.buildFrameSpace((JComponent)detailPan, (int)12), "Center");
    }

    protected void initOkBtnListener() {
        OkBtnListener listsener = new OkBtnListener(this);
        this.getOkBtn().addActionListener(listsener);
    }
}

