/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.ui.dialog.ArchiveCollectMainDialog;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class ExploreButtonListener
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ArchiveCollectMainDialog.class);
    private ArchiveCollectMainDialog dialog;

    public ExploreButtonListener(ArchiveCollectMainDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String archiveCollectDir = this.dialog.getMainDialogLayout().getCollectPathText().getText();
        if (null == archiveCollectDir || "".equals(archiveCollectDir)) {
            LOGGER.error("There are inner exception in getting CollectPathTest!");
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString("archivecollect.remind.collectpthnotexist"));
            return;
        }
        File collectDir = new File(FilePathUtils.checkFile(archiveCollectDir));
        if (collectDir.exists()) {
            OSCmdUtils.explorerFile(archiveCollectDir);
            LOGGER.info("Open collection directory >> {}][Success", (Object)archiveCollectDir);
        } else {
            LOGGER.info("Open collection directory ][Failed");
        }
    }
}

