/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.ui.dialog.ArchiveCollectMainDialog;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import org.slf4j.Logger;

public class FlashRowTaskRunnable
implements Runnable {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ArchiveCollectMainDialog.class);
    private CollectProgressInfo tmpCollectProgressInfo = null;
    private ArchiveCollectMainDialog dialog = null;
    private static final int INT3 = 3;
    private static final int INT4 = 4;

    public FlashRowTaskRunnable(CollectProgressInfo collectProcessInfo, ArchiveCollectMainDialog dialog) {
        this.tmpCollectProgressInfo = collectProcessInfo;
        this.dialog = dialog;
    }

    @Override
    public void run() {
        DevNode dev = this.tmpCollectProgressInfo.getDevNode();
        TableRow<DevNode, String> changeRow = this.dialog.getTableRow(dev.getDeviceSerialNumber());
        String devIp = dev.getIp();
        if (null == changeRow) {
            LOGGER.error("collect call back error,no such devNode :" + devIp);
            return;
        }
        changeRow.setValueAt(3, (Object)new IsmTableCell.ProgressCell(this.tmpCollectProgressInfo.getProcess()));
        changeRow.setValueAt(4, (Object)this.dialog.getStatusCell(this.tmpCollectProgressInfo.getStatus()));
        this.dialog.getMainDialogLayout().getDeviceTable().repaint();
    }
}

