/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.dialog;

import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectStepInfo;
import com.huawei.ism.tool.archivecollect.ui.dialog.CollectDetailDialog;
import com.huawei.ism.tool.archivecollect.ui.dialog.ErrorDetailInfoDialog;
import com.huawei.ism.tool.archivecollect.worktaker.ICollectWorktaker;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;

public class ListMouseAdapter
extends MouseAdapter {
    private CollectDetailDialog dialog;

    public ListMouseAdapter(CollectDetailDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) || mouseEvent.getClickCount() > 1) {
            return;
        }
        int index = this.getListIndex(mouseEvent.getPoint(), this.dialog.getCollectDetailLayout().getDetailList());
        if (-1 == index) {
            return;
        }
        CollectProgressInfo info = WorktakerUtil.getWorktaker(ICollectWorktaker.class).getCollectProgressInfo(this.dialog.getDev());
        if (null == info) {
            return;
        }
        List<CollectStepInfo> colectStepList = info.getCollectStepList();
        if (null != colectStepList) {
            CollectStepInfo collectStep = colectStepList.get(index);
            ErrorDetailInfoDialog errDetailDialog = new ErrorDetailInfoDialog(collectStep, this.dialog);
            errDetailDialog.setVisible(true);
        }
    }

    private int getListIndex(Point point, JList detailList) {
        int index = -1;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }
}

