/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.listener;

import com.huawei.ism.tool.archivecollect.context.DeviceArchiveContext;
import com.huawei.ism.tool.archivecollect.ui.dialog.ArchiveCollectMainDialog;
import com.huawei.ism.tool.archivecollect.utils.ArchiveCollectSceneUtil;
import com.huawei.ism.tool.archivecollect.worktaker.ICollectWorktaker;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.WorktakerUtil;
import com.huawei.ism.tool.framework.platform.common.data.UserOpToolBasicData;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;

public class CollectMainWindowListener
extends WindowAdapter
implements KeyListener {
    private ArchiveCollectMainDialog parentDlg;

    public CollectMainWindowListener(ArchiveCollectMainDialog parentDlg) {
        this.parentDlg = parentDlg;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.action();
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.action();
        }
    }

    private void callBackUserData() {
        List<UserOpToolBasicData> userDataList = DeviceArchiveContext.getInstance().getUserOpData();
        if (!userDataList.isEmpty()) {
            UserOpDataSaveUtil.batchSaveUserOpdata(userDataList);
        }
    }

    private void action() {
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        for (TableRow row : this.parentDlg.getMainDialogLayout().getDeviceTable().getAllRows()) {
            devs.add((DevNode)row.getUserObject());
        }
        if (!this.parentDlg.isCollecting(devs)) {
            this.callBackUserData();
            this.clear();
            return;
        }
        WarningDialog dialogWarning = DialogUtils.showYesNoDialog((Window)this.parentDlg, (String)ResourceUtil.getString("archivecollect.remind.close"));
        if (0 == dialogWarning.getValue()) {
            this.callBackUserData();
            this.clear();
        }
    }

    private void clear() {
        WorktakerUtil.getWorktaker(ICollectWorktaker.class).cleanOnExit();
        if (ArchiveCollectSceneUtil.isScene()) {
            ArchiveCollectSceneUtil.finishedSceneTask();
        }
        DeviceArchiveContext.getInstance().fireToolStopped();
        this.parentDlg.dispose();
        LoggerFactory.getLogger(this.getClass()).info("ArchiveCollect tool exit.");
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

