/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.ui.listener;

import com.huawei.ism.tool.archivecollect.ui.dialog.ArchiveCollectMainDialog;
import com.huawei.ism.tool.archivecollect.utils.FilesUtil;
import com.huawei.ism.tool.base.ui.filechooser.ToolFileChooser;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirSetupButtonListener
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirSetupButtonListener.class);
    private ArchiveCollectMainDialog parent = null;

    public DirSetupButtonListener(ArchiveCollectMainDialog parent) {
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ArrayList<DevNode> devs = new ArrayList<DevNode>();
        for (TableRow row : this.parent.getMainDialogLayout().getDeviceTable().getAllRows()) {
            devs.add((DevNode)row.getUserObject());
        }
        if (this.parent.isCollecting(devs)) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString("archivecollect.remind.nochangewhencollecting"));
            return;
        }
        String[] exts = new String[]{};
        File file = ToolFileChooser.selectFileByPathDealDot((Window)this.parent, (String)ResourceUtil.getString("archivecollect.set.directory.title"), (String[])exts, (String)this.parent.getMainDialogLayout().getCollectPathText().getText(), (String)ResourceUtil.getString("archivecollect.folder"), (int)1, (boolean)false, (boolean)ApplicationContext.getInstance().isWindowsOS(), (Locale)LanguageManager.getInstance().getCurrentLanguage(), (boolean)true);
        if (file == null) {
            return;
        }
        if (!FilesUtil.isNormalPath(utils.FilesUtil.getCanonicalPath((File)file))) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString("archivecollect.remind.dirchangefail.character"));
            this.actionPerformed(event);
            return;
        }
        try {
            LOGGER.info("change collect dir success.");
            this.parent.getMainDialogLayout().getCollectPathText().setText(file.getCanonicalPath());
            LOGGER.info("Save scan directory >> {}][Success", (Object)file.getCanonicalPath());
            this.parent.getMainDialogLayout().getCollectPathText().setToolTipText(file.getCanonicalPath());
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString("archivecollect.remind.dirchangesuccess"));
        }
        catch (RuntimeException ex) {
            LOGGER.error("save collect dir failed!!!", (Throwable)ex);
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString("archivecollect.remind.dirchangefail"));
        }
        catch (Exception ex) {
            LOGGER.error("save collect dir failed!!!", (Throwable)ex);
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString("archivecollect.remind.dirchangefail"));
        }
    }
}

