/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.utils;

import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.task.CollectTask;
import com.huawei.ism.tool.archivecollect.task.CollectTaskManager;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public abstract class ArchiveCollectSceneUtil {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ArchiveCollectSceneUtil.class);
    private static final String TOOL_ID = "ArchiveCollect";
    private static final String SCENE_RESULT_PATH = "jsonSceneResultPath";
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String SCENE_DEV_STATUS = "status";
    private static final String SCENE_TOOL_ID = "toolId";
    private static final String EMPTY_VALUE = "";

    public static boolean isScene() {
        return SceneUtils.isScene();
    }

    public static String getSceneResultPath() {
        ScenePathValue sceneValue = null;
        try {
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            sceneValue = (ScenePathValue)environmentImpl.getEnvirValueByKey(SCENE_RESULT_PATH);
        }
        catch (ToolException e) {
            LOGGER.error("get json scene result path failed.");
            return EMPTY_VALUE;
        }
        if (sceneValue == null) {
            LOGGER.error("get json scene result path failed.");
            return EMPTY_VALUE;
        }
        return sceneValue.getJsonSceneResultPathValue();
    }

    public static boolean needSelectedDev(String sn) {
        String jsonStr = "{'toolId':'ArchiveCollect','SN':'" + sn + "'}";
        String sceneStatus = null;
        try {
            ISceneEnvironment environment = SceneEnvironmentImpl.getInstance();
            sceneStatus = environment.getDataVarByKey(jsonStr);
        }
        catch (ToolException e) {
            LOGGER.error("get scene select device node failed");
            return false;
        }
        if (StringUtils.isNULLStr((String)sceneStatus) || sceneStatus.equals(TaskResult.Result.SUCCESS.toString())) {
            LOGGER.info("devNode's scene is {}", (Object)sceneStatus);
            return false;
        }
        return true;
    }

    public static void finishedSceneTask() {
        try {
            LOGGER.info("finishedSceneTask begin.");
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            ArrayList<Map<String, String>> sceneDeviceMapList = new ArrayList<Map<String, String>>();
            Collection<CollectTask> devCollectTaskMap = CollectTaskManager.getInstance().getAllCollectTask();
            if (!devCollectTaskMap.isEmpty()) {
                for (CollectTask task : devCollectTaskMap) {
                    sceneDeviceMapList.add(ArchiveCollectSceneUtil.createSceneDeviceMap(task));
                }
            } else {
                sceneDeviceMapList.add(ArchiveCollectSceneUtil.createEmptyDeviceMap());
            }
            TaskResult result = environmentImpl.finishedSceneTask(sceneDeviceMapList);
            LOGGER.info("finishedSceneTask result: {}", (Object)result.getResult());
        }
        catch (ToolException e) {
            LOGGER.error("finishedSceneTask catch exception: ", (Object)e.getErrMsg());
        }
    }

    private static Map<String, String> createSceneDeviceMap(CollectTask task) {
        DevNode dev = task.getDevNode();
        CollectProgressInfo collectProgressInfo = task.getCollectProgressInfo();
        HashMap<String, String> sceneDeviceMap = new HashMap<String, String>();
        sceneDeviceMap.put(SCENE_TOOL_ID, TOOL_ID);
        sceneDeviceMap.put(SCENE_SN, dev.getDeviceSerialNumber());
        sceneDeviceMap.put(SCENE_IP, dev.getIp());
        sceneDeviceMap.put(SCENE_DEV_STATUS, String.valueOf((Object)ArchiveCollectSceneUtil.getSceneStatus(collectProgressInfo.getStatus())));
        LOGGER.info("sceneDeviceMap result: {}", (Object)((Object)sceneDeviceMap).toString());
        return sceneDeviceMap;
    }

    private static Map<String, String> createEmptyDeviceMap() {
        HashMap<String, String> sceneDeviceMap = new HashMap<String, String>();
        sceneDeviceMap.put(SCENE_TOOL_ID, TOOL_ID);
        sceneDeviceMap.put(SCENE_SN, EMPTY_VALUE);
        sceneDeviceMap.put(SCENE_IP, EMPTY_VALUE);
        sceneDeviceMap.put(SCENE_DEV_STATUS, EMPTY_VALUE);
        return sceneDeviceMap;
    }

    private static TaskResult.Result getSceneStatus(CollectStatusEnum status) {
        if (CollectStatusEnum.COLLECT_FINISHED == status || CollectStatusEnum.COLLECT_FINISHED_NOTALL == status) {
            return TaskResult.Result.SUCCESS;
        }
        return TaskResult.Result.FAILED;
    }
}

