/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.archivecollect.entity.ibms.DataEnd;
import com.huawei.ism.tool.archivecollect.entity.ibms.DataTable;
import com.huawei.ism.tool.archivecollect.entity.ibms.DataVersion;
import com.huawei.ism.tool.archivecollect.entity.ibms.Device;
import com.huawei.ism.tool.archivecollect.entity.ibms.DeviceExtend;
import com.huawei.ism.tool.archivecollect.entity.ibms.DevicePart;
import com.huawei.ism.tool.archivecollect.entity.ibms.Dimension;
import com.huawei.ism.tool.archivecollect.entity.ibms.Extend;
import com.huawei.ism.tool.archivecollect.entity.ibms.FileData;
import com.huawei.ism.tool.archivecollect.entity.ibms.NEInfomation;
import com.huawei.ism.tool.archivecollect.entity.ibms.Rack;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.common.util.DistributeRestUriUtil;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributeDeviceInfoCollect {
    private static final Logger log = LoggerFactory.getLogger(DistributeDeviceInfoCollect.class);
    private static final Map<Integer, String> DISK_VENDOR = new ConcurrentHashMap<Integer, String>();

    public static void updateClusterBaseInfo(DevNode devNode) {
        DSstorageInfoQryServiceImpl impl = new DSstorageInfoQryServiceImpl();
        impl.queryNodeInfo(devNode, DeviceOpr.UPDATE, null);
    }

    public static void buildClusterNodeXml(DevNode devNode, String savePath, String siteName) {
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            ResponseInfo devicePartInfoResp = conn.execGet(DistributeRestUriUtil.getDevicePartUri(devNode));
            DistributeDeviceInfoCollect.buildClusterNodeResult(devNode, devicePartInfoResp, savePath, siteName);
        }
        catch (Exception e) {
            log.error("build cluster node result for {} failed.", (Object)devNode.getIp(), (Object)e);
        }
    }

    public static String queryFeatureListInfo(DevNode devNode) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
        ResponseInfo featureListInfoResp = conn.execGet(DistributeRestUriUtil.getActiveLicensesUri(devNode));
        return featureListInfoResp.getContent();
    }

    public static String queryLicenseListInfo(DevNode devNode) throws ToolException {
        RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
        ResponseInfo featureListInfoResp = conn.execGet(DistributeRestUriUtil.getLoadLicensesUri(devNode));
        return featureListInfoResp.getContent();
    }

    protected static void buildClusterNodeResult(DevNode devNode, ResponseInfo devicePartInfoResp, String savePath, String siteName) {
        if (devNode.getClusterNodes() == null) {
            return;
        }
        JSONObject disksObjs = JSON.parseObject((String)devicePartInfoResp.getContent()).getJSONObject("disks");
        devNode.getClusterNodes().stream().filter(ClusterNode::isStorageNode).forEach(clusterNode -> DistributeDeviceInfoCollect.wrightClusterNodeXmlInfo(disksObjs, clusterNode, devNode, savePath, siteName));
    }

    private static void wrightClusterNodeXmlInfo(JSONObject disksObjs, ClusterNode clusterNode, DevNode devNode, String savePath, String siteName) {
        FileData data = DistributeDeviceInfoCollect.buildFileData(disksObjs, clusterNode, devNode, siteName);
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver(StandardCharsets.UTF_8.name()));
        xStream.omitField(FileData.class, "classAttribute");
        xStream.processAnnotations(FileData.class);
        String fileName = String.format("IB_SmartKit_%s_%s_%s_%s.xml", clusterNode.getModel(), devNode.getDeviceSerialNumber(), clusterNode.getSerialNumber(), clusterNode.getId());
        StreamUtils.writeInfo2File((byte[])xStream.toXML((Object)data).replace("__", "_").replace("class=\"singleton-list\"", "").getBytes(StandardCharsets.UTF_8), (String)(savePath + File.separator + fileName));
    }

    private static FileData buildFileData(JSONObject disksObjs, ClusterNode clusterNode, DevNode devNode, String siteName) {
        return FileData.builder().version(new DataVersion()).table(DistributeDeviceInfoCollect.buildDataTable(disksObjs, clusterNode, devNode, siteName)).end(new DataEnd(StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss"))).build();
    }

    private static DataTable buildDataTable(JSONObject disksObjs, ClusterNode clusterNode, DevNode devNode, String siteName) {
        return DataTable.builder().neInfomation(DistributeDeviceInfoCollect.buildNeInfomation(clusterNode, devNode, siteName)).racks(Collections.singletonList(DistributeDeviceInfoCollect.buildRackInfo(clusterNode))).devices(Collections.singletonList(DistributeDeviceInfoCollect.buildDeviceInfo(clusterNode, disksObjs))).dimensions(Collections.singletonList(Dimension.builder().name("Cluster").value("1").build())).build();
    }

    private static Rack buildRackInfo(ClusterNode clusterNode) {
        return Rack.builder().location(clusterNode.getCabinet()).build();
    }

    private static NEInfomation buildNeInfomation(ClusterNode clusterNode, DevNode devNode, String siteName) {
        return NEInfomation.builder().esn(DistributeDeviceInfoCollect.getSerialNumber(clusterNode)).sn(DistributeDeviceInfoCollect.getSerialNumber(clusterNode)).id(DistributeDeviceInfoCollect.getSerialNumber(clusterNode)).name(clusterNode.getName()).type(DistributeDeviceInfoCollect.getClusterNodeModel(clusterNode)).version(devNode.getProductVersionToShow()).fatherId(devNode.getDeviceSerialNumber()).extend(Extend.builder().name("Site Name").value(siteName).build()).build();
    }

    private static String getClusterNodeModel(ClusterNode clusterNode) {
        String model = clusterNode.getModelByBmc();
        if (!StringUtils.isNULLStr((String)model) && !"To be filled by O.E.M.".equals(model)) {
            return clusterNode.getModelByBmc();
        }
        if (clusterNode.getBaseBoardType() != null) {
            return clusterNode.getBaseBoardType().getDevType().split(",")[0].split("\\(")[0];
        }
        return clusterNode.getModel();
    }

    private static String getSerialNumber(ClusterNode clusterNode) {
        return clusterNode.getSerialNumber().split("-")[0];
    }

    @NonNull
    private static Device buildDeviceInfo(ClusterNode clusterNode, JSONObject disksObjs) {
        return Device.builder().sn(DistributeDeviceInfoCollect.getSerialNumber(clusterNode)).type("DeviceHost").hwId(clusterNode.getId() + "").hwName(clusterNode.getName()).deviceParts(DistributeDeviceInfoCollect.buildDeviceParts(disksObjs, clusterNode.getManagementIp())).deviceExtends(DistributeDeviceInfoCollect.buildDeviceExtends(clusterNode)).build();
    }

    private static List<DeviceExtend> buildDeviceExtends(ClusterNode clusterNode) {
        ArrayList<DeviceExtend> devices = new ArrayList<DeviceExtend>();
        devices.add(new DeviceExtend("Type", DistributeDeviceInfoCollect.getClusterNodeModel(clusterNode)));
        devices.add(new DeviceExtend("IP", clusterNode.getManagementIp()));
        devices.add(new DeviceExtend("Location", clusterNode.getCabinet()));
        return devices;
    }

    private static List<DevicePart> buildDeviceParts(JSONObject disksObjs, String managementIp) {
        JSONArray array = disksObjs.getJSONArray(managementIp);
        ArrayList<DevicePart> deviceParts = new ArrayList<DevicePart>();
        for (int i = 0; i < array.size(); ++i) {
            JSONObject diskObj = array.getJSONObject(i);
            DevicePart diskInfo = DevicePart.builder().extInfo(diskObj.getOrDefault((Object)"devType", (Object)"").toString()).partId(diskObj.getOrDefault((Object)"id", (Object)"").toString()).vendorName(DISK_VENDOR.getOrDefault(DistributeDeviceInfoCollect.getDiskVendor(diskObj), "UNKNOWN")).type("HardDisk").sn(diskObj.getOrDefault((Object)"devEsn", (Object)"").toString()).build();
            deviceParts.add(diskInfo);
        }
        return deviceParts;
    }

    private static Integer getDiskVendor(JSONObject diskObj) {
        if (!diskObj.containsKey((Object)"vendor")) {
            return 0;
        }
        return diskObj.getInteger("vendor");
    }

    public static void releaseConn(DevNode devNode) {
        RestConnectionManager.releaseConn((DevNode)devNode);
    }

    private DistributeDeviceInfoCollect() {
    }

    static {
        DISK_VENDOR.put(0, "UNKNOWN");
        DISK_VENDOR.put(1, "SEAGATE");
        DISK_VENDOR.put(2, "WDC");
        DISK_VENDOR.put(3, "TOSHIBA");
        DISK_VENDOR.put(4, "HUAWEI");
        DISK_VENDOR.put(5, "HGST");
        DISK_VENDOR.put(6, "HP");
        DISK_VENDOR.put(7, "ATA");
        DISK_VENDOR.put(8, "HITACHI");
        DISK_VENDOR.put(9, "WD");
        DISK_VENDOR.put(10, "IBM_ESXS");
        DISK_VENDOR.put(11, "LSI");
        DISK_VENDOR.put(12, "SAMSUNG");
        DISK_VENDOR.put(13, "INTEL");
        DISK_VENDOR.put(14, "MEMBLAZE");
        DISK_VENDOR.put(15, "RAMAXEL");
        DISK_VENDOR.put(16, "DAPU");
    }
}

