/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesUtil.class);

    public static boolean isNormalPath(String path) {
        path = path.replaceAll("\\\\", "");
        path = path.replaceAll("/", "");
        path = path.replaceAll(":", "");
        if ((path = path.replaceAll("\\.", "")).contains("  ")) {
            return false;
        }
        return path.matches("[\\w ]+");
    }

    public static boolean isValidPath(File selectFile, int miniCapacity) {
        if (!FilesUtil.canWrite(selectFile)) {
            LOGGER.info("the file can not write.");
            return false;
        }
        if (!FilesUtil.checkDiskFreeSpace(selectFile, miniCapacity)) {
            LOGGER.info("the file FreeSpace is not enough.");
            return false;
        }
        return true;
    }

    public static boolean canWrite(File file) {
        if (null == file) {
            LOGGER.info("file is null.");
            return false;
        }
        try {
            String path = file.getCanonicalPath();
            FilesUtil.mkDirs(path);
            File file1 = new File(path + File.separator + "temp.txt");
            if (!file1.createNewFile()) {
                LOGGER.info("create temp file failed.{}", (Object)file1.getCanonicalPath());
                return false;
            }
            boolean success = file1.delete();
            LOGGER.info("file can write. delete temp file success:{}.", (Object)success);
        }
        catch (IOException e) {
            LOGGER.error("create file error.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static void mkDirs(String path) {
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.info("create dirs failed.{}", (Object)path);
        }
    }

    private static boolean checkDiskFreeSpace(File file, int miniCapacity) {
        long capacity;
        long freeSpace = file.getFreeSpace();
        return freeSpace >= (capacity = (long)miniCapacity * 1024L * 1024L);
    }

    public static boolean isDirectory(String filePath) {
        if (null == filePath || "".equals(filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists() && file.isDirectory();
    }

    public static void copyFileThrowEx(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream input = new FileInputStream(sourceFile);
             BufferedInputStream inBuff = new BufferedInputStream(input);
             FileOutputStream output = new FileOutputStream(targetFile);
             BufferedOutputStream outBuff = new BufferedOutputStream(output);){
            int len;
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                outBuff.write(b, 0, len);
            }
        }
    }

    public static void closeStream(OutputStream out, InputStream input) {
        FilesUtil.closeResource(out, out);
        FilesUtil.closeResource(null, input);
    }

    public static void closeResource(Flushable flushed, Closeable closed) {
        try {
            if (null != flushed) {
                flushed.flush();
            }
        }
        catch (IOException e) {
            LOGGER.error("Close output stream error...", (Throwable)e);
        }
        try {
            if (null != closed) {
                closed.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Close output stream error...", (Throwable)e);
        }
    }

    public static boolean createDir(File path) {
        if (!path.exists()) {
            if (!path.mkdirs()) {
                LoggerFactory.getLogger(FileUtils.class).error("create path successed." + path);
                return false;
            }
            LoggerFactory.getLogger(FileUtils.class).error("create path faild." + path);
        }
        return true;
    }
}

