/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.utils;

import com.huawei.ism.tool.archivecollect.utils.DistributeDeviceInfoCollect;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.common.util.DistributeRestUriUtil;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FusionCubeDeviceInfoCollectUtil {
    private static final Logger log = LoggerFactory.getLogger(FusionCubeDeviceInfoCollectUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFusionCubeLicenseInfo(DevNode devNode, String cmd) {
        DevNode devNodeCube = FusionCubeDeviceInfoCollectUtil.getDevNode(devNode);
        try {
            ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)devNodeCube);
            String string = sshConnection.execCmd(cmd);
            return string;
        }
        catch (ToolException e) {
            log.error("get fusionCube License info error", (Throwable)e);
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)devNodeCube);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildClusterNodeXml(DevNode devNode, String savePath, String siteName, String esn) {
        DistributeDeviceInfoCollect.updateClusterBaseInfo(devNode);
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            ResponseInfo devicePartInfoResp = conn.execGet(DistributeRestUriUtil.getDevicePartUri(devNode));
            if (!StringUtils.isNULLStr((String)esn) && !"NA".equals(esn)) {
                devNode.setDeviceSerialNumber(esn);
            }
            DistributeDeviceInfoCollect.buildClusterNodeResult(devNode, devicePartInfoResp, savePath, siteName);
        }
        catch (Exception e) {
            log.error("build cluster node result for {} failed.", (Object)devNode.getIp(), (Object)e);
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    @NotNull
    private static DevNode getDevNode(DevNode devNode) {
        DevNode devNodeCube = new DevNode();
        devNodeCube.setLoginUser(devNode.getFusionCubeLoginUser());
        devNodeCube.setIp(devNode.getIp());
        devNodeCube.setPort(devNode.getFusionCubeSSHPort());
        devNodeCube.setDeviceType(devNode.getDeviceType());
        devNodeCube.setDeviceSerialNumber(devNode.getDeviceSerialNumber());
        devNodeCube.setRootUser(devNode.getRootUser());
        return devNodeCube;
    }

    private FusionCubeDeviceInfoCollectUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

