/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.worktaker.impl;

import com.huawei.ism.tool.archivecollect.entity.CollectResult;
import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.entity.CollectStepEnum;
import com.huawei.ism.tool.archivecollect.task.CollectTask;
import com.huawei.ism.tool.bizpack.IProcessListener;
import com.huawei.ism.tool.bizpack.NodeItem;
import com.huawei.ism.tool.bizpack.NodeResult;
import com.huawei.ism.tool.bizpack.ProcessInfo;
import com.huawei.ism.tool.bizpack.ProcessInstance;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArchiveCollectProcess
implements IProcessListener {
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_FAILED = 0;
    public static final int RESULT_PART_SUCCESS = 2;
    public static final int FINISH_PROGRESS = 100;
    public static final String PARAM_TABLE_LIST = "tableList";
    public static final String PARAM_TITLE_LIST_MAP = "titleListMap";
    public static final String PARAM_RET_DATA_MAP = "retDataMap";
    private String errMsg = null;
    private String curStepId = null;
    private Map<String, CollectResult> collectResultMap = new HashMap<String, CollectResult>();
    private ProcessInstance processInstance = null;
    private ProcessInfo processInfo = null;
    private CollectTask collectTask = null;

    public void stepOut(NodeResult stepResult) {
        this.setExecuteResult(stepResult);
        CollectResult collectResult = new CollectResult();
        collectResult.setSuccess(stepResult.isSuccess());
        collectResult.setErrMsg(stepResult.getDetail());
        collectResult.setDetailResultMsg(stepResult.getResult());
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>();
        returnDataMap.put(PARAM_TABLE_LIST, this.processInstance.getEnvData(PARAM_TABLE_LIST));
        returnDataMap.put(PARAM_TITLE_LIST_MAP, this.processInstance.getEnvData(PARAM_TITLE_LIST_MAP));
        returnDataMap.put(PARAM_RET_DATA_MAP, this.processInstance.getEnvData(PARAM_RET_DATA_MAP));
        collectResult.setReturnData(returnDataMap);
        this.collectResultMap.put(this.curStepId, collectResult);
    }

    public int getStepFinishProgress() {
        int scriptStepNumber = this.processInstance.getNodeNum();
        int stepIndex = 0;
        List nodeList = this.processInfo.getNodeItems();
        for (NodeItem node : nodeList) {
            if (!node.getId().equals(this.curStepId)) continue;
            stepIndex = nodeList.indexOf(node);
            break;
        }
        int totalProgress = CollectStepEnum.GET_ARCHIVE_FILE.getTotalProgress();
        int stepFinishProgress = (int)((double)(stepIndex + 1) / (double)scriptStepNumber * (double)totalProgress);
        if (stepIndex == scriptStepNumber) {
            stepFinishProgress = totalProgress;
        }
        return stepFinishProgress;
    }

    public void stepIn(NodeItem stepItem) {
        this.curStepId = stepItem.getId();
        this.collectTask.inStep(stepItem.getDescription(), this.curStepId);
    }

    public int getStepTotalProgress(int progress) {
        int scriptStepNumber = this.processInstance.getNodeNum();
        int stepIndex = 0;
        List nodeList = this.processInfo.getNodeItems();
        for (NodeItem node : nodeList) {
            if (!node.getId().equals(this.curStepId)) continue;
            stepIndex = nodeList.indexOf(node);
            break;
        }
        int totalProgress = CollectStepEnum.GET_ARCHIVE_FILE.getTotalProgress();
        int finishStepProgress = (int)((double)stepIndex / (double)scriptStepNumber * (double)totalProgress);
        double progressDouble = (double)totalProgress / (double)scriptStepNumber * ((double)progress / 100.0);
        int singleStepProgress = (int)progressDouble;
        return singleStepProgress + finishStepProgress;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public Map<String, CollectResult> getCollectResultMap() {
        return this.collectResultMap;
    }

    public void preStart(ProcessInstance processInstanceLocal) {
    }

    public void afterFinish(ProcessInstance processInstanceLocal) {
        processInstanceLocal.getExecutor().clearUp();
    }

    public String getCurStepId() {
        return this.curStepId;
    }

    public void setCollectTask(CollectTask collectTask) {
        this.collectTask = collectTask;
    }

    public void setProcessInfo(ProcessInfo processInfo) {
        this.processInfo = processInfo;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    private void setExecuteResult(NodeResult stepResult) {
        switch (stepResult.getResultEnum()) {
            case 0: {
                this.errMsg = stepResult.getDetail();
                this.collectTask.outStep(this.curStepId, 100, CollectStatusEnum.COLLECT_FAILED, this.errMsg, stepResult.getResult());
                break;
            }
            case 1: {
                this.collectTask.outStep(this.curStepId, this.getStepFinishProgress(), CollectStatusEnum.COLLECT_FINISHED, "", stepResult.getResult());
                break;
            }
            case 2: {
                this.errMsg = stepResult.getDetail();
                this.collectTask.outStep(this.curStepId, this.getStepFinishProgress(), CollectStatusEnum.COLLECT_FINISHED_NOTALL, this.errMsg, stepResult.getResult());
                break;
            }
        }
    }
}

