/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.worktaker.impl;

import com.huawei.ism.tool.archivecollect.entity.CollectInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectProgressInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectStatusEnum;
import com.huawei.ism.tool.archivecollect.listener.ICollectListener;
import com.huawei.ism.tool.archivecollect.task.CollectTask;
import com.huawei.ism.tool.archivecollect.task.CollectTaskManager;
import com.huawei.ism.tool.archivecollect.worktaker.ICollectWorktaker;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.List;
import org.slf4j.Logger;

public class CollectWorktakerImpl
extends AbstractWorktaker
implements ICollectWorktaker {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CollectWorktakerImpl.class);
    private CollectTaskManager taskManager = CollectTaskManager.getInstance();

    @Override
    public void startCollect(CollectInfo collectInfo, List<DevNode> devNodeList, ICollectListener collectUiListener) {
        collectInfo.setDevNodeList(devNodeList);
        for (DevNode devNode : devNodeList) {
            try {
                this.taskManager.addCollectTask(collectInfo, devNode, collectUiListener);
            }
            catch (ToolException e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    @Override
    public void setDetailListener(DevNode devNode, ICollectListener collectUiListener) {
        CollectTask collectTask = this.taskManager.getCollectTask(devNode.getDeviceSerialNumber());
        if (collectTask != null) {
            collectTask.setDetailUiListener(collectUiListener);
        }
    }

    @Override
    public void removeListener(DevNode devNode) {
        CollectTask collectTask = this.taskManager.getCollectTask(devNode.getDeviceSerialNumber());
        if (collectTask != null) {
            collectTask.setDetailUiListener(null);
        }
    }

    @Override
    public CollectStatusEnum getDevCollectStatus(DevNode devNode) {
        String devNodeSn = devNode.getDeviceSerialNumber();
        CollectTask collectTask = this.taskManager.getCollectTask(devNodeSn);
        if (collectTask == null) {
            return CollectStatusEnum.NOT_COLLECT;
        }
        CollectProgressInfo progressInfo = collectTask.getCollectProgressInfo();
        return progressInfo.getStatus();
    }

    @Override
    public CollectProgressInfo getCollectProgressInfo(DevNode devNode) {
        String devNodeSn = devNode.getDeviceSerialNumber();
        CollectTask collectTask = this.taskManager.getCollectTask(devNodeSn);
        if (collectTask == null) {
            return null;
        }
        return collectTask.getCollectProgressInfo();
    }

    @Override
    public void cleanOnExit() {
    }
}

