/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.worktaker.impl;

import com.huawei.ism.tool.archivecollect.context.DeviceArchiveContext;
import com.huawei.ism.tool.archivecollect.entity.ArchiveBizPackage;
import com.huawei.ism.tool.archivecollect.entity.CustomerInfo;
import com.huawei.ism.tool.archivecollect.worktaker.IResultHandler;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.bizpack.BizPackage;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;

public class ExcelHandler
implements IResultHandler {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExcelHandler.class);
    private static final String SHEET_NAME_CLIENT = "ClientInfo";
    private static final String SHEET_TABLE_CLIENT = "client info";
    private static final String UNDERLINE = "_";
    private static final String EXTENSION_XLS = ".xls";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final int MAX_SINGLE_EXCEL_ROWS = 60000;
    private String devNodeSn = null;
    private Sheet tempWorkSheet = null;
    private String lastSheetTableName;
    private String reportSavePath = null;
    private String nextReportSavePath = null;
    private int nameSort = 2;
    private List<String> sheetNameList = new ArrayList<String>();
    private Map<String, List<String>> sheetTableMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> titleListMap = null;
    private Map<String, List<Map<String, String>>> retDataMap = null;
    private HSSFWorkbook writableBook = null;
    private ArchiveBizPackage bizPackage = null;
    private CustomerInfo customerInfo = null;
    private CellStyle titleStyle = null;
    private CellStyle contentStyle = null;

    public ExcelHandler(Map<String, Object> returnData, DevNode devNode, String reportSavePath, BizPackage bizPackage, CustomerInfo customerInfo) {
        this.titleListMap = (Map)returnData.get("titleListMap");
        this.retDataMap = (Map)returnData.get("retDataMap");
        this.devNodeSn = devNode.getDeviceSerialNumber();
        this.reportSavePath = reportSavePath;
        this.bizPackage = (ArchiveBizPackage)bizPackage;
        this.customerInfo = customerInfo;
    }

    @Override
    public void createResult() throws ToolException {
        FileUtils.createDir(this.reportSavePath);
        this.nextReportSavePath = this.reportSavePath = this.createReportFilePath();
        try {
            this.writableBook = new HSSFWorkbook();
            this.initCellStyle(this.writableBook);
            this.initSheetTableMap();
            for (String sheetName : this.sheetNameList) {
                this.createWorkSheet(sheetName);
            }
        }
        catch (Exception e) {
            LOGGER.error("create excel error.", (Throwable)e);
            throw new ToolException(e.toString(), false, (Throwable)e);
        }
        finally {
            ExcelHandler.flushXls(this.writableBook, this.nextReportSavePath);
        }
        DeviceArchiveContext.getInstance().putResultSavePath(this.devNodeSn, this.nextReportSavePath);
        OSCmdUtils.executeCmd("icacls " + this.nextReportSavePath + " /inheritance:d");
        OSCmdUtils.executeCmd("icacls " + this.nextReportSavePath + " /remove:g Users");
    }

    private void initSheetTableMap() {
        this.sheetNameList = this.bizPackage.getSheetNameList();
        this.sheetTableMap = this.bizPackage.getSheetTableMap();
        if (!this.sheetNameList.contains(SHEET_NAME_CLIENT)) {
            this.sheetNameList.add(SHEET_NAME_CLIENT);
            ArrayList<String> sheetClientTable = new ArrayList<String>();
            sheetClientTable.add(SHEET_TABLE_CLIENT);
            this.sheetTableMap.put(SHEET_NAME_CLIENT, sheetClientTable);
        }
        if (!this.titleListMap.containsKey(SHEET_TABLE_CLIENT)) {
            Map<String, String> clientInfoMap = this.customerInfo.getCustomerMap();
            ArrayList<String> clientInfoColumns = new ArrayList<String>();
            clientInfoColumns.addAll(clientInfoMap.keySet());
            this.titleListMap.put(SHEET_TABLE_CLIENT, clientInfoColumns);
            ArrayList<Map<String, String>> clientInfoList = new ArrayList<Map<String, String>>();
            clientInfoList.add(clientInfoMap);
            this.retDataMap.put(SHEET_TABLE_CLIENT, clientInfoList);
        }
    }

    private void createWorkSheet(String sheetName) {
        LOGGER.info("Begin to create worksheet: {}", (Object)sheetName);
        this.tempWorkSheet = this.writableBook.createSheet(sheetName);
        List<String> tableList = this.sheetTableMap.get(sheetName);
        if (null == tableList) {
            LOGGER.error("create Work Sheet failed! tableList is null!");
            return;
        }
        this.lastSheetTableName = tableList.get(tableList.size() - 1);
        int maxCellNum = 0;
        for (String tableName : tableList) {
            this.createSheetTable(tableName);
            this.tempWorkSheet.createRow(this.tempWorkSheet.getLastRowNum() + 2);
            this.retDataMap.remove(tableName);
            int tittleListSize = ((List)this.titleListMap.getOrDefault(tableName, new ArrayList())).size();
            maxCellNum = maxCellNum > tittleListSize ? maxCellNum : tittleListSize;
        }
        for (int i = 0; i < maxCellNum; ++i) {
            this.tempWorkSheet.autoSizeColumn(i);
        }
    }

    private void createSheetTable(String tableName) {
        int i;
        LOGGER.info("Begin to create sheet table: {}", (Object)tableName);
        List<String> tableColumnList = this.titleListMap.get(tableName);
        if (tableColumnList == null) {
            LOGGER.error("The table column list is NULL, tableName: " + tableName);
            return;
        }
        if (this.tempWorkSheet.getLastRowNum() >= 60000 && !tableColumnList.isEmpty()) {
            this.writeNewExcel();
        }
        Row row = this.tempWorkSheet.createRow((i = this.tempWorkSheet.getLastRowNum()) == 0 ? 0 : ++i);
        row.createCell(row.getLastCellNum() + 1).setCellValue(tableName);
        this.createCell(tableColumnList, this.tempWorkSheet.createRow(this.tempWorkSheet.getLastRowNum() + 1), this.titleStyle);
        List<Map<String, String>> tableItemList = this.retDataMap.get(tableName);
        if (tableItemList == null) {
            LOGGER.error("The table item list is NULL, tableName: " + tableName);
            return;
        }
        if (tableItemList.isEmpty()) {
            if (this.tempWorkSheet.getLastRowNum() >= 60000 && !this.lastSheetTableName.equals(tableName)) {
                this.writeNewExcel();
            }
            LOGGER.info("The table item list is empty, tableName: {}", (Object)tableName);
            return;
        }
        this.writeTableData(tableName, tableItemList, tableColumnList);
    }

    private void writeTableData(String tableName, List<Map<String, String>> tableItemList, List<String> tableColumnList) {
        int rowIndex = 0;
        for (Map<String, String> tableItemMap : tableItemList) {
            Row itemRow = this.tempWorkSheet.createRow(this.tempWorkSheet.getLastRowNum() + 1);
            this.createLable(tableColumnList, itemRow, tableItemMap);
            if (this.tempWorkSheet.getLastRowNum() < 60000 || tableItemList.size() < ++rowIndex) continue;
            if (tableItemList.size() == rowIndex && this.lastSheetTableName.equals(tableName)) {
                return;
            }
            this.writeNewExcel();
            if (tableItemList.size() <= rowIndex) continue;
            Row newItemRow = this.tempWorkSheet.createRow(this.tempWorkSheet.getLastRowNum() + 1);
            newItemRow.createCell(newItemRow.getLastCellNum() + 1).setCellValue(tableName);
            this.createCell(tableColumnList, this.tempWorkSheet.createRow(this.tempWorkSheet.getLastRowNum() + 1), this.titleStyle);
        }
    }

    private void createLable(List<String> tableColumnList, Row itemRow, Map<String, String> tableItemMap) {
        int cellIndex = 0;
        for (String title : tableColumnList) {
            String colunmStr = tableItemMap.getOrDefault(title, "");
            Cell itemCell = itemRow.createCell(cellIndex++);
            itemCell.setCellValue(colunmStr);
            itemCell.setCellStyle(this.contentStyle);
        }
    }

    private void writeNewExcel() {
        ExcelHandler.flushXls(this.writableBook, this.nextReportSavePath);
        this.nextReportSavePath = this.getNextExcelName();
        String sheetName = this.tempWorkSheet.getSheetName();
        this.writableBook = new HSSFWorkbook();
        this.initCellStyle(this.writableBook);
        this.tempWorkSheet = this.writableBook.createSheet(sheetName);
    }

    private void createCell(List<String> cellDatas, Row dataRow, CellStyle style) {
        int cellIndex = 0;
        for (String data : cellDatas) {
            Cell cell = dataRow.createCell(cellIndex++);
            cell.setCellValue(data);
            cell.setCellStyle(style);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void flushXls(HSSFWorkbook workbook, String savePath) {
        block11: {
            if (null == workbook) {
                LOGGER.info("the workbook is null");
                return;
            }
            FileOutputStream fos = null;
            fos = new FileOutputStream(new File(savePath));
            workbook.write((OutputStream)fos);
            StreamUtils.closeStream(fos, null);
            try {
                workbook.close();
            }
            catch (IOException e) {
                LOGGER.error("Get exception in writting xls file.", (Throwable)e);
            }
            break block11;
            catch (IOException e) {
                try {
                    LOGGER.error("Write xls file error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(fos, null);
                    try {
                        workbook.close();
                    }
                    catch (IOException e2) {
                        LOGGER.error("Get exception in writting xls file.", (Throwable)e2);
                    }
                    throw throwable;
                }
                StreamUtils.closeStream(fos, null);
                try {
                    workbook.close();
                }
                catch (IOException e3) {
                    LOGGER.error("Get exception in writting xls file.", (Throwable)e3);
                }
            }
        }
    }

    private String createReportFilePath() {
        Date curDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String curDateStr = dateFormat.format(curDate);
        curDateStr = curDateStr.replaceAll(":", "");
        curDateStr = curDateStr.replaceAll("-", "");
        curDateStr = curDateStr.replaceAll(" ", "");
        StringBuffer sbReportPath = new StringBuffer();
        sbReportPath.append(this.reportSavePath);
        sbReportPath.append(File.separator);
        sbReportPath.append(this.devNodeSn);
        sbReportPath.append(UNDERLINE);
        sbReportPath.append(curDateStr);
        sbReportPath.append(EXTENSION_XLS);
        return sbReportPath.toString();
    }

    private String getNextExcelName() {
        String temPath = this.reportSavePath;
        String name = temPath.substring(0, temPath.length() - EXTENSION_XLS.length());
        StringBuilder nameSb = new StringBuilder();
        nameSb.append(name);
        nameSb.append("(");
        nameSb.append(this.nameSort++);
        nameSb.append(")");
        nameSb.append(EXTENSION_XLS);
        return nameSb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileFromClassLoader(String oldFilePath, String newFilePath) {
        FileOutputStream fileOutStream;
        InputStream inputStream;
        block7: {
            File newFile;
            int byteread;
            block6: {
                LOGGER.info("Old file path: {}", (Object)oldFilePath);
                LOGGER.info("New file path: {}", (Object)newFilePath);
                inputStream = null;
                fileOutStream = null;
                int bytesum = 0;
                byteread = 0;
                inputStream = FileUtils.getStreamWithObj(ExcelHandler.class, oldFilePath);
                newFile = new File(newFilePath);
                if (newFile.exists() || newFile.createNewFile()) break block6;
                LOGGER.error("Create file failed.");
                StreamUtils.closeStream(fileOutStream, inputStream);
                return;
            }
            try {
                newFile.setWritable(true);
                if (inputStream == null) break block7;
                fileOutStream = new FileOutputStream(newFile);
                byte[] buffer = new byte[1024];
                while ((byteread = inputStream.read(buffer)) != -1) {
                    bytesum += byteread;
                    fileOutStream.write(buffer, 0, byteread);
                }
                LOGGER.info("Copy file successed.");
            }
            catch (IOException e) {
                try {
                    LOGGER.error("Copy file failed.");
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(fileOutStream, inputStream);
                    throw throwable;
                }
                StreamUtils.closeStream(fileOutStream, inputStream);
            }
        }
        StreamUtils.closeStream(fileOutStream, inputStream);
    }

    private CellStyle newDefaultCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle style = workbook.createCellStyle();
        ExcelHandler.addBorder((CellStyle)style);
        style.setWrapText(true);
        return style;
    }

    private static void addBorder(CellStyle style) {
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
    }

    private void initCellStyle(HSSFWorkbook workbook) {
        this.titleStyle = this.newDefaultCellStyle(workbook);
        this.titleStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIGHT_GREEN.getIndex());
        this.titleStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.contentStyle = this.newDefaultCellStyle(workbook);
    }
}

