/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.archivecollect.worktaker.impl;

import com.huawei.ism.tool.archivecollect.context.DeviceArchiveContext;
import com.huawei.ism.tool.archivecollect.entity.CollectInfo;
import com.huawei.ism.tool.archivecollect.entity.CollectResult;
import com.huawei.ism.tool.archivecollect.entity.CustomerInfo;
import com.huawei.ism.tool.archivecollect.worktaker.IResultHandler;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NotNull;
import org.python.core.PyList;
import org.slf4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import utils.Products;

public class XmlHandler
implements IResultHandler {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(XmlHandler.class);
    private static final String UNDERLINE = "_";
    private static final String IBMS_FILE_PREFIX = "IB_SmartKit";
    private static final String SYSTEM = "System";
    private static List<String> productModelKeys = Arrays.asList("Device Model", "Product Model", "Cluster_Version", "Device Type");
    private static final String BOOLEAN_TRUE = "true";
    private static final String ENCODING_UTF8 = "utf-8";
    private static final String EXTENSION_XML = ".xml";
    private static final String XML_ARCHIVE_CFG = "xmlarchivecfg.xml";
    private static final String XML_ARCHIVE_CFG_MICRO = "xmlarchivecfg_micro.xml";
    private static final String XML_ARCHIVE_CFG_DORADO = "xmlarchivecfg_dorado.xml";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String COLLECT_STANDARD_SCRIPT_ID = "collectStandard";
    private static final String XML_TEMPLATE_PATH = "/config/archivecollect/report/xml_report.xml";
    private Map<String, List<Map<String, Object>>> retDataMap = null;
    private CollectInfo collectInfo = null;
    private String reportSavePath = null;
    private String packagePath = null;
    private String devNodeSn = null;
    private Document reportDoc = null;
    private Element fileDataEle = null;
    private Element dataTableEle = null;
    private boolean isDstorage = false;
    private String deviceType;

    public XmlHandler(Map<String, CollectResult> collectResultMap, CollectInfo collectInfo, DevNode devNode, String packagePath, String reportSavePath) {
        this.collectInfo = collectInfo;
        CollectResult collectResult = collectResultMap.get(COLLECT_STANDARD_SCRIPT_ID);
        this.retDataMap = (Map)collectResult.getReturnData().get("retDataMap");
        this.devNodeSn = devNode.getDeviceSerialNumber();
        this.packagePath = packagePath;
        this.reportSavePath = reportSavePath;
        this.isDstorage = devNode.isDstorage();
        this.deviceType = devNode.getDeviceType().toString();
        this.initData();
    }

    private void initData() {
        InputStream xmlInputStream = null;
        try {
            xmlInputStream = XmlHandler.class.getResourceAsStream(XML_TEMPLATE_PATH);
            this.reportDoc = XmlUtils.parseDocument(xmlInputStream);
            this.fileDataEle = this.reportDoc.getDocumentElement();
            this.dataTableEle = XmlUtils.getChild(this.fileDataEle, "DataTable");
        }
        finally {
            StreamUtils.closeStream(null, xmlInputStream);
        }
    }

    @Override
    public void createResult() throws ToolException {
        this.fillInfo();
        this.fillCustomerInfo();
        Date curDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String curDateStr = dateFormat.format(curDate);
        Element dataEndEle = XmlUtils.getChild(this.fileDataEle, "DataEnd");
        if (dataEndEle != null) {
            dataEndEle.setAttribute("datetime", curDateStr);
        } else {
            LOGGER.error("dataEndEle is null!");
        }
        this.delEmptyXmlNode();
        String reportPath = this.getReportPath();
        this.writeXmlFile(this.reportDoc, reportPath, ENCODING_UTF8);
        DeviceArchiveContext.getInstance().putResultSavePath(this.devNodeSn, reportPath);
        OSCmdUtils.executeCmd("icacls " + reportPath + " /inheritance:d");
        OSCmdUtils.executeCmd("icacls " + reportPath + " /remove:g Users");
    }

    @NotNull
    private String getReportPath() {
        StringBuffer sbReportPath = new StringBuffer();
        sbReportPath.append(this.reportSavePath);
        sbReportPath.append(File.separator);
        sbReportPath.append(IBMS_FILE_PREFIX);
        sbReportPath.append(UNDERLINE);
        sbReportPath.append(this.getProductModelFromRetDataMap());
        sbReportPath.append(UNDERLINE);
        sbReportPath.append(this.devNodeSn);
        sbReportPath.append(EXTENSION_XML);
        return sbReportPath.toString();
    }

    private void delEmptyXmlNode() {
        NodeList childNodeList = this.dataTableEle.getChildNodes();
        int childNodeCount = childNodeList.getLength();
        for (int i = 0; i < childNodeCount; ++i) {
            Node childNode = childNodeList.item(i);
            if (childNode.hasChildNodes()) continue;
            this.dataTableEle.removeChild(childNode);
            childNodeCount = childNodeList.getLength();
            --i;
        }
    }

    private void writeXmlFile(Document doc, String filename, String encoding) throws ToolException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(filename));
        try {
            Transformer xFormer = TransformerFactory.newInstance().newTransformer();
            xFormer.setOutputProperty("encoding", encoding);
            xFormer.setOutputProperty("indent", "yes");
            xFormer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new ToolException(e.toString(), false, (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ToolException(e.toString(), false, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ToolException(e.toString(), false, (Throwable)e);
        }
    }

    private String getXmlArchiveCfgPath(String xmlPath) {
        StringBuffer sbFilePath = new StringBuffer();
        sbFilePath.append(this.packagePath);
        sbFilePath.append(File.separator);
        sbFilePath.append(xmlPath);
        return sbFilePath.toString();
    }

    private void createSingleArchiveItem(Element dataTypeCfgEle, Element parentEle) {
        String typeId = dataTypeCfgEle.getAttribute("typeId");
        String xmlDataTypeTag = dataTypeCfgEle.getAttribute("xmlTag");
        if (StringUtils.isNULLStr(xmlDataTypeTag)) {
            return;
        }
        String name = dataTypeCfgEle.getAttribute("Name");
        List<Map<String, String>> xmlAttrMapList = this.getXmlAttrMap(dataTypeCfgEle);
        List<Map<String, Object>> archiveTypeDataList = this.retDataMap.get(typeId);
        if (archiveTypeDataList == null) {
            return;
        }
        for (Map<String, Object> archiveDataMap : archiveTypeDataList) {
            Element newEle = this.reportDoc.createElement(xmlDataTypeTag);
            this.insertAttrMap(xmlAttrMapList, archiveDataMap, newEle);
            if (!StringUtils.isNULLStr(name)) {
                newEle.setAttribute("Name", name);
            }
            parentEle.appendChild(newEle);
        }
    }

    private void insertAttrMap(List<Map<String, String>> xmlAttrMapList, Map<String, Object> archiveDataMap, Element newEle) {
        HashMap<String, PyList> devicePartMap = new HashMap<String, PyList>();
        HashMap<String, String> deviceExtendMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : archiveDataMap.entrySet()) {
            String xmlDataAttrTag;
            String xmlAttrId = entry.getKey();
            Map<String, String> attrMap = this.getAttrMapByAttrId(xmlAttrMapList, xmlAttrId);
            if (attrMap == null || StringUtils.isNULLStr(xmlDataAttrTag = attrMap.get("xmlTag"))) continue;
            if (BOOLEAN_TRUE.equals(attrMap.get("isChild"))) {
                String childTag = attrMap.get("childTag");
                Element subAttrEle = this.reportDoc.createElement(childTag);
                if (childTag.contains("Version")) {
                    subAttrEle.setAttribute("Type", xmlDataAttrTag);
                    subAttrEle.setAttribute("Value", archiveDataMap.get(xmlAttrId).toString());
                } else if (childTag.contains("Patch")) {
                    subAttrEle.setAttribute("Patch", archiveDataMap.get(xmlAttrId).toString());
                } else {
                    if (childTag.contains("DevicePart") && archiveDataMap.get(xmlAttrId) instanceof PyList) {
                        devicePartMap.put(xmlDataAttrTag, (PyList)archiveDataMap.get(xmlAttrId));
                        continue;
                    }
                    if (!childTag.contains("DeviceExtend")) continue;
                    deviceExtendMap.put(xmlDataAttrTag, archiveDataMap.get(xmlAttrId).toString());
                    continue;
                }
                newEle.appendChild(subAttrEle);
                continue;
            }
            try {
                newEle.setAttribute(xmlDataAttrTag, entry.getValue().toString());
            }
            catch (DOMException e) {
                LOGGER.error("could not write entry to file : " + xmlDataAttrTag);
            }
        }
        if (xmlAttrMapList.stream().anyMatch(map -> map.containsValue("NE_SN"))) {
            newEle.setAttribute("NE_SN", this.devNodeSn);
        }
        this.insertChildTable(newEle, devicePartMap, deviceExtendMap);
    }

    private void insertChildTable(Element newEle, Map<String, PyList> devPartMap, Map<String, String> devExtendMap) {
        Element attrEle;
        if (!devPartMap.isEmpty()) {
            int length = devPartMap.entrySet().iterator().next().getValue().size();
            for (int i = 0; i < length; ++i) {
                attrEle = this.reportDoc.createElement("DevicePart");
                for (Map.Entry<String, PyList> stringEntry : devPartMap.entrySet()) {
                    attrEle.setAttribute(stringEntry.getKey(), stringEntry.getValue().get(i).toString());
                }
                newEle.appendChild(attrEle);
            }
        }
        if (!devExtendMap.isEmpty()) {
            for (Map.Entry<String, String> entry : devExtendMap.entrySet()) {
                attrEle = this.reportDoc.createElement("DeviceExtend");
                attrEle.setAttribute("Name", entry.getKey());
                attrEle.setAttribute("Value", entry.getValue());
                newEle.appendChild(attrEle);
            }
        }
    }

    private Map<String, String> getAttrMapByAttrId(List<Map<String, String>> xmlAttrMapList, String attrId) {
        for (Map<String, String> attrMap : xmlAttrMapList) {
            if (!attrId.equals(attrMap.get("attrId"))) continue;
            return attrMap;
        }
        return null;
    }

    private List<Map<String, String>> getXmlAttrMap(Element dataTypeCfgEle) {
        ArrayList<Map<String, String>> xmlAttrMapList = new ArrayList<Map<String, String>>();
        Collection<Element> dataAttrList = XmlUtils.getChildren(dataTypeCfgEle, "DataAttr");
        for (Element dataAttr : dataAttrList) {
            HashMap<String, String> attrMap = new HashMap<String, String>();
            attrMap.put("attrId", dataAttr.getAttribute("attrId"));
            attrMap.put("xmlTag", dataAttr.getAttribute("xmlTag"));
            attrMap.put("isChild", dataAttr.getAttribute("isChild"));
            attrMap.put("childTag", dataAttr.getAttribute("childTag"));
            xmlAttrMapList.add(attrMap);
        }
        return xmlAttrMapList;
    }

    private void createGroupArchiveItem(Element dataGroupEle) {
        String groupName = dataGroupEle.getAttribute("name");
        boolean hasTypePart = Boolean.parseBoolean(dataGroupEle.getAttribute("hasTypePart"));
        Element newEle = this.reportDoc.createElement(groupName);
        Collection<Element> dataTypeCfgList = XmlUtils.getChildren(dataGroupEle, "DataType");
        if (hasTypePart) {
            int index = 0;
            for (Element dataTypeCfgEle : dataTypeCfgList) {
                this.createMultipleArchiveItem(dataTypeCfgEle, newEle, index);
                ++index;
            }
        } else {
            for (Element dataTypeCfgEle : dataTypeCfgList) {
                this.createSingleArchiveItem(dataTypeCfgEle, newEle);
            }
        }
        this.dataTableEle.appendChild(newEle);
    }

    private void createMultipleArchiveItem(Element dataTypeCfgEle, Element parentEle, int index) {
        String typeId = dataTypeCfgEle.getAttribute("typeId");
        String xmlDataTypeTag = dataTypeCfgEle.getAttribute("xmlTag");
        if (StringUtils.isNULLStr(xmlDataTypeTag)) {
            return;
        }
        List<Map<String, Object>> archiveTypeDataList = this.retDataMap.get(typeId);
        for (Map<String, Object> archiveDataMap : archiveTypeDataList) {
            Element newEle = this.reportDoc.createElement(xmlDataTypeTag);
            List<Map<String, String>> xmlAttrMapList = this.getXmlAttrMap(dataTypeCfgEle);
            this.insertAttrMap(xmlAttrMapList, archiveDataMap, newEle);
            Collection<Element> dataPartCfgList = XmlUtils.getChildren(dataTypeCfgEle, "DataTypePart");
            for (Element dataPartCfgEle : dataPartCfgList) {
                this.createHasPartTypeArchiveItem(dataPartCfgEle, newEle, typeId, index);
            }
            parentEle.appendChild(newEle);
        }
    }

    private void createHasPartTypeArchiveItem(Element dataTypeCfgEle, Element parentEle, String id, int index) {
        String typeId = dataTypeCfgEle.getAttribute("typeId");
        String xmlDataTypeTag = dataTypeCfgEle.getAttribute("xmlTag");
        String name = dataTypeCfgEle.getAttribute("Name");
        List archiveTypeDataList = (List)this.retDataMap.get(id).get(index).get(typeId);
        if (Utils.isNullList((List)archiveTypeDataList)) {
            return;
        }
        for (Map archiveDataMap : archiveTypeDataList) {
            Element newEle = this.reportDoc.createElement(xmlDataTypeTag);
            List<Map<String, String>> xmlAttrMapList = this.getXmlAttrMap(dataTypeCfgEle);
            this.insertAttrMap(xmlAttrMapList, archiveDataMap, newEle);
            if (!StringUtils.isNULLStr(name)) {
                newEle.setAttribute("Type", name);
            }
            parentEle.appendChild(newEle);
        }
    }

    private void fillInfo() throws ToolException {
        if (null == this.retDataMap) {
            LOGGER.error("The retDataMap is null.");
            return;
        }
        for (String retDataTitle : this.retDataMap.keySet()) {
            LOGGER.info("retDataTitle: {}", (Object)retDataTitle);
        }
        if (!this.isDstorage) {
            this.replaceProductModel();
        }
        Document xmlCfgDoc = null;
        FileInputStream fin = null;
        String xmlPath = this.getXmlPath();
        try {
            fin = new FileInputStream(new File(this.getXmlArchiveCfgPath(xmlPath)));
            xmlCfgDoc = XmlUtils.parseDocument(fin);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ToolException("file not found.");
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, fin);
                throw throwable;
            }
        }
        StreamUtils.closeStream(null, fin);
        Element xmlCfgRoot = xmlCfgDoc.getDocumentElement();
        Collection<Element> dataTypeCfgList = XmlUtils.getChildren(xmlCfgRoot, "DataType");
        for (Element dataTypeCfgEle : dataTypeCfgList) {
            this.createSingleArchiveItem(dataTypeCfgEle, this.dataTableEle);
        }
        Collection<Element> dataGroupCfgList = XmlUtils.getChildren(xmlCfgRoot, "DataGroup");
        for (Element dataGroupCfgEle : dataGroupCfgList) {
            this.createGroupArchiveItem(dataGroupCfgEle);
        }
    }

    private String getXmlPath() {
        if (Products.OCEAN_STOR_MICRO_DEVS.contains(this.deviceType)) {
            return XML_ARCHIVE_CFG_MICRO;
        }
        if (Products.DORADO_V6_DEV.contains(this.deviceType)) {
            return XML_ARCHIVE_CFG_DORADO;
        }
        return XML_ARCHIVE_CFG;
    }

    private void replaceProductModel() {
        try {
            this.getSystemMap();
        }
        catch (Exception e) {
            LOGGER.error("The retDataMap doesn't have the content we need.", (Throwable)e);
            return;
        }
        this.putProductModelToRetDataMap(this.deviceType);
    }

    private String getProductModelFromRetDataMap() {
        return String.valueOf(this.getSystemMap().get(this.getSystemMapModelKey()));
    }

    private void putProductModelToRetDataMap(String model) {
        this.getSystemMap().put(this.getSystemMapModelKey(), model);
    }

    private Map<String, Object> getSystemMap() {
        return this.retDataMap.get(SYSTEM).get(0);
    }

    private String getSystemMapModelKey() {
        return this.getSystemMap().keySet().stream().filter(this::isModelKey).findFirst().orElse("");
    }

    private boolean isModelKey(String key) {
        return productModelKeys.contains(key);
    }

    private void fillCustomerInfo() {
        CustomerInfo customerInfo = this.collectInfo.getCustomerInfo();
        Map<String, String> customerInfoMap = customerInfo.getCustomerMap();
        if (customerInfoMap.isEmpty()) {
            LOGGER.error("The customer info map is empty.");
            return;
        }
        Element neInfoEle = XmlUtils.getChild(this.dataTableEle, "NEInformation");
        if (null == neInfoEle) {
            LOGGER.error("The NEInformation node is not exist, need to create new one.");
            neInfoEle = this.reportDoc.createElement("NEInformation");
            this.dataTableEle.appendChild(neInfoEle);
        }
        for (Map.Entry<String, String> entry : customerInfoMap.entrySet()) {
            if (StringUtils.isNULLStr(entry.getKey()) || StringUtils.isNULLStr(entry.getValue()) || !"Site Name".equals(entry.getKey())) continue;
            Element extendEle = this.reportDoc.createElement("Extend");
            extendEle.setAttribute("Name", entry.getKey());
            extendEle.setAttribute("Value", entry.getValue());
            neInfoEle.appendChild(extendEle);
        }
    }
}

