/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.cert.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.certbase.ssl.MyTrustSslSocketFactoryTool;
import com.huawei.ism.tool.channel.cert.service.HttpsCertManager;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCertUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLCertUtils.class);
    private static final String PUBLICKEY_BEGIN = "BEGIN PUBLIC KEY";
    private static final String PUBLICKEY_END = "END PUBLIC KEY";

    public static SSLSocketFactory getSSLFactory() {
        try {
            return MyTrustSslSocketFactoryTool.getMyTrustSSLFactory(SSLCertUtils.getCertPath(), "TLSv1.2");
        }
        catch (CertificateException e) {
            LOGGER.error("getCertSSLSocket CertificateException");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("getCertSSLSocket NoSuchAlgorithmException");
        }
        catch (KeyStoreException e) {
            LOGGER.error("getCertSSLSocket KeyStoreException");
        }
        return null;
    }

    private static String getCertPath() {
        String path = ApplicationContext.getInstance().getCurrWorkPath() + HttpsPropUtils.getCertFileDir();
        File certDir = new File(path);
        if (certDir.exists() && certDir.isDirectory()) {
            try {
                return certDir.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("getCertPath error.");
            }
        }
        return "";
    }

    public static SSLSocketFactory getServerSSLFactory() {
        return SSLCertUtils.getSSLFactory();
    }

    public static SSLSocketFactory getYellowServerSSLFactory() {
        return SSLCertUtils.getSSLFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate getServerX509Cert(String serverCertPath) {
        InputStream input = null;
        try {
            X509Certificate cert;
            ClassLoader loader = SSLCertUtils.class.getClassLoader();
            if (null == loader) {
                LOGGER.error("get class loader exception.");
                X509Certificate x509Certificate = null;
                return x509Certificate;
            }
            input = loader.getResourceAsStream(serverCertPath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(input);
            return x509Certificate;
        }
        catch (CertificateException e) {
            LOGGER.error("getServerX509Certificate error.CertificateException");
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.error("close InputStream error.IOException");
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getClientX509Cert(String clentCertPath) {
        KeyStore keyStore = null;
        FileInputStream fis = null;
        try {
            X509Certificate certificate;
            keyStore = KeyStore.getInstance("PKCS12");
            String cntCertPath = clentCertPath == null ? HttpsCertManager.getInstance().getClientCertPath() : clentCertPath;
            File file = new File(cntCertPath).getCanonicalFile();
            if (file.exists()) {
                LOGGER.info("get user cert");
                fis = new FileInputStream(cntCertPath);
                keyStore.load(fis, HttpsCertManager.getInstance().getClientCertPwd());
            } else {
                LOGGER.info("get default cert");
                fis = new FileInputStream(HttpsCertManager.getInstance().getDefaultClientCertPath());
                keyStore.load(fis, HttpsCertManager.getInstance().getDefaultClientCertPwd());
            }
            Certificate[] certs = keyStore.getCertificateChain("client");
            if (null == certs) {
                certs = keyStore.getCertificateChain("1");
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(certs[0].getEncoded());
            X509Certificate x509Certificate = certificate = (X509Certificate)cf.generateCertificate(bais);
            return x509Certificate;
        }
        catch (CertificateException e) {
            LOGGER.error("getClientX509Cert error.CertificateException");
        }
        catch (FileNotFoundException e) {
            LOGGER.error("getClientX509Cert error.FileNotFoundException");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("getClientX509Cert error.NoSuchAlgorithmException");
        }
        catch (IOException e) {
            LOGGER.error("getClientX509Cert error.IOException", e);
        }
        catch (KeyStoreException e) {
            LOGGER.error("getClientX509Cert error.KeyStoreException");
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.error("close fis error.IOException");
                }
            }
        }
        return null;
    }

    public static X509Certificate getClientX509Cert() {
        return SSLCertUtils.getClientX509Cert(HttpsCertManager.getInstance().getClientCertPath());
    }

    public static PublicKey getPublicKey(String filePath) {
        X509Certificate x509Cert = SSLCertUtils.getServerX509Cert(filePath);
        if (null != x509Cert) {
            PublicKey publicKey = x509Cert.getPublicKey();
            return publicKey;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPublicKeyStr(String pemPath) {
        String path = pemPath + HttpsPropUtils.getPublicKeyVersioin() + ".pem";
        InputStream input = null;
        ClassLoader sslClassLoader = SSLCertUtils.class.getClassLoader();
        if (null == sslClassLoader) {
            LOGGER.error("get class loader exception.");
            return "";
        }
        input = sslClassLoader.getResourceAsStream(path);
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            if (null == input) {
                String string = "";
                return string;
            }
            reader = new BufferedReader(new InputStreamReader(input, "utf-8"));
            String temp = "";
            while (null != (temp = reader.readLine())) {
                if (temp.contains(PUBLICKEY_BEGIN) || temp.contains(PUBLICKEY_END)) continue;
                sb.append(temp);
            }
            StreamUtils.closeResource(null, (Closeable)reader);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("privateKey File is not found.");
        }
        catch (IOException e) {
            LOGGER.error("read privateKey File failed.", e);
        }
        finally {
            StreamUtils.closeResource(null, reader);
        }
        return sb.toString();
    }
}

