/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.PostRequestByFile;
import com.huawei.ism.tool.protocol.rest.PutRequest;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.rest.iterf.IRestConn;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.Optional;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.apache.hc.core5.http.message.StatusLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmeRestConnection
extends RestConnection
implements IRestConn,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DmeRestConnection.class);

    public DmeRestConnection(DevNode devNode, HttpResponseInterceptor responseInterceptor, boolean isDstorage) {
        super(devNode, responseInterceptor, isDstorage);
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        req.addParam("grantType", "password");
        req.addParam("userName", this.userName);
        req.addParam("value", this.devNode.getLoginUser().getPassword());
        req.setHeader("Content-Type", "application/json");
    }

    @Override
    public ResponseInfo login(boolean isLogging) throws ToolException {
        if (null == this.uri) {
            log.info("url is null");
            return null;
        }
        PutRequest req = new PutRequest(this.uri);
        this.setLoginParam(req);
        this.createForwardOnNeeded(this.devNode);
        this.reporaceAddressOnForward(req);
        ResponseInfo resp = null;
        try {
            this.initSession();
            resp = this.session.sendRequest1(req, isLogging);
            this.setLoginStatus(this.checkLoginResult(resp));
        }
        catch (IOException e) {
            log.error("Login device by rest failed:", (Throwable)e);
            if ("sun.security.validator.ValidatorException: No trusted certificate found".contains(e.getMessage())) {
                this.closeSession();
                throw new ToolException("No trusted certificate found");
            }
            return null;
        }
        catch (JSONException e) {
            this.closeSession();
            log.error("Login device by rest failed:", (Throwable)e);
            return resp;
        }
        catch (CertificateException e) {
            log.error(e.getMessage());
            throw new ToolException("No trusted certificate found");
        }
        return resp;
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
        if (!(req instanceof PostRequestByFile)) {
            req.setHeader("Content-Type", "application/json");
        }
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        int code = resp.getStatusLine().getStatusCode();
        if (code != 200) {
            log.error("receive a bad http status code {} , response : {} ", (Object)code, (Object)SensitiveInfoFilter.filter(resp.getContent()));
            throw new ToolException("http.authorized.failed");
        }
        String content = resp.getContent();
        JSONObject json = new JSONObject(content);
        this.session.setSessionID(this.getJsonValue("roaRand", json));
        this.session.setToken(this.getJsonValue("accessSession", json));
        return true;
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        return Optional.ofNullable(resp).map(ResponseInfo::getStatusLine).map(StatusLine::getStatusCode).filter(statusCode -> statusCode == 401).isPresent();
    }
}

