/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import cn.hutool.core.io.resource.InputStreamResource;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.VerifyUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.connection.MultiRouteManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.DeleteRequest;
import com.huawei.ism.tool.protocol.rest.DownFileObserver;
import com.huawei.ism.tool.protocol.rest.GetRequest;
import com.huawei.ism.tool.protocol.rest.GetResultWithBody;
import com.huawei.ism.tool.protocol.rest.HttpSession;
import com.huawei.ism.tool.protocol.rest.PostRequest;
import com.huawei.ism.tool.protocol.rest.PostRequestByFile;
import com.huawei.ism.tool.protocol.rest.PutRequest;
import com.huawei.ism.tool.protocol.rest.StateLessRestCallback;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.rest.iterf.IRestConn;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponseInterceptor;
import org.jetbrains.annotations.NotNull;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.slf4j.Logger;

public class RestConnection
implements IRestConn,
AutoCloseable {
    private static final int SUCCESS_FLAG = 0;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(RestConnection.class);
    private static final int TIMEOUTSTATUSCODE = -401;
    private static final int TOKEN_INVALID = 500;
    private static final String TOKEN_INVALID_ERR_SUGGEST_K_WORD = "token is invalid";
    private static final String LOGIN_PWD_ERROR = "The user name or password is incorrect";
    private static final String VALIDATOR_EXCEPTION = "sun.security.validator.ValidatorException: No trusted certificate found";
    protected String userName;
    public static final String CERT_VALIDATE_ERROR_KEY = "No trusted certificate found";
    private static final String DOMAIN_SCOPE = "1";
    private int responseTimeOut = -1;
    protected String uri;
    private String loginUri;
    private String passW;
    private String scope;
    protected HttpSession session;
    protected HttpResponseInterceptor responseInterceptor;
    private boolean isLogined = false;
    protected DevNode devNode;
    private int foradPort = 0;
    private boolean isDstorage = false;
    private MultiRouteManager routeMgr = null;
    private int level = 3;
    private int roleId = 0;
    public static final String LEVEL_KEY = "level";
    public static final String COOKIE_NAME = "name";
    public static final String COOKIE_VALUE = "value";
    public static final String RILE_ID_KEY = "roleId";
    public static final String FS_ROLE_ID_KEY = "role_id";
    private String proxySvpIp = "";
    private List<String> sensitiveLogKeyword = Arrays.asList("x-auth-token", "x_csrf_token", "iBaseToken", "accessSession");
    private String authToken = "";
    private RequestInfo loginInfo = null;
    private StateLessRestCallback callback = null;

    public String getUri() {
        return this.uri;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void setForadPort(int foradPort) {
        this.foradPort = foradPort;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    private RestConnection(String uRI, String userName, String password, String scope) {
        this.uri = uRI;
        this.userName = userName;
        this.passW = password;
        this.scope = scope;
        if (scope == null || scope.isEmpty()) {
            this.scope = "0";
        }
        this.disableHttpLog();
    }

    public RestConnection(DevNode devNode) {
        this(RestUtil.getloginUri(devNode), devNode.getLoginUser().getUserName(), devNode.getLoginUser().getPassword(), null);
        this.devNode = devNode;
        this.disableHttpLog();
    }

    public static Map<String, String> getRestConnectHeader(RestConnection connection) {
        HttpSession newSession = connection.getSession();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("iBaseToken", newSession.getSessionID());
        newSession.getCookieStore().getCookies().stream().findFirst().ifPresent(cookie -> headers.put("Cookie", "session=" + cookie.getValue()));
        headers.put("Content-Type", "multipart/form-data");
        return headers;
    }

    public String getBaseUrl() {
        return RestUtil.getBaseUri(this.devNode);
    }

    public String getHttpsPrefixWithAddress() {
        return RestUtil.getHttpsPrefixWithAddress(this.devNode);
    }

    public String getDstorageBaseUrlNoV2() {
        return RestUtil.getDstorageBaseUrlNoV2(this.devNode);
    }

    public RestConnection(DevNode devNode, HttpResponseInterceptor responseInterceptor, boolean isDstorage) {
        this(isDstorage ? RestUtil.getDstorageloginUri(devNode) : RestUtil.getloginUri(devNode), devNode.getLoginUser().getUserName(), devNode.getLoginUser().getPassword(), null);
        this.devNode = devNode;
        this.isDstorage = isDstorage;
        this.responseInterceptor = responseInterceptor;
        this.disableHttpLog();
    }

    public RestConnection(DevNode devNode, boolean isDstorage) {
        this(devNode, null, isDstorage);
    }

    public void createForwardOnNeeded(DevNode node) {
        if (node.getSshForwardList() != null && !node.getSshForwardList().isEmpty()) {
            try {
                int portNew;
                this.routeMgr = new MultiRouteManager(node.getSshForwardList());
                this.foradPort = portNew = this.routeMgr.createForwarderLocalPort(node.getIp(), 8088);
            }
            catch (Exception e) {
                if (this.routeMgr != null) {
                    this.routeMgr.close();
                }
                LOGGER.error("create forward error", (Throwable)e);
            }
        }
    }

    public RestConnection(String uri, DevNode devNode) {
        this(uri, devNode.getLoginUser().getUserName(), devNode.getLoginUser().getPassword(), null);
        this.devNode = devNode;
        this.disableHttpLog();
    }

    public boolean isLogin() {
        return this.session != null && this.isLogined;
    }

    public synchronized void reLogin() throws ToolException {
        try {
            String reLoginUri = this.loginUri;
            if (this.session != null) {
                this.logOut();
                this.session.close();
                this.session = null;
                this.authToken = "";
            }
            if (this.routeMgr != null) {
                try {
                    this.routeMgr.close();
                }
                catch (Exception e) {
                    LOGGER.error("close route error.");
                }
            }
            this.isLogined = false;
            this.loginUri = reLoginUri;
            this.uri = reLoginUri;
        }
        catch (Exception e) {
            LOGGER.error("in reconnect close Connection error!", (Throwable)e);
        }
        this.login();
    }

    public void reLoginWithTimeOut() throws ToolException {
        this.uri = this.loginUri;
        try {
            if (this.session != null) {
                this.session.close();
                this.session = null;
                this.isLogined = false;
            }
        }
        catch (Exception e1) {
            LOGGER.error("reLogin in reconnect close Connection error!", (Throwable)e1);
        }
        this.login();
    }

    public void checkAndReLogin(String checkUri) throws ToolException {
        if (!this.isAuthenticate(checkUri)) {
            LOGGER.info("Connection is closed, and try to login again.");
            this.uri = this.loginUri;
            this.login();
        }
    }

    public boolean isAuthenticate(String checkUri) {
        try {
            this.execGet(checkUri);
        }
        catch (Exception e) {
            LOGGER.error("Connection is closed, Please login again.");
            return false;
        }
        return true;
    }

    public ResponseInfo login() throws ToolException {
        return this.login(true);
    }

    public ResponseInfo login(boolean isLogging) throws ToolException {
        if (null == this.uri) {
            LOGGER.info("url is null");
            return null;
        }
        PostRequest req = new PostRequest(this.uri);
        this.setLoginParam(req);
        this.createForwardOnNeeded(this.devNode);
        this.reporaceAddressOnForward(req);
        ResponseInfo resp = null;
        try {
            this.initSession();
        }
        catch (CertificateException e) {
            LOGGER.error(e.getMessage());
            throw new ToolException(CERT_VALIDATE_ERROR_KEY);
        }
        try {
            resp = this.session.sendRequest1(req, isLogging);
            boolean success = this.checkLoginResult(resp);
            this.setLoginStatus(success);
        }
        catch (IOException e) {
            if (VALIDATOR_EXCEPTION.contains(e.getMessage())) {
                LOGGER.error(e.getMessage());
                throw new ToolException(CERT_VALIDATE_ERROR_KEY);
            }
            this.closeSession();
            LOGGER.error("Login device by rest failed:", (Throwable)e);
            return resp;
        }
        catch (JSONException e) {
            this.closeSession();
            LOGGER.error("Login device by rest failed:", (Throwable)e);
            return resp;
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCert(DevNode dev) throws ToolException {
        if (null == this.uri) {
            LOGGER.info("url is null");
            return;
        }
        PostRequest req = new PostRequest(this.uri);
        this.setLoginParam(req);
        this.createForwardOnNeeded(this.devNode);
        this.reporaceAddressOnForward(req);
        try (HttpSession tempSessioin = null;){
            tempSessioin = HttpSession.createNewSession(dev, (CookieStore)new BasicCookieStore());
            if (VerifyUtil.isEmpty((Object)tempSessioin)) {
                return;
            }
            if (this.responseTimeOut > 0) {
                tempSessioin.setReadDataTimeout(this.responseTimeOut);
            }
            LOGGER.info("login result:{}", (Object)this.checkLoginResult(tempSessioin.sendRequest1(req, true)));
        }
    }

    protected void setLoginParam(RequestInfo req) {
        String userNameKey = this.isDstorage ? "user_name" : "username";
        req.addParam(userNameKey, this.getParamUserName());
        req.addParam("password", this.passW);
        req.addParam("scope", this.getParamScope());
    }

    private String getParamUserName() {
        return this.isDomainUser() ? this.userName.replace("domain/", "") : this.userName;
    }

    private String getParamScope() {
        return this.isDomainUser() ? DOMAIN_SCOPE : this.scope;
    }

    private boolean isDomainUser() {
        return this.userName.startsWith("domain/") || this.devNode.getLoginUser().isDomain();
    }

    /*
     * Exception decompiling
     */
    public ResponseInfo loginSvpProxy() throws ToolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkSvpProxyCanProcessLogin() {
        if (this.uri == null) {
            LOGGER.info("url is null");
            return false;
        }
        if (!this.devNode.getHighDevSVPModuleInfo().endsWith("hassvp")) {
            LOGGER.info("not svp device");
            return false;
        }
        if (this.devNode.getSshForwardList() == null || this.devNode.getSshForwardList().isEmpty()) {
            LOGGER.info("ssh forward list is empty");
            return false;
        }
        return true;
    }

    private void checkIsPwdError(ResponseInfo resp) throws ToolException {
        if (resp.getContentMap().getOrDefault("description", "").toString().contains(LOGIN_PWD_ERROR)) {
            throw new ToolException("http.authorized.failed");
        }
    }

    public ResponseInfo loginThrowErrorCode() throws ToolException {
        if (null == this.uri) {
            LOGGER.info("url is null");
            return null;
        }
        PostRequest req = new PostRequest(this.uri);
        this.setLoginParam(req);
        this.createForwardOnNeeded(this.devNode);
        this.reporaceAddressOnForward(req);
        try {
            this.initSession();
        }
        catch (CertificateException e) {
            LOGGER.error(e.getMessage());
            throw new ToolException(CERT_VALIDATE_ERROR_KEY);
        }
        ResponseInfo resp = null;
        try {
            resp = this.session.sendRequest1(req, true);
            this.checkLoginResult(resp);
        }
        catch (JSONException | IOException e) {
            this.closeSession();
            LOGGER.error("Login device by rest failed:", e);
            return resp;
        }
        Long obj = (Long)resp.getContentMap().get("errorCode");
        if (obj == null || 0L != obj) {
            this.isLogined = false;
            LOGGER.error("Rest login failed:" + obj);
            throw new ToolException(null != obj ? obj.toString() : "-1");
        }
        LOGGER.info("login success.");
        this.isLogined = true;
        this.loginUri = this.uri;
        return resp;
    }

    protected void initSession() throws CertificateException {
        this.initSession((CookieStore)new BasicCookieStore());
    }

    private void initSession(CookieStore cookieStore) throws CertificateException {
        if (this.session == null) {
            this.session = HttpSession.createNewSession(this.devNode, cookieStore, this.responseInterceptor);
            if (null == this.session) {
                throw new NullPointerException();
            }
            if (this.responseTimeOut > 0) {
                this.session.setReadDataTimeout(this.responseTimeOut);
            }
        }
    }

    public void setTimeout(int second) {
        this.responseTimeOut = second;
        if (this.responseTimeOut > 0) {
            this.session.setReadDataTimeout(this.responseTimeOut);
        }
    }

    public String getPassword() {
        return AESEncrypt.decrypt((String)this.passW);
    }

    @Override
    public ResponseInfo execGet(String url, String param) throws ToolException {
        return this.execGet(url, param, null);
    }

    public PyDictionary execGetForBig(String url, String param) throws ToolException {
        ResponseInfo resp = this.execGet(url, param);
        if (null == resp) {
            LOGGER.info("url is null");
            return null;
        }
        JSONObject json = new JSONObject(resp.getContent());
        JSONArray data = null;
        try {
            data = json.getJSONArray("data");
        }
        catch (JSONException je) {
            data = new JSONArray();
        }
        JSONObject error = json.getJSONObject("error");
        PyList pylist = new PyList();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject obj = (JSONObject)data.get(i);
            Iterator it = obj.keys();
            PyDictionary pymap = new PyDictionary();
            while (it.hasNext()) {
                String key = (String)it.next();
                pymap.put((Object)key, obj.get(key));
            }
            pylist.append((PyObject)pymap);
        }
        Iterator iterror = error.keys();
        PyDictionary errormap = new PyDictionary();
        while (iterror.hasNext()) {
            String key = (String)iterror.next();
            errormap.put((Object)key, error.get(key));
        }
        PyDictionary pymapAll = new PyDictionary();
        pymapAll.put((Object)"data", (Object)pylist);
        pymapAll.put((Object)"error", (Object)errormap);
        return pymapAll;
    }

    private ResponseInfo requestProcess(String param, RequestInfo req, IRestConn.RestParamEntity entity) throws ToolException {
        return this.requestProcess(param, req, entity, null);
    }

    private ResponseInfo requestProcess(String param, RequestInfo req, IRestConn.RestParamEntity entity, Map headerParam) throws ToolException {
        return this.requestProcess(param, req, entity, headerParam, null);
    }

    private ResponseInfo requestProcess(String param, RequestInfo req, IRestConn.RestParamEntity entity, Map headerParam, DownFileObserver downFileObserver) throws ToolException {
        if (null == this.session || !this.isLogined) {
            LOGGER.warn("connection is closed");
            ResponseInfo resp = new ResponseInfo();
            return resp;
        }
        this.reporaceAddressOnForward(req);
        LOGGER.info("param: {}", (Object)SensitiveInfoFilter.filter(param));
        this.addParams(param, req);
        this.createHeader(req, headerParam);
        ResponseInfo resp = null;
        try {
            resp = this.session.sendRequest1(req, true, downFileObserver);
            if ((null == entity || entity.isWithLog()) && LOGGER.isInfoEnabled()) {
                LOGGER.info("ResponseInfo : {}", (Object)resp.getContent());
            }
        }
        catch (IllegalStateException ise) {
            this.reLogin();
        }
        catch (IOException e) {
            if (req instanceof DeleteRequest && this.isLoginRequest(req)) {
                LOGGER.info("Login connections of the delete rest do not need to be closed.");
            } else {
                this.closeSession();
            }
            LOGGER.info("error.conn", (Throwable)e);
            return resp;
        }
        return resp;
    }

    private boolean isLoginRequest(RequestInfo req) {
        String forwardUrl = "";
        if (this.foradPort != 0) {
            forwardUrl = req.getURL().replace("127.0.0.1", this.devNode.getIp()).replace(String.valueOf(this.foradPort), String.valueOf(8088));
        }
        return req.getURL().equals(this.loginUri) || forwardUrl.equals(this.loginUri);
    }

    protected void createHeader(RequestInfo req, Map headerParam) {
        if (!this.isDstorage) {
            req.setHeader("iBaseToken", this.session.getSessionID());
            if (req.getURL().contains("/api/v2")) {
                req.setHeader("Content-Type", "application/json");
            }
            req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        } else {
            req.setHeader("X-Auth-Token", this.session.getToken());
            if (!req.getURL().contains("/cluster/inspection/patch") && !req.getURL().contains("/cluster/collection/patch")) {
                req.setHeader("Content-Type", "application/json");
                req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
            }
        }
        if (null != headerParam) {
            for (Object key : headerParam.keySet()) {
                req.setHeader(key.toString(), headerParam.get(key).toString());
            }
        }
    }

    public void addParams(String param, RequestInfo req) {
        if (param != null && !param.isEmpty()) {
            try {
                JSONObject json = new JSONObject(param);
                Iterator nameItr = json.keys();
                while (nameItr.hasNext()) {
                    String name = (String)nameItr.next();
                    req.addParam(name, json.get(name));
                }
            }
            catch (JSONException e) {
                LOGGER.error("param is error", (Throwable)e);
                req.setParamStr(param);
            }
        }
    }

    public void reporaceAddressOnForward(RequestInfo req) {
        if (this.foradPort != 0) {
            req.setUrl(req.getURL().replace(this.devNode.getIp(), "127.0.0.1").replace(String.valueOf(8088), String.valueOf(this.foradPort)));
        }
    }

    @Override
    public ResponseInfo execDelete(String url, String param) throws ToolException {
        return this.execDelete(url, param, null);
    }

    @Override
    public ResponseInfo execDelete(String url) throws ToolException {
        return this.execDelete(url, null, null);
    }

    @Override
    public ResponseInfo execPost(String url, String param) throws ToolException {
        return this.execPost(url, param, null);
    }

    public void closeSession() {
        if (this.session != null) {
            this.logOut();
            this.session.close();
            this.session = null;
        }
        if (this.routeMgr != null) {
            try {
                this.routeMgr.close();
            }
            catch (Exception e) {
                LOGGER.error("close route error.");
            }
        }
    }

    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        this.checkLoginStatus(resp);
        this.parseLoginData(resp);
        this.checkIsPwdError(resp);
        Long obj = (Long)resp.getContentMap().get("errorCode");
        return 0L == obj;
    }

    private boolean checkLoginStatus(ResponseInfo resp) {
        if (resp == null) {
            return false;
        }
        String content = resp.getContent();
        if (content == null || content.isEmpty()) {
            return false;
        }
        this.recordingLoginContent(content);
        for (Header h : resp.getHeaders()) {
            String name = h.getName();
            String value = h.getValue();
            if (!name.equals("Set-Cookie")) continue;
            if (value.contains("failLoginCount")) {
                return false;
            }
            if (!value.contains("logFlag=in")) continue;
            return true;
        }
        return content.contains("Your logon site is loading");
    }

    private void parseLoginData(ResponseInfo resp) {
        if (resp == null || StringUtils.isNULLStr(resp.getContent())) {
            return;
        }
        String content = resp.getContent();
        JSONObject json = new JSONObject(content);
        JSONObject jsonData = json.getJSONObject("data");
        this.session.setSessionID(this.getJsonValue("iBaseToken", jsonData));
        this.session.setToken(this.getJsonValue("x_auth_token", jsonData));
        if (!this.devNode.isFusionCube() || StringUtils.isNULLStr(this.devNode.getDeviceSerialNumber())) {
            if (jsonData.has("deviceid") && StringUtils.isNULLStr(this.devNode.getDeviceSerialNumber())) {
                this.devNode.setDeviceSerialNumber(this.getJsonValue("deviceid", jsonData));
            }
            if (jsonData.has("system_esn") && !StringUtils.isNULLStr(jsonData.getString("system_esn"))) {
                this.devNode.setDeviceSerialNumber(jsonData.getString("system_esn"));
            }
            if (jsonData.has("system_current_time")) {
                this.devNode.setDevCurrentTime(jsonData.getLong("system_current_time"));
            }
        }
        this.parseUserLevelOrRoleId(jsonData);
    }

    private void recordingLoginContent(String content) {
        if (LOGGER.isInfoEnabled()) {
            if (this.sensitiveLogKeyword.stream().noneMatch(content::contains)) {
                LOGGER.info("resp content is: {}", (Object)content);
            }
        }
    }

    protected void setLoginStatus(boolean success) {
        if (success) {
            LOGGER.info("login success.");
            this.isLogined = true;
            this.loginUri = this.uri;
            return;
        }
        this.isLogined = false;
        LOGGER.error("Rest login failed");
    }

    public void longTermConnectionInit(String sessionID, String token, int level, List<Map<String, String>> cookieInfoList) {
        try {
            BasicCookieStore cookieStore = new BasicCookieStore();
            cookieInfoList.forEach(arg_0 -> this.lambda$longTermConnectionInit$1((CookieStore)cookieStore, arg_0));
            this.initSession((CookieStore)cookieStore);
            this.session.setSessionID(sessionID);
            this.session.setToken(token);
            this.level = level;
            this.loginUri = this.uri;
            this.isLogined = true;
        }
        catch (CertificateException e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void parseUserLevelOrRoleId(JSONObject jsonObject) {
        String data;
        if (jsonObject.has(LEVEL_KEY)) {
            data = String.valueOf(jsonObject.get(LEVEL_KEY)).trim();
            try {
                this.level = Integer.parseInt(data);
            }
            catch (Exception e) {
                LOGGER.error("Get level exception, data is " + data);
            }
        }
        if (jsonObject.has(RILE_ID_KEY)) {
            data = String.valueOf(jsonObject.get(RILE_ID_KEY)).trim();
            try {
                this.roleId = Integer.parseInt(data);
            }
            catch (Exception e) {
                LOGGER.error("Get roleId exception, data is " + data);
            }
        }
        if (jsonObject.has(FS_ROLE_ID_KEY)) {
            data = String.valueOf(jsonObject.get(FS_ROLE_ID_KEY)).trim();
            try {
                this.roleId = Integer.parseInt(data);
            }
            catch (Exception e) {
                LOGGER.error("Get fusionstorage roleId exception, data is " + data);
            }
        }
    }

    protected String getJsonValue(String key, JSONObject jsonObject) {
        if (!jsonObject.has(key)) {
            return "";
        }
        String data = (String)jsonObject.get(key);
        if (StringUtils.isNULLStr(data)) {
            return "";
        }
        return data;
    }

    @Override
    public ResponseInfo execPut(String url, String param) throws ToolException {
        return this.execPut(url, param, null);
    }

    public ResponseInfo execPut(String url, String param, IRestConn.RestParamEntity entity, Map headerParam) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        PutRequest req = new PutRequest(this.replaceHostForSvp(url));
        ResponseInfo resp = this.requestProcess(param, req, entity, headerParam);
        resp = this.checkRespToReLogin(param, entity, req, resp);
        return resp;
    }

    public ResponseInfo execPost(String url, String param, IRestConn.RestParamEntity entity, Map headerParam) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        PostRequest req = new PostRequest(this.replaceHostForSvp(url));
        ResponseInfo resp = this.requestProcess(param, req, entity, headerParam);
        resp = this.checkRespToReLogin(param, entity, req, resp);
        return resp;
    }

    @Override
    public ResponseInfo execPost(String url, String param, IRestConn.RestParamEntity entity) throws ToolException {
        return this.execPost(url, param, entity, null);
    }

    @Override
    public ResponseInfo execDelete(String url, String param, IRestConn.RestParamEntity entity) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        DeleteRequest req = new DeleteRequest(this.replaceHostForSvp(url));
        ResponseInfo resp = this.requestProcess(param, req, entity);
        resp = this.checkRespToReLogin(param, entity, req, resp);
        return resp;
    }

    public ResponseInfo execDeleteLogout(String url) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        return this.requestProcess(null, new DeleteRequest(this.replaceHostForSvp(url)), null);
    }

    @Override
    public ResponseInfo execGet(String url, String param, IRestConn.RestParamEntity entity) throws ToolException {
        return this.execGet(url, param, entity, null);
    }

    public ResponseInfo execGet(String url, String param, IRestConn.RestParamEntity entity, Map headerParam) throws ToolException {
        GetRequest req = new GetRequest(this.replaceHostForSvp(url));
        return this.execGet(req, param, entity, headerParam);
    }

    private ResponseInfo execGet(RequestInfo req, String param, IRestConn.RestParamEntity entity, Map headerParam) throws ToolException {
        if (null == req || StringUtils.isNULLStr(req.getURL())) {
            LOGGER.info("url is null");
            return null;
        }
        ResponseInfo resp = this.requestProcess(param, req, entity, headerParam);
        resp = this.checkRespToReLogin(param, entity, req, resp);
        return resp;
    }

    public ResponseInfo execGetNotCheckResp(String url, String param, IRestConn.RestParamEntity entity, Map headerParam) throws ToolException {
        GetRequest req = new GetRequest(this.replaceHostForSvp(url));
        if (req == null || StringUtils.isNULLStr(req.getURL())) {
            LOGGER.info("url is null");
            return null;
        }
        return this.requestProcess(param, req, entity, headerParam);
    }

    @Override
    public ResponseInfo execGetDivisionLang(String url, String param) throws ToolException {
        GetRequest req = new GetRequest(this.replaceHostForSvp(url));
        req.setHeader("Accept-Language", LanguageManager.getInstance().getCurrentLanguage().toLanguageTag());
        return this.execGet(req, param, null, null);
    }

    @Override
    public ResponseInfo execPut(String url, String param, IRestConn.RestParamEntity entity) throws ToolException {
        if (null == url) {
            LOGGER.info("url is null");
            return null;
        }
        PutRequest req = new PutRequest(this.replaceHostForSvp(url));
        ResponseInfo resp = this.requestProcess(param, req, entity);
        resp = this.checkRespToReLogin(param, entity, req, resp);
        return resp;
    }

    private ResponseInfo checkRespToReLogin(String param, IRestConn.RestParamEntity entity, RequestInfo req, ResponseInfo resp) throws ToolException {
        if (resp != null && this.isNeedReLogin(resp)) {
            LOGGER.info("Connection timeout and start reconnection.");
            this.reLoginWithTimeOut();
            return this.requestProcess(param, req, entity);
        }
        return resp;
    }

    public boolean isNeedReLogin(ResponseInfo resp) {
        String content = resp.getContent();
        if (content != null && !content.isEmpty()) {
            String errorKey;
            JSONObject json = new JSONObject(content);
            String string = errorKey = json.has("error") ? "error" : "result";
            if (!json.has(errorKey)) {
                return false;
            }
            Object obj = json.get(errorKey);
            if (!(obj instanceof JSONObject)) {
                return false;
            }
            JSONObject jsonData = (JSONObject)obj;
            if (jsonData.getInt("code") == -401 || this.isSessionTimeout(jsonData)) {
                LOGGER.info("Connection timeout and start reconnection.");
                return true;
            }
        }
        return false;
    }

    public ResponseInfo execGet(String url, Map param) throws ToolException {
        String para = new JSONObject(param).toString();
        return this.execGet(url, para, null);
    }

    public ResponseInfo execGetWithBody(String url, Map param) throws ToolException {
        String para = new JSONObject(param).toString();
        GetResultWithBody req = new GetResultWithBody(this.replaceHostForSvp(url));
        return this.execGet(req, para, null, null);
    }

    public ResponseInfo execGetFile(String url, Map param, String localPath, Map headerParam) throws ToolException {
        return this.execGetFile(url, param, localPath, headerParam, null);
    }

    public ResponseInfo execGetFile(String url, Map param, String localPath, Map headerParam, DownFileObserver downFileObserver) throws ToolException {
        String para = new JSONObject(param).toString();
        GetRequest req = new GetRequest(this.replaceHostForSvp(url));
        req.setLocationPath(localPath);
        ResponseInfo resp = this.requestProcess(para, req, null, headerParam, downFileObserver);
        return this.checkRespToReLogin(para, null, req, resp);
    }

    public ResponseInfo execPostDownloadFile(String url, Map param, String localPath, Map headerParam, DownFileObserver downFileObserver) throws ToolException {
        String para = new JSONObject(param).toString();
        PostRequest req = new PostRequest(url);
        req.setLocationPath(localPath);
        ResponseInfo resp = this.requestProcess(para, req, null, headerParam, downFileObserver);
        return this.checkRespToReLogin(para, null, req, resp);
    }

    public ResponseInfo execGetFile(String url, Map param, String localPath) throws ToolException {
        return this.execGetFile(url, param, localPath, null, null);
    }

    public ResponseInfo execPut(String url, Map param) throws ToolException {
        if (param != null) {
            String para = new JSONObject(param).toString();
            return this.execPut(url, para, null);
        }
        return this.execPut(url, "", null);
    }

    public ResponseInfo execGet(String url) throws ToolException, JSONException {
        return this.execGet(url, null, null);
    }

    public ResponseInfo execPost(String url, Map param) throws ToolException {
        String para = new JSONObject(param).toString();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("para is: {}", (Object)SensitiveInfoFilter.filter(para));
        }
        return this.execPost(url, para, null);
    }

    public ResponseInfo execPostUploadFile(String url, File file) throws ToolException {
        return this.execPostUploadFile(url, file, null);
    }

    public ResponseInfo execPostUploadFile(String url, String filePartName, File file) throws ToolException {
        return this.execPostUploadFile(url, filePartName, file, null, null);
    }

    public ResponseInfo execPostUploadFile(String url, File file, IRestConn.RestParamEntity entity) throws ToolException {
        return this.execPostUploadFile(url, file, entity, null);
    }

    public ResponseInfo execPostUploadFile(String url, File file, IRestConn.RestParamEntity entity, Map<String, String> header) throws ToolException {
        return this.execPostUploadFile(url, null, file, entity, header);
    }

    public ResponseInfo execPostUploadFile(String url, String filePartName, File file, IRestConn.RestParamEntity entity, Map<String, String> header) throws ToolException {
        if (null == url) {
            LOGGER.error("url is null");
            return null;
        }
        PostRequestByFile req = new PostRequestByFile(this.replaceHostForSvp(url), filePartName, file);
        if (entity != null && MapUtils.isNotEmpty(entity.getBodyParam())) {
            entity.getBodyParam().forEach(req::addParam);
        }
        ResponseInfo resp = this.requestProcess(null, req, null, header);
        resp = this.checkRespToReLogin(null, entity, req, resp);
        return resp;
    }

    public HttpResponse uploadFileByHutool(String url, String filePath, String uploadFormName, Map<String, String> header) {
        Map<String, String> connectHeader = header;
        if (Objects.isNull(url)) {
            LOGGER.error("url is null");
            return null;
        }
        if (Objects.isNull(connectHeader)) {
            connectHeader = RestConnection.getRestConnectHeader(this);
            LOGGER.info("no header create header : {}", SensitiveInfoFilter.filterMap(connectHeader));
        }
        LOGGER.info("url is : {}", (Object)url);
        HttpRequest.delete((String)url);
        HttpRequest.closeCookie();
        HttpRequest.post((String)url).clearHeaders();
        HttpRequest.post((String)url).disableCookie();
        String newUrl = this.handleUrlIfPortForward(url);
        return ((HttpRequest)HttpRequest.post((String)newUrl).addHeaders(connectHeader)).form(uploadFormName, new File(filePath)).execute();
    }

    public HttpResponse uploadFileFromInputStream(@NotNull String url, @NotNull InputStream input, String fileName, @NotNull String formName, Map<String, String> header) {
        Map<String, String> actualHeader = header == null ? RestConnection.getRestConnectHeader(this) : header;
        LOGGER.info("update file {} via url {} with header {}", new Object[]{fileName, url, SensitiveInfoFilter.filterMap(actualHeader)});
        HttpRequest.delete((String)url);
        HttpRequest.closeCookie();
        HttpRequest.post((String)url).clearHeaders();
        HttpRequest.post((String)url).disableCookie();
        return ((HttpRequest)HttpRequest.post((String)this.handleUrlIfPortForward(url)).addHeaders(actualHeader)).form(formName, (Resource)new InputStreamResource(input, fileName)).execute();
    }

    private String handleUrlIfPortForward(@NotNull String url) {
        String newUrl = url;
        if (this.foradPort != 0) {
            newUrl = url.replace(this.devNode.getIp(), "127.0.0.1").replace(String.valueOf(8088), String.valueOf(this.foradPort));
        }
        return newUrl;
    }

    public ResponseInfo execPostUploadFileWithNodeIds(String url, File file, List<String> nodeIds) throws ToolException {
        if (url == null) {
            LOGGER.error("url is null");
            return null;
        }
        PostRequestByFile req = new PostRequestByFile(this.replaceHostForSvp(url), file, nodeIds);
        ResponseInfo resp = this.requestProcess(null, req, null);
        resp = this.checkRespToReLogin(null, null, req, resp);
        return resp;
    }

    private String replaceHostForSvp(String originUrl, String svpHost) {
        if (StringUtils.isNULLStr(svpHost)) {
            return originUrl;
        }
        return originUrl.replace(URI.create(originUrl).getHost(), svpHost);
    }

    private String replaceHostForSvp(String originUrl) {
        return this.replaceHostForSvp(originUrl, this.proxySvpIp);
    }

    private boolean isSessionTimeout(JSONObject errorJson) {
        if (null == errorJson || !errorJson.has("code") || !errorJson.has("suggestion")) {
            return false;
        }
        return errorJson.getInt("code") == 500 && errorJson.getString("suggestion").contains(TOKEN_INVALID_ERR_SUGGEST_K_WORD);
    }

    private void disableHttpLog() {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "stdout,basefile");
    }

    @Override
    public ResponseInfo execPostWithNoLog(String url, String param) throws ToolException {
        IRestConn.RestParamEntity entity = new IRestConn.RestParamEntity(false);
        return this.execPost(url, param, entity);
    }

    @Override
    public ResponseInfo execDeleteWithNoLog(String url, String param) throws ToolException {
        IRestConn.RestParamEntity entity = new IRestConn.RestParamEntity(false);
        return this.execDelete(url, param, entity);
    }

    @Override
    public ResponseInfo execGetWithNoLog(String url, String param) throws ToolException {
        IRestConn.RestParamEntity entity = new IRestConn.RestParamEntity(false);
        return this.execGet(url, param, entity);
    }

    @Override
    public ResponseInfo execPutWithNoLog(String url, String param) throws ToolException {
        IRestConn.RestParamEntity entity = new IRestConn.RestParamEntity(false);
        return this.execPut(url, param, entity);
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public RequestInfo getLoginInfo() {
        return this.loginInfo;
    }

    public void setLoginInfo(RequestInfo loginInfo) {
        this.loginInfo = loginInfo;
    }

    public StateLessRestCallback getCallback() {
        return this.callback;
    }

    public void setCallback(StateLessRestCallback callback) {
        this.callback = callback;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public RestConnection(DevNode key, RequestInfo loginInfo, StateLessRestCallback callback1) throws ToolException {
        this.loginInfo = loginInfo;
        this.devNode = key;
        this.disableHttpLog();
        this.callback = callback1;
        if (!this.doAuthenticate()) {
            throw new ToolException("http.authorized.failed");
        }
    }

    public boolean doAuthenticate() throws ToolException {
        this.createForwardOnNeeded(this.devNode);
        this.reporaceAddressOnForward(this.loginInfo);
        try {
            this.initSession();
            ResponseInfo responseInfo = this.doRequest(this.loginInfo, false, false);
            if (responseInfo.getStatusLine().getStatusCode() != 200) {
                throw new ToolException("http status code: " + responseInfo.getStatusLine().getStatusCode());
            }
            if (this.callback == null) {
                LOGGER.error("callback is null.");
                return false;
            }
            this.authToken = this.callback.parse4AuthToken(responseInfo);
            if (StringUtils.isNULLStr(this.authToken)) {
                LOGGER.error("the auth token is not fetched!");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (e instanceof ToolException && CERT_VALIDATE_ERROR_KEY.equals(((ToolException)e).getErrorId())) {
                throw (ToolException)e;
            }
            LOGGER.error("exception occurred on authorizing:" + e);
            return false;
        }
    }

    public ResponseInfo doRequest(RequestInfo req, boolean isLogging, boolean isAutoRelogin) throws ToolException {
        ResponseInfo resp;
        block9: {
            resp = new ResponseInfo();
            if (isLogging) {
                LOGGER.info("sending http request...");
            }
            this.reporaceAddressOnForward(req);
            RequestInfo actualReq = req;
            try {
                actualReq = this.callback.updateRequestAuthToken(actualReq, this.authToken);
                resp = this.session.sendRequest1(actualReq, isLogging);
                if (isLogging && LOGGER.isInfoEnabled()) {
                    LOGGER.info("ResponseInfo : " + resp.getContent());
                }
                if (resp.getStatusLine().getStatusCode() != 401) break block9;
                if (isAutoRelogin) {
                    LOGGER.info("auth-token expired, ask to regenerate one....");
                    this.authToken = "";
                    boolean isReconnected = this.doAuthenticate();
                    if (!isReconnected) {
                        throw new ToolException("http.authorized.failed");
                    }
                    if (this.callback == null) {
                        LOGGER.info("callback is null.");
                        throw new NullPointerException("callback is null.");
                    }
                    actualReq = this.callback.updateRequestAuthToken(actualReq, this.authToken);
                    LOGGER.info("re-send current request using new auth-token.");
                    resp = this.session.sendRequest1(actualReq, true);
                    break block9;
                }
                throw new ToolException("http.unauthorized");
            }
            catch (ToolException tex) {
                LOGGER.error("Tool-exception occurred on sending request, raise ..");
                throw tex;
            }
            catch (IOException e) {
                if (VALIDATOR_EXCEPTION.contains(e.getMessage())) {
                    throw new ToolException(CERT_VALIDATE_ERROR_KEY);
                }
                this.closeSession();
                LOGGER.error("error.conn", (Throwable)e);
                return resp;
            }
        }
        return resp;
    }

    public void logOut() {
        try {
            this.execDeleteLogout(this.loginUri);
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred on logout.");
        }
        finally {
            LOGGER.info("Rest logout success.");
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public int getRoleId() {
        return this.roleId;
    }

    public String getProxySvpIp() {
        return this.proxySvpIp;
    }

    public String toString() {
        return "RestConnection{responseTimeOut=" + this.responseTimeOut + ", scope='" + this.scope + '\'' + ", foradPort=" + this.foradPort + ", level=" + this.level + ", roleId=" + this.roleId + ", proxySvpIp='" + this.proxySvpIp + '\'' + '}';
    }

    @Override
    public void close() throws Exception {
        this.closeSession();
        this.uri = null;
        this.userName = null;
        this.passW = null;
        this.scope = null;
        this.authToken = "";
        this.loginInfo = null;
        this.callback = null;
    }

    public void setLoginUri(String loginUri) {
        this.loginUri = loginUri;
    }

    private /* synthetic */ void lambda$longTermConnectionInit$1(CookieStore cookieStore, Map cookieInfo) {
        BasicClientCookie cookie = new BasicClientCookie((String)cookieInfo.get(COOKIE_NAME), (String)cookieInfo.get(COOKIE_VALUE));
        cookie.setDomain(this.devNode.getIp());
        cookieStore.addCookie((Cookie)cookie);
    }
}

