/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.utils;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.NodeHardwareUsage;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.utils.GetDistributedDeviceHardwareUsage;
import com.huawei.ism.tool.protocol.utils.ResourceUsageService;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDeviceHardwareUsageTask
implements Callable<List<List<String>>> {
    private static final Logger log = LoggerFactory.getLogger(QueryDeviceHardwareUsageTask.class);
    private final ProgressDialog progressDialog;
    private final List<DevNode> devNodeList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<List<String>> call() {
        ArrayList<List<String>> hardwareUsageList = new ArrayList<List<String>>();
        try {
            for (DevNode devNode : this.devNodeList) {
                try {
                    GetDistributedDeviceHardwareUsage.getHardwareStatus(devNode).stream().map(this::parseNodeHardwareUsage).forEach(hardwareUsageList::add);
                }
                catch (ToolException e) {
                    log.error("query devNode hardware failed", (Throwable)e);
                    hardwareUsageList.add(ResourceUsageService.getQueryFailedResult(devNode.getIp()));
                }
            }
        }
        finally {
            SwingUtil.disPoseDialg((ProgressDialog)this.progressDialog);
        }
        return hardwareUsageList;
    }

    private List<String> parseNodeHardwareUsage(NodeHardwareUsage usage) {
        return Arrays.asList(usage.getDeviceIp(), usage.getNodeIp(), usage.getNodeRole(), usage.getCpuUsage(), usage.getMemUsage(), usage.getIoUsage(), usage.getDiskUsage(), usage.getDescription());
    }

    public QueryDeviceHardwareUsageTask(ProgressDialog progressDialog, List<DevNode> devNodeList) {
        this.progressDialog = progressDialog;
        this.devNodeList = devNodeList;
    }
}

