/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.a800switch;

import com.huawei.ism.tool.a800switch.SwitchParamHandler;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class SwitchSnmpParam
implements SwitchParamHandler {
    private static final String TYPE_PRIVACY = "privacy";
    private static final String TYPE_AUTHENTICATION = "authentication";
    private static final String TYPE_NO_AUTHENTICATION = "noauthentication";
    private String username;
    private String authProtocol;
    private String authPassword;
    private String encProtocol;
    private String encPassword;
    private int port;

    @Override
    public Map<String, String> buildParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("{username}", this.username);
        params.put("{type}", this.parseType());
        params.put("{authProtocol}", this.authProtocol);
        params.put("{encProtocol}", this.encProtocol);
        params.put("{port}", String.valueOf(this.port));
        return params;
    }

    private String parseType() {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.authProtocol, this.encProtocol})) {
            return TYPE_PRIVACY;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.authProtocol)) {
            return TYPE_AUTHENTICATION;
        }
        return TYPE_NO_AUTHENTICATION;
    }

    @Override
    public List<String> getSensitiveKeys() {
        return Arrays.asList(this.authPassword, this.encPassword);
    }

    @Override
    public boolean isNeedExecute(String command) {
        if (command.contains("authentication-mode")) {
            return Arrays.asList(TYPE_PRIVACY, TYPE_AUTHENTICATION).contains(this.parseType());
        }
        if (command.contains("privacy-mode")) {
            return Objects.equals(TYPE_PRIVACY, this.parseType());
        }
        return SwitchParamHandler.super.isNeedExecute(command);
    }

    SwitchSnmpParam(String username, String authProtocol, String authPassword, String encProtocol, String encPassword, int port) {
        this.username = username;
        this.authProtocol = authProtocol;
        this.authPassword = authPassword;
        this.encProtocol = encProtocol;
        this.encPassword = encPassword;
        this.port = port;
    }

    public static SwitchSnmpParamBuilder builder() {
        return new SwitchSnmpParamBuilder();
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public String getEncPassword() {
        return this.encPassword;
    }

    public static class SwitchSnmpParamBuilder {
        private String username;
        private String authProtocol;
        private String authPassword;
        private String encProtocol;
        private String encPassword;
        private int port;

        SwitchSnmpParamBuilder() {
        }

        public SwitchSnmpParamBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SwitchSnmpParamBuilder authProtocol(String authProtocol) {
            this.authProtocol = authProtocol;
            return this;
        }

        public SwitchSnmpParamBuilder authPassword(String authPassword) {
            this.authPassword = authPassword;
            return this;
        }

        public SwitchSnmpParamBuilder encProtocol(String encProtocol) {
            this.encProtocol = encProtocol;
            return this;
        }

        public SwitchSnmpParamBuilder encPassword(String encPassword) {
            this.encPassword = encPassword;
            return this;
        }

        public SwitchSnmpParamBuilder port(int port) {
            this.port = port;
            return this;
        }

        public SwitchSnmpParam build() {
            return new SwitchSnmpParam(this.username, this.authProtocol, this.authPassword, this.encProtocol, this.encPassword, this.port);
        }

        public String toString() {
            return "SwitchSnmpParam.SwitchSnmpParamBuilder(username=" + this.username + ", authProtocol=" + this.authProtocol + ", authPassword=" + this.authPassword + ", encProtocol=" + this.encProtocol + ", encPassword=" + this.encPassword + ", port=" + this.port + ")";
        }
    }
}

