/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.cert.auth;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.cert.auth.CertUtil;
import com.huawei.ism.tool.cert.auth.MyTrustManager;
import com.huawei.ism.tool.cert.auth.TestContextResult;
import com.huawei.ism.tool.cert.auth.TestContextTask;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.connection.MultiRouteManager;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.ProxySOCKS5;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.AddressUtil;
import com.huawei.ism.util.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;

public abstract class AbstractAuthStep {
    private static final String V200R002C00 = "V200R002C00";
    private static final String V300R001 = "V300R001";
    private static final String V200R002C20 = "V200R002C20";
    private static final String V300R002 = "V300R002";
    private static final String VIS_CERT_PEM = "VIS_cert.pem";
    private static final String V200R002C20_PEM = "V200R002C20.pem";
    private static final String V300R002_PEM = "V300R002.pem";
    private static final String V300R001_PEM = "V300R001.pem";
    private static final String V200R002C00_PEM = "V200R002C00.pem";
    public static final String CONTEXT_TLS = "TLSv1.2";
    public static final String CERT_LOC = "/config/devicecerts/";
    public static final String CERTBASE = File.separator + "devicecerts" + File.separator;
    public static final String DEFAULT_CRT = "ca.crt";
    public static final String DEFAULT_CRL = "/config/devicecerts/ca.crl";
    private static final String[] TLS_PROTOCOLS = new String[]{"TLSv1.2"};
    private static final int CONN_PROTOCOL_SSL = 1;
    private static final Logger logger = ToolLoggerFactory.getLogger(AbstractAuthStep.class);
    private final Object lock = new Object();
    private String ip;
    private DevNode devNode;
    private int port;
    private Socks5Proxy socks5Proxy = null;
    private List<MultiRouteNode> sshForwardNodes = null;
    private MultiRouteManager multiRouteManager = null;
    private List<String> certList = new ArrayList<String>();

    public List<String> getCertList() {
        return this.certList;
    }

    public void setCertList(List<String> certList) {
        this.certList = certList;
    }

    public void addCertList(String cert) {
        this.certList.add(cert);
    }

    public AbstractAuthStep(DevNode devNode, int port) {
        this.devNode = devNode;
        this.ip = devNode == null ? null : devNode.getIp();
        this.port = port;
        this.sshForwardNodes = devNode == null ? null : devNode.getSshForwardList();
        this.socks5Proxy = devNode == null ? null : devNode.getSocks5Proxy();
        this.certList.add(this.getCrtPath());
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getCrtFileName() {
        return DEFAULT_CRT;
    }

    public String getCrlFileName() {
        return DEFAULT_CRL;
    }

    public boolean generateAlarm() {
        return true;
    }

    public abstract String getAlarmId();

    public boolean checkCrl() {
        return true;
    }

    public String getCrtPath() {
        String crtPath = "";
        String ipForPath = this.getIpFixedPath();
        String workPath = UserOpDataSaveUtil.getToolBoxPath();
        crtPath = workPath + CERTBASE + ipForPath + File.separator + this.getCrtFileName();
        File crtFile = new File(crtPath);
        if (crtFile.exists()) {
            return crtPath;
        }
        return CERT_LOC + this.getCrtFileName();
    }

    public String getCrlPath() {
        String crlPath = "";
        String ipForPath = this.getIpFixedPath();
        String workPath = ApplicationContext.getInstance().getWorkPath();
        crlPath = workPath + CERTBASE + ipForPath + File.separator + this.getCrlFileName();
        File file = FilePathUtils.checkFile((File)new File(crlPath));
        if (!file.exists()) {
            logger.info("Use the default.Not find ");
            crlPath = CERT_LOC + this.getCrlFileName();
        }
        return crlPath;
    }

    public abstract String[] getSSLType();

    public int process() {
        for (String cert : this.certList) {
            TrustManager trustManager = this.getTrustManagerFromFile(cert, this.ip, this.checkCrl(), this.getCrlPath());
            TrustManager[] tms = new TrustManager[]{trustManager};
            ArrayList<TestContextTask> tasks = new ArrayList<TestContextTask>();
            for (String protocol : this.getSSLType()) {
                TestContextTask task = new TestContextTask(this, protocol, tms);
                tasks.add(task);
            }
            TestContextResult result = (TestContextResult)AsyncExcutor.execReturnFirstSucc(tasks);
            if (result == null || 0 != result.getTestResult()) continue;
            return 0;
        }
        return -2;
    }

    private TrustManager getTrustManagerFromFile(String certFile, String ipAddr, boolean checkCrl, String crlPath) {
        X509Certificate certificateFromFile = CertUtil.getCertificateFromFile(certFile);
        if (certificateFromFile == null) {
            logger.error("Not get x509 certificate from file:" + certFile);
        }
        MyTrustManager trustManager = new MyTrustManager(certificateFromFile, ipAddr, checkCrl, crlPath);
        return trustManager;
    }

    public String getMmtFile(DevNode dNode) {
        String pdVersion;
        String string = pdVersion = dNode == null ? "" : dNode.getProductVersion();
        if (pdVersion.contains(V200R002C00)) {
            return V200R002C00_PEM;
        }
        if (pdVersion.contains(V300R001)) {
            return V300R001_PEM;
        }
        if (pdVersion.contains(V300R002)) {
            return V300R002_PEM;
        }
        if (pdVersion.contains(V200R002C20)) {
            return V200R002C20_PEM;
        }
        return VIS_CERT_PEM;
    }

    /*
     * Exception decompiling
     */
    public int testContext(String ipAddr, TrustManager[] tms, String contextString) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getSslHandShakeExceptionValue(String ipAddr, String contextString, SSLHandshakeException e) {
        logger.error("Error when use tls handshake " + ipAddr + " class:" + this.getClass().getSimpleName());
        if (e.getCause() instanceof CertificateException) {
            return -2;
        }
        if (contextString.equals(CONTEXT_TLS)) {
            return -4;
        }
        return -1;
    }

    private void socketStartHandShake(String ipAddr, SSLSocket socket) throws IOException {
        socket.setEnabledProtocols(TLS_PROTOCOLS);
        InetSocketAddress address = new InetSocketAddress(ipAddr, this.port);
        socket.connect(address);
        socket.setReuseAddress(true);
        long timeMillis = System.currentTimeMillis();
        socket.startHandshake();
        logger.info("shake hand takes time : {}", (Object)(System.currentTimeMillis() - timeMillis));
    }

    private SSLSocketFactory getSslSocketFactory(TrustManager[] tms, String contextString) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance(contextString);
        context.init(null, tms, SecureRandom.getInstanceStrong());
        SSLSocketFactory ssf = context.getSocketFactory();
        return ssf;
    }

    private SSLSocket connect(String socketIp, int portInt, int connType, int timeout, SSLSocketFactory ssf) throws IOException {
        SSLSocket soc = null;
        ProxySOCKS5 proxySOCKS5 = null;
        if (null != this.socks5Proxy) {
            proxySOCKS5 = new ProxySOCKS5(this.socks5Proxy.getServerIp(), Integer.valueOf(this.socks5Proxy.getPort()));
            if (this.socks5Proxy.isAuthentic()) {
                String pass = this.socks5Proxy.getPass();
                proxySOCKS5.setUserPasswd(this.socks5Proxy.getUser(), pass);
                pass = null;
            }
            proxySOCKS5.setDest(socketIp, portInt);
        }
        if (connType == 1) {
            try {
                soc = (SSLSocket)this.getSslSocket(socketIp, portInt, proxySOCKS5, timeout, ssf);
            }
            catch (Exception e) {
                logger.error("get TLSv1.2 getSslSocket error.", e);
            }
            return soc;
        }
        throw new IllegalArgumentException("connType error.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getSslSocket(String socketIp, int portInt, ProxySOCKS5 proxySOCKS5, int timeout, SSLSocketFactory ssf) throws IOException {
        SSLSocket soc;
        block8: {
            soc = null;
            try {
                if (null != proxySOCKS5) {
                    Socket currSocket = ssf.createSocket(proxySOCKS5.connect(), socketIp, portInt, false);
                    soc = (SSLSocket)CommonUtil.convertObject((Object)currSocket, SSLSocket.class);
                    break block8;
                }
                if (ssf.createSocket() instanceof SSLSocket) {
                    soc = (SSLSocket)CommonUtil.convertObject((Object)ssf.createSocket(), SSLSocket.class);
                }
                if (soc == null) {
                    return null;
                }
                InetSocketAddress address = new InetSocketAddress(socketIp, portInt);
                soc.connect(address, timeout * 1000);
                Object object = this.lock;
                synchronized (object) {
                    int ot = soc.getSoTimeout();
                    soc.setSoTimeout(20000);
                    soc.startHandshake();
                    soc.setSoTimeout(ot);
                    soc.setReuseAddress(true);
                }
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
        return soc;
    }

    private void closeSocket(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException e) {
            logger.error("close socket error.", e);
        }
        catch (Exception e1) {
            logger.error("close socket error.", e1);
        }
    }

    protected String getIpFixedPath() {
        String ipForPath = this.ip;
        if (AddressUtil.isValidIPV6(this.ip)) {
            ipForPath = this.ip.replaceAll(":", "_");
        }
        return ipForPath;
    }
}

