/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.config.resource;

import com.huawei.ism.tool.obase.entity.UpgradeFeature;
import com.huawei.ism.tool.obase.ui.upgrade.UpgradeModePanel;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import utils.Products;

public class ReleaseFeatureConfig {
    private static final String ROLL_MODE_NUM = "0";
    private static final String PARALLEL_MODE_NUM = "1";
    private static final String FAST_MODE_NUM = "2";
    private static final String APOLLO_MODE_NUM = "8";
    private final Map<String, List<UpgradeFeature>> featureMap = new HashMap<String, List<UpgradeFeature>>();
    private final Pattern releasePattern = Pattern.compile("^\\d+\\.\\d+\\.\\d+.*");
    private final Pattern rcReleasePattern = Pattern.compile("^\\d+\\.\\d+\\.RC.+");

    public static ReleaseFeatureConfig getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private ReleaseFeatureConfig() {
        Document doc;
        InputStream stream = this.getClass().getResourceAsStream("/cbb/res/upgrade/product_release_note.xml");
        if (null == stream) {
            return;
        }
        try {
            doc = XmlUtils.parseDocument(stream);
        }
        finally {
            StreamUtils.closeStream(null, stream);
        }
        Element root = doc.getDocumentElement();
        Element noteParent = XmlUtils.getChild(root, "releaseItem");
        this.parseReleaseNotes(noteParent);
    }

    private void parseReleaseNotes(Element firstElement) {
        ArrayList<UpgradeFeature> features = new ArrayList<UpgradeFeature>();
        for (Node currentNode = firstElement; currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (!(currentNode instanceof Element)) continue;
            Element currentElement = currentNode;
            UpgradeFeature feature = new UpgradeFeature();
            this.parseAttributes(currentElement, feature);
            this.parseContent(currentElement, feature);
            features.add(feature);
        }
        this.featureMap.putAll(features.stream().collect(Collectors.groupingBy(UpgradeFeature::getVersion)));
    }

    private void parseAttributes(Element currentNode, UpgradeFeature feature) {
        feature.setVersion(currentNode.getAttribute("version"));
        feature.setFeatureId(Integer.parseInt(currentNode.getAttribute("id")));
        String[] modes = currentNode.getAttribute("upgEffectMode").split("\\|");
        ArrayList<UpgradeModePanel.UpgradeMode> supportedMode = new ArrayList<UpgradeModePanel.UpgradeMode>();
        String[] stringArray = modes;
        int n = stringArray.length;
        block12: for (int i = 0; i < n; ++i) {
            String mode;
            switch (mode = stringArray[i]) {
                case "0": {
                    supportedMode.add(UpgradeModePanel.UpgradeMode.ROLL);
                    continue block12;
                }
                case "1": {
                    supportedMode.add(UpgradeModePanel.UpgradeMode.PARALLEL);
                    continue block12;
                }
                case "2": {
                    supportedMode.add(UpgradeModePanel.UpgradeMode.FAST);
                    continue block12;
                }
                case "8": {
                    supportedMode.add(UpgradeModePanel.UpgradeMode.APOLLO);
                    continue block12;
                }
            }
        }
        feature.setSupportedMode(supportedMode);
    }

    private void parseContent(Element currentNode, UpgradeFeature feature) {
        Node child = currentNode.getFirstChild();
        while (child.getNextSibling() != null) {
            if (!((child = child.getNextSibling()) instanceof Element)) continue;
            String name = child.getAttributes().getNamedItem("name").getNodeValue();
            String content = child.getFirstChild().getNodeValue();
            String lang = child.getNodeName();
            UpgradeFeature.FeatureDetail detail = new UpgradeFeature.FeatureDetail(name, content);
            if (lang.equals("zh")) {
                feature.setDetailCN(detail);
                continue;
            }
            feature.setDetailEN(detail);
        }
    }

    public List<UpgradeFeature> getFeatureListWithinVersion(String currentVersion, String targetVersion) {
        if (!this.validateVersion(targetVersion)) {
            return Collections.emptyList();
        }
        ArrayList<UpgradeFeature> result = new ArrayList<UpgradeFeature>();
        this.featureMap.forEach((key, features) -> {
            if (Products.compareVersion(key, currentVersion) > 0 && Products.compareVersion(key, targetVersion) <= 0) {
                result.addAll((Collection<UpgradeFeature>)features);
            }
        });
        return result;
    }

    private boolean validateVersion(String version) {
        return this.releasePattern.matcher(version).find() || this.rcReleasePattern.matcher(version).find();
    }

    public List<UpgradeFeature> getApolloFeatureList(String version) {
        List<UpgradeFeature> featureList = this.featureMap.get(version);
        if (featureList != null) {
            return featureList.stream().filter(entry -> ReleaseFeatureConfig.modeSupport(entry, UpgradeModePanel.UpgradeMode.APOLLO)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean modeSupport(UpgradeFeature feature, UpgradeModePanel.UpgradeMode mode) {
        for (UpgradeModePanel.UpgradeMode supportedMode : feature.getSupportedMode()) {
            if (supportedMode != mode) continue;
            return true;
        }
        return false;
    }

    public static UpgradeFeature.FeatureSupport supportType(UpgradeFeature feature, UpgradeModePanel.UpgradeMode mode) {
        for (UpgradeModePanel.UpgradeMode supportedMode : feature.getSupportedMode()) {
            if (supportedMode != mode) continue;
            return UpgradeFeature.FeatureSupport.SUPPORT;
        }
        return UpgradeFeature.FeatureSupport.NOT_SUPPORT;
    }

    private static class InstanceHolder {
        private static final ReleaseFeatureConfig INSTANCE = new ReleaseFeatureConfig();

        private InstanceHolder() {
        }
    }
}

