/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.config.validate;

import com.huawei.ism.tool.obase.config.validate.AbstractValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ValidatorChain
extends AbstractValidator {
    private List<Validation> validations = new ArrayList<Validation>();

    public ValidatorChain() {
    }

    public ValidatorChain(Collection<AbstractValidator> validators) {
        for (AbstractValidator validator : validators) {
            this.validations.add(new Validation(validator, new Object[0]));
        }
    }

    public void append(AbstractValidator validator, Object ... params) {
        this.validations.add(new Validation(validator, params));
    }

    @Override
    public boolean validate(Object object, String objectDesc, Object ... params) {
        boolean succ = true;
        for (Validation v : this.validations) {
            Object[] vp1 = v.getParams();
            Object[] vp = params;
            if (vp1.length > 0) {
                vp = new Object[vp1.length + params.length];
                System.arraycopy(vp1, 0, vp, 0, vp1.length);
                System.arraycopy(params, 0, vp, vp1.length, params.length);
            }
            if (v.getValidator().validate(object, objectDesc, vp)) continue;
            succ = false;
            super.setErrMsg(v.getValidator().getErrMsg());
            break;
        }
        return succ;
    }

    private static class Validation {
        private Object[] params;
        private AbstractValidator validator;

        public Validation(AbstractValidator validator, Object ... params) {
            this.validator = validator;
            this.params = params;
        }

        public Object[] getParams() {
            return this.params;
        }

        public AbstractValidator getValidator() {
            return this.validator;
        }
    }
}

