/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.exception.LegoExceptionTranslator;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class AddressUtil {
    private static final int VALUE_0X00FFFFFF = 0xFFFFFF;
    private static final int VALUE_0X0000FFFF = 65535;
    private static final int VALUE_0X000000FF = 255;
    private static final String REREX_IPV6_ADDRESS = "^\\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\s*$";
    private static final BigInteger INVALID = BigInteger.ZERO;

    private AddressUtil() {
    }

    public static boolean checkLocalIP(String ip) {
        InetAddress addrd;
        if (null == ip || ip.length() <= 0) {
            return false;
        }
        if ("127.0.0.1".equals(ip)) {
            return true;
        }
        if ("localhost".equalsIgnoreCase(ip)) {
            return true;
        }
        try {
            addrd = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ee) {
            throw LegoExceptionTranslator.convert(ee);
        }
        String hostName = addrd.getHostName();
        InetAddress[] ipsAddr = null;
        try {
            ipsAddr = InetAddress.getAllByName(hostName);
        }
        catch (UnknownHostException ex) {
            throw LegoExceptionTranslator.convert(ex);
        }
        String[] localServers = new String[ipsAddr.length];
        for (int i = 0; i < ipsAddr.length; ++i) {
            if (ipsAddr[i] == null) continue;
            localServers[i] = ipsAddr[i].getHostAddress();
            if (!ip.equals(localServers[i])) continue;
            return true;
        }
        return false;
    }

    public static String getLocalIP() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw LegoExceptionTranslator.convert(e);
        }
        String hostName = addr.getHostName();
        InetAddress[] ipsAddr = null;
        try {
            ipsAddr = InetAddress.getAllByName(hostName);
        }
        catch (UnknownHostException e) {
            throw LegoExceptionTranslator.convert(e);
        }
        if (ipsAddr.length > 0) {
            return ipsAddr[0].getHostAddress();
        }
        return "";
    }

    public static long ipToLong(String ipaddress) {
        long[] ip = new long[4];
        int position1 = ipaddress.indexOf(".");
        int position2 = ipaddress.indexOf(".", position1 + 1);
        int position3 = ipaddress.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(ipaddress.substring(0, position1));
        ip[1] = Long.parseLong(ipaddress.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(ipaddress.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(ipaddress.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String longToIP(long ipaddress) {
        StringBuffer sb = new StringBuffer("");
        sb.append(String.valueOf(ipaddress >>> 24));
        sb.append('.');
        sb.append(String.valueOf((ipaddress & 0xFFFFFFL) >>> 16));
        sb.append('.');
        sb.append(String.valueOf((ipaddress & 0xFFFFL) >>> 8));
        sb.append('.');
        sb.append(String.valueOf(ipaddress & 0xFFL));
        return sb.toString();
    }

    public static boolean ipValid(String ip) {
        if (null == ip) {
            return false;
        }
        String regex = "^([1-9]|[1-9]\\d|1\\d{2}|2[0-1]\\d|22[0-3]).(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5]).(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5]).(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ip);
        boolean isIp = matcher.matches();
        if (isIp) {
            String[] iPArray = ip.split("\\.");
            if (iPArray.length != 4) {
                return false;
            }
            int val = Integer.parseInt(iPArray[0]);
            return val != 127;
        }
        return false;
    }

    public static String maskToIp(int mask) {
        String part = "";
        int xCoordinates = mask / 8;
        int yCoordinates = mask % 8;
        for (int i = 0; i < xCoordinates; ++i) {
            if (xCoordinates == 4) {
                part = "255.255.255.255";
                break;
            }
            part = part + "255.";
        }
        int sum = 0;
        int constant = 256;
        for (int i = 0; i < yCoordinates; ++i) {
            sum += (constant >>= 1);
        }
        StringBuffer buf = new StringBuffer();
        if (xCoordinates != 4) {
            for (int i = 0; i < 3 - xCoordinates; ++i) {
                buf = buf.append(".0");
            }
            part = part + sum + buf.toString();
        }
        return part;
    }

    public static BigInteger ipv6ToBigInteger(String addr) {
        if (addr == null) {
            return INVALID;
        }
        int startIndex = addr.indexOf("::");
        if (startIndex != -1) {
            String firstStr = addr.substring(0, startIndex);
            String secondStr = addr.substring(startIndex + 2, addr.length());
            BigInteger first = AddressUtil.ipv6ToBigInteger(firstStr);
            int xCoordinates = AddressUtil.countChar(firstStr, ':');
            BigInteger two = AddressUtil.ipv6ToBigInteger(secondStr);
            first = first.shiftLeft(16 * (7 - xCoordinates)).add(two);
            return first;
        }
        String[] strArr = addr.split(":");
        BigInteger retValue = BigInteger.valueOf(0L);
        for (int i = 0; i < strArr.length; ++i) {
            if (strArr[i].isEmpty()) {
                strArr[i] = "0";
            }
            BigInteger bi = new BigInteger(strArr[i], 16);
            retValue = retValue.shiftLeft(16).add(bi);
        }
        return retValue;
    }

    public static String bigIntegerToipv6(BigInteger ipNumber) {
        String ipString = "";
        BigInteger a = new BigInteger("FFFF", 16);
        for (int i = 0; i < 8; ++i) {
            ipString = ipNumber.and(a).toString(16) + ":" + ipString;
            ipNumber = ipNumber.shiftRight(16);
        }
        return ipString.substring(0, ipString.length() - 1).replaceFirst("(^|:)(0+(:|$)){2,8}", "::");
    }

    public static boolean isValidIPV6(String ipv6) {
        if (null == ipv6) {
            return false;
        }
        ipv6 = Normalizer.normalize(ipv6, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile(REREX_IPV6_ADDRESS);
        Matcher mat = pattern.matcher(ipv6);
        if (mat.matches()) {
            try {
                InetAddress address = InetAddress.getByName(ipv6);
                if (address == null) {
                    return false;
                }
                return !(address instanceof Inet4Address) || !ipv6.equals(address.getHostAddress());
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (Exception e1) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidIPV4(String ip) {
        return AddressUtil.ipValid(ip);
    }

    private static int countChar(String str, char reg) {
        char[] ch = str.toCharArray();
        int count = 0;
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] != reg) continue;
            ++count;
        }
        return count;
    }
}

