/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;

public class SecureRuntime {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SecureRuntime.class);
    private String cmd;

    public SecureRuntime(String cmd) {
        this.cmd = cmd;
    }

    public int exitValue() throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(this.cmd);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
        errorGobbler.start();
        outputGobbler.start();
        int ret = proc.exitValue();
        try {
            errorGobbler.join();
            outputGobbler.join();
        }
        catch (InterruptedException e) {
            LOGGER.error("StreamGobbler interrupt. ");
        }
        return ret;
    }

    private class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.is));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    LOGGER.info("line: {}", (Object)line);
                }
            }
            catch (IOException e) {
                LOGGER.error("read io exception");
            }
            finally {
                StreamUtils.closeStream(null, this.is);
            }
        }
    }
}

