/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.xml.cli;

import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.obase.xml.XmlNode;
import com.huawei.ism.tool.obase.xml.cli.CliCmdListNode;
import com.huawei.ism.tool.obase.xml.cli.CliCmdNode;
import com.huawei.ism.util.parser.XmlParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.w3c.dom.Element;

public class CliXmlConfig {
    private List<XmlNode> nodes = new ArrayList<XmlNode>();
    private String xmlFile = null;

    public CliXmlConfig(ClassLoader cl, String file) {
        this.xmlFile = file;
        XmlParser xp = this.loadXml(cl);
        this.nodes.addAll(this.parseNodes(xp));
    }

    private List<XmlNode> parseNodes(XmlParser parser) {
        if (parser == null) {
            throw new NullPointerException("parser");
        }
        ArrayList<XmlNode> subNodes = new ArrayList<XmlNode>();
        Element rootNode = parser.treeWalkOfOneElementNode("root");
        if (null != rootNode) {
            Collection<Element> subs = XmlUtils.getChildren(rootNode);
            for (Element element : subs) {
                String tagName = element.getTagName().trim();
                if ("clicmdlist".equalsIgnoreCase(tagName)) {
                    subNodes.add(new CliCmdListNode(element));
                    continue;
                }
                if ("clicmd".equalsIgnoreCase(tagName)) {
                    subNodes.add(new CliCmdNode(element));
                    continue;
                }
                throw new IllegalArgumentException("the cli config error, the tag \"" + tagName + " is unkunow");
            }
        }
        return subNodes;
    }

    public List<XmlNode> getAllNodes() {
        return this.nodes;
    }

    public XmlNode getNodeById(String id) {
        for (XmlNode node : this.nodes) {
            if (!node.getID().equals(id)) continue;
            return node;
        }
        return null;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append((Object)("CLICmdListNode:" + this.getAllNodes())).toString();
    }

    private XmlParser loadXml(ClassLoader cl) {
        return XmlParser.getXmlDomParser((String)this.xmlFile, (ClassLoader)cl);
    }
}

