/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObjectIntf;
import com.huawei.json.JSONUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JSONObject
implements JSONObjectIntf {
    private JsonObject members;
    public static final Object NULL = new Null();

    public JSONObject() {
        this.members = new JsonObject();
    }

    public JSONObject(Object object) {
        JsonElement var = JSONUtils.parseToJsonElement(object);
        this.members = var instanceof JsonObject ? (JsonObject)var : new JsonObject();
    }

    public JSONObject(String jsonStr) {
        this.members = JSONUtils.parseToJsonObject(jsonStr);
    }

    JSONObject(JsonObject object) {
        this.members = object;
    }

    public JSONObject(Map map) {
        JsonElement var = JSONUtils.parseToJsonElement(map);
        this.members = var instanceof JsonObject ? (JsonObject)var : new JsonObject();
    }

    private Object internalGet(String key) throws JSONException {
        if (key == null) {
            throw new JSONException("Null key.");
        }
        Object object = this.opt(key);
        if (object == null) {
            throw new JSONException("JSONObject not found.");
        }
        return object;
    }

    @Override
    public Object get(String key) throws JSONException {
        Object object = this.internalGet(key);
        if (object instanceof JsonObject) {
            return new JSONObject((JsonObject)object);
        }
        if (object instanceof JsonArray) {
            return new JSONArray((JsonArray)object);
        }
        if (object instanceof JsonNull) {
            return NULL;
        }
        if (object instanceof JsonPrimitive) {
            return JSONUtils.INSTANCE.castJsonElement((JsonPrimitive)object);
        }
        return object;
    }

    @Override
    public boolean getBoolean(String key) throws JSONException {
        boolean result;
        JsonElement element = (JsonElement)this.internalGet(key);
        try {
            result = element.getAsJsonPrimitive().getAsBoolean();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a Boolean.");
        }
        return result;
    }

    @Override
    public double getDouble(String key) throws JSONException {
        double result;
        JsonElement element = (JsonElement)this.internalGet(key);
        try {
            result = element.getAsJsonPrimitive().getAsDouble();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a number.");
        }
        return result;
    }

    @Override
    public int getInt(String key) throws JSONException {
        int result;
        JsonElement element = (JsonElement)this.internalGet(key);
        try {
            result = element.getAsJsonPrimitive().getAsInt();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a number.");
        }
        return result;
    }

    @Override
    public JSONArray getJSONArray(String key) throws JSONException {
        Object object = this.internalGet(key);
        if (object instanceof JsonArray) {
            return new JSONArray((JsonArray)object);
        }
        throw new JSONException("JSONObject is not a JSONArray.");
    }

    @Override
    public JSONObject getJSONObject(String key) throws JSONException {
        Object obj = this.internalGet(key);
        if (obj instanceof JsonObject) {
            return new JSONObject((JsonObject)obj);
        }
        throw new JSONException("Object is not a JSONObject.");
    }

    @Override
    public long getLong(String key) throws JSONException {
        long result;
        JsonElement element = (JsonElement)this.internalGet(key);
        try {
            result = element.getAsJsonPrimitive().getAsLong();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a number.");
        }
        return result;
    }

    @Override
    @Deprecated
    public String getString(String key) throws JSONException {
        String result;
        JsonElement element = (JsonElement)this.opt(key);
        try {
            if (element == null) {
                throw new JSONException("element is null.");
            }
            result = element.getAsJsonPrimitive().getAsString();
        }
        catch (Exception e) {
            throw new JSONException("JSONObject is not a string.");
        }
        return result;
    }

    @Override
    public String getStringOrDefault(String key, String defaultValue) {
        try {
            return this.getString(key);
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public boolean has(String key) {
        return this.members.has(key);
    }

    @Override
    public boolean isNull(String key) {
        return this.members.get(key).isJsonNull();
    }

    @Override
    public Iterator keys() {
        return this.members.keySet().iterator();
    }

    @Override
    public Set keySet() {
        return this.members.keySet();
    }

    @Override
    public int length() {
        return this.members.size();
    }

    @Override
    public Object opt(String key) {
        return key == null ? null : this.members.get(key);
    }

    @Override
    public boolean optBoolean(String key) {
        return this.optBoolean(key, false);
    }

    @Override
    public boolean optBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public double optDouble(String key) {
        return this.optDouble(key, Double.NaN);
    }

    @Override
    public double optDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public int optInt(String key) {
        return this.optInt(key, 0);
    }

    @Override
    public int optInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public long optLong(String key) {
        return this.optLong(key, 0L);
    }

    @Override
    public long optLong(String key, long defaultValue) {
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public String optString(String key) {
        return this.optString(key, "");
    }

    @Override
    public String optString(String key, String defaultValue) {
        try {
            return this.getString(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public JSONObject put(String key, boolean value) throws JSONException {
        return this.put(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public JSONObject put(String key, Collection value) throws JSONException {
        return this.put(key, JSONUtils.parseToJsonElement(value));
    }

    @Override
    public JSONObject put(String key, double value) throws JSONException {
        return this.put(key, new Double(value));
    }

    @Override
    public JSONObject put(String key, int value) throws JSONException {
        return this.put(key, new Integer(value));
    }

    @Override
    public JSONObject put(String key, long value) throws JSONException {
        return this.put(key, new Long(value));
    }

    @Override
    public JSONObject put(String key, Map value) throws JSONException {
        this.members.add(key, JSONUtils.parseToJsonElement(value));
        return this;
    }

    @Override
    public JSONObject put(String key, Object value) throws JSONException {
        if (key == null) {
            throw new NullPointerException("Null key.");
        }
        if (value != null) {
            this.addProperties(key, value);
        } else {
            this.remove(key);
        }
        return this;
    }

    @Override
    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            if (this.opt(key) != null) {
                throw new JSONException("Duplicate key \"" + key + "\"");
            }
            this.put(key, value);
        }
        return this;
    }

    @Override
    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public Object remove(String key) {
        return this.members.remove(key);
    }

    public String toString() {
        return this.members.toString();
    }

    private void addProperties(String key, Object object) {
        if (object instanceof Number) {
            this.members.addProperty(key, (Number)object);
        } else if (object instanceof Boolean) {
            this.members.addProperty(key, (Boolean)object);
        } else if (object instanceof Character) {
            this.members.addProperty(key, (Character)object);
        } else if (object instanceof String) {
            this.members.addProperty(key, (String)object);
        } else if (object instanceof JSONObject) {
            this.members.add(key, ((JSONObject)object).getMembers());
        } else if (object instanceof JSONArray) {
            this.members.add(key, ((JSONArray)object).getMembers());
        } else {
            this.members.add(key, JSONUtils.parseToJsonElement(object));
        }
    }

    public JsonObject getMembers() {
        return this.members;
    }

    public static final class Null {
        private Null() {
        }

        public boolean equals(Object object) {
            return object == null || object == this;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return "null";
        }
    }
}

