# -*- coding: UTF-8 -*-

from cbb.frame.adapter.resourceService import ResrouceFactory
from cbb.frame.base import baseUtil
from cbb.frame.context import contextUtil


# 执行入口
def execute(dataDict):
    return RssOfflineCheck(dataDict).execute()


class RssOfflineCheck():
    def __init__(self, context):
        self.context = context
        self.allCliRet = ""
        self.errorMsg = ""

    def appendRestRet(self, uri, datas):
        dataStr = self.formatRestData(uri, datas)
        self.allCliRet += dataStr

    @staticmethod
    def formatRestData(uri, datas):
        dataStr = ""
        if datas:
            if not isinstance(datas, list):
                return "\nRest Uri:%s\nResponse:[%s]" % (uri, str(datas))
            for data in datas:
                dataStr += str(data)
                dataStr += "\n"
        return "\nRest Uri:%s\nResponse:[%s]" % (uri, dataStr)

    def execute(self):
        self.logger = contextUtil.getLogger(self.context)
        self.resrouceFactory = ResrouceFactory(self.context)
        self.lang = contextUtil.getLang(self.context)

        licenseFeatureData = self.resrouceFactory.executeInterface("getLicenseFeature")
        self.appendRestRet("licenseFeature", licenseFeatureData)

        checkResults = []
        hyperMetroPairFlag = False
        for licenseFeatureDict in licenseFeatureData:
            hyperReplicationLicense = licenseFeatureDict.get("HyperReplication", -1)
            if hyperReplicationLicense in [1, 2]:
                checkResults.append(self.checkRemoteReplicationPair())
                continue
            hyperMetroLicense = licenseFeatureDict.get("HyperMetro", -1)
            hyperMetroNasLicense = licenseFeatureDict.get("HyperMetroNAS", -1)
            if (hyperMetroLicense in [1, 2] or hyperMetroNasLicense in [1, 2]) and False == hyperMetroPairFlag:
                hyperMetroPairFlag = True
                checkResults.append(self.checkHyperMetroPair())
                continue
            hyperVaultLicense = licenseFeatureDict.get("HyperVault", -1)
            if hyperVaultLicense in [1, 2]:
                checkResults.append(self.checkHypervaultJob())
                continue
            hyperCopyLicense = licenseFeatureDict.get("HyperCopy", -1)
            if hyperCopyLicense in [1, 2]:
                checkResults.append(self.checkLunCopy())
                continue

        flag = False if False in checkResults else True
        if True == flag:
            self.errorMsg = baseUtil.getMsg(self.lang, "RssOfflineUpgradeCheck.pass")

        self.logger.info("The rss offline upgrde check result is：%s" % str(flag))
        return flag, self.errorMsg

    def checkRemoteReplicationPair(self):
        '''
        远程复制运行状态为分裂(Splited)，检查通过
        '''
        replicationPairData = self.resrouceFactory.executeInterface("getReplicationPair")
        self.appendRestRet("ReplicationPair", replicationPairData)

        replicationPairIDs = []
        for replicationPair in replicationPairData:
            # 只判断阵列间远程复制（REMOTEDEVICESN为“--”）的运行状态
            if replicationPair.get("REMOTEDEVICESN") == "--":
                continue
            # 运行状态为分裂（RUNNINGSTATUS为26）
            if replicationPair.get("RUNNINGSTATUS") != "26":
                replicationPairIDs.append(replicationPair.get("ID"))
        if replicationPairIDs:
            self.logger.info("The ReplicationPair check result is no pass.")
            self.logger.info("The ReplicationPair ids is:%s ." % ",".join(replicationPairIDs))
            self.errorMsg += baseUtil.getMsg(self.lang, "replicationPair.not.split", ",".join(replicationPairIDs))
        return not bool(replicationPairIDs)

    def checkHyperMetroPair(self):
        '''
        双活运行状态为暂停（Paused），检查通过
        '''
        hyperMetroPairData = self.resrouceFactory.executeInterface("getHyperMetroPair")
        self.appendRestRet("hyperMetroPair", hyperMetroPairData)
        hyperMetroPairIDs = []
        for hyperMetroPair in hyperMetroPairData:
            # 运行状态为分裂（RUNNINGSTATUS为41）
            if hyperMetroPair.get("RUNNINGSTATUS") != "41":
                hyperMetroPairIDs.append(hyperMetroPair.get("ID"))

        if hyperMetroPairIDs:
            self.errorMsg += baseUtil.getMsg(self.lang, "hyperMetroPair.not.split", ",".join(hyperMetroPairIDs))

        return not bool(hyperMetroPairIDs)

    def checkHypervaultJob(self):
        '''
        一体化备份的作业状态为完成（Job Completed）,检查通过
        '''
        hyperVaultJobData = self.resrouceFactory.executeInterface("getHyperVaultJob")
        self.appendRestRet("hyperVaultJob", hyperVaultJobData)
        hyperVaultJobIDs = []
        for hyperVaultJob in hyperVaultJobData:
            # 运行状态为分裂（RUNNINGSTATUS为70或95）
            if hyperVaultJob.get("RUNNINGSTATUS") not in ["70", "95"]:
                hyperVaultJobIDs.append(hyperVaultJob.get("ID"))
        if hyperVaultJobIDs:
            self.errorMsg += baseUtil.getMsg(self.lang, "hyperVaultJob.not.completeOrCancel",
                                             ",".join(hyperVaultJobIDs))

        return not bool(hyperVaultJobIDs)

    def checkLunCopy(self):
        '''
        查询所有LUN拷贝运行状态为Copying或  Queuing的LUN拷贝ID；如果不存在，则检查通过；
        否则对每一个LUN 拷贝执行show lun_copy member lun_copy_id=lun_copy_id，如果所有的设备ID（Device ID ）
        为--,则检查通过；否则检查不通过
        '''
        lunCopyData = self.resrouceFactory.executeInterface("getLunCopy")
        self.appendRestRet("luncopy", lunCopyData)
        quingOrCopyingLunCopyIds = []
        for luncopyInfo in lunCopyData:
            # 运行状态为分裂（RUNNINGSTATUS为26）
            if luncopyInfo.get("RUNNINGSTATUS") in ["37", "39"]:
                quingOrCopyingLunCopyIds.append(luncopyInfo.get("ID"))

        lunCopyIds = []
        for lunCopyId in quingOrCopyingLunCopyIds:
            memLunCopyData = self.resrouceFactory.executeInterface("getMemberLunCopy", lunCopyId)
            for memLunInfo in memLunCopyData:
                if memLunInfo.get('LUNDEVICEID') != 'INVALID':
                    lunCopyIds.append(lunCopyId)
                    self.appendRestRet("LUNCOPYMEMBERLUN/GET_BATCH_NEXT_LUNCOPY_MEMBERLUN?LUNCOPYID=%s"
                                       % lunCopyId, lunCopyData)
                    break

        if lunCopyIds:
            self.errorMsg += baseUtil.getMsg(self.lang, "inter.array.lunCopy.running", ",".join(lunCopyIds))

        return not bool(lunCopyIds)
