# -*- coding: UTF-8 -*-

import ast
import copy
import decimal
import json
import math
import os
import re
import socket
import threading
import time
import traceback

import java.net.InetAddress as JInetAddress
import java.net.UnknownHostException as JUnknownHostException
import java.util.regex.Pattern as Jpattern
from com.huawei.ism.tool.obase.entity import EntityUtils
from com.huawei.ism.tool.protocol.rest import RestConnectionManager
from com.huawei.ism.tool.devicemanager.utils import LicenseFeatureQueryUtil
from utils import Products

from cbb.business.operate.expansion import config
from cbb.business.operate.expansion import logger
from cbb.business.operate.expansion import resource
from cbb.business.operate.expansion import toolConfigUtil
from cbb.business.operate.expansion.cabinetFactory import CABINET
from cbb.business.product.product_selector import get_product_adapter
from cbb.common.conf import switch_config
from cbb.common.conf.productConfig import ENC_HEIGHT_TO_CTRL_NUM
from cbb.common.conf.productConfig import IP_SAS_INTERNAL_PDT_MODEL_TUPLE
from cbb.common.conf.productConfig import SAS_INTERNAL_PDT_MODEL_TUPLE
from cbb.common.conf.v5HighEnd.fullBayConf import MAX_DISK_BAY_PER_SYS
from cbb.common.conf.v5HighEnd.fullBayConf import MAX_DISK_ENC_PER_BAY
from cbb.common.conf.v6HighEnd.fullBayConf import EXP_DAE_SYM_BAY_PAIRS
from cbb.frame.base import baseUtil, jsonUtil
from cbb.frame.base import config as baseConfig
from cbb.frame.base.config import DORADO_DEVS_V6_HIGH
from cbb.frame.base.config import NEW_DORADO
from cbb.frame.base.config import OCEAN_PROTECT
from cbb.frame.base.config import OCEAN_STOR_COMPUTING_DEVS, OCEAN_STOR_MICRO_DEVS
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from cbb.frame.rest import commonRestData
from cbb.frame.rest import commonRestUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.frame.rest.restDataConstants import ENCLOSURE_HEIGHT
from cbb.frame.rest.restDataConstants import ENCLOSURE_MODEL
from cbb.frame.tlv import tlvData
from cbb.frame.tlv import tlvUtil

STATUS_NORMAL = "Normal"
STATUS_FAULT = "Fault"
STATUS_ONLINE = "Online"
STATUS_RUNNING = "Running"
STATUS_BALANCING = "Balancing"
STATUS_CHARGING = "Charging"
STATUS_DISCHARGING = "Discharging"
STATUS_ENABLED = "Enabled"
STATUS_YES = "Yes"
STATUS_NO = "No"
STATUS_LINK_UP = "Link Up"
STATUS_LINK_DOWN = "Link Down"
STATUS_ON = "On"
STATUS_OFF = "Off"
STATUS_START = "Start"
TOTAL_RUN_CNT = "Total Run Count"
CLUST_TYPE_NONE = "none"
CLUST_TYPE_DIRECT = "direct"  # 直连
CLUST_TYPE_SWITCH = "switch"  # 交换

IPV4 = "v4"
IPV6 = "v6"

INTF_RUNMODEL_FC = 1
INTF_RUNMODEL_ETH = 2
INTF_RUNMODEL_CLUSTER = 3

FILE_SUFFIX = "."
VERSIONS_CHECK_TIME_LIMIT = 600
VERSIONS_CHECK_TIME_INTERVAl = 30
NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_LIMIT = 7200
NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl = 30
# 单个流程上电失败最大等待时间（备注：如果多引擎同时重启，需要修改此超时时间）
SINGLE_STEP_FLOW_CHECK_TIME_LIMIT = 900
# 2U和3U设备单引擎扩控典型时间
TYPICAL_POWER_ON_TIME_2U_3U = 60 * 60
# 2U和3U设备单引擎扩控典型时间等待后，缓冲一个间隔时间刷新进度
TYPICAL_POWER_ON_DELTA_TIME_2U_3U = 5 * 60

ALUA_CHECK_RETRY_TIMES = 3
ALUA_CHECK_RETRY_INTERVAL = 1
NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE = 5
MAX_CPU_USAGE = 80

# 扩控前检查告警ID白名单
PRE_CHECK_ALARM_WHITELIST = {
    "0x100F00D8002B",  # 存储池可用空间不足。重要
    "0x100F00D8002C",  # 存储池已无可用空间。紧急
    "0x10A0005",  # 硬盘域热备空间不足
    "0x10A0007",  # 硬盘域硬盘数量不满足热备策略要求
    "0x200F00D8011D",  # 存储池容量耗尽
    "0xD80001",  # 存储池剩余容量不足
    "0xD80002",  # 存储池容量即将耗尽
    "0xF00280047",  # 文件系统剩余容量不足。重要
    "0xF00280120",  # 文件系统剩余容量不足。重要
    "0xF00280126",  # 文件系统耗尽保护生效。重要
    "0xF00D80114",  # 存储池剩余容量不足
    "0xF00D80119",  # 存储池剩余容量不足
    "0xF00D80120",  # 存储池容量即将耗尽
    "0xF00D80142",  # 系统承诺容量不足
    "0xF00D80143",  # 系统承诺容量即将耗尽
    "0xF00D80144",  # 系统承诺容量耗尽
    "0xF00D80148",  # 可得容量消耗不符合预期
    "0xF00E00038",  # 存储池可用空间耗尽。紧急
    "0xF01050015",  # 交换机无法监控
    "0xF010A0059",  # 硬盘域热备空间不足。重要
    "0xF010B0005",  # 写入容量达到可得容量规格
    "0xF010B0006",  # 写入容量超过可得容量规格
    "0xF03300068",  # 虚拟机文件系统剩余容量低于阈值。重要
    "0xF0D80004",  # 存储池热备空间不足。重要
    "0xF0D80006",  # 存储池容量即将耗尽
}

# 扩控后检查告警ID白名单
POST_CHECK_ALARM_WHITELIST = {
    "0x100F00D8002B",  # 存储池可用空间不足。重要
    "0x100F00D8002C",  # 存储池已无可用空间。紧急
    "0x10A0005",  # 硬盘域热备空间不足
    "0x10A0007",  # 硬盘域硬盘数量不满足热备策略要求
    "0x200F00D8011D",  # 存储池容量耗尽
    "0xD80001",  # 存储池剩余容量不足
    "0xD80002",  # 存储池容量即将耗尽
    "0xF00280047",  # 文件系统剩余容量不足。重要
    "0xF00280120",  # 文件系统剩余容量不足。重要
    "0xF00280126",  # 文件系统耗尽保护生效。重要
    "0xF00D80114",  # 存储池剩余容量不足
    "0xF00D80119",  # 存储池剩余容量不足
    "0xF00D80120",  # 存储池容量即将耗尽
    "0xF00D80142",  # 系统承诺容量不足
    "0xF00D80143",  # 系统承诺容量即将耗尽
    "0xF00D80144",  # 系统承诺容量耗尽
    "0xF00D80148",  # 可得容量消耗不符合预期
    "0xF00E00038",  # 存储池可用空间耗尽。紧急
    "0xF01050015",  # 交换机无法监控
    "0xF010A0059",  # 硬盘域热备空间不足。重要
    "0xF010B0005",  # 写入容量达到可得容量规格
    "0xF010B0006",  # 写入容量超过可得容量规格
    "0xF03300068",  # 虚拟机文件系统剩余容量低于阈值。重要
    "0xF0D80004",  # 存储池热备空间不足。重要
    "0xF0D80006",  # 存储池容量即将耗尽
}

CHECK_MANIP_CONFLICT = {
    '0xF00C9013D',  # 管理IP冲突告警
}

# 扩控前检查新扩控告警ID白名单
PRE_CHECK_NEW_SYS_ALARM_WHITELIST = [
    "0xF00060020",  # 端口间的线缆连接错误
    "0xF0CE0001",  # 系统无法监控硬盘框
    "0xF00CF0017",  # 控制器端口和交换机端口连接错误
    "0xF0060004",  # 端口连接断开
]

# 扩控前检查新扩控告警ID白名单FOR DORADO NAS
PRE_CHECK_NEW_SYS_ALARM_WHITELIST_FOR_DORADO_NAS = [
    "0xF00060028",  # 端口间的线缆连接错误
    "0xF0CE0001",  # 系统无法监控硬盘框
    "0xF00CF0017",  # 控制器端口和交换机端口连接错误
    "0xF0060004",  # 端口连接断开
]

MGMT_PORT_CONFIGMANIP = ["CTE0.SMM0.MGMT", "CTE0.SMM1.MGMT",
                         "CTE0.SMM0.MGMT0", "CTE0.SMM0.MGMT1", "CTE0.SMM1.MGMT0", "CTE0.SMM1.MGMT1",
                         "CTE0.A.MGMT", "CTE0.B.MGMT",
                         "CTE0.A.MGMT0", "CTE0.A.MGMT1", "CTE0.B.MGMT0", "CTE0.B.MGMT1"]

CHECK_CONFLICT_LIMIT_TIME = 60 * 6

# 刷新进度间隔时间
REFRESH_PROCESS_INTERVAL_TIME = 2
# IPv4正则表达式定义
IPV4_REGEX_DEFINE = "^((25[0-5]|2[0-4]\d|[0-1]?\d\d?)\.){3}(25[0-5]|2[0-4]\d|[0-1]?\d\d?)$"

# IPv6正则表达式定义
IPV6_REGEX_DEFINE = "^\s*((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\d|[01]?\d{1,2})(\.(25[0-5]|2[0-4]\d|[01]?\d{1,2})){3})))(%.+)?\s*$"

# IP冲突错误码定义（未进行过扩容的阵列）
IP_CONFLICT_ERRCODE_UNEXPANSIONED_DEFINE = {
    "1077949780": "confilict.managementIP.unexpansioned",
    "1077949781": "confilict.severciIP.unexpansioned",
    "1077949782": "confilict.maintenanceIP.unexpansioned",
    "1073743379": "confilict.ip.addr.alrady.exist.unexpansioned",
    "1073743383": "confilict.severciIP.same.segment.unexpansioned",
    "1073743382": "confilict.maintenanceIP.same.segment.unexpansioned",
    "1073743381": "confilict.managementIP.same.segment.unexpansioned",
}

# IP冲突错误码定义（已进行过扩容的阵列）
IP_CONFLICT_ERRCODE_EXPANSIONED_DEFINE = {
    "1077949780": "confilict.managementIP.expansioned",
    "1077949781": "confilict.severciIP.expansioned",
    "1077949782": "confilict.maintenanceIP.expansioned",
    "1073743379": "confilict.ip.addr.alrady.exist.expansioned",
    "1073743383": "confilict.severciIP.same.segment.expansioned",
    "1073743382": "confilict.maintenanceIP.same.segment.expansioned",
    "1073743381": "confilict.managementIP.same.segment.expansioned",
}

# Dorado基地址IP冲突错误码
IP_CONFLICT_ERRCODE_DORADO = {
    "1073743378": "confilict.clusterIP.expansioned",
    "1073743381": "confilict.managementIP.expansioned",
    "1073743382": "confilict.maintenanceIP.expansioned",
    "1073743383": "confilict.severciIP.expansioned",
}
# 配置IP与网管不在同一网段失败错误码
RETURN_GW_NOT_MATCH_IP = "1077949777"

# 用户扩控回退的识别告警和错误码
NODE_ERR_CODE_SYNC_VERSION_FAIL = "0x40401702"  # 系统上电时，控制器同步版本失败 错误码
CHECK_CTRL_ISOLATED = "0x100F00CF0034"  # 控制器被隔离 告警ID
EXPANSION_ROLL_BACK_CTRL_NUM_ORIGIN = "EXPANSION_ROLL_BACK_CTRL_NUM_ORIGIN"  # 扩容回退控制器数量
EXPANSION_ROLL_BACK_FROM_TIME = "EXPANSION_ROLL_BACK_FROM_TIME"  # 扩容回退查询告警（事件）的起始时间
EXPANSION_ROLL_BACK_RULELIST_2U3U = ["0A", "0B",
                                     "1A", "1B",
                                     "2A", "2B",
                                     "3A", "3B"]
EXPANSION_ROLL_BACK_RULELIST_6U = ["0A", "0B", "0C", "0D",
                                   "1A", "1B", "1C", "1D",
                                   "2A", "2B", "2C", "2D",
                                   "3A", "3B", "3C", "3D"]

# ------扩柜新增------#
# 一个系统柜支持最大的硬盘柜数量
MAX_DISK_BAYS_PER_SYS_BAY = 5
# 一个系统柜可带的硬盘柜（包括系统柜）
MAX_DISK_BAY_PER_BAY = 6

# 十进制映射为十六进制的字符
INT_TO_HEX_STRING = {
    0: "0", 1: "1", 2: "2", 3: "3",
    4: "4", 5: "5", 6: "6", 7: "7",
    8: "8", 9: "9", 10: "A", 11: "B",
    12: "C", 13: "D", 14: "E", 15: "F",
}
# 单个引擎满配柜时，每个柜号的分区起始硬盘框（框号后两位）标识字典
CABINET_START_ENCLOSURE_DICT = {
    "0": ["00", "10", "20", "30"],
    "1": ["40", "50", "60", "70"],
    "2": ["80", "90", "A0", "B0"],
    "3": ["04", "14", "24", "34"],
    "4": ["44", "54", "64", "74"],
    "5": ["84", "94", "A4", "B4"],
}

# 每个分区对应的硬盘框名称的后两位
CABINET_PARTITION_ENCLOSURE_DICT = {
    "0": ["00", "40", "80", "04", "44", "84"],
    "1": ["10", "50", "90", "14", "54", "94"],
    "2": ["20", "60", "A0", "24", "64", "A4"],
    "3": ["30", "70", "B0", "34", "74", "B4"],
}

# 每个环路的起始位置
SAS_PORT_START_U = {
    "0": 1, "1": 9, "2": 27, "3": 35,
    "4": 1, "5": 9, "6": 27, "7": 35,
    "8": 1, "9": 9, "A": 27, "B": 35,
}

# 每个分区不同类型的硬盘框支持的规格数量
PARTITION_ENCLOSURE_CONFIG = {
    "2": 4,
    "4": 2,
}

# 2U,4U对应的硬盘类型
ENC_TYPE = {
    "2": "EXPSAS2U_25",
    "4": "EXPSAS4U_24_NEW",
}

# 系统柜标识
SYSTEM_CABINET = "SMB"

# 存储柜标识
STORAGE_CABINET = "DKB"

# 硬盘框上电时间
TIME_OUT_EXP_ENC = 25 * 60

# 单控模式
SINGLE_CTRL = "SINGLE_CTRL"

# 扩容配置数据持久化目录
CFG_DATA_PERSIST_DIR = os.path.join("temp", "expanEval")
CFG_DATA_PERSIST_FILENAME = "expansionEvalConfig.dat"
# 向上两级目录
DIR_RELATIVE_CMD = os.path.join("..", "..")

# 扩容网段是否有subnetMask字段
HAVE_SUBNET = "have_subnet"

# 默认的行高度
ROW_HEIGHT = 25

# 备份平面
BACKUP = "backup"

# 归档平面
ARCHIVE = "archive"

# 复制平面
COPY = "copy"

# 高端2引擎控制器数量
HIGH_END_WITH_TWO_ENGINE_CTRL_NUM = 8
# 中端2引擎控制器数量
MID_END_WITH_TWO_ENGINE_CTRL_NUM = 4


class returnVal():
    """
    Function：构造两个返回值的字典
    Params：succ=执行结果是否成功；info=需要回传的信息
    Return：两个值的字典
    """

    @staticmethod
    def dict2(succ, info):
        return {"succ": succ, "info": info}

    """
    Function：构造三个返回值的字典
    Params：succ=执行结果是否成功；reason=原因；suggestion=建议
    Return：三个值的字典
    """

    @staticmethod
    def dict3(succ, reason, suggestion):
        return {"succ": succ, "reason": reason, "suggestion": suggestion}


def getClustInfo(context, tlv):
    '''
    @summary: 获取设备信息
    '''

    logger = getLogger(context.get("logger"), __file__)

    # 获取当前集群控制器数量
    controllerNum = tlvUtil.getControllersNum(tlv)
    logger.logInfo("controllerNum:%s" % controllerNum)

    # 获取引擎数量
    ctrl_enclosure_num = len(tlvUtil.getControllerEnclosureRecords(tlv))
    logger.logInfo("engine number:{}".format(ctrl_enclosure_num))

    bayRecords = tlvUtil.getBayRecords(tlv)
    logger.logInfo("bayRecords:%s" % str(bayRecords))
    # 获取所有柜id
    bayIds = tlvUtil.getBayIds(bayRecords if bayRecords else [])
    logger.logInfo("bayIds:%s" % ",".join(bayIds))

    # 获取配置文件中控制器的数量
    bayId = None if (bayIds is None or len(bayIds) == 0) else min(bayIds)
    bayConfigCtrlNum = tlvUtil.getBayConfigCtrlNum(tlv, bayId, isIpScaleOut=True)
    logger.logInfo("bayConfigCtrlNum:%s" % bayConfigCtrlNum)

    # 获取配置文件中集群组网方式
    try:
        x_net_info = tlvUtil.readXnetInfo(tlv)
        config_cluster_type = tlvUtil.getBayConfigClustType(x_net_info)
    except Exception as ex:
        logger.logInfo("exception:{}".format(str(ex)))
        logger.logInfo("read xnet info failed: %s"
                       % str(traceback.format_exc()))
        config_cluster_type = -1
    logger.logInfo("bay config cluster type:{}".format(config_cluster_type))

    # 获取控制框高度
    ctrlEnclosureHeight = tlvUtil.getCtrlEnclosureHeight(tlv)
    logger.logInfo("ctrlEnclosureHeight:%s" % ctrlEnclosureHeight)

    # 获取产品型号
    productModel = tlvUtil.getProductModel(tlv)
    logger.logInfo("productModel:%s" % productModel)

    productVersion = tlvUtil.getProductVersion(tlv)
    logger.logInfo("productVersion:%s" % productVersion)

    fullProductVersion = tlvUtil.getFullProductVersion(tlv)
    logger.logInfo("fullProductVersion:%s" % fullProductVersion)

    patchVersion = tlvUtil.getPatchVersion(tlv)
    logger.logInfo("patchVersion:%s" % patchVersion)

    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    sysDate = cliUtil.getSystemDate(cli, lang)
    logger.logInfo("sysDate:%s" % str(sysDate[0]))
    if sysDate[0] == "":
        raise Exception("get system date error.")

    product_model_string = productModel
    if baseUtil.isArmDevV5New(productModel):
        product_model_string = tlvUtil.get_product_model_string(tlv)
    popupSelectModel = getProductModelByDev(context, product_model_string)

    logger.logInfo("popupSelectModel:%s" % popupSelectModel)
    # 获取扩容规格字典
    interModel = getInternalProductModel(context)
    logger.logInfo("InterProductModel:%s" % interModel)
    contextUtil.setItem(context, "interProductModel", interModel)

    expansionSpecDict = getExpansionSpecDict(controllerNum, productModel,
                                             fullProductVersion)
    logger.logInfo("expansionSpecDict:%s" % expansionSpecDict)

    # 获取原集群控制框型号
    ctrlEnclosureModel = tlvUtil.getCtrlEnclosureModel(tlv)
    logger.logInfo("ctrlEnclosureModel:%s" % str(ctrlEnclosureModel))

    # 获取硬盘框数量
    enclosureRecords = tlvUtil.getEnclosureRecords(tlv)
    diskEncNum = len(tlvUtil.getDiskEnclouresName(enclosureRecords))
    logger.logInfo("disk enclosure num:%s" % str(diskEncNum))

    # 当前版本是否支持交换机和C+硬件
    is_sup_switch_c_plus = baseUtil.is_v5v6_support_switch(productModel,
                                                           fullProductVersion)
    contextUtil.setItem(context, "is_sup_switch_c_plus", is_sup_switch_c_plus)
    # 保存当前集群控制器数量到上下文
    contextUtil.setItem(context, "ctrlNum", controllerNum)
    # 保存当前集群控制框数量
    contextUtil.setItem(context, "ctrl_enclosure_num", ctrl_enclosure_num)
    # 扩容回退控制器数量，勿改动！
    contextUtil.setItem(context, EXPANSION_ROLL_BACK_CTRL_NUM_ORIGIN, controllerNum)
    # 扩容回退查询告警的起始时间，勿改动！
    contextUtil.setItem(context, EXPANSION_ROLL_BACK_FROM_TIME, sysDate[0])
    # 保存当前集群控制框高度到上下文
    contextUtil.setItem(context, "ctrlHeight", ctrlEnclosureHeight)
    # 保存当前集群上所有柜的柜id信息到上下文
    contextUtil.setItem(context, "configBayIds", bayIds)
    # 保存组网方式
    contextUtil.setItem(context, "configClustType", config_cluster_type)
    # 保存配置文件中控制器数量到上下文
    contextUtil.setItem(context, "configCtrlNum", bayConfigCtrlNum)
    # 保存扩容规格字典到上下文
    contextUtil.setItem(context, "expansionSpecDict", expansionSpecDict)
    # 保存产品型号到上下文
    contextUtil.setItem(context, "productModel", productModel)
    # 保存产品版本到上下文
    contextUtil.setItem(context, "productVersion", productVersion)
    # 保存补丁版本到上下文
    contextUtil.setItem(context, "patchVersion", patchVersion)
    # 保存全产品版本到上下文
    contextUtil.setItem(context, "fullProductVersion", fullProductVersion)
    # 保存选择组网显示到上下文
    contextUtil.setItem(context, "popupSelectModel", popupSelectModel)
    # 保存NVMe到上下文
    contextUtil.setItem(context, "ctrlEnclosureModel", ctrlEnclosureModel)
    # 保存硬盘框数量
    contextUtil.setItem(context, "diskEnclosureNum", diskEncNum)

    # 记录工具执行步骤标记，用于工具界面提示
    contextUtil.setItem(context, "expStep", "")

    return


def getRes(lang, res, args="", resDict=resource.RESOURCE_DICT):
    '''
    @summary: 资源国际化
    @param lang: 语言lang
    @param res: 资源
    @param args: 资源对应的参数
    @param resDict: 资源字典
    @return: 经过国际化处理后的资源
    '''
    try:

        spValue = toolConfigUtil.getValue(config.SPECIAL_MSG_KEY)
        key = "%s_%s_%s" % (spValue, res, lang)
        if not resDict.has_key(key):
            key = "%s_%s" % (res, lang)
            if not resDict.has_key(key):
                return ("--", "")

        context = resDict.get(key)
        if "%s" in context or "%i" in context:
            context = context % args

        return context

    except:
        return ("--", "")


def get_error_result(lang, err_key):
    """
    根据key获取错误提示和建议
    :param err_key: 消息key
    :param lang: 语言
    :return:
    """
    err_msg, suggestion = getMsg(lang, err_key)
    return {"flag": False,
            "errMsg": err_msg,
            "suggestion": suggestion}


def getMsg(lang, msg, errMsgArgs="", suggestionArgs="", msgDict=resource.MESSAGES_DICT):
    '''
    @summary: 错误消息和修复建议国际化
    @param lang: 语言lang
    @param msg: 消息
    @param errMsgArgs: 错误对应的参数
    @param suggestionArgs: 修复建议对应的参数
    @param msgDict: 消息和修复建议字典
    @return: 经过国际化处理后的消息和修复建议
    '''
    try:
        if not msgDict.has_key(msg):
            return ("--", "")

        localeDict = msgDict.get(msg)

        spValue = toolConfigUtil.getValue(config.SPECIAL_MSG_KEY)
        errMsgKey = "%s_errMsg_%s" % (spValue, lang)
        if errMsgKey not in localeDict.keys():
            errMsgKey = "errMsg_%s" % lang

        suggestionKey = "%s_suggestion_%s" % (spValue, lang)
        if suggestionKey not in localeDict.keys():
            suggestionKey = "suggestion_%s" % lang

        errMsg = localeDict.get(errMsgKey, "--")
        suggestion = localeDict.get(suggestionKey, "")

        if "%s" in errMsg or "%i" in errMsg:
            errMsg = errMsg % errMsgArgs
        if "%s" in suggestion or "%i" in suggestion:
            suggestion = suggestion % suggestionArgs

        return (errMsg, suggestion)

    except:
        return ("--", "")


def getExpansionResource(lang, msgKey, msgDict=resource.EXPASION_STEP_RES_DICT):
    """错误消息和修复建议国际化

    :param lang:
    :param msgKey:
    :param msgDict:
    :return:
    """
    return msgDict.get(msgKey, {}).get(lang, '--')


def getJsonStr(obj):
    '''
    @summary: 将字典或集合类型数据结构转成json字符串
    @param obj: 字典或集合类型数据结构
    '''
    if type(obj) == dict:
        return dict2JsonStr(obj)

    if type(obj) == list:
        strObj = "["
        metFirst = False
        for index in range(0, len(obj)):
            strDict = dict2JsonStr(obj[index])
            if True == metFirst:
                strObj = strObj + ', ' + strDict
            else:
                strObj = strObj + strDict
                metFirst = True
        strObj = strObj + ']'
        return strObj

    return ""


def dict2JsonStr(obj):
    '''
    @summary: 将字典类型数据结构转成json字符串
    @param obj: 字典类型数据结构
    '''
    return jsonUtil.dict2JsonStr(obj)


def regSearch(regex, s):
    '''
    @summary: 正则表达式匹配
    @param regex: 正则表达式
    @param s: 要匹配的字符串
    @return: 
        True: 匹配成功
        False: 匹配失败
    '''
    reg = Jpattern.compile(regex)
    match = reg.matcher(s)
    if match.find():
        return True
    else:
        return False


def jsonStr2Dict(strJson):
    '''
    @summary: 将json字符串转成字典数据结构
    @param strJson: json字符串
    '''
    return ast.literal_eval(str(strJson))


def getSysAbnormalRet(ret, lang):
    '''
    @summary: 将cli的执行结果由tuple转换为dict
    @param ret: cli执行的tuple形式结果
    @param lang: 语言lang
    @return:
        flag: 
            True: cli执行成功
            False: cli执行失败
        errMsg: 错误消息
        suggesiton: 修复建议
        ret: cli回显
    '''
    msgs = getMsg(lang, "system.abnormal")
    suggestion = msgs[1]
    return {"flag": False, "ret": ret[1], "errMsg": ret[2], "suggestion": suggestion}


def getBaseName(file_path):
    '''
    @summary: 返回文件路径的文件名，不包含后缀
    @param file_path:文件路径
    @return: 返回不包含后缀的文件名字符串
    '''
    file_name = os.path.basename(file_path)
    if FILE_SUFFIX in file_name:
        dot_index = file_name.rindex(FILE_SUFFIX)
        return file_name[0:dot_index]
    else:
        return file_name


def getLogger(loggerInstance, pyFilePath):
    '''
    @summary: 获取日志类
    @param loggerInstance: logger实例
    @param pyFilePath: py文件路径
    '''
    pyFileName = getBaseName(pyFilePath)
    return logger.Logger(loggerInstance, pyFileName)


def checkPrevilege(cli, lang):
    '''
    @summary: 检查用户权限为管理员或超级管理员
    @param cli: cli对象
    @param lang: 语言lang
    @return: 以字典形式返回结果 
        flag: 
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag": True, "errMsg": "", "suggestion": ""}

    hasAdminOrSuperAdminPrivilegeRet = cliUtil.hasAdminOrSuperAdminPrivilege(cli, lang, cliUtil.PrivilegeType.ROLE_ID)

    if not hasAdminOrSuperAdminPrivilegeRet[0]:
        return getSysAbnormalRet(hasAdminOrSuperAdminPrivilegeRet, lang)

    if not hasAdminOrSuperAdminPrivilegeRet[1]:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "check.user.rights.error")
        return result

    return result


def checkSuperAdminPrevilege(cli, lang):
    '''
    @summary: 检查用户权限为超级管理员
    @param cli: cli对象
    @param lang: 语言lang
    @return: 以字典形式返回结果 
        flag: 
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag": True, "errMsg": "", "suggestion": ""}

    hasSuperAdminPrivilegeRet = cliUtil.hasSuperAdminPrivilege(cli, lang, cliUtil.PrivilegeType.ROLE_ID)

    if not hasSuperAdminPrivilegeRet[0]:
        return getSysAbnormalRet(hasSuperAdminPrivilegeRet, lang)

    if not hasSuperAdminPrivilegeRet[1]:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "check.user.rights.error")
        return result

    return result


def checkControllerStatus(context, cli, lang):
    '''
    @summary: 检查原集群控制健康状态和运行状态是否正常
    @param cli: cli对象
    @param lang: 语言lang
    @return: 以字典形式返回结果 
        flag: 
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag": True, "errMsg": "", "suggestion": ""}

    cmd = "show controller general|filterColumn include columnList=Controller,Health\sStatus,Running\sStatus"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not checkRet[0]:
        return getSysAbnormalRet(checkRet, lang)

    cliRet = checkRet[1]
    cliRetLinesList = cliUtil.getVerticalCliRet(cliRet)
    if len(cliRetLinesList) == 0:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "cannot.get.controller.info")
        return result

    ctrlList = []
    flag = True
    for retDict in cliRetLinesList:
        healthStatus = retDict["Health Status"]
        runningStatus = retDict["Running Status"]
        controller = retDict["Controller"]

        if healthStatus != STATUS_NORMAL or runningStatus != STATUS_ONLINE:
            ctrlList.append(controller)
            flag = False

    if not flag:
        ctrlList.sort()
        ctrlListStr = ",".join(ctrlList)
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "controller.status.abnormal", ctrlListStr)
        return result

    return result


def checkMoveCardSysAlarm(context, lang, locations, alarmWhiteList):
    """
    @summary: 检查系统是否存在特定告警
    @param cli: cli对象
    @param lang: 语言lang
    @param alarmWhiteList: 告警白名单
    @param location: 接口卡槽位
    @return: 以字典形式返回结果
        flag:
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    """
    result = {"flag": True, "errMsg": "", "suggestion": ""}

    # 查询重要紧急级别的告警
    cli = contextUtil.getCli(context)
    cmd = "show alarm |filterRow column=Level predict=equal_to value=Major logicOp=or column=Level predict=equal_to value=Critical |filterColumn include columnList=Sequence,ID"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not checkRet[0]:
        return getSysAbnormalRet(checkRet, lang)
    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return result

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        if line["ID"] in alarmWhiteList:
            continue
        if line["ID"] != "0xF0D10005":
            result["flag"] = False
            result["errMsg"], result["suggestion"] = getMsg(lang, "system.exists.alarm")
            return result

        # 拔插卡告警检查（指定框号与槽位号的卡，告警过滤不检查）
        alarmCheckcmd = "show alarm sequence=" + line["Sequence"]
        newCheckRet = cliUtil.execCmdInCliMode(cli, alarmCheckcmd, True, lang)
        if not newCheckRet[0]:
            return getSysAbnormalRet(newCheckRet, lang)

        interModules = re.findall(r'\((.*?)\)', newCheckRet[1])
        if not interModules:
            # 告警信息异常
            result["flag"] = False
            result["errMsg"], result["suggestion"] = getMsg(lang, "system.exists.alarm")
            return result

        # 非待挪卡的拔插卡告警，检查不通过
        if not filter(lambda location: location[:4] in interModules[0] and location[5:] in interModules[0], locations):
            result["flag"] = False
            result["errMsg"], result["suggestion"] = getMsg(lang, "system.exists.alarm")
            return result
        else:  # 检查到移卡槽位拔卡告警时工具清除
            if line["Sequence"]:
                clearAlarm(context, line["Sequence"])

    return result


def clearAlarm(context, sequence):
    params = {}
    rest = contextUtil.getRest(context)
    uriParamDict = restUtil.CommonRest.getUriParamDict(
        restData.RestCfg.SpecialUri.QUERY_CURRENT_SINGLE_ALARM_INFO % sequence)
    return restUtil.CommonRest.execCmd(rest, uriParamDict, params, restData.RestCfg.RestMethod.DELETE)


def checkSysAlarm(cli, lang, alarmWhiteList):
    '''
    @summary: 检查系统是否存在特定告警
    @param cli: cli对象
    @param lang: 语言lang
    @param alarmWhiteList: 告警白名单
    @return: 以字典形式返回结果 
        flag: 
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag": True, "errMsg": "", "suggestion": ""}

    cmd = "show alarm|filterColumn include columnList=ID,Level"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not checkRet[0]:
        return getSysAbnormalRet(checkRet, lang)

    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return result

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        if line["Level"].lower() in ["major", "critical"] and line["ID"] not in alarmWhiteList:
            result["flag"] = False
            result["errMsg"], result["suggestion"] = getMsg(lang, "system.exists.alarm")
            return result

    return result


def checkSpecifiedAlarms(cli, lang, **kwargs):
    """检查系统是否存在特定告警

    Args:
        cli: cli对象
        lang: 语言lang
        alarmWhiteList: 告警白名单

    Returns:
        list: 检查到的异常信息

    """
    checkedAlarm = []
    chkAlmIdList = kwargs.get("chkAlmIdList", [])
    almIdWhiteList = kwargs.get("almIdWhiteList", [])
    cmd = "show alarm|filterColumn include columnList=ID,Level"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if checkRet[0] != True:
        return getSysAbnormalRet(checkRet, lang)

    cliRet = checkRet[1]
    if cliUtil.queryResultWithNoRecord(cliRet):
        return []

    cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
    for line in cliRetLinesList:
        if line.get("Level", "").lower() in ["major", "critical"] \
                and line.get("ID", "") not in almIdWhiteList \
                and line.get("ID", "") in chkAlmIdList:
            alarm = {}
            alarm["ID"] = line.get("ID")
            alarm["Sequence"] = line.get("Sequence")
            checkedAlarm.append(alarm)
    return checkedAlarm


def checkSysAlarmByIdWithErrCode(cli, lang, alarmId, errorCode, fromDate):
    '''
    @summary: 检查系统是否存在特定错误码的告警
    @param cli: cli对象
    @param lang: 语言lang
    @param alarmId: 被检查告警Id
    @param errorCode: 被检查告警Id包含的错误码
    @param fromDate: 查询告警的起始时间
    @return: 以字典形式返回结果 
        flag: 
            True: 存在指定告警
            False: 异常或不存在指定告警
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    try:
        cmd = "show event object_type=207 from_time=%s |filterColumn include columnList=ID,Sequence" % str(fromDate)
        checkRet = cliUtil.execCmdInCliMode(cli, cmd, False, lang)
        if not checkRet[0]:
            return False

        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return False

        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        for line in cliRetLinesList:
            if line.get("ID") == alarmId:
                queryBySeqCmd = "show event sequence=%s" % str(line.get("Sequence"))
                queryBySeqCmdRet = cliUtil.execCmdInCliMode(cli, queryBySeqCmd, True, lang)
                if not queryBySeqCmdRet[0]:
                    return False

                retContent = queryBySeqCmdRet[1]
                retContentLinesList = cliUtil.getVerticalCliRet(retContent)
                for retDict in retContentLinesList:
                    alarmDetail = retDict.get("Detail")
                    if errorCode.upper() in alarmDetail.upper():
                        return True

        return False
    except:
        return False


def getDiskEnclosure(cli, lang):
    enclosureInfo = {"SMART": [], "SAS": [], "NVMe": []}
    cmd = "show enclosure"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not checkRet[0]:
        return {}
    cliRet = checkRet[1]
    cliRetLinesExpModuleList = cliUtil.getHorizontalCliRet(cliRet)
    for rec in cliRetLinesExpModuleList:
        logicType = rec.get("Logic Type", "")
        if logicType != "Expansion Enclosure":
            continue
        diskEncType = rec.get("Type", "")
        encid = rec.get("ID", "")
        if "IP" in diskEncType or "smart" in diskEncType:
            enclosureInfo["SMART"].append(encid)
        elif "SAS" in diskEncType:
            enclosureInfo["SAS"].append(encid)
        else:
            enclosureInfo["NVMe"].append(encid)
    return enclosureInfo


def getExpModuleVersions(cli, lang, versionName, enclosureInfo={}):
    """ 检查级联模块SES、Logic、PCB等版本是否一致

    :param cli: cli对象
    :param lang: 语言lang
    :param versionName: SES、Logic、PCB等版本
    :param enclosureInfo: 硬盘框信息
    :return: 以字典形式返回结果
            flag:
                True: 检查通过
                False: 检查不通过
            errMsg: 错误消息
            suggestion: 修复建议
    """
    result = {"flag": True, "errMsg": "", "suggestion": "", "hasEmptyVersion": False}

    cmd = "show version all"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not checkRet[0]:
        return getSysAbnormalRet(checkRet, lang)
    cliRet = checkRet[1]

    expModuleRet = cliUtil.getSplitedCliRet(cliRet, "Expansion Module:")
    if len(expModuleRet) == 0:
        result["flag"] = True
        return result
    cliRetLinesExpModuleList = cliUtil.getHorizontalCliRet(expModuleRet)

    highDensityDiskEnclosureIdListRet = cliUtil.getHighDensityDiskEnclosureIdList(cli, lang)
    if not highDensityDiskEnclosureIdListRet[0]:
        return getSysAbnormalRet(highDensityDiskEnclosureIdListRet, lang)
    highDensityDiskEnclosureIdList = highDensityDiskEnclosureIdListRet[1]

    expModuleHighDensityDiskVersionsSet = set()
    emptyVersionList = []
    sasVersion = set()
    nvmeVersion = set()
    smartVersion = set()

    for line in cliRetLinesExpModuleList:
        expModuleId = line["ID"]
        enclosureId = expModuleId.split(".")[0]
        expModuleVersion = line["%s Version" % versionName]
        if len(expModuleVersion) == 0:
            emptyVersionList.append(expModuleId)
        else:
            if enclosureId in highDensityDiskEnclosureIdList:
                expModuleHighDensityDiskVersionsSet.add(expModuleVersion)
            else:
                if enclosureId in enclosureInfo.get("SAS", []):
                    sasVersion.add(expModuleVersion)
                if enclosureId in enclosureInfo.get("NVMe", []):
                    nvmeVersion.add(expModuleVersion)
                if enclosureId in enclosureInfo.get("SMART", []):
                    smartVersion.add(expModuleVersion)

    if len(emptyVersionList) > 0:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "version.of.exp.module.detail.empty",
                                                        (",".join(emptyVersionList), versionName))
        result["hasEmptyVersion"] = True
        return result

    if len(sasVersion) > 1:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "version.of.exp.module.on.disk.inconsistent", versionName)
        return result

    if len(nvmeVersion) > 1:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "version.of.exp.module.on.disk.inconsistent", versionName)
        return result

    if len(smartVersion) > 1:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "version.of.exp.module.on.disk.inconsistent", versionName)
        return result

    if len(expModuleHighDensityDiskVersionsSet) > 1:
        result["flag"] = False
        result["errMsg"], result["suggestion"] = getMsg(lang, "version.of.exp.module.on.high-density.inconsistent",
                                                        versionName)
        return result

    return result


def checkExpModuleSESVersions(context, checkTime=VERSIONS_CHECK_TIME_LIMIT):
    """检查级联模块SES版本是否一致

    :param context:
    :param checkTime:
    :return: 以字典形式返回结果
            flag:
                True: 检查通过
                False: 检查不通过
            errMsg: 错误消息
            suggestion: 修复建议
    """
    result = {"flag": True, "errMsg": "", "suggestion": ""}
    lang = contextUtil.getLang(context)
    cli = contextUtil.getCli(context)
    startTime = time.time()
    enclosureInfo = getDiskEnclosure(cli, lang)
    logger = getLogger(context.get("logger"), __file__)
    logger.logInfo("enclosureInfo:%s" % enclosureInfo)
    while (time.time() - startTime) < checkTime:

        cli = contextUtil.getCli(context)
        # 检查SES版本
        sesResult = getExpModuleVersions(cli, lang, "SES", enclosureInfo)

        # 检查CPLD版本
        logicResult = getExpModuleVersions(cli, lang, "Logic", enclosureInfo)

        # 刷新错误信息
        result = sesResult if not sesResult["flag"] else logicResult

        # 如果版本空继续查询
        if sesResult["hasEmptyVersion"] or logicResult["hasEmptyVersion"]:
            time.sleep(VERSIONS_CHECK_TIME_INTERVAl)
            context["curRemainTime"] -= VERSIONS_CHECK_TIME_INTERVAl
            setExpansionProgress(context, True)
            continue

        # 如果存在版本不一致，继续查询
        if not sesResult["flag"] or not logicResult["flag"]:
            time.sleep(VERSIONS_CHECK_TIME_INTERVAl)
            context["curRemainTime"] -= VERSIONS_CHECK_TIME_INTERVAl
            setExpansionProgress(context, True)
            continue
        else:
            # 版本都一致则退出
            return result

    return result


def checkClusterCtrlsNumWithDetail(context, cli, lang, requiredCtrlsNum, newEnclosureSN, traceType="11",
                                   timeOut=NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_LIMIT,
                                   maxTimeOut=NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_LIMIT,
                                   rollbackInfo={"rollback": False}):
    '''
    @summary: 检查新集群的控制器数量是否满足要求
    @param cli: cli对象
    @param lang: 语言lang
    @param requiredCtrlsNum: 新集群需要的控制器数量
    @param rollbackInfo: 原集群回退信息，包含是否回退标识
    @return: 以字典形式返回结果
        flag:
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag": True, "errMsg": "", "suggestion": "", "ret": ""}
    logger = getLogger(context.get("logger"), __file__)
    setExpStep(context, requiredCtrlsNum)
    startTime = time.clock()
    isCtrlsNumOK = False
    isTraceFailure = False
    stepFlowList = []
    # 用于界面展示的stepFlowList
    stepFlowShowList = []
    # 记录最后一次StepFlow的集合
    lastFailActionList = []
    # 记录最后一次Trace的状态集合
    lastTraceStatusList = []
    # 记录最后一次Run Cnt的结果集合
    lastTraceRunCntList = []
    failAction = "--"
    failInfo = "--"
    nodeResult = "--"
    resetTimeFlag = False

    # 防止参数传入错误导致误判，修正maxTimeOut值为传入timeout值的最大值
    maxTimeOut = max(timeOut, maxTimeOut)

    while True:
        elapsedTime = time.clock() - startTime
        if elapsedTime >= maxTimeOut:
            break
        if resetTimeFlag == False and (elapsedTime + TYPICAL_POWER_ON_DELTA_TIME_2U_3U) >= timeOut:
            deltaTime = maxTimeOut - timeOut
            # 重新设置当前剩余时间
            context["curRemainTime"] += deltaTime
            # 重新设置总剩余时间
            totalReaminTime = contextUtil.getItem(context, "totalReaminTime")
            totalReaminTime += deltaTime
            contextUtil.setItem(context, "totalReaminTime", totalReaminTime)
            # 设置进度
            setExpansionProgress(context, True)
            resetTimeFlag = True

        # 查询Node Recovery流程状态
        cmd = "show system trace_with_type trace_type=%s" % traceType
        checkRet = cliUtil.execCmdInDeveloperMode(cli, cmd, True, lang)
        cliRet = checkRet[1]
        logger.logInfo("system trace:%s" % str(cliRet))
        if "Current Trace".lower() not in cliRet.lower():
            # 未执行到具体Step时，不刷新流程信息
            cliRet = ""
        sysTraceList = cliRet.splitlines()

        # 将所有的Step涉及的Trace加入到stepFlowList
        stepFlowList = []

        traceStatusIdx = 0
        traceCntIdx = 0
        traceStatus = ""
        traceCnt = 0
        for i in xrange(0, len(sysTraceList)):
            sysTrace = sysTraceList[i].strip()
            firstWord = sysTrace.split("  ")[0].strip()
            # 获取Status
            if traceStatusIdx == 0 and str(firstWord).lower() == "status" and TOTAL_RUN_CNT in sysTrace:
                # Status的值在Status表头的第二行
                traceStatusIdx = i + 2
                traceCntIdx = sysTraceList[i].index(TOTAL_RUN_CNT)

            # 获取Step
            if firstWord.isdigit():
                stepFlow = sysTrace.split("  ")[-1]
                # Steplist中记录Step原始值，用于逻辑判断Step是否执行失败，原始值不可更改
                stepFlowList.append(stepFlow)

            # 获取Fail Action
            if "Fail Action".lower() in sysTrace.lower():
                failAction = sysTrace.replace("  ", "")
            # 获取Fail Information
            if "Fail Information".lower() in sysTrace.lower():
                failInfo = sysTrace.replace("  ", "")
            # 获取Node Result
            if "Node Result".lower() in sysTrace.lower():
                nodeResult = sysTrace.replace("  ", "")
        logger.logInfo("stepFlowList=%s" % str(stepFlowList))

        if traceStatusIdx < len(sysTraceList):
            line = sysTraceList[traceStatusIdx]
            traceStatus = line.strip().split("  ")[0]
            if traceCntIdx > 0:
                traceCnt = line[traceCntIdx:traceCntIdx + len(TOTAL_RUN_CNT)].strip()
                if traceCnt.isdigit() and traceCnt != "0":
                    traceCnt = int(traceCnt)
                    # 最后一次Run Cnt的结果记录到集合中
                    lastTraceRunCntList.append(traceCnt)
                    # 流程最后执行状态记录到集合中
                    lastTraceStatusList.append(traceStatus)
                    # Fail Action结果记录到集合中
                    lastFailActionList.append(failAction)

        logger.logInfo("lastTraceStatusList=%s" % str(lastTraceStatusList))
        logger.logInfo("lastFailActionList=%s" % str(lastFailActionList))
        logger.logInfo("lastTraceRunCntList=%s" % str(lastTraceRunCntList))

        # 上下文中写入最后一个进度的信息
        if len(stepFlowList) > 0:
            stepInfo = stepFlowList[-1].split(":")[0].strip()
            # 由于Step信息过于内部，将加工处理后的Step信息记录到stepFlowShowList
            stepFlowShowList.append(stepInfo)
            remindInfo = getRemindInfo(lang, "expansion.show.trace.notice.detail", (newEnclosureSN, stepInfo))
            # 提示信息相同时，增加后缀区分
            if len(stepFlowShowList) >= 2 and stepFlowShowList[-1] == stepFlowShowList[-2]:
                newStepInfo = "%s (%s)" % (stepInfo, str(getLastSameItemCnt(stepFlowShowList)))
                remindInfo = getRemindInfo(lang, "expansion.show.trace.notice.detail", (newEnclosureSN, newStepInfo))
            context["remindInfo"] = remindInfo
        logger.logInfo("stepFlowShowList=%s" % str(stepFlowShowList))

        # 如果10分钟内一直执行某个流程且该流程的状态为失败状态则认为该流程上电失败（备注：如果多引擎同时重启，需要修改此超时时间）
        waitCnt = SINGLE_STEP_FLOW_CHECK_TIME_LIMIT / NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl
        if traceStatus.lower() == "failure" and \
                len(lastTraceRunCntList) >= waitCnt and \
                len(lastTraceStatusList) >= waitCnt:
            if len(set(lastTraceRunCntList[-waitCnt:])) == 1 and \
                    len(set(lastTraceStatusList[-waitCnt:])) == 1:
                isTraceFailure = True

        # 查询控制器数量
        getControllerIdListRet = cliUtil.getControllerIdList(cli, lang)
        if not getControllerIdListRet[0]:
            return getSysAbnormalRet(getControllerIdListRet, lang)

        controllerIdList = getControllerIdListRet[1]
        result["ret"] = len(controllerIdList)

        if len(controllerIdList) < requiredCtrlsNum:

            # 原集群控制器数量
            rollbackInfo["orginCtrlNum"] = contextUtil.getItem(context, EXPANSION_ROLL_BACK_CTRL_NUM_ORIGIN)
            rollbackInfo["supportedCtrlNum"] = requiredCtrlsNum
            rollbackInfo["currentCtrlIDList"] = controllerIdList
            rollbackInfo["ruleList"] = getRuleList(contextUtil.getItem(context, "ctrlHeight"))

            rollbackRet = rollBack(context, rollbackInfo)
            # 下发回退命令成功
            if rollbackRet.get("needRollBack") == True:
                result["flag"] = False
                if rollbackRet.get("rollBackResult") == True:
                    result["errMsg"], result["suggestion"] = getMsg(lang, "expansion.rollback.success",
                                                                    len(controllerIdList))
                else:
                    result["errMsg"], result["suggestion"] = getMsg(lang, "expansion.rollback.failure")

                return result
            # 流程上电失败，提前退出
            if isTraceFailure:
                isCtrlsNumOK = False
                break
            else:
                baseUtil.safeSleep(NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl)
        else:
            isCtrlsNumOK = True
            break

    if not isCtrlsNumOK:
        result["flag"] = False
        if failAction.strip() == "--":
            result["errMsg"], result["suggestion"] = getMsg(lang, "expansion.failed.params.null", newEnclosureSN)
        else:
            result["errMsg"], result["suggestion"] = getMsg(lang, "expansion.failed",
                                                            (newEnclosureSN, failAction, failInfo, nodeResult))
    return result


def checkRollback(logger, rollbackInfo):
    logger.logInfo("Find Alarm, Check Expansion RollBack Param Start")
    try:
        rollback = rollbackInfo.get("rollback")
        if rollback != True:
            return False

        orginCtrlNum = rollbackInfo.get("orginCtrlNum")
        supportedCtrlNum = rollbackInfo.get("supportedCtrlNum")
        currentCtrlIDList = rollbackInfo.get("currentCtrlIDList", [])
        currentCtrlIDList.sort()

        ruleList = rollbackInfo.get("ruleList", [])
        if len(currentCtrlIDList) < 1 or currentCtrlIDList != ruleList[:len(currentCtrlIDList)]:
            return False

        rollbackNum = len(currentCtrlIDList)
        if int(orginCtrlNum) <= rollbackNum < int(supportedCtrlNum) and rollbackNum > 1 and rollbackNum % 2 == 0:
            return True
        return False
    except:
        logger.logInfo("Find Alarm, Check Expansion RollBack Param, Exception")
        return False


def getRuleList(height):
    if str(height) in ["2", "3"]:
        return EXPANSION_ROLL_BACK_RULELIST_2U3U
    elif str(height) in ["6"]:
        return EXPANSION_ROLL_BACK_RULELIST_6U


def rollBack(context, rollbackInfo):
    result = {"needRollBack": False, "rollBackResult": False}
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    logger = getLogger(context.get("logger"), __file__)

    sysDate = contextUtil.getItem(context, EXPANSION_ROLL_BACK_FROM_TIME)

    if not checkSysAlarmByIdWithErrCode(cli, lang, CHECK_CTRL_ISOLATED, NODE_ERR_CODE_SYNC_VERSION_FAIL, sysDate):
        return result

    result["needRollBack"] = True
    if not checkRollback(logger, rollbackInfo):
        result["rollBackResult"] = False
        return result

    context["remindInfo"] = getRes(lang, "expansion_rollback")
    try:
        currentCtrlIDList = rollbackInfo.get("currentCtrlIDList", [])
        logger.logInfo("Expansion RollBack Start")
        ret = cliUtil.rollbackExpansion(cli, lang, logger, len(currentCtrlIDList))
        logger.logInfo("Expansion RollBack End")
        result["rollBackResult"] = ret[0]
        return result
    except:
        result["rollBackResult"] = False
        return result


def checkClusterCtrlsNumWithDetailFor2TO4(context, cli, lang, newConfigCtrlNum, traceType="11",
                                          timeOut=NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_LIMIT,
                                          rollbackInfo={"rollback": False}):
    '''
    @summary: 检查新集群的控制器数量是否满足要求
    @param cli: cli对象
    @param lang: 语言lang
    @param requiredCtrlsNum: 新集群需要的控制器数量
    @param rollbackInfo: 原集群回退信息，包含是否回退标识
    @return: 以字典形式返回结果
        flag:
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag": True, "errMsg": "", "suggestion": "", "ret": ""}
    logger = getLogger(context.get("logger"), __file__)
    setExpStep(context, newConfigCtrlNum)
    startTime = time.clock()
    isCtrlsNumOK = False
    isTraceFailure = False
    stepFlowList = []
    # 用于界面展示的stepFlowList
    stepFlowShowList = []
    # 记录最后一次StepFlow的集合
    lastFailActionList = []
    # 记录最后一次Trace的状态集合
    lastTraceStatusList = []
    # 记录最后一次Run Cnt的结果集合
    lastTraceRunCntList = []
    failAction = "--"
    failInfo = "--"
    nodeResult = "--"

    while (time.clock() - startTime) < timeOut:
        # 查询Node Recovery流程状态
        cmd = "show system trace_with_type trace_type=%s" % traceType
        checkRet = cliUtil.execCmdInDeveloperModePrompt(cli, cmd, True, lang)
        cliRet = checkRet[1]
        logger.logInfo("system trace:%s" % str(cliRet))
        if "Current Trace".lower() not in cliRet.lower():
            # 未执行到具体Step时，不刷新流程信息
            cliRet = ""
        sysTraceList = cliRet.splitlines()

        # 将所有的Step涉及的Trace加入到stepFlowList
        stepFlowList = []

        traceStatusIdx = 0
        traceCntIdx = 0
        traceStatus = ""
        traceCnt = 0
        for i in xrange(0, len(sysTraceList)):
            sysTrace = sysTraceList[i].strip()
            firstWord = sysTrace.split("  ")[0].strip()
            # 获取Status
            if traceStatusIdx == 0 and str(firstWord).lower() == "status" and TOTAL_RUN_CNT in sysTrace:
                # Status的值在Status表头的第二行
                traceStatusIdx = i + 2
                traceCntIdx = sysTraceList[i].index(TOTAL_RUN_CNT)

            # 获取Step
            if firstWord.isdigit():
                stepFlow = sysTrace.split("  ")[-1]
                # Steplist中记录Step原始值，用于逻辑判断Step是否执行失败，原始值不可更改
                stepFlowList.append(stepFlow)

            # 获取Fail Action
            if "Fail Action".lower() in sysTrace.lower():
                failAction = sysTrace.replace("  ", "")
            # 获取Fail Information
            if "Fail Information".lower() in sysTrace.lower():
                failInfo = sysTrace.replace("  ", "")
            # 获取Node Result
            if "Node Result".lower() in sysTrace.lower():
                nodeResult = sysTrace.replace("  ", "")
        logger.logInfo("stepFlowList=%s" % str(stepFlowList))

        if traceStatusIdx < len(sysTraceList):
            line = sysTraceList[traceStatusIdx]
            traceStatus = line.strip().split("  ")[0]
            if traceCntIdx > 0:
                traceCnt = line[traceCntIdx:traceCntIdx + len(TOTAL_RUN_CNT)].strip()
                if traceCnt.isdigit() and traceCnt != "0":
                    traceCnt = int(traceCnt)
                    # 最后一次Run Cnt的结果记录到集合中
                    lastTraceRunCntList.append(traceCnt)
                    # 流程最后执行状态记录到集合中
                    lastTraceStatusList.append(traceStatus)
                    # Fail Action结果记录到集合中
                    lastFailActionList.append(failAction)

        logger.logInfo("lastTraceStatusList=%s" % str(lastTraceStatusList))
        logger.logInfo("lastFailActionList=%s" % str(lastFailActionList))
        logger.logInfo("lastTraceRunCntList=%s" % str(lastTraceRunCntList))

        # 上下文中写入最后一个进度的信息
        if len(stepFlowList) > 0:
            stepInfo = stepFlowList[-1].split(":")[0].strip()
            # 由于Step信息过于内部，将加工处理后的Step信息记录到stepFlowShowList
            stepFlowShowList.append(stepInfo)
            remindInfo = getRemindInfo(lang, "expansion.show.trace.notice", stepInfo)
            # 提示信息相同时，增加后缀区分
            if len(stepFlowShowList) >= 2 and stepFlowShowList[-1] == stepFlowShowList[-2]:
                newStepInfo = "%s (%s)" % (stepInfo, str(getLastSameItemCnt(stepFlowShowList)))
                remindInfo = getRemindInfo(lang, "expansion.show.trace.notice", newStepInfo)
            context["remindInfo"] = remindInfo
        logger.logInfo("stepFlowShowList=%s" % str(stepFlowShowList))

        # 如果10分钟内一直执行某个流程且该流程的状态为失败状态则认为该流程上电失败（备注：如果多引擎同时重启，需要修改此超时时间）
        waitCnt = SINGLE_STEP_FLOW_CHECK_TIME_LIMIT / NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl
        if traceStatus.lower() == "failure" and \
                len(lastTraceRunCntList) >= waitCnt and \
                len(lastTraceStatusList) >= waitCnt:
            if len(set(lastTraceRunCntList[-waitCnt:])) == 1 and \
                    len(set(lastTraceStatusList[-waitCnt:])) == 1:
                isTraceFailure = True

        # 查询控制器数量
        getControllerIdListRet = cliUtil.getControllerIdList(cli, lang)
        if not getControllerIdListRet[0]:
            return getSysAbnormalRet(getControllerIdListRet, lang)

        controllerIdList = getControllerIdListRet[1]
        result["ret"] = len(controllerIdList)
        if len(controllerIdList) != newConfigCtrlNum:
            # 原集群控制器数量
            rollbackInfo["orginCtrlNum"] = contextUtil.getItem(context, EXPANSION_ROLL_BACK_CTRL_NUM_ORIGIN)
            rollbackInfo["supportedCtrlNum"] = newConfigCtrlNum
            rollbackInfo["currentCtrlIDList"] = controllerIdList
            rollbackInfo["ruleList"] = getRuleList(contextUtil.getItem(context, "ctrlHeight"))

            rollbackRet = rollBack(context, rollbackInfo)
            # 下发回退命令成功
            if rollbackRet.get("needRollBack") == True:
                result["flag"] = False
                if rollbackRet.get("rollBackResult") == True:
                    result["errMsg"], result["suggestion"] = getMsg(lang, "expansion.rollback.success",
                                                                    len(controllerIdList))
                else:
                    result["errMsg"], result["suggestion"] = getMsg(lang, "expansion.rollback.failure")

                return result
            # 流程上电失败，提前退出
            if isTraceFailure:
                isCtrlsNumOK = False
                break
            else:
                for oneUpdate in \
                        range(NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_INTERVAl / NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE):
                    baseUtil.safeSleep(NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE)
                    context["curRemainTime"] -= NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_UPDATE
                    setExpansionProgress(context, True)
        else:
            logger.logInfo("Ctrl number is expected:%s" % str(newConfigCtrlNum))
            contextUtil.setItem(context, "ctrlNum", newConfigCtrlNum)
            isCtrlsNumOK = True
            break

    if not isCtrlsNumOK:
        result["flag"] = False
        if failAction.strip() == "--":
            result["errMsg"], result["suggestion"] = getMsg(lang,
                                                            "number.of.controllers.donot.meets.post.expansion.params.null")
        else:
            result["errMsg"], result["suggestion"] = getMsg(lang, "number.of.controllers.donot.meets.post.expansion",
                                                            (failAction, failInfo, nodeResult))
    return result


def getLastSameItemCnt(itemList):
    '''
    @summary: 在给定的集合中查找与最后一个元素相同的相邻元素个数
    @param itemList: 给定的集合
    @return: 相邻元素个数
    @example: 当给定的集合为["x","y","z","x","x","x"]时，返回3
    '''
    if itemList is None or len(itemList) == 0 or type(itemList) != list:
        return 0

    lastItem = itemList[-1]
    for idx, item in enumerate(reversed(itemList)):
        if item != lastItem:
            break
    return idx


def checkSystemStatus(cli, lang):
    '''
    @summary: 检查系统状态是否正常
    @param cli: cli对象
    @param lang: 语言lang
    @return: 以字典形式返回结果 
        flag: 
            True: 检查通过
            False: 检查不通过
        errMsg: 错误消息
        suggestion: 修复建议
    '''
    result = {"flag": True, "errMsg": "", "suggestion": ""}

    cmd = "show system general"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)

    if not checkRet[0]:
        return getSysAbnormalRet(checkRet, lang)

    cliRet = checkRet[1]
    lineList = cliRet.splitlines()
    for line in lineList:
        fields = line.split(":")
        if len(fields) < 2:
            continue

        fieldName = fields[0].strip()
        fieldValue = fields[1].strip()

        if fieldName == "Health Status" and fieldValue != STATUS_NORMAL:
            result["flag"] = False
            result["errMsg"], result["suggestion"] = getMsg(lang, "system.abnormal")
            return result

        elif fieldName == "Running Status" and fieldValue != STATUS_NORMAL:
            result["flag"] = False
            result["errMsg"], result["suggestion"] = getMsg(lang, "system.abnormal")
            return result

    return result


def getManPortIdList(cli, lang):
    '''
    @summary: 获取管理端口ID列表
    @param cli: cli对象
    @param lang: 语言lang
    @return: 以字典形式返回结果 
        flag: 
            True: 获取成功
            False: 获取失败
        errMsg: 错误消息
        suggestion: 修复建议
        ret: 管理端口ID列表
    '''
    result = {"flag": True, "errMsg": "", "suggestion": "", "ret": None}

    cmd = "show port general physical_type=ETH logic_type=Management_Port"
    checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)

    if not checkRet[0]:
        return getSysAbnormalRet(checkRet, lang)

    cliRet = checkRet[1]
    cliRetList = cliUtil.getHorizontalCliRet(cliRet)
    manPortIdList = []
    for lineDict in cliRetList:
        manPortIdList.append(lineDict["ID"])

    result["ret"] = manPortIdList
    return result


def getClusterNodes(enclosureSN, boardsList):
    '''
    @summary: 根据框SN获取该框上的节点数量
    @param enclosureSN: 框SN
    @param boardsList: 框和节点信息结合
    @return: 框上的所有节点数
    '''
    return len([board["enclosureSN"] for board in boardsList if board["enclosureSN"] == enclosureSN])


def getScaleOutCardSpecNum(expansionSpec):
    '''
    @summary: 获取需要ETH接口卡的数量
    @param expansionSpec: 扩容规格表
    @return: 根据扩容规格表，返回对应的需要的接口卡数量
    '''
    if expansionSpec is None:
        return 0
    return expansionSpec.get("scale_out_card_num", 0)


def getScaleOutPortsSpecNum(expansionSpec, clustMode):
    '''
    @summary: 获取每个控制器上需要的ETH端口数量
    @param expansionSpec: 扩容规格表
    @param clustMode: 组网类型
    '''
    cardSpecNum = getScaleOutCardSpecNum(expansionSpec)
    portsNum = 0

    # 直连组网每张卡上4个端口
    if clustMode == CLUST_TYPE_DIRECT:
        portsNum = 4
    # 交换机组网每张卡上2个端口
    elif clustMode == CLUST_TYPE_SWITCH:
        portsNum = 2

    return cardSpecNum * portsNum


def getExpansionSpecDict(ctrlNumber, productModel, fullProductVersion):
    """根据框高和控制器数量获取扩容规格字典

    :param ctrlNumber: 系统控制器数量
    :param productModel: 设备型号
    :param fullProductVersion: 设备完整版本号
    :return:
    """
    is_sup_switch = baseUtil.is_v5v6_support_switch(productModel,
                                                    fullProductVersion)
    from cbb.business.product.product_selector import get_product_adapter
    product_adapter = get_product_adapter()
    if product_adapter:
        product_adapter.get_logger().info(
            "use product adapter cal expansion spec.")
        return product_adapter.get_expansion_spec(ctrlNumber)

    config_dict = dict()
    if baseUtil.isArmDevV5New(productModel):
        config_dict["direct_only"] = config.EXPANSION_DICT_ARM_DIRECT_ONLY
        config_dict["switch_sup"] = config.EXPANSION_DICT_ARM_SWITCH_SUP
    else:
        config_dict["direct_only"] = config.EXPANSION_DICT_DORADO_DIRECT_ONLY
        config_dict["switch_sup"] = config.EXPANSION_DICT_DORADO_SWITCH_SUP
    return getExpansionDict(productModel, ctrlNumber, is_sup_switch,
                            config_dict)


def getExpansionDict(productModel, ctrlNumber, is_sup_switch, config_dict):
    """根据设备型号和控制器数量获取扩容规格字典

    :param productModel: 产品型号
    :param ctrlNumber: 当前控制器数量
    :param is_sup_switch: 是否支持交换机
    :param config_dict: 配置字典
    :return:
    """
    config_only_direct = config_dict.get("direct_only", {})
    config_switch_sup = config_dict.get("switch_sup", {})
    if productModel.upper() in config_switch_sup and is_sup_switch:
        expansionSpecDict = config_switch_sup
    else:
        expansionSpecDict = config_only_direct
    productExpInfo = expansionSpecDict.get(productModel.upper(), None)
    if productExpInfo is not None:
        key = "%sC" % ctrlNumber
        return productExpInfo.get(key, None)
    return None


def getExpansionCtrlsSpec(expansionSpec):
    '''
    @summary: 根据扩容规格表，获取支持扩容的控制器数量集合
    @param expansionSpec: 扩容规格表
    @return: 支持扩容的控制器数量集合
    '''
    if expansionSpec is None:
        return []
    return expansionSpec.get("supports_expansion_ctrls", [])


def getDefaultNetworkType(expansionSpecDict):
    '''
    @summary: 获取默认的组网类型（2控扩4控场景，默认组网类型为直连组网）
    @param expansionSpecDict:
    @return: 默认的组网类型
    '''
    keys = expansionSpecDict.keys()
    # 第一优先：无组网
    if CLUST_TYPE_NONE in keys:
        return CLUST_TYPE_NONE
    # 第二优先：直连组网
    if CLUST_TYPE_DIRECT in keys:
        return CLUST_TYPE_DIRECT
    return keys[0]


def getExpansionEnclosuresList(scanEnclosuresResult, lang):
    '''
    @summary: 根据用户选择的需要扩容的框SN列表返回所有需要扩容的框SN集合
    @param scanEnclosuresResult: 用户选择的需要扩容的框SN列表
    @return: 所有需要扩容的框SN集合
    '''
    scanEnclosuresList = jsonArray2DictList(scanEnclosuresResult)
    if scanEnclosuresList is None:
        return []
    beExpansionEnclosuresList = []
    for scanEnclosures in scanEnclosuresList:
        if scanEnclosures.get("beExpansion", "") == getRes(lang, "yes") or scanEnclosures.get("_self_marked",
                                                                                              "") == "true":
            beExpansionEnclosuresList.append(scanEnclosures["enclosureSN"])
    return beExpansionEnclosuresList


def getToBeMovedSasCardList(tobeMoveSasCardListResult, lang):
    '''
    @summary: 根据用户选择的需要扩容的框SN列表返回所有需要扩容的框SN集合
    @param tobeMoveSasCardListResult: 用户选择的需要扩容的框SN列表
    @return: 所有需要扩容的框SN集合
    '''
    sasCardList = jsonArray2DictList(tobeMoveSasCardListResult)
    if sasCardList is None:
        return []
    toBeMoveSasCardInfoList = []

    for sasCardInfo in sasCardList:
        if sasCardInfo["isToBeMoved"] == getRes(lang, "yes"):
            toBeMoveSasCardInfoList.append(
                (sasCardInfo.get("engineNum", ""),
                 sasCardInfo.get('sasCardCurLoc', ''),
                 sasCardInfo.get("sasCardDstLoc", "")))
    return toBeMoveSasCardInfoList


def getNewBoardsList(beExpansionEnclosuresList, newExpansionBoardsList):
    '''
    @summary: 根据所有需要扩容的框SN集合返回所有需要扩容的节点信息
    @param beExpansionEnclosuresList: 所有需要扩容的框SN集合
    @return: 所有需要扩容的节点信息
    '''
    return [board for board in newExpansionBoardsList if board["enclosureSN"] in beExpansionEnclosuresList]


def getEnclosureNodes(enclosureSN, boardsList):
    '''
    @summary: 根据框SN获取该框下所有控制器的个数
    @param enclosureSN: 框SN
    @param boardsList: 节点列表
    @return: 获取该框下所有控制器的个数
    '''
    return len([board for board in boardsList if board["enclosureSN"] == enclosureSN])


def getNewEnclosuresList(newBoardsList):
    '''
    @summary: 获取所有的待扩容节点的框SN列表
    @param newBoardsList: 待扩容节点信息集合
    @return: 扩容节点的框SN列表
    '''
    newEnclosuresList = []
    for board in newBoardsList:
        enclosureSN = board["enclosureSN"]
        if enclosureSN not in newEnclosuresList:
            newEnclosuresList.append(enclosureSN)
    return newEnclosuresList


def isIntfModuleRunModeOK(runMode, enclosureSN, originEnclosureSNs):
    '''
    @summary: 检查接口卡工作模式是否正确。原集群必须为集群模式，待扩容控制器必须为集群模式或以太模式
    @param runMode: 接口卡工作模式
    @param enclosureSN: 接口卡对应的框SN
    @param originEnclosureSNs: 原集群所有框列表
    @return: 
        True: 接口卡工作模式正确
        False: 接口卡工作模式错误
    '''
    # 原集群场景
    if enclosureSN in originEnclosureSNs:
        if runMode in [INTF_RUNMODEL_CLUSTER]:
            return True
    # 待扩容控制器场景
    else:
        if runMode in [INTF_RUNMODEL_CLUSTER, INTF_RUNMODEL_ETH]:
            return True

    return False


def cmpBoard(board1, board2):
    '''
    @summary: 节点字典比较
    @param board1: 节点字典1
    @param board2: 节点字典2
    @return: 根据框SN和控制器ID进行比较的结果
    '''
    if board1["enclosureSN"] < board2["enclosureSN"]:
        return -1
    elif board1["enclosureSN"] > board2["enclosureSN"]:
        return 1
    if board1["controllerID"] < board2["controllerID"]:
        return -1
    elif board1["controllerID"] > board2["controllerID"]:
        return 1
    return 0


def cmpIPAlarmDict(board1, board2):
    '''
    @summary: 节点字典比较
    @param board1: 节点字典1
    @param board2: 节点字典2
    @return: 根据框SN和控制器ID进行比较的结果
    '''
    if board1["portLocation"] < board2["portLocation"]:
        return -1
    elif board1["portLocation"] > board2["portLocation"]:
        return 1
    if isIpV4(board1["portIp"]):
        return -1
    else:
        return 1
    return 0


def cmpPortDict(portDict1, portDict2):
    '''
    @summary: 端口字典比较
    @param portDict1: 端口字典1
    @param portDict2: 端口字典2
    @return: 根据bayid和location进行比较的结果
    '''
    if portDict1["bayid"] < portDict2["bayid"]:
        return -1
    elif portDict1["bayid"] > portDict2["bayid"]:
        return 1
    if portDict1["location"] < portDict2["location"]:
        return -1
    elif portDict1["location"] > portDict2["location"]:
        return 1
    return 0


def getDswID(portLocation, clustType):
    '''
    @summary: 根据端口location和组网类型，获取端口对应的交换机编号
    @param portLocation: 端口location
    @param clustType: 组网类型
    @return: 端口对应的交换机编号
    '''
    if clustType == CLUST_TYPE_SWITCH:
        if portLocation.endswith("P0"):
            return 0
        elif portLocation.endswith("P1"):
            return 1
    return -1


def getPortSlot(portInfo):
    '''
    @summary: 根据端口信息，获取该端口的槽位号
    @param portInfo: 端口信息
    @return: 端口的槽位号
    '''
    return portInfo["location"].split(".")[-1]


def generateNewBayId(bayIds):
    '''
    @summary: 根据柜id列表，自动给待扩集群生成新的柜id
    @param bayIds: 柜id列表
    '''
    bayIdNumList = []
    for bayid in bayIds:
        if str(bayid).isdigit():
            bayIdNumList.append(int(bayid))
    return max(bayIdNumList) + 1


def generateNewPortLocation(location, bayId):
    '''
    @summary: 根据柜id和端口location，自动给待扩集群生成新的端口location
    @param location: 端口location
    @param bayIds: 柜id
    '''
    locationParts = location.split(".")
    engLocation = locationParts[0]
    newEngLocation = "%s%s" % (engLocation[0:-1], bayId)
    slotLocation = location[len(engLocation):]
    return "%s%s" % (newEngLocation, slotLocation)


def dictList2JsonArray(portsInfoList):
    '''
    @summary: 将字典的集合转换为json数组
    @param portsInfoList: 端口的字典列表集合
    @return: 端口信息对应的json数组
    '''
    jsonArray = []
    for portsInfoDict in portsInfoList:
        jsonArray.append(
            "{%s}" % ",".join(['"%s":"%s"' % (key, portsInfoDict.get(key)) for key in portsInfoDict.keys()]))
    return "[%s]" % ",".join(jsonArray)


def jsonArray2DictList(jsonArray):
    '''
    @summary: 将json数组转换为字典的集合
    @param jsonArray: json数组
    @return: json数组对应的字典的集合
    '''
    if jsonArray is None or len(jsonArray) <= 2:
        return None
    jsonArray = jsonArray[1:-1]
    resultDictList = []
    for items in jsonArray.split("},{"):
        resultDict = {}
        for item in items.split("\",\""):
            kv = item.replace("{", "").replace("}", "").replace("\"", "").split(":")
            if len(kv) != 2:
                return resultDictList
            resultDict[kv[0]] = kv[1]
        if len(resultDict.keys()) > 0:
            resultDictList.append(resultDict.copy())

    return resultDictList


def getVRCVersion(version):
    '''
    @summary: 获取产品的C版本信息
    @param version: 产品版本
    @return: 产品C版本
    '''
    if len(version) <= 11:
        return version
    else:
        return version[0:11]


def getSPCVersion(version):
    '''
    @summary: 获取产品的SPC版本信息
    @param version: 产品版本
    @return: 产品SPC版本
    '''
    return version[0:17]


def isScaleOutExpansioned(configBaseIpAddr):
    '''
    @summary: 判断当前集群是否已经进行过ScaleOut扩容
    @param configBaseIpAddr: 配置文件中基地址IP
    @return: 
        True: 当前集群已经进行过ScaleOut扩容
        False: 当前集群未进行过ScaleOut扩容
    '''
    if len(configBaseIpAddr) != 0 and configBaseIpAddr != "0.0.0.0":
        return True
    return False


def isPureDigit(digitStr):
    '''
    @summary: 判断字符串是否为数字（如果字符串以0开头，不认为是数字）
    '''
    if not digitStr.isdigit():
        return False

    if len(digitStr) != len(str(int(digitStr))):
        return False

    return True


def getIpVer(accessIP):
    '''
    @summary: 获取IP地址版本号
    @param baseIpAddr: IP
    @return: 
        v4: IPv4地址
        v6: IPv6地址
    '''
    if ":" in accessIP:
        return IPV6
    return IPV4


def isIpV4(ip):
    '''
    @summary: 检测IP地址是否为通用的IPv4地址
    '''
    return regSearch(IPV4_REGEX_DEFINE, ip)


def isIpV6(ip):
    '''
    @summary: 检测IP地址是否为通用的IPv6地址
    '''
    return regSearch(IPV6_REGEX_DEFINE, ip)


def isIllegalBaseIpAddr(baseIpAddr):
    '''
    @summary: 校验基地址IP是否合法
    @param baseIpAddr: 基地址IP
    @return: 
        True: 基地址IP合法
        False: 基地址IP不合法
    '''
    addrs = baseIpAddr.split(".")
    if len(addrs) != 4:
        return False

    baseIpAddrs = []
    for ipSeg in addrs:
        if not isPureDigit(ipSeg):
            return False
        baseIpAddrs.append(int(ipSeg))

    if not (baseIpAddr.startswith("172.17.") or baseIpAddr.startswith("10.253.")):
        return False
    if not baseIpAddr.endswith(".1"):
        return False
    if baseIpAddrs[2] < config.BASE_IP_RANGE_BEGIN or baseIpAddrs[2] > config.BASE_IP_RANGE_END:
        return False

    return True


def isIllegalManIpAddr(manIpAddr, ipVer):
    '''
    @summary: 校验管理IP地址是否合法（要求为合法的主机IP地址）
    @param manIpAddr: 管理IP
    @return: 
        True: 管理IP合法
        False: 管理IP不合法
    '''
    if ipVer is None:
        # IPv4地址
        if not ":" in manIpAddr:
            return isIllegalManIpv4Addr(manIpAddr)
        # 考虑IPv6地址有兼容IPv4的情况
        return isIllegalManIpv4Addr(manIpAddr) or isIllegalManIpv6Addr(manIpAddr)

    if ipVer == IPV4:
        return isIllegalManIpv4Addr(manIpAddr)

    if ipVer == IPV6:
        return isIllegalManIpv6Addr(manIpAddr)

    return False


def isConfigSameManIpAddr(manIpAddr, inputManIPList):
    if len(inputManIPList) == 0:
        inputManIPList.append(manIpAddr)
        return True
    for manIp in inputManIPList:
        if manIpAddr == manIp:
            return False
    return True


def isIllegalManIpv4Addr(manIpAddr):
    '''
    @summary: 校验管理IP地址是否为合法的IPv4地址
    @param manIpAddr: 管理IP
    @return: 
        True: 合法的IPv4地址
        False: 不合法的IPv4地址
    '''
    if not isIpV4(manIpAddr):
        return False

    addrs = manIpAddr.split(".")

    if int(addrs[0]) == 0:
        return False

    return True


def isIllegalManIpv6Addr(manIpAddr):
    '''
    @summary: 校验管理IP地址是否为合法的IPv6地址
    @param manIpAddr: 管理IP
    @return: 
        True: 合法的IPv6地址
        False: 不合法的IPv6地址
    '''
    return isIpV6(manIpAddr)


def isIllegalMask(mask, ipVer):
    '''
    @summary: 校验IPV4子网掩码/IPV6前缀是否合法
    @param mask: 子网掩码/前缀
    @return: 
        True: 子网掩码/前缀合法
        False: 子网掩码/前缀不合法
    '''
    if ipVer is None:
        return isIllegalSubnetMask(mask) or isIllegalPrefix(mask)

    if ipVer == IPV4:
        return isIllegalSubnetMask(mask)

    if ipVer == IPV6:
        return isIllegalPrefix(mask)

    return False


def isIllegalSubnetMask(mask):
    '''
    @summary: 校验IPV4子网掩码是否合法
    @param mask: IPV4子网掩码
    @return: 
        True: IPV4子网掩码合法
        False: IPV4子网掩码不合法
    '''
    if not isIpV4(mask):
        return False

    addrs = mask.split(".")

    if int(addrs[0]) == 0:
        return False

    return True


def isIllegalPrefix(mask):
    '''
    @summary: 校验IPV6前缀是否合法
    @param mask: IPV6前缀
    @return: 
        True: IPV6前缀合法
        False: IPV6前缀不合法
    '''
    if not isPureDigit(mask):
        return False

    if 0 <= int(mask) <= 128:
        return True
    else:
        return False


def isIllegalGateway(gateway, ipVer):
    '''
    @summary: 校验IPV4网关地址/IPV6网关地址是否合法
    @param mask: 网关地址
    @return: 
        True: 网关地址
        False: 网关地址
    '''
    if ipVer is None:
        return isIllegalIPv4Gateway(gateway) or isIllegalIPv6Gateway(gateway)

    if ipVer == IPV4:
        return isIllegalIPv4Gateway(gateway)

    if ipVer == IPV6:
        return isIllegalIPv6Gateway(gateway)

    return False


def isIllegalIPv4Gateway(gateway):
    '''
    @summary: 校验IPv4网关地址是否合法
    @param mask: IPv4网关地址
    @return: 
        True: IPv4网关地址合法
        False: IPv4网关地址不合法
    '''
    return isIpV4(gateway)


def isIllegalIPv6Gateway(gateway):
    '''
    @summary: 校验IPv6网关地址是否合法
    @param mask: IPv6网关地址
    @return: 
        True: IPv6网关地址合法
        False: IPv6网关地址不合法
    '''
    return isIpV6(gateway)


def getNodeBayId(enclosureSNbayIdDict, board, boardList):
    '''
    @summary: 获取对应节点的柜ID
    @param enclosureSNbayIdDict: 键为柜ID，值为框SN的字典
    @param board: 含有键为框SN和控制器ID的单个节点
    @param boardList: 含有键为框SN和控制器ID的所有节点集合
    @return 对应节点的柜ID
    '''
    boadNum = 0
    for x in boardList:
        if x["enclosureSN"] == board["enclosureSN"]:
            boadNum += 1

    newBayIDs = enclosureSNbayIdDict.get(board["enclosureSN"])
    bayIdList = list(set(newBayIDs))
    bayIdList.sort()

    controllerID = board["controllerID"]
    step = boadNum / len(bayIdList)
    newBayID = bayIdList[controllerID / step]
    return newBayID


def getClustType(newConfigClustType):
    '''
    @summary: 将界面配置的组网类型，转换为配置文件中对应的组网类型
        "direct": 直连组网，配置文件中值为0
        "switch": 交换机组网，配置文件中值为1
    @param newConfigClustType: 界面配置的组网类型
    @return: 配置文件中对应的组网类型
    '''
    clustType = -1
    if newConfigClustType == CLUST_TYPE_DIRECT:
        clustType = 0
    elif newConfigClustType == CLUST_TYPE_SWITCH:
        clustType = 1
    return clustType


def getManIP(manIpList, eng, slot):
    '''
    @summary: 根据柜ID和管理口槽位号，从界面配置的管理IP列表中获取对应的管理IP
    @param manIpList: 界面配置的管理IP列表
    @param eng: 引擎号
    @param slot: 管理口槽位号
    '''
    for manIpDict in manIpList:
        if manIpDict["bayid"] == int(eng) and manIpDict["slot"] == slot:
            return manIpDict["manIp"]
    return ""


def getMask(manIpList, eng, slot):
    '''
    @summary: 根据柜ID和管理口槽位号，从界面配置的管理IP列表中获取对应的子网掩码
    @param manIpList: 界面配置的管理IP列表
    @param eng: 引擎号
    @param slot: 管理口槽位号
    '''
    for manIpDict in manIpList:
        if manIpDict["bayid"] == int(eng) and manIpDict["slot"] == slot:
            return manIpDict["mask"]
    return ""


def getGateway(manIpList, eng, slot):
    '''
    @summary: 根据柜ID和管理口槽位号，从界面配置的管理IP列表中获取对应的网关
    @param manIpList: 界面配置的管理IP列表
    @param eng: 引擎号
    @param slot: 管理口槽位号
    '''
    for manIpDict in manIpList:
        if manIpDict["bayid"] == int(eng) and manIpDict["slot"] == slot:
            return manIpDict["gateway"]
    return ""


def getManIpGateWay(ipAddr):
    '''
    @summary: 获取管理IP的网关
    @param ipAddr: 管理IP地址
    @return: 管理IP的网关
    '''
    ipAddrs = ipAddr.split(".")
    gateWays = ipAddrs[0:-2]
    gateWays.append("0")
    gateWays.append("1")
    return ".".join(gateWays)


def setExpansionProgress(context, showRemain=True):
    '''
    @summary: 根据剩余时间设置扩容进度
    @param context: 上下文对象
    '''
    currentRemainTime = context["curRemainTime"] if context["curRemainTime"] > 0 else 0
    if showRemain == True:
        context["remainTime"] = int(currentRemainTime)
    totalReaminTime = contextUtil.getItem(context, "totalReaminTime")
    if currentRemainTime is None or totalReaminTime is None:
        return

    context["curProgressPer"] = int(100.0 * (totalReaminTime - currentRemainTime) / totalReaminTime)
    return


def modifyManIP(cli, lang, manIpDictList, ipVer):
    '''
    @summary: 修改待扩容引擎管理IP
    @param cli: cli对象
    @param lang: 语言lang
    @param manIpDictList: 管理IP字典集合
    @return: 
        flag: 
            True: cli执行成功
            False: cli执行失败
        errMsg: 错误消息
        suggesiton: 修复建议
        ret: cli回显
    '''

    resultDict = {"flag": True, "errMsg": "", "suggestion": "", "ret": ""}
    flag = True
    cliRet = ""
    manPortId = ""
    for manIpDict in manIpDictList:
        manPortId = manIpDict["eth_port_id"]

        cmd = "--"
        if ipVer == IPV4:
            if manIpDict["gateway"] is not None and manIpDict["gateway"] != "":
                cmd = "change system management_ip eth_port_id=%s ip_type=ipv4_address ipv4_address=%s mask=%s gateway_ipv4=%s" % \
                      (manPortId, manIpDict["address"], manIpDict["mask"], manIpDict["gateway"])
            else:
                cmd = "change system management_ip eth_port_id=%s ip_type=ipv4_address ipv4_address=%s mask=%s delete_gateway=yes" % \
                      (manPortId, manIpDict["address"], manIpDict["mask"])
        elif ipVer == IPV6:
            if manIpDict["gateway"] is not None and manIpDict["gateway"] != "":
                cmd = "change system management_ip eth_port_id=%s ip_type=ipv6_address ipv6_address=%s prefix_length=%s gateway_ipv6=%s" % \
                      (manPortId, manIpDict["address"], manIpDict["mask"], manIpDict["gateway"])
            else:
                cmd = "change system management_ip eth_port_id=%s ip_type=ipv6_address ipv6_address=%s prefix_length=%s delete_gateway=yes" % \
                      (manPortId, manIpDict["address"], manIpDict["mask"])
        checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            flag = False
            break

        cnt = 0
        while ("y/n" in checkRet[1] and cnt < 3):
            cmd = "y"
            checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
            cliRet += checkRet[1]
            if checkRet[0] != True:
                flag = False
                break
            cnt += 1

        if not cliUtil.queryResultWithNoRecord(checkRet[1]):
            flag = False
            break

    if flag:
        resultDict["ret"] = cliRet
        return resultDict
    else:
        errMsg, suggestion = getMsg(lang, "config.man.ip.failure", manPortId)
        resultDict = {"flag": False, "errMsg": errMsg, "suggestion": suggestion, "ret": cliRet}
        return resultDict


def modifyManIPSingle(cli, lang, manIpDictList, ipVer):
    '''
    @summary: 修改待扩容引擎管理IP
    @param cli: cli对象
    @param lang: 语言lang
    @param manIpDictList: 管理IP字典集合
    @return: 
        flag: 
            True: cli执行成功
            False: cli执行失败
        errMsg: 错误消息
        suggesiton: 修复建议
        ret: cli回显
    '''
    isOpened = False
    try:
        errMsg, suggestion = getMsg(lang, "command.execute.failure")
        resultDict = {"flag": False, "errMsg": errMsg, "suggestion": suggestion, "ret": ""}
        flag = True
        cliRet = ""
        manPortId = ""
        isOpened, checkRet = cliUtil.needOpenDeveloperSwitch(cli, lang)

        if isOpened == True:
            checkRet = cliUtil.openDeveloperSwitch(cli, lang)
            if checkRet[0] != True:
                return resultDict

        enterDeveloperCheckRet = cliUtil.enterDeveloperMode(cli, lang)
        if not enterDeveloperCheckRet[0]:
            cliUtil.developerMode2CliMode(cli)
            return resultDict

        for manIpDict in manIpDictList:
            manPortId = manIpDict["eth_port_id"]
            cmd = "--"
            if ipVer == IPV4:
                if manIpDict["gateway"] is not None and manIpDict["gateway"] != "":
                    cmd = "change system management_ip eth_port_id=%s ip_type=ipv4_address ipv4_address=%s mask=%s gateway_ipv4=%s" % \
                          (manPortId, manIpDict["address"], manIpDict["mask"], manIpDict["gateway"])
                else:
                    cmd = "change system management_ip eth_port_id=%s ip_type=ipv4_address ipv4_address=%s mask=%s" % \
                          (manPortId, manIpDict["address"], manIpDict["mask"])
            elif ipVer == IPV6:
                if manIpDict["gateway"] is not None and manIpDict["gateway"] != "":
                    cmd = "change system management_ip eth_port_id=%s ip_type=ipv6_address ipv6_address=%s prefix_length=%s gateway_ipv6=%s" % \
                          (manPortId, manIpDict["address"], manIpDict["mask"], manIpDict["gateway"])
                else:
                    cmd = "change system management_ip eth_port_id=%s ip_type=ipv6_address ipv6_address=%s prefix_length=%s" % \
                          (manPortId, manIpDict["address"], manIpDict["mask"])
            checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
            cliRet += checkRet[1]
            if checkRet[0] != True:
                flag = False
                break
            cnt = 0
            while ("y/n" in checkRet[1] and cnt < 3):
                cmd = "y"
                checkRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
                cliRet += checkRet[1]
                if checkRet[0] != True:
                    flag = False
                    break
                cnt += 1
            if not cliUtil.queryResultWithNoRecord(checkRet[1]):
                flag = False
                break

        cliUtil.developerMode2CliMode(cli)

        if flag:
            resultDict = {"flag": True, "errMsg": "", "suggestion": "", "ret": cliRet}
            return resultDict
        else:
            errMsg, suggestion = getMsg(lang, "config.man.ip.failure", manPortId)
            resultDict = {"flag": False, "errMsg": errMsg, "suggestion": suggestion, "ret": cliRet}
            return resultDict
    finally:
        # 关闭开关
        if isOpened == True:
            cliUtil.closeDeveloperSwitch(cli, lang)


def is6U2C(controllerNum, ctrlEnclosureHeight):
    '''
    @summary: 判断是否是6U2C
    '''
    if ctrlEnclosureHeight == 6 and controllerNum <= 2:
        return True
    else:
        return False


def is2U1C(controllerNum, ctrlEnclosureHeight):
    '''
    @summary: 判断是否是2U1C
    '''
    if ctrlEnclosureHeight == 2 and controllerNum == 1:
        return True
    else:
        return False


def is6U2CTo4C(controllerNum, ctrlEnclosureHeight, newConfigCtrlNum):
    '''
    @summary: 判断是否是6U2C扩容至4C
    '''
    if ctrlEnclosureHeight == 6 and controllerNum <= 2 and newConfigCtrlNum == 4:
        return True
    else:
        return False


def is6U2CTo6C(controllerNum, ctrlEnclosureHeight, newConfigCtrlNum):
    '''
    @summary: 判断是否是6U2C扩容至6C
    '''
    if ctrlEnclosureHeight == 6 and controllerNum <= 2 and newConfigCtrlNum == 6:
        return True
    else:
        return False


def is6U2CTo8C(controllerNum, ctrlEnclosureHeight, newConfigCtrlNum):
    '''
    @summary: 判断是否是6U2C扩容至8C
    '''
    if ctrlEnclosureHeight == 6 and controllerNum <= 2 and newConfigCtrlNum == 8:
        return True
    else:
        return False


def is6U6CTo8C(controllerNum, ctrlEnclosureHeight, newConfigCtrlNum):
    '''
    @summary: 判断是否是6U6C扩容至8C
    '''
    if ctrlEnclosureHeight == 6 and 5 <= controllerNum <= 6 and newConfigCtrlNum == 8:
        return True
    else:
        return False


def isSingleExpansion(productModel, controllerNum, ctrlEnclosureHeight):
    '''
    @summary: 判断是否是单扩扩容至双控场景
    '''
    if is2800V3(productModel) and is2U1C(controllerNum, ctrlEnclosureHeight):
        return True
    return False


def isHybridExpansion(controllerNum, ctrlEnclosureHeight):
    '''
    @summary: 6UM控扩容至N控的混合场景（M为偶数但不为4的倍数）为混合扩容场景
    '''
    if ctrlEnclosureHeight == 6 and controllerNum % 2 == 0 and controllerNum % 4 != 0:
        return True
    return False


def isDorado(productModel):
    '''
    @summary: 判断是否是Dorado,二级存储，新融合
    '''
    if "DORADO" in productModel.upper() or \
            productModel in (OCEAN_PROTECT + NEW_DORADO + OCEAN_STOR_COMPUTING_DEVS + OCEAN_STOR_MICRO_DEVS):
        return True
    return False


def isDorado18000(productModel):
    """判断是否是Dorado18000 V3产品型号.

    :param productModel:产品型号
    :return:
    """
    if "DORADO 18000" in productModel.upper():
        return True
    return False


def isDorado8000(productModel):
    """判断是否是Dorado8000 V3产品型号.

    :param productModel:产品型号
    :return:
    """
    if "DORADO 8000" in productModel.upper():
        return True
    return False


def isDorado5000SAS(productModel, encModel):
    """判断是否是Dorado5000 SAS V3产品型号.

    :param productModel:产品型号
    :return:
    """
    if "DORADO5000" in productModel.upper() and not isNVMeDev(encModel):
        return True
    return False


def is2800V3(productModel):
    '''
    @summary: 判断是否是2800V3
    '''
    if productModel.upper() in config.PDT_MODEL_2800V3:
        return True
    return False


def isArmProduct(productModel):
    '''
    @summary: 判断是否为ARM产品
    '''
    if productModel.upper() in config.PDT_MODEL_ARM:
        return True
    return False


def is18000V3(productModel):
    '''
    @summary: 判断是否是18000V3
    '''
    if productModel.upper() in config.SUPPORT_PDT_MODEL_18000:
        return True
    return False


def needConfigNewManIP(controllerNum, ctrlHeight, newConfigCtrlNum):
    '''
    @summary: 判断是否需要配置新引擎管理IP
    '''
    if (ctrlHeight == 2 or ctrlHeight == 3) and controllerNum <= 2:
        return True
    if ctrlHeight == 6 and controllerNum <= 4 and newConfigCtrlNum >= 6:
        return True
    return False


def needCheckSmartIOIpScaleout(originEnclosureRec, ctrlEnclosureHeight, newConfigCtrlNum, newConfigClustType,
                               controllerNum):
    '''
    @summary: 判断是否需要SmartIO接口卡检查项
    '''
    if newConfigClustType == CLUST_TYPE_NONE:
        return False
    if len(originEnclosureRec) != 1:
        return False

    if (ctrlEnclosureHeight == 6 and newConfigCtrlNum > 4 and controllerNum == 2):
        return False

    return True


def needConfigSwitch(newConfigClustType, configClustType):
    '''
    @summary: 判断是否需要配置交换机
    '''
    if newConfigClustType == CLUST_TYPE_SWITCH and configClustType != getClustType(newConfigClustType):
        return True
    return False


def getDefaultNetWorkingType(context):
    '''
    @summary: 获取默认的组网配置
    '''

    lang = contextUtil.getLang(context)
    logger = getLogger(context.get("logger"), __file__)
    expansionSpecDict = contextUtil.getItem(context, "expansionSpecDict")

    logger.logInfo("expansionSpecDict is = " + str(expansionSpecDict))
    # 获取默认组网配置
    defaultKey = getDefaultNetworkType(expansionSpecDict)
    defaultNetWorkType = ""
    netWorkTypes = []
    for key in expansionSpecDict.keys():
        netWorkingType = ""
        if key == CLUST_TYPE_NONE:
            netWorkingType = getRes(lang, "none")
        elif key == CLUST_TYPE_DIRECT:
            netWorkingType = getRes(lang, "direct")
        elif key == CLUST_TYPE_SWITCH:
            netWorkingType = getRes(lang, "switch")
        netWorkTypes.append(netWorkingType)

        if key == defaultKey:
            defaultNetWorkType = netWorkingType

    return {"rule": "##".join(netWorkTypes), "default": defaultNetWorkType}


def getDefaultNetWorkingSpec(context):
    '''
    @summary: 获取默认的扩容规格
    '''

    expansionSpecDict = contextUtil.getItem(context, "expansionSpecDict")
    defaultKey = getDefaultNetworkType(expansionSpecDict)
    expansionSpec = expansionSpecDict.get(defaultKey)
    expansionCtrls = getExpansionCtrlsSpec(expansionSpec)

    lang = contextUtil.getLang(context)
    ctrlNum = contextUtil.getItem(context, "ctrlNum")

    msg = getRes(lang, "controller")
    expansionCtrls = ["%s %s" % (str(num), msg) for num in expansionCtrls if num > ctrlNum]
    return {"rule": "##".join(expansionCtrls), "default": expansionCtrls[0]}


def getDefaultBaseConfigIp(context):
    backupConfigBaseIpAddr = contextUtil.getItem(context, "backupConfigBaseIpAddr")
    if isScaleOutExpansioned(backupConfigBaseIpAddr):
        return None
    return {"rule": "##".join(config.CHOOSE_INNER_IP), "default": config.DEFAULT_INNER_IP}


def isNeedCofigIP(ctrlNum, newCtrlNum, encHeight):
    '''
    :param ctrlNum:
    :param newCtrlNum:
    :param encHeight:
    :return: 需要配置内部IP返回True
    '''
    if encHeight == 6:
        return (ctrlNum, newCtrlNum) not in config.NONEED_BASEIP_NEWWORK
    else:
        if ctrlNum == 2:
            return True
    return False


def popupSelectExpansionDialog(context):
    '''
    @summary: 选择扩容场景窗口
    '''
    logger = getLogger(context.get("logger"), __file__)
    logger.logInfo("popupSelectExpansionDialog start")

    lang = contextUtil.getLang(context)
    defaultNetWorkingTypeDict = getDefaultNetWorkingType(context)
    defaultNetWorkingSpecDict = getDefaultNetWorkingSpec(context)

    title = getRes(lang, "selectExpansionTitle")
    desc = getRes(lang, "selectExpansionDesc")

    width = '450' if lang == "en" else '350'

    # 脚本设置
    checkScript = "common/saveExpansionMode.py"
    checkMethod = "execute"

    # 窗体内容设置
    inputComponent = []
    set_expansion_input_component(context, inputComponent, defaultNetWorkingTypeDict, defaultNetWorkingSpecDict)

    # 是否存在容器特性
    has_container_feature = check_container_feature_and_container_application(context)
    if has_container_feature:
        contextUtil.setItem(context, "has_container_feature", True)
        default_new_ctrl_num = int(defaultNetWorkingSpecDict["default"].split()[0])
        contextUtil.setItem(context, "new_ctrl_num", default_new_ctrl_num)

    # 支持扩IP时，窗体内容新增备份IP和归档IP
    if is_support_expand_ip(context, has_container_feature):
        add_ip_to_input_component(context, inputComponent)

    # 如果有窗体包含备份IP或归档IP，则调整框的长度
    height = 450 + (len(inputComponent) - 3) * ROW_HEIGHT
    dialogInfo = {'title': title, 'desc': desc, 'width': width, 'height': str(height)}
    jDiaglogInfo = getJsonStr(dialogInfo)

    jInputComponent = getJsonStr(inputComponent)

    dialogUtil = context.get('dialogUtil')
    dialogUtil.showInputDialog(jDiaglogInfo, checkScript, checkMethod, jInputComponent)


def is_support_expand_ip(context, has_container_feature):
    """
    判断是否支持扩容IP(A8000支持，二级存储X系列1.5.0以前支持)
    @param context: 上下文
    @param has_container_feature: 是否具有容器服务特性
    @return: True: 支持扩IP， False: 不支持扩IP
    """
    product_model = contextUtil.getItem(context, "productModel")
    product_version = contextUtil.getItem(context, "productVersion")
    if product_model == "OceanProtect A8000":
        return True
    return all([has_container_feature, baseUtil.is_ocean_protect(product_model), product_version <= "1.3.0"])


def set_expansion_input_component(context, input_component,
                                  default_network_type_dict,
                                  default_network_spec_dict):
    """
    设置扩容窗体内容
    :param context: 上下文
    :param input_component: 窗体内容列表
    :param default_network_type_dict: 默认组网字典
    :param default_network_spec_dict: 默认规格字典
    :return:
    """

    lang = contextUtil.getLang(context)
    refresh_script = "common/refreshExpansionMode.py"
    refresh_ip_segment_script = "common/refresh_ip_network_segment.py"

    product_model = {
        'id': 'productModel',
        'name': getRes(lang, "selectExpansion_productModel"),
        'type': 'label',
        'labelTxt': contextUtil.getItem(context, "popupSelectModel"),
    }
    input_component.append(product_model)

    # 组网设置
    network_type = {
        'id': 'netWorkingType',
        'name': getRes(lang, "selectExpansion_netWorkingType"),
        'type': 'dropdown',
        'rule': default_network_type_dict["rule"],
        'default': default_network_type_dict["default"],
        'refreshScript': refresh_script,
        'refreshItems': 'networkSpec',
        'refreshType': 'dropdown',
    }
    input_component.append(network_type)

    # 扩容规格
    network_spec = {
        'id': 'networkSpec',
        'name': getRes(lang, "selectExpansion_networkSpec"),
        'type': 'dropdown',
        'rule': default_network_spec_dict["rule"],
        'default': default_network_spec_dict["default"],
        'refreshScript': refresh_ip_segment_script,
        'refreshItems': 'backup_start_ip_new,exist_backup_ip,backup_end_ip_new',
        'refreshType': 'textField',
    }
    input_component.append(network_spec)


def check_container_feature_and_container_application(context):
    """
    检查是否具备支持容器服务的特性和容器应用
    :param context: 上下文
    :return: True:具有该特性，部署了容器应用 False: 不具备该特性或未部署容器应用
    """
    dev = context.get("devNode0")
    dev_node = EntityUtils.toOldDev(dev)
    if not LicenseFeatureQueryUtil.hasSupportedContainerFeature(dev_node):
        return False
    # 检查是否有容器应用
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    cmd = "show container_application general"
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)

    return "dataprotect" in cli_ret


def add_ip_to_input_component(context, input_component):
    """
    A8000窗体内容新增备份IP和归档IP
    :param context: 上下文
    :param input_component: 窗体内容列表
    :return:
    """
    # 判断版本，1.0.0及以后才支持
    product_version = contextUtil.getItem(context, "productVersion")
    product_model = contextUtil.getItem(context, "productModel")
    if product_model == "OceanProtect A8000" and Products.compareVersion(product_version, "1.0.0") < 0:
        return
    # 二级存储X系列1.5.0及以后不需要扩容IP
    if baseUtil.is_ocean_protect_x(product_model) and contextUtil.getItem(context, "productVersion") > "1.3.0":
        return
    # 判断是否为1.1.RC1及以后版本，后续判断IP数量用到
    if product_model == "OceanProtect A8000" and Products.compareVersion(product_version, "1.1.RC1") >= 0:
        contextUtil.setItem(context, "is_version_1.1.RC1", True)
    # 2引擎起扩，不需要扩容IP
    if contextUtil.getItem(context, "ctrl_enclosure_num") >= 2:
        return
    init_context_ip(context)

    # 查询IP段
    lang = contextUtil.getLang(context)
    uri = "system/expandBackupServiceIp"
    record = execute_container_rest_cmd(context, uri, "GET")

    if not is_right_response_info(record):
        raise Exception("error response.")

    backup_plane = record.get("data", {}).get("backupPlane", [])
    archive_plane = record.get("data", {}).get("archivePlane", [])
    copy_plane = record.get("data", {}).get("copyPlane", [])

    # 备份IP不存在，直接通过
    if not backup_plane:
        return
    contextUtil.setItem(context, "exist_backup_plane", backup_plane)
    # 设备上已有的备份IP数量
    exist_backup_ip_num = get_ip_num_and_set_subnet_mask(backup_plane, context)

    if product_model == "OceanProtect A8000" and has_enough_ip_num(context, exist_backup_ip_num):
        return
    # 添加备份IP配置框
    add_backup_ip_to_input_component(context, lang, backup_plane, input_component)

    # 归档IP不存在，则直接返回
    if archive_plane:
        contextUtil.setItem(context, "exist_archive_plane", archive_plane)
        exist_archive_ip_num = get_ip_num_and_set_subnet_mask(archive_plane, context, plane_type=ARCHIVE)
        archive_plane_start_ip = archive_plane[0].get("startIp")
        archive_plane_end_ip = archive_plane[0].get("endIp")
        contextUtil.setItem(context, "archive_start_ip", archive_plane_start_ip)
        contextUtil.setItem(context, "archive_end_ip", archive_plane_end_ip)
        # 归档IP小于8个或不在同一IP段，展示归档IP配置框
        if not has_enough_ip_num(context, exist_archive_ip_num, plane_type=ARCHIVE):
            add_archive_ip_to_input_component(context, lang, archive_plane, input_component)

    if copy_plane:
        contextUtil.setItem(context, "exist_copy_plane", copy_plane)
        exist_copy_ip_num = get_ip_num_and_set_subnet_mask(copy_plane, context, plane_type=COPY)
        copy_plane_start_ip = copy_plane[0].get("startIp")
        copy_plane_end_ip = copy_plane[0].get("endIp")
        contextUtil.setItem(context, "copy_start_ip", copy_plane_start_ip)
        contextUtil.setItem(context, "copy_end_ip", copy_plane_end_ip)
        # 复制IP小于8个或不在同一IP段，展示复制IP配置框
        if not has_enough_ip_num(context, exist_copy_ip_num, plane_type=COPY):
            add_copy_ip_to_input_component(context, lang, copy_plane, input_component)


def init_context_ip(context):
    # 开始之前将开始和结束IP设置为""
    contextUtil.setItem(context, "backup_start_ip", "")
    contextUtil.setItem(context, "archive_start_ip", "")
    contextUtil.setItem(context, "copy_start_ip", "")
    contextUtil.setItem(context, "backup_start_ip_new", "")
    contextUtil.setItem(context, "archive_start_ip_new", "")
    contextUtil.setItem(context, "copy_start_ip_new", "")
    contextUtil.setItem(context, "backup_end_ip", "")
    contextUtil.setItem(context, "archive_end_ip", "")
    contextUtil.setItem(context, "copy_end_ip", "")
    contextUtil.setItem(context, "backup_end_ip_new", "")
    contextUtil.setItem(context, "archive_end_ip_new", "")
    contextUtil.setItem(context, "copy_end_ip_new", "")
    contextUtil.setItem(context, "backup_subnet_mask", "")
    contextUtil.setItem(context, "archive_subnet_mask", "")
    contextUtil.setItem(context, "copy_subnet_mask", "")
    contextUtil.setItem(context, HAVE_SUBNET, False)


def get_ip_num_and_set_subnet_mask(plane, context, plane_type=BACKUP):
    """
    针对不同平面获取ip数量并且设置对应的子网掩码
    :param plane: 平面
    :param context: 上下文
    :param plane_type: 平面类型
    :return: ip数量
    """
    subnet_mask = plane[0].get("subnetMask")
    if subnet_mask:
        contextUtil.setItem(context, HAVE_SUBNET, True)
        if plane_type == BACKUP:
            # 非连续网段的subnetMask后面要用来判断是否为同一网段
            contextUtil.setItem(context, "backup_subnet_mask", subnet_mask)
        elif plane_type == ARCHIVE:
            contextUtil.setItem(context, "archive_subnet_mask", subnet_mask)
        elif plane_type == COPY:
            contextUtil.setItem(context, "copy_subnet_mask", subnet_mask)
    ip_num = 0
    for temp in plane:
        ip_num += get_ip_num(temp.get("startIp"), temp.get("endIp"))
    if plane_type == BACKUP:
        contextUtil.setItem(context, "existing_backup_ip_num", ip_num)
    elif plane_type == ARCHIVE:
        contextUtil.setItem(context, "existing_archive_ip_num", ip_num)
    elif plane_type == COPY:
        contextUtil.setItem(context, "existing_copy_ip_num", ip_num)
    return ip_num


def execute_container_rest_cmd(context, uri, execute_type, param=""):
    """
    获取网络配置信息
    :return:
    """
    dev = context.get("devNode0")
    dev_node = EntityUtils.toOldDev(dev)
    rest = restUtil.get_container_rest(dev_node)
    url = restUtil.ContainerRestService.get_full_url(rest, uri)
    if execute_type == "GET":
        response_info = rest.execGet(url, param)
    elif execute_type == "POST":
        response_info = rest.execPost(url, param)
    data_string = response_info.getContent()
    record = restUtil.ContainerRestService.deal_zh_msg(
        json.loads(data_string))

    return record


def is_right_response_info(record):
    """
    校验响应数据是否正确。
    :param record:
    :return:
    """
    err_info = restUtil.CommonRest.getErrInfo(record)
    if not err_info:
        return False
    err_code = restUtil.CommonRest.getRecordValue(
        err_info, restData.ErrorInfo.CODE
    )
    # 不支持该命令, 直接返回通过
    if str(err_code) == '-1':
        return True
    # 如果命令执行失败
    if str(err_code) != '0':
        return False
    return True


def has_enough_ip_num(context, exist_backup_ip_num, plane_type=BACKUP):
    """
    判断是否有足够的IP（备份IP 20个，归档IP 8个）,1.1.RC1及以后（备份IP 8个，归档IP 4个），
    Dorado Cloudbackup(备份IP不少于扩容后控制器数量)
    Dorado、新融合扩容后控制器数量大于2个引擎的控制器数量，则备份IP数量为两个引擎控制器数量的2倍
    :return:
    """
    backup_num = 20
    archive_num = 8
    # 1.1.RC1及以后备份IP 8个，归档IP 4个
    if contextUtil.getItem(context, "is_version_1.1.RC1") or contextUtil.getItem(context, HAVE_SUBNET):
        backup_num = 8
        archive_num = 4
    # Dorado 6.1.3 备份IP个数为扩容后控制器个数的2倍
    if contextUtil.getItem(context, "has_container_feature") and \
            contextUtil.getItem(context, "productModel") not in OCEAN_PROTECT:
        backup_num = get_required_backup_ip_num(context)
    if plane_type == BACKUP and exist_backup_ip_num >= backup_num:
        return True
    if plane_type == ARCHIVE and exist_backup_ip_num >= archive_num:
        return True
    if plane_type == COPY and exist_backup_ip_num >= archive_num:
        return True
    return False


def get_required_backup_ip_num(context):
    """
    获取需要的备份IP数量
    @param context: 上下文
    @return: 备份IP数量
    """
    product_model = contextUtil.getItem(context, "productModel")
    product_version = contextUtil.getItem(context, "productVersion")
    new_ctrl_num = contextUtil.getItem(context, "new_ctrl_num")
    # 高端扩容后引擎数大于2，即控制器数量大于8，则备份IP数量为两个引擎控制器数量的2倍，即16
    if product_model in DORADO_DEVS_V6_HIGH and new_ctrl_num > HIGH_END_WITH_TWO_ENGINE_CTRL_NUM:
        return HIGH_END_WITH_TWO_ENGINE_CTRL_NUM * 2
    # 中端扩容后引擎数大于2，即控制器数量大于4，则备份IP数量为两个引擎控制器数量的2倍，即8
    if baseUtil.isDoradoV6Mid(product_model) and new_ctrl_num > MID_END_WITH_TWO_ENGINE_CTRL_NUM:
        return MID_END_WITH_TWO_ENGINE_CTRL_NUM * 2
    # 扩容后引擎数量小于等于2，则备份IP数量为扩容后控制器数量的2倍
    return new_ctrl_num * 2


def get_required_ctrl_num(context, product_model):
    """
    获取扩容容器需要的控制器数量（大于2个引擎时，以两个引擎的控制器为准）
    @param context: 上下文
    @param product_model: 设备型号
    @return: 需要的控制器数量
    """
    tlv = contextUtil.getTlv(context)
    current_controller_num = tlvUtil.getControllersNum(tlv)
    # 高端设备，引擎数大于2，即控制器数量大于8，返回2个引擎内的控制器数量，即8
    if baseUtil.isDoradoV6HighEnd(product_model) and current_controller_num > HIGH_END_WITH_TWO_ENGINE_CTRL_NUM:
        return HIGH_END_WITH_TWO_ENGINE_CTRL_NUM
    # 中端设备，引擎数大于2，即控制器数量大于4，返回2个引擎内的控制器数量，即4
    if baseUtil.isDoradoV6Mid(product_model) and current_controller_num > MID_END_WITH_TWO_ENGINE_CTRL_NUM:
        return MID_END_WITH_TWO_ENGINE_CTRL_NUM
    return current_controller_num


def get_ip_num(start_ip, end_ip):
    """
    获取开始于结束ip之间的连续ip个数
    :param start_ip:开始ip
    :param end_ip:结束ip
    :return:合法ip段，返回数量，不合法的，返回0
    """
    if not start_ip or not end_ip:
        return 0
    # 既不是IPV4，也不是IPV6，返回0
    if not (isIpV4(start_ip) or isIpV6(start_ip)) or not (isIpV4(end_ip) or isIpV6(end_ip)):
        return 0
    ip_num = convert_ip_to_int(end_ip) - convert_ip_to_int(start_ip) + 1
    return ip_num if ip_num > 0 else 0


def is_ip_v6(start_ip, end_ip):
    """
    判断起始IP和结束IP是否为IPV6格式
    :param start_ip:
    :param end_ip:
    :return:
    """
    return ":" in start_ip and ":" in end_ip


def is_same_ip_address_segment(start_ip, end_ip, context=None, plane=BACKUP):
    """
    判断起始IP和结束IP是否在同一IP段
    :return:
    """
    subnet_mask = None
    if context:
        content_key = "{}_subnet_mask".format(plane)
        subnet_mask = contextUtil.getItem(context, content_key)
    if context is None or not subnet_mask:
        pattern = ":" if is_ip_v6(start_ip, end_ip) else "."
        return start_ip.rsplit(pattern, 1)[0] == end_ip.rsplit(pattern, 1)[0]
    is_v4 = False if ":" in start_ip else True
    if is_v4:
        return check_same_segment_v4_by_subnet(start_ip, end_ip, subnet_mask)
    return check_same_segment_v6_by_subnet(start_ip, end_ip, subnet_mask)


def check_same_segment_v6_by_subnet(end_ip, start_ip, subnet_mask):
    """
    通过子网掩码检测IPV6是否在同一网段
    先获取移动位数x（128-子网掩码）
    将开始ip，结束ip，转为数字，在然后分别右移x位再左移x位，如果相等，则为同一网段
    :param start_ip: 开始ip
    :param end_ip: 结束ip
    :param subnet_mask:子网掩码,为数字
    :return:检测结果
    """
    if not isIpV6(start_ip) or not isIpV6(end_ip):
        return False
    need_move = 128 - int(subnet_mask)
    start_int = convert_ip_to_int(start_ip) >> need_move << need_move
    end_int = convert_ip_to_int(end_ip) >> need_move << need_move
    return start_int == end_int


def check_same_segment_v4_by_subnet(start_ip, end_ip, subnet_mask):
    """
    通过子网掩码检测IPV4是否在同一网段
    将开始ip，结束ip与子网掩码，转为数字，在然后用子网掩码的数字分别对开始ip与结束ip做与操作，如果结果相等，则为同一网段
    :param start_ip: 开始ip
    :param end_ip: 结束ip
    :param subnet_mask:子网掩码
    :return:检测结果
    """
    if not isIpV4(start_ip) or not isIpV4(end_ip) or not isIpV4(subnet_mask):
        return False
    sub_int = convert_ip_to_int(subnet_mask)
    start_int = convert_ip_to_int(start_ip)
    end_int = convert_ip_to_int(end_ip)
    return sub_int & start_int == sub_int & end_int


def convert_ip_to_int(ip):
    is_v4 = False if ":" in ip else True
    temp_bytes = socket.inet_pton(socket.AF_INET if is_v4 else socket.AF_INET6, ip)
    return int(temp_bytes.encode('hex'), 16)


def set_ip_to_list(start_ip, end_ip, all_ip_num):
    """
    将ip段内所有ip存入列表，仅用于判断是否有相同IP
    :param start_ip: 开始IP
    :param end_ip: 结束IP
    :param all_ip_num: 列表
    """
    if not start_ip or not end_ip:
        return
    if is_ip_v4_or_v6(start_ip, end_ip):
        start_ip_num = convert_ip_to_int(start_ip)
        end_ip_num = convert_ip_to_int(end_ip)
        while start_ip_num <= end_ip_num:
            all_ip_num.append(start_ip_num)
            start_ip_num += 1


def is_ip_v4_or_v6(start_ip, end_ip):
    """
    判断ip是否属于IpV4或IpV6
    :param start_ip: 开始IP
    :param end_ip: 结束IP
    :return: 是：属于IpV4或IpV6；否：属于IpV4或IpV6
    """
    return isIpV4(start_ip) and isIpV4(end_ip) or (isIpV6(start_ip) and isIpV6(end_ip))


def add_backup_ip_to_input_component(context, lang, backup_plane, input_component):
    """
    添加备份IP到窗体内容
    :return:
    """
    backup_plane_start_ip = backup_plane[0].get("startIp")
    backup_plane_end_ip = backup_plane[0].get("endIp")
    contextUtil.setItem(context, "backup_start_ip", backup_plane_start_ip)
    contextUtil.setItem(context, "backup_end_ip", backup_plane_end_ip)
    # 不支持非连续性网段
    if not contextUtil.getItem(context, HAVE_SUBNET):
        required_backup_num = 20
        backup_start_ip = {
            'id': 'backup_start_ip',
            'name': getRes(lang, "backup_start_ip"),
            'type': 'label',
            'labelTxt': backup_plane_start_ip,
        }
        input_component.append(backup_start_ip)
        backup_end_ip = {
            'id': 'backup_end_ip',
            'name': getRes(lang, "backup_end_ip"),
            'type': 'textField',
            'default': backup_plane_end_ip,
            'toolTip': getRes(lang, "select_backup_ip_tip", required_backup_num)
        }
        input_component.append(backup_end_ip)
        return
    backup_plane_ip_list = []
    for temp in backup_plane:
        backup_plane_ip_list.append("{}~{}".format(temp.get("startIp"), temp.get("endIp")))

    exist_backup_ip_num = contextUtil.getItem(context, "existing_backup_ip_num")
    is_show = str(not has_enough_ip_num(context, exist_backup_ip_num))
    # 已有备份IP
    exist_backup_ip = {
        'id': 'exist_backup_ip',
        'name': getRes(lang, "exist_backup_ip"),
        'type': 'label',
        'labelTxt': ",".join(backup_plane_ip_list),
        'isShow': is_show
    }
    input_component.append(exist_backup_ip)
    # 如果具有容器特性，IP个数为扩容后控制器个数(扩容后超过2个引擎，以两个引擎控制器数量为准)的2倍，否则IP个数为8
    required_backup_num = get_required_backup_ip_num(context) \
        if contextUtil.getItem(context, "has_container_feature") else 8

    add_new_ip_input(input_component, lang, required_backup_num, context, is_show)


def add_new_ip_input(inputs, lang, required_ip_num, context, is_show, types=BACKUP):
    """
    添加新的ip输入框
    :param inputs:已有的输入框列表
    :param lang:语言
    :param required_ip_num: 需要的ip个数
    :param context: 上下文
    :param types:ip所属类型
    :return:
    """
    start_ip_new = {
        'id': '{}_start_ip_new'.format(types),
        'name': getRes(lang, "{}_start_ip".format(types)),
        'type': 'textField',
        'default': '',
        'isShow': is_show
    }
    inputs.append(start_ip_new)
    subnet_mask = contextUtil.getItem(context, "{}_subnet_mask".format(types))
    tool_tip = getRes(lang, "select_{}_ip_tip_new".format(types),
                      (required_ip_num, subnet_mask))
    if contextUtil.getItem(context, "has_container_feature") and types == BACKUP:
        tool_tip = getRes(lang, "cloud_backup_ip_tip_new", subnet_mask)
    # 大规格带容器扩容开关打开
    if is_container_switch_open(context) and types == BACKUP:
        tool_tip = getRes(lang, "backup_ip_tip_with_container_switch_open", subnet_mask)
    end_ip_new = {
        'id': '{}_end_ip_new'.format(types),
        'name': getRes(lang, "{}_end_ip".format(types)),
        'type': 'textField',
        'default': '',
        'isShow': is_show,
        'toolTip': tool_tip,
    }
    inputs.append(end_ip_new)


def is_container_switch_open(context):
    """
    判断大规格带容器扩容开关是否打开(只有回显中存在Support才是打开，其余情况全部默认关闭)
    @param context: 上下文
    @return: True：打开 False：关闭
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)
    log = contextUtil.getLogger(context)
    cmd = "container.sh -c supportMultiEngine"
    try:
        flag, cli_ret, err_msg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, lang)
        if not flag:
            return False
        return "Support" in cli_ret
    except Exception as ex:
        log.error("get container switch error: {}".format(ex))
        return False
    finally:
        cliUtil.enterCliModeFromSomeModel(cli, lang)


def check_multi_ips(exist_plane, custom_ip, context, plane_type=BACKUP):
    lang = contextUtil.getLang(context)
    for ip in custom_ip:
        if not ip or (not isIpV4(ip) and not isIpV6(ip)):
            return False, getRes(lang, "{}_ip_format_error".format(plane_type))
    if len(custom_ip) < 2:
        return False, getRes(lang, "{}_ip_format_error".format(plane_type))
    # 是否都是IPV4，或者都是IPV6，
    if not any([isIpV4(exist_plane[0].get("startIp")) and isIpV4(custom_ip[0]),
                isIpV6(exist_plane[0].get("startIp")) and isIpV6(custom_ip[0])]):
        return False, getRes(lang, "{}_ip_format_error".format(plane_type))
    # 校验多段ip时，要校验用户输入的与原来的是否在同一网段
    if not is_same_ip_address_segment(exist_plane[0].get("startIp"), custom_ip[0], context, plane_type):
        return False, getRes(lang, "{}_ip_segment_not_same".format(plane_type))
    return check_ips_repeat(exist_plane, custom_ip, lang, plane_type)


def check_ips_repeat(exist_plane, custom_ip, lang, plane_type):
    """
    检测多段ip的合法性, 两段ip不能有重合的地方，如果有，则返回False
    :param exist_plane: 原始ip段
    :param custom_ip: 自定义ip段
    :return:
    """
    if len(custom_ip) < 2:
        return False
    is_ipv4 = False
    is_ipv6 = False
    for ip in custom_ip:
        if ":" in ip:
            is_ipv6 = True
        else:
            is_ipv4 = True
    # ipv4与v6只能有一种
    if is_ipv4 and is_ipv6:
        return False, getRes(lang, "{}_ip_must_one".format(plane_type))
    custom_ip_ints = [convert_ip_to_int(custom_ip[0]), convert_ip_to_int(custom_ip[1])]
    if custom_ip_ints[1] < custom_ip_ints[0]:
        return False, getRes(lang, "{}_end_must_more_than".format(plane_type))
    for plane in exist_plane:
        origin_ip_ints = [convert_ip_to_int(plane.get("startIp")), convert_ip_to_int(plane.get("endIp"))]
        if origin_ip_ints[0] <= custom_ip_ints[0] <= origin_ip_ints[1] or \
                origin_ip_ints[0] <= custom_ip_ints[1] <= origin_ip_ints[1]:
            return False, getRes(lang, "{}_ip_repeat".format(plane_type))
        if custom_ip_ints[0] <= origin_ip_ints[0] <= custom_ip_ints[1] or \
                custom_ip_ints[0] <= origin_ip_ints[1] <= custom_ip_ints[1]:
            return False, getRes(lang, "{}_ip_repeat".format(plane_type))
    return True, ""


def verify_ip_address(context, start_ip, end_ip, plane_type):
    """
    校验IP地址
    :return:
    """
    lang = contextUtil.getLang(context)
    # 校验起始IP和结束IP是否都存在
    if not start_ip or not end_ip:
        return False, getRes(lang, "{}_ip_format_error".format(plane_type))

    # 校验IP格式
    if not (isIpV4(start_ip) and isIpV4(end_ip)) and \
            not (isIpV6(start_ip) and isIpV6(end_ip)
                 and is_ip_v6(start_ip, end_ip)):
        return False, getRes(lang, "{}_ip_format_error".format(plane_type))

    # 校验IP段
    if not is_same_ip_address_segment(start_ip, end_ip, context=context, plane=plane_type):
        return False, getRes(lang, "{}_ip_segment_not_same".format(plane_type))

    # 校验IP个数
    ip_num = get_ip_num(start_ip, end_ip)
    if not has_enough_ip_num(context, ip_num, plane_type=plane_type):
        return False, getRes(lang, "{}_ip_not_enough".format(plane_type))

    return True, ""


def add_archive_ip_to_input_component(context, lang, archive_plane, input_component):
    """
    添加归档IP到窗体内容
    :return:
    """
    archive_plane_start_ip = archive_plane[0].get("startIp")
    archive_plane_end_ip = archive_plane[0].get("endIp")
    contextUtil.setItem(context, "archive_start_ip", archive_plane_start_ip)
    contextUtil.setItem(context, "archive_end_ip", archive_plane_end_ip)

    # 不支持非连续性网段
    if not contextUtil.getItem(context, HAVE_SUBNET):
        required_archive_num = 8
        archive_start_ip = {
            'id': 'archive_start_ip',
            'name': getRes(lang, "archive_start_ip"),
            'type': 'label',
            'labelTxt': archive_plane_start_ip,
        }
        input_component.append(archive_start_ip)
        archive_end_ip = {
            'id': 'archive_end_ip',
            'name': getRes(lang, "archive_end_ip"),
            'type': 'textField',
            'default': archive_plane_end_ip,
            'toolTip': getRes(lang, "select_archive_ip_tip",
                              required_archive_num),
        }
        input_component.append(archive_end_ip)
        return
    archive_plane_ip_list = []
    for temp in archive_plane:
        archive_plane_ip_list.append("{}~{}".format(temp.get("startIp"), temp.get("endIp")))
    # 已有归档IP
    exist_archive_ip = {
        'id': 'exist_archive_ip',
        'name': getRes(lang, "exist_archive_ip"),
        'type': 'label',
        'labelTxt': ",".join(archive_plane_ip_list),
    }
    input_component.append(exist_archive_ip)

    required_archive_num = 4
    add_new_ip_input(input_component, lang, required_archive_num, context, 'True', ARCHIVE)


def add_copy_ip_to_input_component(context, lang, plane, input_component):
    """
    添加归档IP到窗体内容
    :return:
    """
    copy_plane_start_ip = plane[0].get("startIp")
    copy_plane_end_ip = plane[0].get("endIp")
    contextUtil.setItem(context, "copy_start_ip", copy_plane_start_ip)
    contextUtil.setItem(context, "copy_end_ip", copy_plane_end_ip)
    # 不支持非连续性网段
    if not contextUtil.getItem(context, HAVE_SUBNET):
        required_num = 8
        copy_start_ip = {
            'id': 'copy_start_ip',
            'name': getRes(lang, "copy_start_ip"),
            'type': 'label',
            'labelTxt': copy_plane_start_ip,
        }
        input_component.append(copy_start_ip)
        copy_end_ip = {
            'id': 'copy_end_ip',
            'name': getRes(lang, "copy_end_ip"),
            'type': 'textField',
            'default': copy_plane_end_ip,
            'toolTip': getRes(lang, "select_copy_ip_tip",
                              required_num),
        }
        input_component.append(copy_end_ip)
        return
    copy_plane_ip_list = []
    for temp in plane:
        copy_plane_ip_list.append("{}~{}".format(temp.get("startIp"), temp.get("endIp")))
    # 已有归档IP
    exist_copy_ip = {
        'id': 'exist_copy_ip',
        'name': getRes(lang, "exist_copy_ip"),
        'type': 'label',
        'labelTxt': ",".join(copy_plane_ip_list),
    }
    input_component.append(exist_copy_ip)

    required_copy_num = 4
    add_new_ip_input(input_component, lang, required_copy_num, context, 'True', COPY)


def getDefaultNetWorkingType18000(context):
    '''
    @summary: 获取默认的组网配置
    '''

    lang = contextUtil.getLang(context)
    expansionSpecDict = contextUtil.getItem(context, "expansionSpecDict")

    # 获取默认组网配置
    defaultKey = getDefaultNetworkType(expansionSpecDict)
    defaultNetWorkType = ""
    netWorkTypes = []
    for key in expansionSpecDict.keys():
        netWorkingType = ""
        if key == CLUST_TYPE_NONE:
            netWorkingType = getRes(lang, "none")
        elif key == CLUST_TYPE_DIRECT:
            netWorkingType = getRes(lang, "direct")
        elif key == CLUST_TYPE_SWITCH:
            netWorkingType = getRes(lang, "switch")
        netWorkTypes.append(netWorkingType)

        if key == defaultKey:
            defaultNetWorkType = netWorkingType

    return {"rule": "##".join(netWorkTypes), "default": defaultNetWorkType}


def getDefaultNetWorkingSpec18000(context):
    '''
    @summary: 获取默认的扩容规格
    '''

    expansionSpecDict = contextUtil.getItem(context, "expansionSpecDict")
    defaultKey = getDefaultNetworkType(expansionSpecDict)
    expansionSpec = expansionSpecDict.get(defaultKey)
    expansionCtrls = getExpansionCtrlsSpec(expansionSpec)

    lang = contextUtil.getLang(context)
    ctrlNum = contextUtil.getItem(context, "ctrlNum")

    msg = getRes(lang, "controller")
    expansionCtrls = ["%s %s" % (str(num), msg) for num in expansionCtrls if num > ctrlNum]
    return {"rule": "##".join(expansionCtrls), "default": expansionCtrls[0]}


def popupSelectExpansion18000Dialog(context):
    '''
    @summary: 选择扩容场景窗口（针对18000）
    '''
    logger = getLogger(context.get("logger"), __file__)
    logger.logInfo("popupSelectExpansionDialog start")

    lang = contextUtil.getLang(context)
    defaultNetWorkingTypeDict = getDefaultNetWorkingType18000(context)
    defaultNetWorkingSpecDict = getDefaultNetWorkingSpec18000(context)

    title = getRes(lang, "selectExpansionTitle")
    desc = getRes(lang, "selectExpansionDesc")

    width = '350'
    if lang == "en":
        width = '450'

    # 窗口设置
    dialogInfo = {'title': title, 'desc': desc, 'width': width, 'height': '400'}
    jDiaglogInfo = getJsonStr(dialogInfo)

    # 脚本设置
    checkScript = "common/saveExpansionMode.py"
    checkMethod = "execute"
    refreshScript = "common/refreshExpansionMode.py"

    # 窗体内容设置
    inputComponent = []

    # 设备类型
    productModel = {
        'id': 'productModel',
        'name': getRes(lang, "selectExpansion_productModel"),
        'type': 'label',
        'labelTxt': contextUtil.getItem(context, "productModel"),
    }
    inputComponent.append(productModel)

    # 组网设置
    netWorkingType = {
        'id': 'netWorkingType',
        'name': getRes(lang, "selectExpansion_netWorkingType"),
        'type': 'dropdown',
        'rule': defaultNetWorkingTypeDict["rule"],
        'default': defaultNetWorkingTypeDict["default"],
        'refreshScript': refreshScript,
        'refreshItems': 'networkSpec',
        'refreshType': 'dropdown',
    }
    inputComponent.append(netWorkingType)

    # 扩容规格
    networkSpec = {
        'id': 'networkSpec',
        'name': getRes(lang, "selectExpansion_networkSpec"),
        'type': 'dropdown',
        'rule': defaultNetWorkingSpecDict["rule"],
        'default': defaultNetWorkingSpecDict["default"],
    }
    inputComponent.append(networkSpec)
    jInputComponent = getJsonStr(inputComponent)

    dialogUtil = context.get('dialogUtil')
    dialogUtil.showInputDialog(jDiaglogInfo, checkScript, checkMethod, jInputComponent)


def popupManIPConfigDialog(context, board, portInfo):
    logger = getLogger(context.get("logger"), __file__)
    logger.logInfo("popupManIPConfigDialog start")
    lang = contextUtil.getLang(context)

    title = getRes(lang, "configManIPTitle")
    desc = getRes(lang, "configManIPDesc", (board["enclosureSN"], portInfo["portLocation"]))

    width = '450'
    if lang == "en":
        width = '480'

    height = '360'
    if lang == "en":
        height = '380'

        # 窗口设置
    dialogInfo = {'title': title, 'desc': desc, 'width': width, 'height': height}
    jDiaglogInfo = getJsonStr(dialogInfo)

    # 脚本设置
    checkScript = "doradoExpansion/configManIP.py"
    checkMethod = "execute"

    # 窗体内容设置
    inputComponent = []

    ipVer = contextUtil.getItem(context, "MODIFY_MGMT_IPVer")

    i = 0
    manIp = {'id': 'manIp%s' % i, 'name': getRes(lang, "confict_manIp", (ipVer)), 'type': 'textField'}
    inputComponent.append(manIp)
    if ipVer == IPV4:
        mask = {'id': 'mask%s' % i, 'name': getRes(lang, "confict_mask"), 'type': 'textField'}
    elif ipVer == IPV6:
        mask = {'id': 'mask%s' % i, 'name': getRes(lang, "confict_prefix"), 'type': 'textField'}
    inputComponent.append(mask)
    gateway = {'id': 'gateway%s' % i, 'name': getRes(lang, "confict_gateway", (ipVer)), 'type': 'textField'}
    inputComponent.append(gateway)

    jInputComponent = getJsonStr(inputComponent)

    dialogUtil = context.get('dialogUtil')
    dialogUtil.showInputDialog(jDiaglogInfo, checkScript, checkMethod, jInputComponent)


def popupConfigSwtichDialog(context):
    '''
    @summary: 初始化配置交换机窗口
    '''
    logger = getLogger(context.get("logger"), __file__)
    logger.logInfo("popupConfigSwtichDialog start")

    lang = contextUtil.getLang(context)

    title = getRes(lang, "configSwitchTitle")
    desc = getRes(lang, "configSwitchDesc")

    width = '450'
    if lang == "en":
        width = '480'

    height = '520'
    if lang == "en":
        height = '550'
        # 窗口设置
    dialogInfo = {'title': title, 'desc': desc, 'width': width, 'height': height}
    jDiaglogInfo = getJsonStr(dialogInfo)

    # 脚本设置
    checkScript = "ipScaleOut/configSwtich.py"
    checkMethod = "execute"

    # 窗体内容设置
    inputComponent = []

    for i in range(0, 2):
        ipAddress = {'id': 'ipaddress%s' % i, 'name': getRes(lang, "ipaddress", i), 'type': 'textField'}
        inputComponent.append(ipAddress)
        username = {'id': 'username%s' % i, 'name': getRes(lang, "username", i), 'type': 'textField'}
        inputComponent.append(username)
        password = {'id': 'password%s' % i, 'name': getRes(lang, "password", i), 'type': 'pwdField'}
        inputComponent.append(password)
        port = {'id': 'port%s' % i, 'name': getRes(lang, "port", i), 'type': 'textField'}
        inputComponent.append(port)

    jInputComponent = getJsonStr(inputComponent)

    dialogUtil = context.get('dialogUtil')
    dialogUtil.showInputDialog(jDiaglogInfo, checkScript, checkMethod, jInputComponent)


def connectSwitch(connectorFactory, switchInfo):
    '''
    @summary: 与交换机建立连接
    '''
    resultDict = {"flag": False, "cli": None, "cliRet": ""}
    try:
        sshConnector = connectorFactory.createSshConnector(switchInfo["ipaddress"],
                                                           int(switchInfo["port"]), switchInfo["username"],
                                                           switchInfo["password"])
        cli = sshConnector.getConnection()
        cli.execCmd("N")  # 避免登录后需要改密码的情形
        res = cli.execCmd("#")
        if res.endswith(">"):
            resultDict["flag"] = True
            resultDict["cli"] = cli
            resultDict["cliRet"] = res
            return resultDict
    except:
        return resultDict
    return resultDict


def execDisplaySwitchInfo(cli, cmd):
    '''
    @summary: 针对交换机执行查询类命令
    '''
    res = cli.execCmd(cmd)
    cliRet = res

    i = 0
    while "---- More ----" in res:
        if i > 512:
            cli.execCmd("#")
            cli.execCmd("#")
            break
        res = cli.execCmd("\n")
        cliRet += res
        i += 1

    return cliRet


def checkSwitchVer(cli):
    """检查交换机产品型号是否满足扩容要求

    :param cli:
    :return:
    """
    cliRet = execDisplaySwitchInfo(cli, "display version")
    supportFlag = False
    switchVer = ""
    for suppportVer in config.SUPPORT_SWITCH_VER:
        if suppportVer in cliRet:
            switchVer = suppportVer
            supportFlag = True
            break

    return {"flag": supportFlag, "cliRet": cliRet, "switchVer": switchVer}


def configSwitch(cli, switch_ver, switch_num):
    """对交换机进行配置

    :param cli: 交换机连接
    :param switch_ver: 交换机版本
    :param switch_num: 交换机编号
    :return:
    """
    all_ret_list = list()
    # 从用户视图进入系统视图
    view_ret = cli.execCmd("system-view")
    all_ret_list.append(view_ret)

    # 修改交换机名称
    sys_name_ret = cli.execCmd(switch_config.SYS_NAME.format(switch_num))
    all_ret_list.append(sys_name_ret)

    config_cmd = ""
    product_adapter = get_product_adapter()
    if product_adapter:
        config_cmd = product_adapter.get_switch_config(switch_ver)
    elif switch_ver in ("CE6865", "CE6866"):
        config_cmd = switch_config.CE6865
    elif switch_ver == "CE8850":
        config_cmd = switch_config.CE8850
    else:
        config_cmd = switch_config.CE8851

    # 下发配置vlan、qos等命令
    config_ret = cli.execCmd(config_cmd)
    all_ret_list.append(config_ret)

    all_ret = "\n".join(all_ret_list)
    for line in all_ret.lower().splitlines():
        # 忽略undo lldp disable命令执行失败的回显
        if "error: failed to execute the port-group command for" in line:
            continue
        if "^" in line or "error" in line:
            return {"flag": False, "cliRet": all_ret}

    # 下发save
    return_ret = cli.execCmd("return")
    save_ret = cli.execCmd("save STORAGE-SCALE-SW-{}.cfg\nY\nY".format(
        switch_num))
    all_ret_list.append(return_ret)
    all_ret_list.append(save_ret)

    if not "successfully" in save_ret:
        return {"flag": False, "cliRet": "\n".join(all_ret_list)}

    # 修改下次启动项配置
    cli.execCmd("startup saved-configuration STORAGE-SCALE-SW-{}.cfg".format(
        switch_num))
    return {"flag": True, "cliRet": "\n".join(all_ret_list)}


def switchRet2Dict(cliRet):
    '''
    @summary: 将交换机的cli回显转换为字典
    '''
    retDict = {}
    lines = cliRet.splitlines()
    key = "default"
    for line in lines:
        if len(line.strip()) == 0:
            continue
        if line.startswith("#"):
            continue
        if not line.startswith(" "):
            key = line.strip()
            retDict[key] = []
        else:
            retDict[key].append(line.strip())
    return retDict


def isSwitchConfigOK(cli):
    '''
    @summary: 检查交换机的配置是否已生效
    '''
    # 查看当前配置
    cliRet = cli.execCmd("return")
    cliRet += cli.execCmd("system-view")
    configItemDict = switchRet2Dict(config.SWITCH_CONFIG)
    configItemKeys = configItemDict.keys()

    for configItem in configItemKeys:
        # 只检查接口的配置是否生效，其他配置是否生效因为screen-length限制不做检查
        if not configItem.lower().startswith("interface"):
            continue

        # 进入接口视图
        cliRet += cli.execCmd(configItem)

        # 获取该接口视图下对应的回显
        intfRet = execDisplaySwitchInfo(cli, "display this")
        cliRet += intfRet

        intfItemVals = [intfItemVal.replace("---- More ----\x1b[16D                \x1b[16D", "").strip() for
                        intfItemVal in intfRet.split("\n")]
        configItemVals = configItemDict[configItem]
        for configItemVal in configItemVals:
            if configItemVal not in intfItemVals:
                return {"flag": False, "cliRet": cliRet}

    cliRet += cli.execCmd("return")
    return {"flag": True, "cliRet": cliRet}


def getProcessConfDict(xmlFile):
    '''
    @summary: 获取流程配置
    '''
    return '{"conf":"%s"}' % xmlFile


def getExpansionDaeType(diskEncModelList, internalProductModel):
    """获取扩容硬盘框的类型：SAS/SMART

    :param diskEncModelList: 系统已有硬盘框类型列表
    :param internalProductModel: 系统内部型号
    :return: SAS/SMART
    """
    if diskEncModelList:
        diskEncModel = diskEncModelList[0]
        if diskEncModel in [tlvData.ENCLOSURE_MODEL_E.get('EXP_IPSAS_2U_25'),
                            tlvData.ENCLOSURE_MODEL_E.get('EXP_IPSAS_2U_12'),
                            tlvData.ENCLOSURE_MODEL_E.get('EXP_IPNVMe_2U_36'),
                            ]:
            daeType = 'SMART'
        else:
            daeType = 'SAS'
    else:
        daeType = 'SAS' if internalProductModel in SAS_INTERNAL_PDT_MODEL_TUPLE else 'SMART'
        if internalProductModel in IP_SAS_INTERNAL_PDT_MODEL_TUPLE:
            diskEncModel = tlvData.ENCLOSURE_MODEL_E.get('EXP_IPSAS_2U_25')  # Dorado V6 规格表无IP SAS 12盘位硬盘框
        else:
            diskEncModel = tlvData.ENCLOSURE_MODEL_E.get('EXP_IPNVMe_2U_36')

    # 新融合支持SAS框
    if internalProductModel in config.HYBRID_V6_FULL_BAY_SUP_SAS_ENC:
        daeType = "SAS"

    return daeType, diskEncModel


def getClsInfoForExpandDisk(context, tlv):
    """获取扩容硬盘框或硬盘柜所需的集群信息

    :param context:
    :param tlv:
    :return:
    """
    logger = getLogger(context.get("logger"), __file__)

    # 获取柜信息字典
    cabinetRecords = tlvUtil.getBayRecords(tlv)
    cabinetDict = tlvUtil.getCabinetDict(cabinetRecords if cabinetRecords else [])
    logger.logInfo("cabinetDict:%s" % str(cabinetDict))
    contextUtil.setItem(context, "cabinetDict", cabinetDict)

    cabinetNames = tlvUtil.getBayNames(cabinetRecords if cabinetRecords else [])
    logger.logInfo("oldCabinetNames:%s" % str(cabinetNames))
    contextUtil.setItem(context, "oldCabinetNames", cabinetNames)

    ctrlRecs = tlvUtil.getControllerRecords(tlv)
    logger.logInfo("ctrlRecords:%s" % str(ctrlRecs))
    contextUtil.setItem(context, "ctrlRecords", ctrlRecs)
    # 获取硬盘框数量
    enclosureRecords = tlvUtil.getEnclosureRecords(tlv)
    encLocs = tlvUtil.getDiskEnclouresLoc(enclosureRecords)
    # 已有框名列表
    encNameList = tlvUtil.getDiskEnclouresName(enclosureRecords)
    contextUtil.setItem(context, "originDiskEncNameList", set(encNameList))

    ctrlEncNum = tlvUtil.getCtrlEncNum(enclosureRecords)
    diskEncModelList = tlvUtil.getDiskEncloureModels(enclosureRecords)
    contextUtil.setItem(context, "originDiskEncLocList", set(encLocs))
    contextUtil.setItem(context, "ctrlEncNum", ctrlEncNum)

    enc_2u_list, enc_4u_list = \
        tlvUtil.get_disk_enc_2U_4U_list(enclosureRecords)
    logger.logInfo("2U disk enclosure:%s, 4U disk enclosure:%s" %
                   (str(enc_2u_list), str(enc_4u_list)))
    contextUtil.setItem(context, "origin_enc_2u_list", set(enc_2u_list))
    contextUtil.setItem(context, "origin_enc_4u_list", set(enc_4u_list))

    diskEncNum = len(encLocs)
    logger.logInfo("disk enclosure num:%s" % str(diskEncNum))
    logger.logInfo("origin disk enclosure locs:%s" % str(encLocs))
    logger.logInfo("originDiskEncModelList:%s" % str(diskEncModelList))
    # 保存硬盘框数量
    contextUtil.setItem(context, "diskEnclosureNum", diskEncNum)

    # 初始化扩容配置信息
    contextUtil.setItem(context, "selectedConfig", {})

    isSupportInnerHyperMetro, _ = restUtil.CommonRest.hasInnerLicense(tlv)
    backendNetMode = 'share' if isSupportInnerHyperMetro else 'non_share'
    logger.logInfo("backendNetMode:%s" % str(backendNetMode))
    contextUtil.setItem(context, "backendNetMode", backendNetMode)

    internalProductModel = getInternalProductModel(context)
    logger.logInfo("internalProductModel:%s" % str(internalProductModel))

    if not internalProductModel and not diskEncModelList:
        lang = contextUtil.getLang(context)
        resultDict = dict()
        logger.logNoPass("Query internal product model failed, and expansion disk enclosure type unknown.")
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = getMsg(lang, "expdd.errorcode.-1")
        contextUtil.handleFailure(context, resultDict)
        return False, resultDict

    sysBayNum = ctrlEncNum
    daeType, diskEncModel = getExpansionDaeType(diskEncModelList, internalProductModel)
    contextUtil.setItem(context, "originDiskEncModel", diskEncModel)

    daeNumPerBay = EXP_DAE_SYM_BAY_PAIRS.get(daeType, {}).get(backendNetMode, {}).get('daeNumPerBay', 8)
    totalBay = EXP_DAE_SYM_BAY_PAIRS.get(daeType, {}).get(backendNetMode, {}).get('diskBayPerSysBay',
                                                                                  8) * sysBayNum + sysBayNum
    # OceanStor Dorado 18000 V6 NVMe型号6.1.5RC1以后内双活扩大规格,一个引擎支持2个硬盘柜
    if is_expansion_spec_dorado_dev(context):
        totalBay = 2 * sysBayNum + sysBayNum
    maxSupportDaeNum = totalBay * daeNumPerBay

    maxNewDiskEnc = maxSupportDaeNum - diskEncNum
    logger.logInfo("support add disk enclosure num:%s" % str(maxNewDiskEnc))
    logger.logInfo("original disk enclosure model:%s" % str(diskEncModel))
    logger.logInfo("daeEnclosureType:%s" % str(daeType))
    productModel = contextUtil.getItem(context, "productModel")
    support4UDiskEnclosure = \
        baseUtil.is_full_bay_support_4u(productModel, internalProductModel) and daeType == "SAS"
    contextUtil.setItem(context, "support4UDiskEnclosure",
                        support4UDiskEnclosure)
    contextUtil.setItem(context, "maxSupportNewDiskEncNum", maxNewDiskEnc)
    contextUtil.setItem(context, "daeEnclosureType", daeType)

    expandType = "expandDaeOrDiskBay"
    logger.logInfo("expandType:%s" % expandType)
    contextUtil.setItem(context, "expandType", expandType)

    return True, dict()


def initClsInfoForEnclosures(context, tlv):
    '''
    @summary: 初始化扩容硬盘框数据（主要为与扩硬盘柜存在的差异项）
    '''

    logger = getLogger(context.get("logger"), __file__)

    fullProductVersion = tlvUtil.getFullProductVersion(tlv, logger)
    logger.logInfo("fullProductVersion = " + fullProductVersion)
    contextUtil.setItem(context, 'fullProductVersion', fullProductVersion)

    # 扩容类型
    isDorado = contextUtil.getItem(context, "isDorado", False)
    logger.logInfo("isDorado:%s" % isDorado)
    expandType = "expandOnly2UDiskEnclosure"
    if isDorado:
        vrcVersion = getVRCVersion(fullProductVersion)
        logger.logInfo("vrcVersion is :" + vrcVersion)
        interModel = getInternalProductModel(context)
        logger.logInfo("InterProductModel:%s" % interModel)
        contextUtil.setItem(context, "interProductModel", interModel)

    logger.logInfo("expandType:%s" % expandType)
    contextUtil.setItem(context, "expandType", expandType)

    # 获取已有柜及对应的硬盘框框号和类型
    oldCabinetInfoDict = getCabinetInfoDict(context, tlv)
    logger.logInfo("oldCabinetInfoDict:%s" % str(oldCabinetInfoDict))
    contextUtil.setItem(context, "oldCabinetInfoDict", oldCabinetInfoDict)

    # 初始化为已有柜信息
    contextUtil.setItem(context, "newCabinetInfoDict", copy.deepcopy(oldCabinetInfoDict))

    # 已有机柜
    cabinetNames = contextUtil.getItem(context, "oldCabinetNames")
    # 具备扩容条件,且未进行扩容的所有柜
    contextUtil.setItem(context, "availableCabinets", cabinetNames)

    # 具备扩容条件,且为已选择了扩容配置的所有柜
    contextUtil.setItem(context, "selectedCabinets", [])

    # 具备扩容条件的所有柜
    contextUtil.setItem(context, "availableCabinetsGroup", cabinetNames)
    return


def initClsInfoForCabinets(context, tlv):
    """初始化扩容硬盘柜数据（主要为与扩硬盘框存在的差异项）

    :param context:
    :param tlv:
    :return:
    """
    logger = getLogger(context.get("logger"), __file__)

    # 扩容类型
    expandType = "expandDiskBay"
    logger.logInfo("expandType:%s" % expandType)
    contextUtil.setItem(context, "expandType", expandType)

    availableCabinets = getNewBayNames(context)
    # 具备扩容条件,且未进行扩容的所有柜
    logger.logInfo("availableCabinets:%s" % availableCabinets)
    contextUtil.setItem(context, "availableCabinets", availableCabinets)

    # 获取所有柜（已有柜和可扩展柜）及对应的硬盘框框号和类型
    oldCabinetInfoDict = getCabinetInfoDict(context, tlv)
    logger.logInfo("oldCabinetInfoDict:%s" % str(oldCabinetInfoDict))
    cabinetInfoDict = getNewCabinetInfoDict(context, oldCabinetInfoDict)
    logger.logInfo("newCabinetInfoDict:%s" % str(cabinetInfoDict))
    contextUtil.setItem(context, "oldCabinetInfoDict", cabinetInfoDict)

    # 初始化为已有柜信息
    contextUtil.setItem(context, "newCabinetInfoDict",
                        copy.deepcopy(cabinetInfoDict))

    # 具备扩容条件,且为已选择了扩容配置的所有柜
    contextUtil.setItem(context, "selectedCabinets", [])

    # 具备扩容条件的所有柜
    contextUtil.setItem(context, "availableCabinetsGroup", availableCabinets)
    return


def getNewCabinetInfoDict(context, oldCabinetInfoDict):
    '''
    @summary: 扩硬盘柜时，初始化可扩展柜的信息字典
    '''

    newCabinetInfoDict = oldCabinetInfoDict.copy()
    availableCabinets = contextUtil.getItem(context, "availableCabinets")
    for cabinetName in availableCabinets:
        cabinetId = getCabinetId(cabinetName)
        cabinetType = getCabinetType(cabinetName)
        enginId = getEnginId(cabinetName)
        cabinet = CABINET(cabinetId, cabinetName, cabinetType, enginId)
        newCabinetInfoDict[cabinetName] = cabinet

    return newCabinetInfoDict


def checkEnclosureSingleLink(tlv):
    '''
    @summary: 检查硬盘框B级联板单链路，即DAE999
    '''
    isPassed = True
    errorCabinets = set()
    cabinetRecords = tlvUtil.getBayRecords(tlv)
    cabinetDict = tlvUtil.getCabinetDict(cabinetRecords)
    encRecords = tlvUtil.getEnclosureRecords(tlv)
    for record in encRecords:
        parentId = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR["parentID"])
        cabinetName = cabinetDict.get(parentId, "")
        name = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR["name"])
        if "DAE999" in str(name):
            isPassed = False
            errorCabinets.add(cabinetName)
    errorCabinets = sorted(errorCabinets)  # 对柜名排序，用于界面错误信息显示
    return (isPassed, errorCabinets)


def checkMaxEnclosureConfig(context, tlv):
    '''
    @summary: 检查硬盘框是否满配，判断机柜空位是否放满
    '''
    logger = getLogger(context.get("logger"), __file__)
    enclosureRecords = tlvUtil.getEnclosureRecords(tlv)
    cteNum = 0
    daeNum = 0
    for record in enclosureRecords:
        logicType = tlvUtil.getRecordValue(record, tlvData.ENCLOSURE['logicType'])

        if logicType == tlvData.ENCLOSURE_TYPE_E["CTRL"]:
            cteNum += 1

        # 非硬盘框跳过
        if logicType != tlvData.ENCLOSURE_TYPE_E["EXP"]:
            continue
        daeNum += 1

    productModel = contextUtil.getItem(context, 'productModel')
    logger.logInfo("productModel = " + productModel)
    maxSupportDaeNum = get_max_support_disk_enc_num(context, cteNum, logger, productModel)

    logger.logInfo('maxSupportDaeNum:%s, current DAE number:%s' %
                   (maxSupportDaeNum, daeNum))
    if maxSupportDaeNum > daeNum:
        # 设置可扩容的硬盘框数
        contextUtil.setItem(context, "maxDaeNumToExp",
                            maxSupportDaeNum - daeNum)
    return daeNum >= maxSupportDaeNum


def get_max_support_disk_enc_num(context, cte_num, log, product_model):
    """
    获取最大支持的硬盘框数量
    @param context: 上下文
    @param cte_num: 控制框数量
    @param log: 日志
    @param product_model: 设备型号
    @return: 最大硬盘框数量
    """
    if not isDorado(product_model):
        return config.V5R8C00_MAX_DAE_NUM.get(product_model, 0)

    inter_model = contextUtil.getItem(context, "interProductModel")
    if not inter_model:
        inter_model = getInternalProductModel(context)
    log.logInfo("interModel = {}".format(inter_model))
    max_support_dae_num = config.DORADO_V6_SINGLE_ENG_MAX_DAE_NUM.get(inter_model, 0) * cte_num
    # 新融合5310/5510,6.1.5RC1以后 扩大了规格到
    product_version = contextUtil.getItem(context, "productVersion")
    if inter_model in config.NEW_DORADO_SINGLE_ENG_MAX_DAE_NUM and \
            Products.compareVersion(product_version, "6.1.5RC1") >= 0:
        max_support_dae_num = config.NEW_DORADO_SINGLE_ENG_MAX_DAE_NUM.get(inter_model, 0) * cte_num
    # OceanStor Dorado 18000 V6 NVMe型号6.1.5RC1以后扩扩大规格
    if is_expansion_spec_dorado_dev(context):
        max_support_dae_num = config.NEW_DORADO_SINGLE_ENG_MAX_DAE_NUM_AFTER_EXPANSION_SPEC.get(inter_model,
                                                                                                0) * cte_num

    # 二级存储OceanProtect X6000 1.5.RC1及以后扩大了规格
    if inter_model in config.OCEAN_PROTECT_SINGLE_ENG_MAX_DAE_NUM and \
            Products.compareVersion(product_version, "1.5.RC1") >= 0:
        max_support_dae_num = config.OCEAN_PROTECT_SINGLE_ENG_MAX_DAE_NUM.get(inter_model, 0) * cte_num
    return max_support_dae_num


def is_expansion_spec_dorado_dev(context):
    """
    判断是否为扩大规格的Dorado设备
    @param context: 上下文
    @return: True: 是 False：不是
    """
    product_model = contextUtil.getItem(context, "productModel")
    product_version = contextUtil.getItem(context, "productVersion")
    # 不是Dorado高端，返回False
    if not baseUtil.isDoradoV6HighEnd(product_model):
        return False
    # 不是共享组网，返回False
    if contextUtil.getItem(context, "backendNetMode") != "share":
        return False
    inter_model = contextUtil.getItem(context, "interProductModel")
    if not inter_model:
        inter_model = getInternalProductModel(context)
    # 如果是Dorado 18000 NVMe,且版本大于等于6.1.5RC1 则返回True
    if inter_model in config.NEW_DORADO_SINGLE_ENG_MAX_DAE_NUM_AFTER_EXPANSION_SPEC and \
            Products.compareVersion(product_version, "6.1.5RC1") >= 0:
        contextUtil.setItem(context, "is_exp_spec_dorado_dev", True)
        return True
    return False


def getCabinetType(cabinetName):
    '''
    @summary: 获取柜的类型，系统柜（SMB）,存储柜（DKB）
    '''
    cabinetName = str(cabinetName)
    return cabinetName[0:3]


def getCabinetPartitionNum(enclosureName):
    '''
    @summary: 根据框名称获取所在分区
    '''

    # 获取所在分区的首个硬盘框
    depth = enclosureName[-1]
    if depth >= '4':
        depth = '4'
    else:
        depth = '0'

    encFlag = enclosureName[-2] + depth  # 以分区首个硬盘框名称最后两位作为分区标识
    for partitionNum in CABINET_PARTITION_ENCLOSURE_DICT.keys():
        encFlagList = CABINET_PARTITION_ENCLOSURE_DICT[partitionNum]
        if encFlag in encFlagList:
            return partitionNum
    return


def getEnginId(cabinetName):
    '''
    @summary: 获取引擎编号，如SMB0，DKB0_0，第三位为引擎编号
    '''
    cabinetName = str(cabinetName)
    return cabinetName[3]


def getCabinetId(cabinetName):
    '''
    @summary: 根据柜名称获取柜的编号
    @description:1个系统柜可带5个存储柜，系统柜和存储柜的编号顺序是独立的，该方法对柜统一编号，
                系统柜为0号，存储柜按照已有顺序编号为1~5
    '''

    # 系统柜直接返回”0“
    if SYSTEM_CABINET in cabinetName:
        return "0"

    # 存储柜按照字典映射返回
    if STORAGE_CABINET in cabinetName:
        last = cabinetName[-1]
        return last

    return ""


def getCabinetInfoDict(context, tlv):
    '''
    @summary: 获取已有硬盘框，并映射为字典
            字典格式：
            {
                "柜号0"：柜对象,
                "柜号1"：柜对象,
                ...
            }
    '''
    logger = getLogger(context.get("logger"), __file__)
    cabinetInfoDict = {}
    cabinetDict = contextUtil.getItem(context, "cabinetDict")
    logger.logInfo("cabinetDict: %s" % str(cabinetDict))
    encRecords = tlvUtil.getEnclosureRecords(tlv)
    logger.logInfo("encRecords: %s" % str(encRecords))
    for record in encRecords:
        logicType = tlvUtil.getRecordValue(record, tlvData.ENCLOSURE['logicType'])
        if logicType != tlvData.ENCLOSURE_TYPE_E["EXP"]:
            continue

        parentId = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR["parentID"])
        cabinetName = cabinetDict.get(parentId, "")
        if not cabinetName:
            continue

        name = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR["name"])
        height = tlvUtil.getRecordValue(record, tlvData.ENCLOSURE["height"])
        partitionNum = getCabinetPartitionNum(name)
        logger.logInfo("enclosure name: %s, partition number:%s" % (name, partitionNum))
        cabinet = None
        logger.logInfo("cabinetName: %s" % cabinetName)
        if cabinetName not in cabinetInfoDict.keys():
            cabinetId = getCabinetId(cabinetName)
            cabinetType = getCabinetType(cabinetName)
            enginId = getEnginId(cabinetName)
            cabinet = CABINET(cabinetId, cabinetName, cabinetType, enginId)
            logger.logInfo("getCabinetInfoDict not exist: %s" % cabinetName)
        else:
            cabinet = cabinetInfoDict.get(cabinetName)
            logger.logInfo("getCabinetInfoDict exist: %s" % cabinetName)
        logger.logInfo("%s cabinet id %d" % (cabinetName, id(cabinet)))

        logger.logInfo("cabinetInfoDict: %s" % cabinetInfoDict)
        logger.logInfo("cabinetName: %s, enclosure name:%s" % (cabinet.name, name))
        cabinet.add_enclosure_to_partition((name, height), partitionNum)
        cabinetInfoDict[cabinetName] = cabinet
    return cabinetInfoDict


def isSameEnclosureModel(partitions):
    '''
    @summary: 判断分区的硬盘型号是否相同
    '''
    for key in partitions.keys():
        encList = partitions[key]
        if len(encList) == 0 or len(encList) == 1:
            continue

        firstEnclosureInfo = encList[0]
        firstEnclosureHeight = firstEnclosureInfo[1]
        for info in encList:
            if info[1] != firstEnclosureHeight:
                # 存在不同类型的硬盘框，返回False
                return False
    return True


def checkEnclosureModel(cabinetInfoDict):
    '''
    @summary: 判断机柜内同一分区的硬盘型号是否相同
    '''
    differentCabinetInfo = []
    isSame = True
    for cabinetName in cabinetInfoDict.keys():
        cabinet = cabinetInfoDict.get(cabinetName, None)
        if cabinet == None:
            continue

        partitions = cabinet.get_partitions()
        if not isSameEnclosureModel(partitions):
            isSame = False
            differentCabinetInfo.append(cabinetName)
            continue

    return (isSame, differentCabinetInfo)


def filterPartitions(partitions):
    '''
    @summary: 过滤柜中可放置硬盘框的分区：非空可放置硬盘框区，空闲区
    '''

    emptyPartitions = []
    noEmptyPartitions = []
    for pNum in partitions.keys():
        oldEnclosures = partitions.get(pNum, [])
        currentEncNum = len(oldEnclosures)
        # 获取空闲区
        if currentEncNum == 0:
            emptyPartitions.append(pNum)
            continue

        # 获取非空闲可放置区，判断是否为标准配置
        noEmptyPartitions.append(pNum)

    return (noEmptyPartitions, emptyPartitions)


def getUpperLimitOfNewEncs(context, cabinet, height, selectedHeight, selectedEncNum=0):
    '''
    @summary: 在非空闲可放置区/空闲区获取可扩的硬盘框数量
    @param cabinet: 柜对象
    @param height: 硬盘框高度（判断2U还是4U）
    @param selectedEncNum: 已选择框的数量（如：获取4U框上限数量时，需要知道已选定的2U框的数量）
    @param selectedHeight: 已选择框框类型,只支持2U框和4U框
    '''
    logger = getLogger(context.get("logger"), __file__)

    resultNum = 0
    selectedEncCount = 0  # 记录非当前框的数量
    partitions = cabinet.get_partitions()
    standardConfigNum = PARTITION_ENCLOSURE_CONFIG[str(height)]  # 单个分区标准配置的最大规格
    selectedConfigNum = PARTITION_ENCLOSURE_CONFIG[str(selectedHeight)]
    logger.logInfo("standardConfigNum:%s, selectedConfigNum:%d" % (standardConfigNum, selectedConfigNum))
    # 获取可放置硬盘框的分区
    (noEmptyPartitions, emptyPartitions) = filterPartitions(partitions)
    logger.logInfo("partitions:%s" % str(partitions))
    logger.logInfo("noEmptyPartitions:%s, emptyPartitions:%s" % (str(noEmptyPartitions), str(emptyPartitions)))
    # 在非空可放置区中，获取可放置当前类型框的数量，并记录可放置已选框的数量
    for pNum in noEmptyPartitions:
        oldEnclosures = partitions.get(pNum, [])
        currentEncNum = len(oldEnclosures)
        firstEnclosure = oldEnclosures[0]
        firstEncHeight = firstEnclosure[1]
        if firstEncHeight == height:
            remainNum = standardConfigNum - currentEncNum
            resultNum += remainNum
        else:
            remainNum = selectedConfigNum - currentEncNum
            selectedEncCount += remainNum
    logger.logInfo("In no empty partitions selectedEncCount:%s, resultNum:%d" % (str(selectedEncCount), resultNum))
    # 如果在非空可放置区中，空闲的框数量未满足已选框的数量，
    # 则排除已选框所占的分区后，剩余为可放置待选定框的分区，按照配置的框数量计算出支持该框的最大数
    if selectedEncCount < selectedEncNum:
        otherRemainNum = selectedEncNum - selectedEncCount
        remainPartitions = len(emptyPartitions) - math.ceil(otherRemainNum / (float)(selectedConfigNum))
        resultNum += remainPartitions * standardConfigNum
    else:
        # 在非空可放置区中，空闲的框数量已满足已选框的数量，则按照分区数量计算出支持待选框的最大数
        resultNum += len(emptyPartitions) * standardConfigNum

    return int(resultNum)


def getNewEncsInUsablePartitions(context, cabinet, requiredNum, height, usablePartitions, isNoEmptyPart=True):
    '''
    @summary: 在非空闲可放置区/空闲区获取可扩的硬盘框列表（名称，类型，所属柜）
    '''

    # 需求框的数量为0时，直接返回满足条件
    if requiredNum == 0:
        return (True, [])

    logger = context.get("logger")
    logger.info("usablePartitions:%s" % str(usablePartitions))
    encList = []
    count = 0  # 记录新框数量
    height = str(height)
    usablePartitions.sort()  # 对分区进行小到大排序，便于从下至上放置硬盘框
    cabinetName = cabinet.get_name()
    partitions = cabinet.get_partitions()
    standardConfigNum = PARTITION_ENCLOSURE_CONFIG[height]  # 单个分区标准配置的最大规格
    encType = ENC_TYPE[height]
    cabinetId = cabinet.get_id()
    enginId = cabinet.get_enginId()
    partitionInfo = CABINET_START_ENCLOSURE_DICT[cabinetId]

    # 便于生成新框的级联深度，非空闲可放置区在原有深度上加1，空闲分区从分区起始深度上加0（即包含分区起始框）
    startNum = 1
    if not isNoEmptyPart:
        startNum = 0

    for pNum in usablePartitions:

        oldEnclosures = partitions.get(pNum, [])
        oldEnclosures = sorted(oldEnclosures, key=lambda e: e[0], reverse=True)
        currentEncNum = len(oldEnclosures)
        remainEncNum = standardConfigNum - currentEncNum

        oldEnclosures = sorted(oldEnclosures, key=lambda x: x[0])
        # 非空可放置区根据已有框名生成新框信息
        if isNoEmptyPart:
            lastEnc = oldEnclosures[-1]
            lastEncName = lastEnc[0]
            lastEncHeight = str(lastEnc[1])
            # 框类型不一致跳过
            if lastEncHeight != height:
                continue

            startDepth = int(lastEncName[-1])  # 获取级联深度，框名最后一位，如取“DAE001”的“1”
            portNum = lastEncName[-2]  # SAS端口号
        else:
            startEnclosure = partitionInfo[int(pNum)]  # 起始框名称后两位
            startDepth = int(startEnclosure[-1])  # 起始框的级联深度，框名最后一位，用于生成编号
            portNum = startEnclosure[0]

        baseStartU = SAS_PORT_START_U[str(portNum)]
        for i in range(startNum, remainEncNum + startNum):
            depth = startDepth + i
            encName = "DAE%s%s%s" % (enginId, portNum, str(depth))
            startU = baseStartU + (depth % 4) * int(height)
            encList.append((encName, encType, startU, cabinetName))
            count += 1
            if count >= requiredNum:
                return (True, encList)

    return (False, encList)


def getNewEnclosures(context, cabinet, requiredNum, height):
    '''
    @summary: 获取可扩的硬盘框列表（名称，类型，所属柜）
    '''

    logger = context.get("logger")
    height = str(height)
    cabinetName = cabinet.get_name()
    partitions = cabinet.get_partitions()
    logger.info("cabinet's (%s) partitions:%s" % (cabinetName, str(partitions)))

    # 获取可放置硬盘框的分区
    (noEmptyPartitions, emptyPartitions) = filterPartitions(partitions)
    logger.info("cabinet's (%s) no empty partitions:%s" % (cabinetName, str(noEmptyPartitions)))
    logger.info("cabinet's (%s) empty partitions:%s" % (cabinetName, str(emptyPartitions)))
    # 先选择非空分区
    (isFill, encList) = getNewEncsInUsablePartitions(context, cabinet, requiredNum, height, noEmptyPartitions, True)

    # 如果在非空闲放置区的位置未达到要求，则放置空闲区
    remainNum = requiredNum - len(encList)
    if not isFill:
        (isFill, encListRet) = getNewEncsInUsablePartitions(context, cabinet, remainNum, height, emptyPartitions, False)
        encList.extend(encListRet)
    return encList


def initAllCabinetUnusedDiskEncInfo(context):
    """初始化各个柜的磁盘框信息。

    :param context:
    :return:
    """
    diskEncIdPostfixDic = {'below': ['00', '20', '40', '60', '08', '28', '48', '68'],
                           'above': ['80', 'A0', 'C0', 'E0', '88', 'A8', 'C8', 'E8'],
                           }
    diskEncStartUDic = {'below': [1, 3, 5, 7, 9, 11, 13, 15],
                        'above': [27, 29, 31, 33, 35, 37, 39, 41],
                        }

    allCabinetFreeDiskEncInfoDict = {}
    availableCabinetNames = contextUtil.getItem(context, 'oldCabinetNames', [])
    usedDiskEncIdSet = contextUtil.getItem(context, 'originDiskEncIdSet', set())

    logger = context.get("logger")
    logger.info('available cabinet names:%s' % (str(availableCabinetNames)))
    logger.info('used disk enclosure IDs:%s' % (str(usedDiskEncIdSet)))

    for cabinetName in availableCabinetNames:
        cabinetNum = cabinetName.split('SMB')[1].strip()
        diskIdPrefix = 'DAE%(cabinetNum)s' % {'cabinetNum': cabinetNum}
        halfBelowEncIdList = [diskIdPrefix + postFix for postFix in diskEncIdPostfixDic.get('below')]
        halfAboveEncIdList = [diskIdPrefix + postFix for postFix in diskEncIdPostfixDic.get('above')]
        belowUsedDiskEncNum = len(list(filter(lambda diskEncId: diskEncId in usedDiskEncIdSet, halfBelowEncIdList)))
        aboveUsedDiskEncNum = len(list(filter(lambda diskEncId: diskEncId in usedDiskEncIdSet, halfAboveEncIdList)))

        halfBelowEncIdAndLocTupList = zip(halfBelowEncIdList, diskEncStartUDic.get('below'))
        halfAboveEncIdAndLocTupList = zip(halfAboveEncIdList, diskEncStartUDic.get('above'))

        belowFreeDiskEncIdAndLocTupList = list(
            filter(lambda diskEncIdAndLocTup: diskEncIdAndLocTup[0] not in usedDiskEncIdSet,
                   halfBelowEncIdAndLocTupList))
        aboveFreeDiskEncIdAndLocTupList = list(
            filter(lambda diskEncIdAndLocTup: diskEncIdAndLocTup[0] not in usedDiskEncIdSet,
                   halfAboveEncIdAndLocTupList))
        allCabinetFreeDiskEncInfoDict[cabinetName] = {
            'below': list(zip(halfBelowEncIdList, diskEncStartUDic.get('below'))),
            'above': list(zip(halfAboveEncIdList, diskEncStartUDic.get('above')))}

        allCabinetFreeDiskEncInfoDict[cabinetName]['belowUsed'] = belowUsedDiskEncNum
        allCabinetFreeDiskEncInfoDict[cabinetName]['aboveUsed'] = aboveUsedDiskEncNum

        allCabinetFreeDiskEncInfoDict[cabinetName]['belowFree'] = [(encId, ENC_TYPE.get('2'), startU, cabinetName) for
                                                                   (encId, startU) in belowFreeDiskEncIdAndLocTupList]
        allCabinetFreeDiskEncInfoDict[cabinetName]['aboveFree'] = [(encId, ENC_TYPE.get('2'), startU, cabinetName) for
                                                                   (encId, startU) in aboveFreeDiskEncIdAndLocTupList]

    contextUtil.setItem(context, 'allCabinetDiskEncInfoDict', allCabinetFreeDiskEncInfoDict)

    logger.info('All cabinet disk enclosure info:%s' % str(allCabinetFreeDiskEncInfoDict))
    return


def getNewPurely2UEnclosures(context, cabinetName, requiredNum):
    """ 获取指定柜可以扩容的2U硬盘框信息。

    Dorado18000 V3 新扩容硬盘框分配算法：

            最大   实际个数   新增个数  z
        	   8	 Y		    (x+y+z)/2                                 上半框
    SMBx-------------------------------------------------------------------
              8	 X		    (x+y+z)/2 + (x+y+z)%2                     下半框


		算法：扩容后总框数：x+y+z, 上下分区平均框数：（x+y+z) / 2, 剩余：（x+y+z)%2
			  SMBx_上： 应该分得： (x+y+z)/2 			     = aboveShouldNum
			  SMBx_下： 应该分配： (x+y+z)/2 + (x+y+z)%2  = belowShouldNum

					if belowShouldNum <= x:
						SMB0_下分配：0
						SMB0_上分配：z
					else:
						SMB0_下分配： belowShouldNum - x
						SMB0_上分配： z - (belowShouldNum - x)
    :param context:
    :param cabinetName:
    :param requiredNum:
    :return:
    """
    logger = context.get("logger")
    sysCtrlNum = contextUtil.getItem(context, 'ctrlRecords', 4)
    allCabinetFreeDiskEncInfoDict = contextUtil.getItem(context, 'allCabinetDiskEncInfoDict', {})
    cabinetDiskInfoDict = allCabinetFreeDiskEncInfoDict.get(cabinetName, {})

    if sysCtrlNum <= 2:
        return cabinetDiskInfoDict.get('belowFree', [])[:requiredNum]

    belowUsedDiskEncNum = cabinetDiskInfoDict.get('belowUsed', 0)
    aboveUsedDiskEncNum = cabinetDiskInfoDict.get('aboveUsed', 0)

    newDiskEncTotNum = requiredNum + belowUsedDiskEncNum + aboveUsedDiskEncNum
    aveEncNum = newDiskEncTotNum / 2  # 每套设备规划的硬盘框个数.
    remainEncNum = newDiskEncTotNum % 2  # 第一套设备优先填满剩余框
    belowHalfShouldHave = aveEncNum + remainEncNum
    aboveHalfShouldHave = aveEncNum

    if belowHalfShouldHave <= belowUsedDiskEncNum:
        allocDiskEncList = cabinetDiskInfoDict.get('aboveFree', [])[:requiredNum]
    else:
        halfBelowAllocNum = belowHalfShouldHave - belowUsedDiskEncNum
        halfAboveAllocNum = aboveHalfShouldHave - aboveUsedDiskEncNum
        allocDiskEncList = cabinetDiskInfoDict.get('belowFree', [])[:halfBelowAllocNum] + \
                           cabinetDiskInfoDict.get('aboveFree', [])[:halfAboveAllocNum]

    logger.info('New disk enclosures to be allocated is:%s' % (str(allocDiskEncList)))
    return allocDiskEncList


def get2UEnclosuresForDorado18000(context, owningCtrl, requireNum):
    """获取指定柜可以扩容的2U硬盘框信息。
    :param context:
    :param owningCtrl:
    :param requireNum:
    :return:
    """
    logger = getLogger(context.get("logger"), __file__)
    diskEncExpConfDictList = contextUtil.getItem(context, 'allPosibleConfDictList', [])
    tgtConfList = filter(lambda conf: conf.get('owningCtrl') == owningCtrl, diskEncExpConfDictList)
    logger.logInfo('Owing ctrl:%s config list: %s' % (owningCtrl, str(tgtConfList)))
    if not tgtConfList:
        return []
    tgtConf = tgtConfList[0]
    ruleDict = tgtConf.get('ruleDict', {})
    if tgtConf.get('independentExp', True):
        return ruleDict.get('freeDiskEncList', [])[:requireNum]
    else:
        return get2UEnclosuresForSymmetricExp(ruleDict, requireNum)


def get2UEnclosuresForSymmetricExp(ruleDict, requireNum):
    """获取指定归属控制器（2套设备）可以扩容的2U硬盘框信息。
    Dorado18000 V3 新扩容硬盘框分配算法：
            最大   实际个数   新增个数  z
               8	 y		    (x+y+z)/2                              引擎2
    -------------------------------------------------------------------
              8	    x		    (x+y+z)/2                              引擎1
        算法：扩容后总框数：x+y+z, 上下分区平均框数：（x+y+z) / 2,
              引擎1： 应该分得： (x+y+z)/2  = aveEncNum
              引擎2： 应该分配： (x+y+z)/2  = aveEncNum
                    if aveEncNum <= x:
                        引擎1：0
                        引擎2：z
                    else:
                        引擎1： aveEncNum - x
                        引擎2： aveEncNum - y
    :param ruleDict: 
    :param requireNum: 
    :return: 
    """
    freeDiskEncList1 = ruleDict.get('freeDiskEncList1', [])
    freeDiskEncList2 = ruleDict.get('freeDiskEncList2', [])
    usedNum1 = 8 - len(freeDiskEncList1)
    usedNum2 = 8 - len(freeDiskEncList2)
    newDiskEncTotNum = requireNum + usedNum1 + usedNum2
    aveEncNum = newDiskEncTotNum / 2  # 每套引擎扩容后实际规划的硬盘框个数.

    if aveEncNum <= usedNum1:  # 第一个引擎已有框个数大于等于平均框数（对称规划框个数），则新框数应该从第二个引擎划分。
        allocDiskEncList = freeDiskEncList2[:requireNum]
    elif aveEncNum <= usedNum2:  # 新框数应该从第一个引擎划分。
        allocDiskEncList = freeDiskEncList1[:requireNum]
    else:  # 新框数应该从两个引擎划分。
        allocNum1 = aveEncNum - usedNum1
        allocNum2 = aveEncNum - usedNum2
        allocDiskEncList = freeDiskEncList1[:allocNum1] + freeDiskEncList2[:allocNum2]
    return allocDiskEncList


def verifyConfigForDorado(context):
    """验证是否选择扩容配置信息，条件：2U框数量数量不能为0，相同的归属控制器不能重复选择。
    :param context:
    :return:
    """
    errorRows = []
    errorOwningCtrls = set()
    checkedOwningCtrls = []
    verifyFlag = True
    selectedConfig = contextUtil.getItem(context, "selectedConfig")  # 初始化扩容配置信息
    logger = getLogger(context.get("logger"), __file__)
    logger.logInfo('SelectedConfig:%s' % selectedConfig)
    if len(selectedConfig) == 0:
        return False, [], []

    isDorado18000 = contextUtil.getItem(context, 'isDorado18000', False)
    for rowKey in selectedConfig:
        rowConfigInfo = selectedConfig.get(rowKey)
        owingCtrl = rowConfigInfo.get("owningCtrl")
        enc2UNum = len(rowConfigInfo.get("newEnc2UList", [])) if isDorado18000 else rowConfigInfo.get("newEnc2UNum", 0)

        if enc2UNum == 0 or owingCtrl in checkedOwningCtrls:
            verifyFlag = False
            errorRows.append(rowKey)
            errorOwningCtrls.add(owingCtrl)

        checkedOwningCtrls.append(owingCtrl)

    errorOwningCtrls = sorted(errorOwningCtrls)
    return verifyFlag, errorRows, errorOwningCtrls


def checkOwningCtrlConfigured(context, rowId, owingCtrl):
    """验证当前归属控制器是否已经进行扩框配置
    :param context:
    :param rowId:
    :param owingCtrl:
    :return:
    """
    selectedConfig = contextUtil.getItem(context, "selectedConfig", {})
    if rowId in selectedConfig:
        return False
    allSelectedOwningCtrlList = contextUtil.getItem(context, "selectedOwingCtrls", [])
    return owingCtrl in allSelectedOwningCtrlList


def createEncGraphInfo(context):
    """ 生成绘制硬盘框设备图的基本信息

    :param context:
    :return:
    """
    logger = getLogger(context.get("logger"), __file__)
    encGraphInfoList = []
    sortList = contextUtil.getItem(context, "newEnc4UList", [])[:]
    sortList += contextUtil.getItem(context, "newEnc2UList", [])
    sortList += contextUtil.getItem(context, "newEnc2UNVMeList", [])

    logger.logInfo("new enclosures:%s" % str(sortList))
    for iSort in sortList:
        logger.logInfo("iSort:%s" % str(iSort))

        encName = iSort[0]
        encType = iSort[1]
        startU = iSort[2]
        bayName = iSort[3]

        encGraphInfo = {}
        encGraphInfo["name"] = encName
        encGraphInfo["type"] = encType
        encGraphInfo["startU"] = startU
        encGraphInfo["bay"] = bayName
        encGraphInfoList.append(encGraphInfo.copy())

    return encGraphInfoList


def createBaysGraph(bayNameList):
    """绘制指定数量的机柜

    :param bayNameList: 柜名列表
    :return:
    """
    if not bayNameList:
        return []

    bayInfoList = []

    for bayName in bayNameList:
        infoDict = {}
        infoDict["typeName"] = 'BAY'
        infoDict["id"] = bayName
        infoDict["name"] = bayName
        infoDict["location"] = ''
        infoDict["oldLoaction"] = ''
        infoDict["modelName"] = ''
        infoDict["parentId"] = 'None'
        infoDict["parentType"] = '0'
        infoDict["healthStatus"] = '0'
        infoDict["runningStatus"] = '0'
        infoDict["startU"] = ''
        infoDict["heightU"] = ''
        infoDict["logicTypeName"] = ""
        infoDict["currentPeerId"] = "--"
        infoDict["suggestPeerId"] = "--"

        bayInfoList.append(infoDict.copy())

    return bayInfoList


def createEncGraphInfoForDoradoV6HighEnd(context):
    """生成绘制硬盘框设备图的基本信息

    :param context:
    :return:
    """
    logger = getLogger(context.get("logger"), __file__)
    encGraphInfoList = []
    sortList = contextUtil.getItem(context, "doradoV6HighEndNewDaes")[:]
    diskEncModel = contextUtil.getItem(context, "originDiskEncModel")
    logger.logInfo("new enclosures:%s" % str(sortList))
    count = 0  # 辅助生成唯一id
    for dae in sortList:
        count += 1
        logger.logInfo("dae:%s" % str(dae))
        encName = dae.name
        startU = dae.locationU
        bayName = dae.bayName
        height = ENCLOSURE_HEIGHT.get(diskEncModel, 2)

        encGraphInfo = {}
        encGraphInfo["id"] = str(time.time() + count)
        encGraphInfo["name"] = encName
        encGraphInfo["type"] = diskEncModel
        encGraphInfo["startU"] = str(startU)
        encGraphInfo["bay"] = bayName
        encGraphInfo["typeName"] = 'ENCLOSURE'

        location = '%s.%sU' % (bayName, str(startU))
        encGraphInfo["location"] = location
        encGraphInfo["oldLoaction"] = location
        encGraphInfo["modelName"] = ENCLOSURE_MODEL.get(diskEncModel, '')
        encGraphInfo["parentId"] = bayName
        encGraphInfo["parentType"] = '205'
        encGraphInfo["healthStatus"] = '0'
        encGraphInfo["runningStatus"] = '0'
        encGraphInfo["startU"] = str(startU)
        encGraphInfo["heightU"] = str(height)
        encGraphInfo["logicTypeName"] = "EXP"
        encGraphInfo["currentPeerId"] = "--"
        encGraphInfo["suggestPeerId"] = "--"

        encGraphInfoList.append(encGraphInfo.copy())

    return encGraphInfoList


def isExpandCtrlFinished(context):
    '''
    @summary: 检查扩容系统柜是否完成
    '''
    abnormalCtrls = []
    tlv = contextUtil.getTlv(context)
    records = tlvUtil.getControllerRecords(tlv)
    for record in records:
        ctrlId = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR["id"])
        runningStatus = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR["runningStatus"])
        if runningStatus == tlvData.RUNNING_STATUS_E["EXPANSION"]:
            abnormalCtrls.append(ctrlId)

    if len(abnormalCtrls) != 0:
        return (False, abnormalCtrls)
    return (True, [])


def getSMBsAndDiskBays(context):
    '''
    @summary: 获取已有系统柜，硬盘柜
    '''
    smbs = []
    diskBays = []
    bayNames = contextUtil.getItem(context, "oldCabinetNames")
    for bay in bayNames:
        if bay.startswith("SMB"):
            smbs.append(bay)
        else:
            diskBays.append(bay)
    smbs.sort(cmp=None, key=None, reverse=False)
    diskBays.sort(cmp=None, key=None, reverse=False)
    return (smbs, diskBays)


def getNewBayNames(context):
    """计算扩容规格，获取可扩容柜的name列表

    :param context:
    :return:
    """
    (smbs, diskBays) = getSMBsAndDiskBays(context)
    # 后端组网类型：SAS, SMART
    dae_type = contextUtil.getItem(context, "daeEnclosureType")
    # 是否F系列
    product_model = contextUtil.getItem(context, "productModel")
    is_f_series = baseUtil.is_f_series_product(product_model)
    # H3/H10槽位可以用于后端接口卡的数量
    available_slots_num = contextUtil.getItem(context,
                                              "available_slots_num", 0)
    # 是否需要跳过特殊柜编号
    need_to_skip_special_dkb = (not is_f_series
                                and dae_type == "SMART"
                                and available_slots_num == 0)
    # 每个系统柜最大支持的硬盘柜数量
    max_disk_bay_per_sys = get_max_bay_conf(context)
    newDiskBays = []
    for smb in smbs:
        newDiskBays.append(smb)
        # 硬盘柜的序号是从0开始编号
        engId = smb[-1]  # 系统柜编号的最后一位为当前系统的引擎号
        for index in range(0, max_disk_bay_per_sys):
            # 跳过特殊硬盘柜号4和10
            if need_to_skip_special_dkb and index in [4, 10]:
                continue
            bayId = "DKB" + engId + '_' + str(index)
            newDiskBays.append(bayId)

    # 所有可以扩的柜
    all_available_bays = newDiskBays[:]
    # 每柜最大2U框个数
    max_disk_2u_enc_per_bay = MAX_DISK_ENC_PER_BAY.get(dae_type)

    origin_enc_2u_list = contextUtil.getItem(context, "origin_enc_2u_list", [])
    origin_enc_4u_list = contextUtil.getItem(context, "origin_enc_4u_list", [])

    for bay_name in newDiskBays:
        enc_2u_on_bay = len([enc_2u for enc_2u in origin_enc_2u_list
                             if enc_2u.startswith(bay_name)])
        enc_4u_on_bay = len([enc_4u for enc_4u in origin_enc_4u_list
                             if enc_4u.startswith(bay_name)])
        # 去掉已经满配的柜
        if enc_2u_on_bay + enc_4u_on_bay * 2 >= max_disk_2u_enc_per_bay:
            all_available_bays.remove(bay_name)
    return all_available_bays


def get_max_bay_conf(context):
    """获取当前系统每个系统柜支持的最大硬盘柜数量

    :param context: 上下文
    :return:
    """
    # 后端组网类型： SAS, SMART
    dae_type = contextUtil.getItem(context, "daeEnclosureType")
    # 最大级联深度
    sas_depth = contextUtil.getItem(context, "deepth")
    smart_depth = contextUtil.getItem(context, "smart_depth")
    depth = str(smart_depth) if dae_type == "SMART" else str(sas_depth)
    return MAX_DISK_BAY_PER_SYS.get(dae_type, {}).get(depth)


def isMaxBaysConfig(context):
    '''
    @summary: 检查硬盘柜是否满配
    '''
    (smbs, diskBays) = getSMBsAndDiskBays(context)
    totalDiskBays = len(smbs) * MAX_DISK_BAYS_PER_SYS_BAY
    if len(diskBays) >= totalDiskBays:
        return True

    return False


def getNewCabinetInfoFor2UEnc(context, enc2UList, cabinetName):
    '''
    @summary: 选定2U硬盘框后生成新的柜信息，用于生成新增4U框的信息
    @param enc2UList:新增2U硬盘框的信息，格式为:[(框名称，类型，起始位置，所属柜)] 
    '''

    oldCabinetInfoDict = contextUtil.getItem(context, "oldCabinetInfoDict")
    copyCabinetInfoDict = copy.deepcopy(oldCabinetInfoDict.copy())
    newCabinetInfoDict = contextUtil.getItem(context, "newCabinetInfoDict")
    cabinet = copyCabinetInfoDict.get(cabinetName)
    # 未选定2U框则返回原有柜信息
    if len(enc2UList) == 0:
        newCabinetInfoDict[cabinetName] = cabinet
        return newCabinetInfoDict

    for encInfo in enc2UList:
        encName = encInfo[0]
        partitionNum = getCabinetPartitionNum(encName)
        cabinet.add_enclosure_to_partition((encName, 2), partitionNum)

    newCabinetInfoDict[cabinetName] = cabinet
    return newCabinetInfoDict


def verifyConfig(context):
    '''
    @summary: 验证是否选择扩容配置信息，条件：2U框数量和4U框数量不能全为0，两个及以上相同机柜不能同时配置
    @return: 返回验证失败的行号，用于界面标记
    '''
    errorRows = []
    errorCabinets = set()
    checkedCabinets = []
    verifyFlag = True
    selectedConfig = contextUtil.getItem(context, "selectedConfig")  # 初始化扩容配置信息
    # 未添加任何信息时不通过。
    if len(selectedConfig.keys()) == 0:
        return (False, [], [])

    for rowKey in selectedConfig.keys():
        rowConfigInfo = selectedConfig.get(rowKey)
        cabinetName = rowConfigInfo.get("cabinetName")
        enc2UNum = len(rowConfigInfo.get("newEnc2UList", []))
        enc2UNVMeNum = len(rowConfigInfo.get("newEnc2UNVMeList", []))
        enc4UNum = len(rowConfigInfo.get("newEnc4UList", []))
        totalNum = enc2UNum + enc4UNum + enc2UNVMeNum
        if totalNum == 0 or cabinetName in checkedCabinets:
            verifyFlag = False
            errorRows.append(rowKey)
            errorCabinets.add(cabinetName)
        checkedCabinets.append(cabinetName)
    errorCabinets = sorted(errorCabinets)
    return (verifyFlag, errorRows, errorCabinets)


def checkSameCabinetCofig(context, cabinetName):
    '''
    @summary: 验证当前机柜是否已经进行扩容配置
    '''
    selectedCabinets = contextUtil.getItem(context, "selectedCabinets")
    if cabinetName in selectedCabinets:
        return False
    return True


def checkAluaStatus(cli, lang):
    '''
    @summary: 检查ALUA功能是否关闭
    @param cli: cli对象
    @param lang: 语言lang
    @return: 以字典形式返回结果 
        flag: 
            True: 获取成功
            False: 获取失败
        errMsg: 错误消息
        suggestion: 修复建议
        ret: 开启ALUA功能的部件列表
    '''
    result = {"flag": True, "errMsg": "", "suggestion": "", "ret": None}

    # FC
    cmd_FC = "show initiator initiator_type=FC"
    checkRet_FC = cliUtil.execCmdInCliMode(cli, cmd_FC, True, lang)
    if not checkRet_FC[0]:
        return getSysAbnormalRet(checkRet_FC, lang)
    cliRet_FC = checkRet_FC[1]
    cliRetList_FC = cliUtil.getHorizontalCliRet(cliRet_FC)

    # iSCSI
    cmd_iSCSI = "show initiator initiator_type=iSCSI"
    checkRet_iSCSI = cliUtil.execCmdInCliMode(cli, cmd_iSCSI, True, lang)
    if not checkRet_iSCSI[0]:
        return getSysAbnormalRet(checkRet_iSCSI, lang)
    cliRet_iSCSI = checkRet_iSCSI[1]
    cliRetList_iSCSI = cliUtil.getHorizontalCliRet(cliRet_iSCSI)

    # IB
    cmd_IB = "show ib_initiator general"
    checkRet_IB = cliUtil.execCmdInCliMode(cli, cmd_IB, True, lang)
    if not checkRet_IB[0]:
        return getSysAbnormalRet(checkRet_IB, lang)
    cliRet_IB = checkRet_IB[1]
    cliRetList_IB = cliUtil.getHorizontalCliRet(cliRet_IB)

    multipathTypeList = []
    for lineDict in cliRetList_FC:
        multipathTypeList.append(lineDict["Multipath Type"])
    for lineDict in cliRetList_iSCSI:
        multipathTypeList.append(lineDict["Multipath Type"])
    for lineDict in cliRetList_IB:
        multipathTypeList.append(lineDict["Multi Path Type"])

    result["ret"] = multipathTypeList
    return result


def sortBayNames(bayNameList):
    '''
    @summary: 按照标准柜名称进行排序（系统柜0，硬盘柜0_1，硬盘柜0_2，硬盘柜0_3，...，系统柜1，硬盘柜1_1，...）
    '''

    # 先按照小到大排序，排序结果硬盘柜在前，系统柜在后
    bayNameList = sorted(bayNameList)
    bayNameListLen = len(bayNameList)

    # 已系统柜为分割点，截取前方为硬盘柜有序列表，截取后方为系统柜列表
    for index in range(bayNameListLen):
        bayName = bayNameList[index]
        if bayName.startswith("SMB"):
            dkbList = bayNameList[0:index]
            smbList = bayNameList[index:]
            break

    # 排序：按照系统柜的顺序，每个系统柜后面有序插入其所属的硬盘柜
    # 系统柜和硬盘柜的引擎号一致则为同一系统柜下的柜。
    resultList = []
    for smb in smbList:
        resultList.append(smb)
        engId = smb[3]
        for dkb in dkbList:
            if engId != dkb[3]:
                break
            resultList.append(dkb)

    return resultList


def getScaleOutIntfModuleList(tlv, ctrlHeight):
    '''
    @summary: 检查接口卡
    @param tlv: tlv对象
    @param ctrlHeight: 框Sn高
    @return: 以列表形式返回结果 
    '''
    records = tlvUtil.getInterfaceModuleRecords(tlv)
    if records == None:
        return []
    smartIoIntfModuleList = []
    for record in records:
        intfModuleID = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR['id'])
        if not isScaleOutIntfModule(intfModuleID, ctrlHeight):
            continue

        scaleOutIntfModuleInfo = {}
        scaleOutIntfModuleInfo["id"] = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR['id'])
        scaleOutIntfModuleInfo["location"] = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR['location'])
        scaleOutIntfModuleInfo["model"] = tlvUtil.getRecordValue(record, tlvData.INTF_MODULE['model'])
        scaleOutIntfModuleInfo["runMode"] = tlvUtil.getRecordValue(record, tlvData.INTF_MODULE['runMode'])
        scaleOutIntfModuleInfo["healthStatus"] = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR['healthStatus'])
        scaleOutIntfModuleInfo["runningStatus"] = tlvUtil.getRecordValue(record, tlvData.PUB_ATTR['runningStatus'])

        smartIoIntfModuleList.append(scaleOutIntfModuleInfo.copy())
    return smartIoIntfModuleList


def isScaleOutIntfModule(intfModuleID, ctrlHeight):
    '''
    @summary: 判断接口卡是否能用于ScaleOut扩容
              1.2U设备，ScaleOut卡固定在1号槽位；
              2.3U/6U设备，ScaleOut卡固定在3号槽位。
    @param intfModuleID: 接口卡ID
    @param ctrlHeight: 框高，用于区分2U\3U\6U等设备
    '''
    if len(intfModuleID) < 3:
        return False

    intfModuleSlot = intfModuleID[-3:]
    if ctrlHeight == 2 and intfModuleSlot in ["A.1", "B.1", "C.1", "D.1"]:
        return True

    if ctrlHeight in [3, 6] and intfModuleSlot in ["A.3", "B.3", "C.3", "D.3"]:
        return True

    return False


def checkSingleModel(tlv):
    '''
    @summary: 检查系统模式为单控模式
    '''
    sysConfigModel = tlvUtil.getSysConfigModel(tlv)
    if sysConfigModel == SINGLE_CTRL:
        return True
    return False


def checkBayCofigConsistent(ctrlNum, bayConfigCtrlNum, tlv):
    '''
    @summary: 检查控制器数量和配置中的控制器数量是否一致，单扩双场景不检查
    '''
    if checkSingleModel(tlv):
        return True

    if ctrlNum < bayConfigCtrlNum:
        return False

    return True


def isExistDiskDomain(cli, lang):
    '''
    @summary: 检查当前集群是否存在storage pool
    '''
    cmd = 'show disk_domain general'
    poolInfoRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)

    cliRet = poolInfoRet[1]
    if poolInfoRet[0] != True:
        return (False, cliRet, poolInfoRet[2], None)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, "", False)

    cliRetList = cliUtil.getHorizontalCliRet(cliRet)
    if len(cliRetList) == 0:
        return (False, cliRet, "", None)

    return (True, cliRet, "", True)


def isDefaultMgmtIP(cli, lang):
    '''
    @summary: 检查当前集群管理IP是否为默认IP
    '''

    cmd = 'show port general physical_type=ETH logic_type=Management_Port'
    mgmtIPInfoRet = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    cliRet = mgmtIPInfoRet[1]
    if not mgmtIPInfoRet[0]:
        return (False, cliRet, mgmtIPInfoRet[2], None)

    mgmtIPInfoList = cliUtil.getHorizontalCliRet(cliRet)
    if len(mgmtIPInfoList) == 0:
        return (False, cliRet, "", None)

    ipv4AddrKey = "IPv4 Address"
    for mgmtIPInfo in mgmtIPInfoList:
        if not mgmtIPInfo.has_key(ipv4AddrKey):
            return (False, cliRet, "", None)
        if mgmtIPInfo.get(ipv4AddrKey) in config.DEFAULT_MGMT_IP:
            return (True, cliRet, "", True)

    return (True, cliRet, "", False)


def isIllegalInnterNetIpAddr(ipAddr, innterNetIpPrefix):
    '''
    @summary: 校验内部基地址IP是否合法
    @param ipAddr: 内部基地址IP
    @return: 
        True: 基地址IP合法
        False: 基地址IP不合法
    '''
    addrs = ipAddr.split(".")
    if len(addrs) != 4:
        return False

    innterNet0IpAddrs = []
    for ipSeg in addrs:
        if not isPureDigit(ipSeg):
            return False
        innterNet0IpAddrs.append(int(ipSeg))

    if not ipAddr.startswith(innterNetIpPrefix):
        return False

    if config.INNTER_IP_RANGE_BEGIN <= innterNet0IpAddrs[3] <= config.EXCLUDE_IP_RANGE_BEGIN - config.NODE_MAX or \
            config.EXCLUDE_IP_RANGE_END < innterNet0IpAddrs[3] <= config.INNTER_IP_RANGE_END:
        return True

    return False


def checkInnterNetIpAddr(netSeg, netIpAddr, prefixNetIp, lang):
    '''
    @summary: 校验是否为合法的基地址IP
    '''

    resultDict = {"flag": True, "errMsg": "", "suggestion": ""}

    if not isIllegalInnterNetIpAddr(netIpAddr, prefixNetIp):
        resultDict["flag"] = False
        resultDict["errMsg"], resultDict["suggestion"] = getMsg(lang, "innter.net.addr.invalid",
                                                                (netSeg, prefixNetIp, config.INNTER_IP_RANGE))
        return resultDict

    return resultDict


def getNodeBayIdByEam(bayIdInfo, board):
    '''
    @summary: 获取指定节点的BayID
    @param bayIdInfo：所有节点BayID信息 
           board: 节点信息
    @return: 
           bayID: 指定节点BayID
    '''
    return bayIdInfo.get(board["enclosureSN"])


def needConfigGESwitchForPCIe(controllerNum, ctrlEnclosureHeight):
    '''
    @summary: PCIe Scalout时判断是否需要配置交换机
    '''
    if controllerNum == 2 and ctrlEnclosureHeight == 2:
        return True
    return False


def getPCIeSwitchPortGroupBySN(PCIePortInfoList, boardsList, ctrlHeight):
    '''
    @summary: 获取指定节点PCIe交换机端口按照enClosureSN分组
    '''
    boardsEnclosureSNList = []
    for board in boardsList:
        boardsEnclosureSNList.append(board['enclosureSN'])
    PCIeSwitchPortGroupBySN = {}
    ctrlIdAndPortMarkTodswPortIndexGroupBySN = {}
    PCIeSwitchPortGroupSpec = ['0-0', '0-1', '1-0', '1-1']
    if ctrlHeight == 6:
        PCIeSwitchPortGroupSpec = ['0-0', '0-1', '1-0', '1-1', '2-0', '2-1', '3-0', '3-1']

    for PCIePortInfo in PCIePortInfoList:
        enClosureSN = PCIePortInfo['enclosureSN']
        ctrlId = str(PCIePortInfo['ctrlId'])
        dswPortIndex = str(PCIePortInfo['dswPortIndex'])
        portMark = PCIePortInfo['portMark']

        if not ctrlIdAndPortMarkTodswPortIndexGroupBySN.has_key(enClosureSN) and enClosureSN in boardsEnclosureSNList:
            ctrlIdAndPortMarkTodswPortIndexGroupBySN[enClosureSN] = {'%s-%s' % (ctrlId, portMark): tuple(dswPortIndex)}
        elif enClosureSN in boardsEnclosureSNList:
            ctrlIdAndPortMarkTodswPortIndexGroupBySN[enClosureSN]['%s-%s' % (ctrlId, portMark)] = tuple(dswPortIndex)

    for enClosureSN in ctrlIdAndPortMarkTodswPortIndexGroupBySN.keys():
        PCIeSwitchPortGroup = tuple()
        for ctrlIdAndPortMark in PCIeSwitchPortGroupSpec:
            PCIeSwitchPortGroup += ctrlIdAndPortMarkTodswPortIndexGroupBySN[enClosureSN].get(ctrlIdAndPortMark, ())

        PCIeSwitchPortGroupBySN[enClosureSN] = PCIeSwitchPortGroup
    return PCIeSwitchPortGroupBySN


def setSpecialMsgInfo(cli, lang, logger):
    '''
    #针对V3R3C20以后版本的资料归一问题
    '''

    version = ''
    ret = cliUtil.getProductVersion(cli, lang)
    if ret[0]:
        version = getVRCVersion(ret[1])

    value = ''
    key = config.SPECIAL_MSG_KEY
    if 'V300R005C00' in version:
        value = config.SPECIAL_MSG_VALUE
    elif version in config.SPECIAL_Dorado_VER:
        value = config.SPECIAL_Dorado_MSG_VALUE

    logger.logNoPass("setSpecialMsgInfo version:%s, value:%s" % (version, value))
    toolConfigUtil.setInfo(key, value)
    return


def isExistHighDensityEnc(context):
    logger = getLogger(context.get("logger"), __file__)
    tlv = contextUtil.getTlv(context)

    isExist = False
    highDensityEncList = []

    recs = tlvUtil.getEnclosureRecords(tlv)
    if len(recs) == 0:
        return isExist, highDensityEncList

    for rec in recs:
        model = tlvUtil.getRecordValue(rec, tlvData.ENCLOSURE['model'])
        name = tlvUtil.getRecordValue(rec, tlvData.PUB_ATTR["name"])
        if model == tlvData.ENCLOSURE_MODEL_E["EXPSAS4U_75"]:
            isExist = True
            highDensityEncList.append(name)

    logger.logInfo("The High-Density Disk Enc list is %s." % str(highDensityEncList))
    return isExist, highDensityEncList


def getUnmatchCompliance10TNlsasDisk(context, encLocList, diskRecs):
    logger = getLogger(context.get("logger"), __file__)
    nlsasDiskList = []
    for rec in diskRecs:
        location = tlvUtil.getRecordValue(rec, tlvData.PUB_ATTR["location"])
        encId = location.split(".")[0]
        if encId not in encLocList:
            continue

        diskType = tlvUtil.getRecordValue(rec, tlvData.DISK["diskType"])
        if diskType != tlvData.DISK_TYPE_E["NL_SAS"]:
            continue

        sectorSize = tlvUtil.getRecordValue(rec, tlvData.DISK["sectorSize"])
        sectors = tlvUtil.getRecordValue(rec, tlvData.DISK["sectors"])

        unit = 1024
        TB = unit ** 4
        capacity = round(float(sectors * sectorSize) / TB, 2)
        if capacity >= 8.7 and capacity <= 9.3:
            nlsasDiskList.append(location)

    logger.logInfo("The uncompliance NL_SAS Disk list is %s." % str(nlsasDiskList))
    return nlsasDiskList


def getProductModelByDev(context, productModel):
    logger = getLogger(context.get("logger"), __file__)
    try:
        isOem = contextUtil.isOem(context)
        if isOem:
            productModel = contextUtil.getOemProductModel(context)
        return productModel
    except Exception as exception:
        logger.logInfo("exception:%s" % str(exception))
        return productModel


def showUITarget(context, curProgressPer, remainTime):
    if curProgressPer < 0 or curProgressPer > 100:
        curProgressPer = 100

    if remainTime < 0:
        remainTime = 0

    event = context.get('event')
    if curProgressPer == 100 and event:
        event.wait()

    context["curProgressPer"] = curProgressPer
    context["remainTime"] = remainTime
    return


def showUI(context, curProgressPer, remainTime):
    threading.Thread(target=showUITarget, args=(context, curProgressPer, remainTime)).start()


def isOverAreaHeight(context):
    '''
    @summary: 校验当前级联框是否超过域的高度，四级交流场景8U一个域，例如4U框可级联4个。
    '''
    areaHeight = 8
    errEnclosureList = []
    logger = getLogger(context.get("logger"), __file__)

    cabinetInfoDict = contextUtil.getItem(context, "oldCabinetInfoDict")
    for (cabinetName, cabinet) in cabinetInfoDict.items():
        partitons = cabinet.get_partitions()
        logger.logInfo("[isOverAreaHeight]cabinetName: %s, partitons: %s." % (str(cabinetName), str(partitons)))
        for encloList in partitons.values():
            encloList = sorted(encloList, key=lambda e: e[0])
            partHeight = 0
            for enclosure in encloList:
                partHeight += enclosure[1]
                if partHeight > areaHeight:
                    errEnclosureList.append(enclosure[0])
    errEnclosureList = sorted(errEnclosureList)
    return errEnclosureList


def getBaseIPAddr(records):
    baseIpAddrList = []
    for record in records:
        baseIpAddr = commonRestUtil.getRecordValue(record, commonRestData.BaseAddr.BASE_ADDR)
        baseIpAddrList.append(baseIpAddr)
    return baseIpAddrList[0]


def handleCtrlExpFlowItems(context, dataDict, errDict):
    """根据查询记录（扩控流程记录）解析查询结果（扩控执行项）。

    :param dataDict:
    :return:
    """
    restErrCode = int(commonRestUtil.getRecordValue(errDict, commonRestData.ErrorInfo.CODE))

    expErrCodeStr = commonRestUtil.getRecordValue(dataDict, commonRestData.ScaleOut.ERRCODE)

    curCtrlExpStep = commonRestUtil.getRecordValue(dataDict, commonRestData.ScaleOut.CUR_STEP)
    curCtrlExpStepRemainMins = int(commonRestUtil.getRecordValue(dataDict, commonRestData.ScaleOut.REMAIN_TIME)) / 60
    ctrlExpFlowState = int(commonRestUtil.getRecordValue(dataDict, commonRestData.ScaleOut.STATE))
    ctrlPowerStep = commonRestUtil.getRecordValue(dataDict, commonRestData.ScaleOut.POWERSTEP)
    # 单独记录步骤，用于重试时的判断
    contextUtil.setItem(context, "preExecuteExpStep", curCtrlExpStep)

    return curCtrlExpStep, curCtrlExpStepRemainMins, ctrlExpFlowState, ctrlPowerStep, restErrCode, expErrCodeStr


def getConfigBaseIP(tlv, fullProductVersion, bayConfigRecord, productModel):
    vrcVersion = getVRCVersion(fullProductVersion)
    if vrcVersion >= config.SUPPORT_DOUBLE_INNER_IP and isDorado(productModel):
        record = commonRestUtil.getBayConfigBaseIpAddr(tlv)
        bayConfigBaseIpAddr = getBaseIPAddr(record)
    else:
        bayConfigBaseIpAddr = tlvUtil.getBayConfigBaseIpAddr(bayConfigRecord)
    return bayConfigBaseIpAddr


def isNVMeDev(encModel):
    if encModel == tlvData.ENCLOSURE_MODEL_E["CTRL_NVMe2U_24"]:
        return True
    return False


def sleepWithProcess(context, beginProcess, endProcess, sleepTime):
    logger = getLogger(context.get("logger"), __file__)
    logger.logInfo("sleepWithProcess endProcess:%s beginProcess:%s" % (endProcess, beginProcess))
    curRemainTime = sleepTime
    context["curProgressPer"] = int(beginProcess)
    while True:
        baseUtil.safeSleep(REFRESH_PROCESS_INTERVAL_TIME)
        curRemainTime -= REFRESH_PROCESS_INTERVAL_TIME
        if curRemainTime < 0:
            curRemainTime = 0
        context["curProgressPer"] = int(
            (endProcess - beginProcess) * (sleepTime - curRemainTime) / sleepTime + beginProcess)
        if curRemainTime <= 0:
            context["curProgressPer"] = int(endProcess)
            return


def getPoweronCtrlTime(version):
    '''
    @summary: 获取上电控制器的超时时间，新版本的超时时间为PURLEY_TIME，其他的保持不变
    @param version: VRC版本
    '''
    if version in config.PURLEY_VERS_BLACKLIST:
        return NEW_CLUSTER_CTRLS_NUM_CHECK_TIME_LIMIT

    return config.PURLEY_TIME


def isSameIpv6(ipv6_1, ipv6_2):
    '''
    @summary:判断ipv6是否相同
    '''

    if not isIpV6(ipv6_1) or not isIpV6(ipv6_2):
        return ipv6_1 == ipv6_2

    try:
        ad_ipv6_1 = JInetAddress.getByName(ipv6_1)
        ad_ipv6_2 = JInetAddress.getByName(ipv6_2)
        return ad_ipv6_1.equals(ad_ipv6_2)
    except JUnknownHostException as e:
        raise Exception(e)


def sortBoardsSnByBayId(boardsDict, oldBoardsList):
    '''
    @summary:board按照bayid从小到大排序
    @param boardsDict: boardsDict = {sn:bayid}
    @return: 
    '''
    boards = []
    boardsList = sorted(boardsDict.items(), lambda x, y: cmp(x[1], y[1]))
    for board in boardsList:
        for oldBoard in oldBoardsList:
            if board[0] == (oldBoard["enclosureSN"], oldBoard["controllerID"]):
                boards.append(oldBoard)
                break
    return boards


def getRemindInfo(lang, msg, errMsgArgs="", suggestionArgs=""):
    errMsg, suggestion = getMsg(lang, msg, errMsgArgs, suggestionArgs)
    errMsg = errMsg[0:100]
    return "<html><font color='blue'>%s</font></html>" % errMsg


def getDangerNoticeRemindInfo(lang):
    return getRemindInfo(lang, "expansion.danger.notice")


# 刷新进度公共方法
def threadUpProcess(context, totalTime, intervalTime):
    logger = getLogger(context.get("logger"), __file__)
    try:
        inProcess(context)
        t = threading.Thread(target=updateProcess, args=(context, totalTime, intervalTime))
        t.start()
        context["thread"] = t
    except Exception as ex:
        logger.logException("Failed to Update process and remainTime: %s" % ex)


# 扩容8s优化提取添加的更新进度的公共方法    
def updateProcess(context, totalTime, interval):
    logger = getLogger(context.get("logger"), __file__)
    # 剩余时间总数
    totalReaminTime = totalTime
    showUI(context, 0, totalReaminTime)

    # 进度平滑处理（解决停留在100%不动的问题）
    # 0~50 interval/50~75 2*interval/75~90 4*interval
    # /90~100 8*interval /99停留直到100
    tmpInterval = interval

    # isSet[0] range(50,75)  isSet[1] range(75,90)  isSet[2] range(90,100)
    isSet = [False, False, False]

    while context["checkState"] == config.PROCESS_STATE_CHECKING:
        # 更新进度条
        totalReaminTime -= tmpInterval
        if totalReaminTime <= 0:
            # 最后的剩余时间保持为上一次显示的剩余时间
            totalReaminTime += tmpInterval
            showUI(context, 99, totalReaminTime)
            baseUtil.safeSleep(interval)
            continue

        currentPro = int(100 * (totalTime - totalReaminTime) / totalTime)
        if tmpInterval != 1:
            if not isSet[0] and currentPro in range(50, 75):
                tmpInterval = 1 if tmpInterval / 2 == 0 else tmpInterval / 2
                isSet[0] = True
            elif not isSet[1] and currentPro in range(75, 90):
                tmpInterval = 1 if tmpInterval / 2 == 0 else tmpInterval / 2
                isSet[1] = True
            elif not isSet[2] and currentPro in range(90, 100):
                tmpInterval = 1 if tmpInterval / 2 == 0 else tmpInterval / 2
                isSet[2] = True

        logger.logInfo("[UI_thread]totalReaminTime:%s currentPro : %s" % (str(totalReaminTime), str(currentPro)))
        showUI(context, currentPro, totalReaminTime)

        baseUtil.safeSleep(interval)

    if context["checkState"] == config.PROCESS_UPGRADE_FINISHED:
        showUI(context, 100, 0)
    return


# 扩容8s优化提取添加的正在刷进度的公共方法
def inProcess(context):
    context["checkState"] = config.PROCESS_STATE_CHECKING
    return


# 扩容8s优化提取添加的完成进度的公共方法
def finishProcess(context):
    context["checkState"] = config.PROCESS_UPGRADE_FINISHED
    # 主线程等待刷进度的线程将剩余时间置于0
    threadJoin(context)
    return


def threadJoin(context):
    try:
        if context.get("thread") != None:
            context["thread"].join()
    except:
        if "logger" in context:
            context.get("logger").info("threadJoin error")


def queryDiskDomain(cli, lang):
    """Query disk domain information.

    :param cli:
    :param lang:
    :return:
    """
    cmd = "show disk_domain general"
    cmdExecSucc, cliRet, _ = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    if not cmdExecSucc:
        return False, {}

    diskDomainIdList = []
    for line in cliRet.splitlines():
        lineFields = line.split()
        if lineFields and lineFields[0].isdigit():
            diskDomainIdList.append(lineFields[0])

    allDiskInfoDict = {}
    qryDiskDomainCmd = 'show disk_domain general disk_domain_id=%(diskDomainId)s'
    for diskDomainId in diskDomainIdList:
        diskDomainInfoDict = {}
        qryCmd = qryDiskDomainCmd % {'diskDomainId': diskDomainId}
        qryDomainSucc, diskDomainRet, _ = cliUtil.execCmdInCliMode(cli, qryCmd, True, lang)
        if not qryDomainSucc:
            return False, {}

        for line in diskDomainRet.splitlines():
            if ':' in line:
                filedName = line.split(':')[0].strip()
                fieldValue = line.split(':')[1].strip()
                if 'Controller' == filedName:
                    diskDomainInfoDict['id'] = diskDomainId
                    diskDomainInfoDict['Controller'] = fieldValue

        if diskDomainInfoDict:
            allDiskInfoDict[diskDomainId] = diskDomainInfoDict

    return True, allDiskInfoDict


def getTypicalPowerOnTime(height, maxPoweronTime):
    '''
    @summary: 获取上电控制器的超时时间，新版本的超时时间为PURLEY_TIME，其他的保持不变
    @param version: VRC版本
    '''
    if str(height) in ["2", "3"]:
        return TYPICAL_POWER_ON_TIME_2U_3U
    return maxPoweronTime


def setExpStep(context, requireCtrlNum):
    try:
        newCtrlNum = contextUtil.getItem(context, "newConfigCtrlNum")
        if newCtrlNum != requireCtrlNum:
            contextUtil.setItem(context, "expStep", config.ExpStep.EXP_CTRL_EXECUTE_EXP_1)
            return
        else:
            contextUtil.setItem(context, "expStep", config.ExpStep.EXP_CTRL_EXECUTE_EXP)
        return
    except:
        if "logger" in context:
            context.get("logger").info("setExpStep error")


def setExpSucNotice(context):
    expStep = contextUtil.getItem(context, "expStep")
    lang = contextUtil.getLang(context)
    if not expStep:
        return

    if expStep == config.ExpStep.EXP_CTRL_EXECUTE_EXP:
        context["remindInfo"] = getRemindInfo(lang, "expansion.postcheck.remind")
    elif expStep == config.ExpStep.EXP_CTRL_EXECUTE_EXP_1:
        context["remindInfo"] = getRemindInfo(lang, "expansion.first.postcheck.remind")
    baseUtil.safeSleep(3)  # 等待线程执行，刷新界面，用户可感知


def changUnit2GBLabelCap(strValue):
    """ 根据传入的标签容量值转换单位为GB
    :param strValue:
    :return:
    """
    floatValue = 0.0
    ratio = 1000
    try:
        if not strValue:
            return False, floatValue
        if re.search("TB?", strValue):
            floatValue = float(strValue.split('T')[0].strip()) * ratio
        elif re.search("GB?", strValue):
            floatValue = float(strValue.split('G')[0].strip())
        elif re.search("MB?", strValue):
            floatValue = float(strValue.split('M')[0].strip()) / ratio
        elif re.search("KB?", strValue):
            floatValue = float(strValue.split('K')[0].strip()) / ratio / ratio
        elif re.search("B", strValue):
            floatValue = float(strValue.split('B')[0].strip()) / ratio / ratio / ratio
        else:
            return False, floatValue

        return True, floatValue

    except Exception:
        return False, floatValue


def getDiskCapacityByDiskId(cli, disk_id, lang, isOrigin=False, isHasLog=True):
    '''
    @summary: 获取硬盘容量
    :param cli:
    :param lang:
    @return:
        flag:
            True: 获取成功
            False: 获取失败
        ret:
            flag为True时，硬盘容量
            flag为False时，cli回显
        errMsg: 错误消息
    '''
    errMsg = ""
    checkRet = getDiskElectronicLabelById(cli, disk_id, lang, isHasLog)
    if not checkRet[0]:
        return False, checkRet[1], checkRet[2]
    cliRet = checkRet[1]
    # 匹配电子标签中的硬盘容量大小
    diskCapacity = None
    cliRetList = checkRet[3].split("  ")
    ElectronicList = filter(lambda x: x != "", cliRetList)
    flag = False
    for line in ElectronicList:
        if not re.search("Description", line, re.IGNORECASE):
            continue
        descValueList = line.split("=")
        if len(descValueList) < 2:
            errMsg = getMsg(lang, "failed.to.get.disk.electronic.label.info", disk_id)
            return False, cliRet, errMsg
        resultList = descValueList[1].split(",")
        for result in resultList:
            diskValueList = result.strip().split(' ')
            for diskValue in diskValueList:
                if not re.search("^[0-9]+(\.\d+)?((G$)|(GB$)|(T$)|(TB$))", diskValue):
                    continue
                if diskValue.startswith("6G"):  # SAS速率跳过
                    continue
                if diskValue.endswith("GB") or diskValue.endswith("TB"):
                    flag = True
                    diskCapacity = diskValue
                    break
                if diskValue.endswith("T"):
                    diskCapacity = diskValue.replace("T", "TB")
                    flag = True
                    break
                if diskValue.endswith("G"):
                    diskCapacity = diskValue.replace("G", "GB")
                    flag = True
                    break
            if flag:
                if isOrigin:
                    return True, diskCapacity, errMsg
                else:
                    checkRet = changUnit2GBLabelCap(diskCapacity)
                return True, checkRet[1], errMsg

    errMsg = getMsg(lang, "failed.to.get.disk.electronic.label.info", disk_id)
    return False, cliRet, errMsg


def getDiskElectronicLabelById(cli, disk_id, lang, isHasLog=True):
    """
    根据硬盘ID获取硬盘电子标签
    """
    elecLabelStr = ""
    cmd = "show disk general disk_id=%s" % disk_id
    flag, cliRet, errMsg = cliUtil.execCmdInCliMode(cli, cmd, isHasLog, lang)
    if not flag:
        errMsg = getMsg(lang, "failed.to.get.disk.info", disk_id)
        return False, cliRet, errMsg, elecLabelStr

    retList = cliUtil.getVerticalCliRetFilterElabel(cliRet, isParseElcLabel=False)

    if not retList:
        errMsg = getMsg(lang, "failed.to.get.disk.info", disk_id)
        return False, cliRet, errMsg, elecLabelStr

    for line in retList:
        if line.has_key("Electronic Label"):
            elecLabelStr = line.get("Electronic Label")
            return True, cliRet, errMsg, elecLabelStr
    errMsg = getMsg(lang, "failed.to.get.disk.info", disk_id)
    return False, cliRet, errMsg, elecLabelStr


def changUnit2GBLabel2DevCap(strValue):
    """ 根据传入的标签容量值转换为等价的设备容量，单位为GB
    :param strValue:
    :return:
    """
    floatValue = 0.0
    ratio = 1000.0 / 1024.0
    try:
        if not strValue:
            return False, floatValue
        if re.search("TB?", strValue):
            floatValue = float(strValue.split('T')[0].strip()) * pow(ratio, 3) * 1000
        elif re.search("GB?", strValue):
            floatValue = float(strValue.split('G')[0].strip()) * pow(ratio, 3)
        elif re.search("MB?", strValue):
            floatValue = float(strValue.split('M')[0].strip()) * pow(ratio, 2) / 1000
        elif re.search("KB?", strValue):
            floatValue = float(strValue.split('K')[0].strip()) * ratio / 1000 / 1000
        elif re.search("B", strValue):
            floatValue = float(strValue.split('B')[0].strip()) / 1000 / 1000 / 1000
        else:
            return False, floatValue

        formatValue = decimal.Decimal(str(floatValue)).quantize(decimal.Decimal('0.000'))
        return True, float(formatValue)

    except Exception:
        return False, floatValue


# 此方法V5X10返回参数错误
def getInterProductModel(tlv, vrcVersion):
    if vrcVersion >= config.EXP_INTERNAL_PRODUCT_MODEL_VERSION:
        orginDevInfo = tlvUtil.getInternalDeviceInfo(tlv)
        orginPdtModel = tlvUtil.getInternalPdtModel(orginDevInfo)
        return orginPdtModel
    return ""


def getInternalProductModel(context):
    """通过rest接口查询内部产品型号(FRU移植)

    :param context:
    :return:
    """
    logger = getLogger(context.get("logger"), __file__)
    devObj = contextUtil.getDevObj(context)
    pdtVersion = devObj.get("version")
    pdtType = devObj.get("type")
    logger.logInfo("Product version:{}, and product model:{}".format(pdtVersion, pdtType))
    if not ((pdtType and 'Dorado' in pdtType and (pdtVersion > 'V300R002C10' or '.' in pdtVersion))  # For dorado
            or pdtType in (baseConfig.OCEAN_PROTECT + baseConfig.NEW_DORADO
                           + baseConfig.OCEAN_STOR_COMPUTING_DEVS + baseConfig.OCEAN_STOR_MICRO_DEVS)
            or (pdtType and 'V5' in pdtType and pdtVersion >= 'V500R007C60')):  # 5X10 V5
        logger.logInfo("Internal productModel not supported.")
        return ''

    params = {}
    rest = contextUtil.getRest(context)
    uriParamDict = restUtil.CommonRest.getUriParamDict(restData.RestCfg.SpecialUri.INTERNAL_DEVICE_INFO)
    record = restUtil.CommonRest.execCmd(rest, uriParamDict, params, restData.RestCfg.RestMethod.GET)
    if not record:
        logger.logInfo("get internal productModel failed.")
        # 如果取得为空的话，直接返回None
        return None
    else:
        internalProductModel = restUtil.CommonRest.getRecordValue(restUtil.CommonRest.getData(record),
                                                                  restData.InternalDeviceInfo.INTERNAL_PRODUCT_MODEL)
        logger.logInfo("Product internal model:{}".format(internalProductModel))
        return internalProductModel


def get_internal_product_model_with_ret(context):
    """
    通过rest接口查询内部产品型号
    :param context:
    :return: 内部型号，ret
    """
    ret = ""
    logger = getLogger(context.get("logger"), __file__)
    dev_obj = contextUtil.getDevObj(context)
    pdt_version = dev_obj.get("version")
    pdt_type = dev_obj.get("type")
    logger.logInfo(
        "Product version:{}, product model:{}".format(pdt_version, pdt_type)
    )
    if not (
            (
                    pdt_type
                    and baseUtil.isDoradoDev(pdt_type)
                    and (pdt_version > "V300R002C10" or "." in pdt_version)
            )  # For dorado
            or (pdt_type and "V5" in pdt_type and pdt_version >= "V500R007C60")
    ):  # 5X10 V5
        logger.logInfo("Internal productModel not supported.")
        return "", ret

    params = {}
    rest = contextUtil.getRest(context)
    uri_param_dict = restUtil.CommonRest.getUriParamDict(
        restData.RestCfg.SpecialUri.INTERNAL_DEVICE_INFO
    )
    ret += "{}{}".format(rest.baseUri, uri_param_dict.get("objUri"))
    record = restUtil.CommonRest.execCmd(
        rest, uri_param_dict, params, restData.RestCfg.RestMethod.GET
    )
    ret += "\n{}".format(str(record))
    if not record:
        logger.logInfo("get internal productModel failed.")
        # 如果取得为空的话，直接返回None
        return None, ret
    else:
        internalProductModel = restUtil.CommonRest.getRecordValue(
            restUtil.CommonRest.getData(record),
            restData.InternalDeviceInfo.INTERNAL_PRODUCT_MODEL,
        )
        logger.logInfo(
            "Product internal model:{}".format(internalProductModel)
        )
        return internalProductModel, ret


def getInterfModule(cli, lang):
    '''
    @summary: 查询槽位信息
    @return:
        flag：True，是否查询成功
        cliRet：CLI回显
        errMsg：方法异常结束时的原因
    '''
    inerfIdModel = {}
    cmd = "show interface_module"
    flag, cliRet, errMsg = cliUtil.execCmdInCliMode(cli, cmd, True, lang)
    # 命令执行失败
    if flag != True:
        return (flag, cliRet, errMsg, inerfIdModel)

    if cliUtil.queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg, inerfIdModel)
    else:
        interModuleDictList = cliUtil.getHorizontalCliRet(cliRet)
        for interModuleDict in interModuleDictList:
            moduleId = interModuleDict.get("ID", "")
            model = interModuleDict.get("Model", "")
            inerfIdModel[moduleId] = model
    return (flag, cliRet, errMsg, inerfIdModel)


def getInterfModelId(context, location):
    # 参数检查
    if not context or not location:
        return ""
    # 查询状态
    tlv = contextUtil.getTlv(context)
    recs = tlvUtil.getInterfaceModuleRecords(tlv)

    ids = tlvUtil.getRecordsValue(recs, tlvData.INTF_MODULE["location"], location)
    if not ids:
        return ""
    return tlvUtil.getRecordValue(ids, tlvData.INTF_MODULE["id"])


def powerOff_IntfModule(context, cardId):
    '''
    下电接口模块
    :param context:
    :param cardId:
    :return: 下电是否成功（错误信息和成败信息已设置）。 True=成功； False=失败 或 异常， 此时已设置错误信息
    '''
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        # 如果接口卡已下电，则操作成功
        runningStatus = getInterfRunningStatus(context, tlvData.INTF_MODULE["runningStatus"], cardId)
        logger.logNoPass("interface module status unknown:" + str(runningStatus))
        if runningStatus < 0:
            logger.logNoPass("interface module status unknown:" + str(runningStatus))
            return False

        if tlvData.RUNNING_STATUS_E["POWER_OFF"] == runningStatus:
            logger.logInfo("the card " + cardId + " is already power off. check passed.")
            return True

        param1 = (restData.PublicAttributes.TYPE, restData.Enum.ObjEnum.INTF_MODULE)
        param2 = (restData.PublicAttributes.ID, cardId)
        paramList = restUtil.Tlv2Rest.getParamList(param1, param2)
        rest = contextUtil.getRest(context)
        rec = restUtil.Tlv2Rest.execCmd(rest, restData.TlvCmd.INTF_MODULE_POWER_OFF, paramList)
        if not rec:
            logger.logNoPass("fail to exec the power off cmd of card " + cardId + ". check failed.")
            return False
        logger.info("exec the power off response :" + str(rec))
    except Exception as ex:
        import traceback
        logger.logNoPass("exception:" + str(traceback.format_exc()))
        logger.error("When the status is POWER_ON_FAILED, execute poweroff commond failed.The excaption :%s" % ex)
    return True


def getInterfRunningStatus(context, fieldType, modeId):
    # 获取FRU信息
    tlv = contextUtil.getTlv(context)
    recs = tlvUtil.getInterfaceModuleRecords(tlv)
    record = tlvUtil.getRecordsValue(recs, tlvData.INTF_MODULE["id"], modeId)
    # 设置返回值
    status = -1
    if record:
        status = tlvUtil.getRecordValue(record, fieldType)  # 8=runningStatus
    return status


def getCtrlNumPerEnc(ctrl_enc_height):
    """根据框高获取每框的最大控制器数量

    :param ctrl_enc_height: 控制框高度
    :return:
    """
    return ENC_HEIGHT_TO_CTRL_NUM.get(ctrl_enc_height, 2)


def renew_expansion_config_data(logger):
    """刷新配置数据文件，避免后面扩容评估时误读

    :pram logger 日志
    """
    try:
        # 工具箱基本目录
        base_dir = os.path.abspath(DIR_RELATIVE_CMD)
        persist_dir = os.path.join(base_dir, CFG_DATA_PERSIST_DIR)
        is_exists_data_dir = os.path.exists(persist_dir)
        if not is_exists_data_dir:
            logger.logInfo(
                "The persist directory does not exist: %s" % persist_dir)
            os.makedirs(persist_dir)

        persist_file = os.path.join(persist_dir, CFG_DATA_PERSIST_FILENAME)
        with open(persist_file, 'w') as file_obj:
            file_obj.write("")
    except Exception as ex:
        logger.logInfo("renew_config_data exception: %s" % ex)
        return False

    return True


def save_expansion_config_data(config_persist_data,
                               logger,
                               file_name=CFG_DATA_PERSIST_FILENAME):
    """将扩容配置数据保存到文本文件中

    :param config_persist_data: 扩容配置数据
    :return:
    """
    try:
        # 工具箱基本目录
        base_dir = os.path.abspath(DIR_RELATIVE_CMD)
        persist_dir = os.path.join(base_dir, CFG_DATA_PERSIST_DIR)
        is_exists_data_dir = os.path.exists(persist_dir)
        if not is_exists_data_dir:
            logger.logInfo(
                "The persist directory does not exist: %s" % persist_dir)
            os.makedirs(persist_dir)

        persist_file = os.path.join(persist_dir, file_name)
        with open(persist_file, 'w') as file_obj:
            file_obj.write(str(config_persist_data))
    except Exception as ex:
        logger.logInfo("save_config_data exception: %s" % ex)
        return False

    return True


def get_expansion_config_data(logger, file_name=CFG_DATA_PERSIST_FILENAME):
    """从文本文件中读取扩容配置数据

    :return:
    """
    try:
        # 工具箱基本目录
        base_dir = os.path.abspath(DIR_RELATIVE_CMD)
        persist_dir = os.path.join(base_dir, CFG_DATA_PERSIST_DIR)
        is_exists_data_dir = os.path.exists(persist_dir)
        if not is_exists_data_dir:
            logger.logInfo(
                "The persist directory does not exist: %s" % persist_dir)
            os.makedirs(persist_dir)

        persist_file = os.path.join(persist_dir, file_name)
        with open(persist_file, 'r') as file_obj:
            config_data = file_obj.read()
            config_data_dict = ast.literal_eval(config_data)
            logger.logInfo("get_config_data is: %s" % config_data_dict)
    except Exception as ex:
        logger.logInfo("get_config_data exception: %s" % ex)
        return None
    return config_data_dict


def delete_temp_config_data(logger, file_name):
    """

    :param logger:
    :param file_name:
    :return:
    """
    try:
        base_dir = os.path.abspath(DIR_RELATIVE_CMD)
        persist_dir = os.path.join(base_dir, CFG_DATA_PERSIST_DIR)
        persist_file = os.path.join(persist_dir, file_name)
        if os.path.isfile(persist_file):
            os.remove(persist_file)
    except Exception:
        logger.logInfo("remove file error.")


def is_smart_enclosure_max_num_risk_version_and_mode(p_version, p_mode):
    """
    检查是否智能框扩容风险版本和型号
    :param p_version:
    :param p_mode:
    :return:
    """
    risk_version_list = filter(
        lambda current_version: p_version.startswith(current_version),
        config.SMART_ENCLOSURE_RISK_VERSION,
    )
    risk_product_list = filter(
        lambda current_mode: p_mode.startswith(current_mode),
        DORADO_DEVS_V6_HIGH,
    )
    return all((list(risk_product_list), list(risk_version_list)))


def isEnclosureRedundancyStrategy(cli, domain_id, lang, logger):
    """获取硬盘域的冗余策略

    :param cli: cli
    :param domain_id: 硬盘域名称
    :param lang: 语言
    :param logger: 日志
    :return: 是否正确获取回显，是否为框级冗余硬盘域， 错误信息
    """

    logger.logInfo("domain_id:" + str(domain_id))
    cmd = "show disk_domain general disk_domain_id=%s" % str(domain_id)
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode4Privilege(cli, cmd,
                                                                  True, lang)
    if not flag:
        return False, False, err_msg

    dict_list = cliUtil.getVerticalCliRet(cli_ret)
    if "Redundancy Strategy" in dict_list[0]:
        if dict_list[0].get("Redundancy Strategy") == "Enclosure":
            return True, True, ""
        else:
            return True, False, ""
    return False, False, ""


def get_rest_api_v2_record(context, cmd, execute_type,
                           param_dict="", time_out=None):
    """
    获取接口返回数据
    :param context:
    :param execute_type:
    :param param_dict:
    :param time_out:
    :param cmd:
    :return:
    """
    params_str = restUtil.CommonRest.getParamsJsonStr(param_dict, False)
    dev = context.get("devNode0")
    dev_node = EntityUtils.toOldDev(dev)
    rest_connection = RestConnectionManager.getRestConnection(dev_node)
    if time_out:
        rest_connection.getSession().setReadDataTimeout(time_out)
    rest_conn_wrapper = contextUtil.getRest(context)
    base_uri = restUtil.get_base_uri_v2(rest_conn_wrapper.getBaseUri())
    if execute_type == "POST":
        response_info = rest_connection.execPost(
            "{}{}".format(base_uri, cmd), params_str
        )
    elif execute_type == "GET":
        response_info = rest_connection.execGet(
            "{}{}".format(base_uri, cmd), params_str
        )
    elif execute_type == "PUT":
        response_info = rest_connection.execPut(
            "{}{}".format(base_uri, cmd), params_str
        )
    else:
        response_info = rest_connection.execDelete(
            "{}{}".format(base_uri, cmd), params_str
        )
    data_string = response_info.getContent()
    record = json.loads(data_string)

    if not is_right_response(record):
        raise Exception("error response.")
    return record


def is_right_response(record):
    """
    校验响应数据是否正确。
    :param record:
    :return:
    """
    err_info = restUtil.CommonRest.getErrInfo(record)
    if not err_info:
        err_info = record.get("result", "")
    if not err_info:
        return False
    return True


def set_notice_item(items, cascading_depth_dict, product_model, lang,
                    inter_product_model=""):
    """
    设置注意事项
    :param items: 注意事项列表
    :param cascading_depth_dict: 级联深度字典
    :param product_model: 产品型号
    :param lang: lang语言
    :param inter_product_model: 内部型号
    :return:
    """
    sas_deepth = cascading_depth_dict.get(
        product_model, {}).get("SAS")
    ip_deepth = cascading_depth_dict.get(
        product_model, {}).get("IP")
    # 混闪场景RDMA级联深度为1
    if inter_product_model in config.INTER_PRODUCT_MODEL_SUPPORT_FLASHING:
        ip_deepth = 1
    items.append(getRes(
        lang, "suggest_cascadeConnection_deepth2",
        (sas_deepth, sas_deepth, sas_deepth / 2, ip_deepth, ip_deepth)))


def get_notice_item_new_dorado(cascading_depth_dict, product_model, product_version, lang,
                               inter_product_model=""):
    """
    获取注意事项
    :param cascading_depth_dict: 级联深度字典
    :param product_model: 产品型号
    :param product_version: 设备版本
    :param lang: lang语言
    :param inter_product_model: 内部型号
    """
    sas_deepth = cascading_depth_dict.get(product_model, {}).get("SAS")
    ip_deepth = 1 if is_support_flashing(inter_product_model) else cascading_depth_dict.get(product_model, {}).get("IP")
    sas_interface_deepth = 2 if "6.1.5" in product_version else 4

    return getRes(lang, "suggest_cascadeConnection_new_dorado_deepth",
                  (sas_deepth, sas_interface_deepth, sas_deepth / 2, sas_interface_deepth / 2, ip_deepth))


def is_support_flashing(inter_product_model):
    return inter_product_model in (
            config.INTER_PRODUCT_MODEL_SUPPORT_FLASHING + config.INTER_PRODUCT_MODEL_SUPPORT_FLASHING_MICRO)


def get_expand_enc_num(context):
    """
    获取待扩框的数量
    :param context: 上下文
    :return: SAS框数量，智能框数量
    """
    selected_config = contextUtil.getItem(context, "selectedConfig")
    enc_num_2u = 0
    enc_num_4u = 0
    enc_num_nvme = 0
    for config_info in selected_config.values():
        enc_num_2u += len(config_info.get("newEnc2UList", []))
        enc_num_4u += len(config_info.get("newEnc4UList", []))
        enc_num_nvme += len(config_info.get("newEnc2UNVMeList", []))
    return enc_num_2u + enc_num_4u, enc_num_nvme
