﻿# -*- coding: UTF-8 -*-
# noinspection PyUnresolvedReferences
from com.huawei.ism.exception import IsmException
# noinspection PyUnresolvedReferences
from com.huawei.ism.tool.framework.platform.exception import ToolException

import BaseFactory
from cbb.frame.context import contextUtil


class Sftp():
    ________TEST_ZONE________ = None

    '''
    Function: 模块测试入口，供TestFactory调用
    '''

    @staticmethod
    def testEntrance(context):

        return

    ________FUNC_ZONE________ = None

    '''
    Function: 从远端设备下载文件到本地目录 
    Params: 
        context=工具上下文信息
        remoteFilePath=远端设备文件路径
        localDirPath=本地目录路径
    Return: 操作是否成功：True=成功；False=失败，此时context中错误信息已设置
    '''

    @staticmethod
    def download(context, remoteFilePath, localDirPath, specificIp=None):
        # 获取sftp连接
        conn = Sftp.Conn.getConn(context, specificIp)
        if None == conn:
            return False  # 错误信息已设置
        # 下载文件
        return Sftp.downloadByConn(context, conn, remoteFilePath, localDirPath, specificIp)

    '''
    Function: 从远端设备下载文件到本地目录(供自定义SFTP连接时使用) 
    Params: 
        context=工具上下文信息
        conn=自定义sftp连接
        remoteFilePath=远端设备文件路径
        localDirPath=本地目录路径
    Return: 操作是否成功：True=成功；False=失败，此时context中错误信息已设置
    '''

    @staticmethod
    def downloadByConn(context, conn, remoteFilePath, localDirPath, specificIp=None):

        # 下载文件
        devIp = ""
        try:
            # 记录日志
            if None == specificIp:
                devIp = (BaseFactory.json.toDict(conn.getLoginInfo()))["ip"]
            else:
                devIp = specificIp
            BaseFactory.log.info(context, "download file from " + devIp
                                 + ", local=" + localDirPath)
            # 下载文件并返回
            conn.getFile(localDirPath, remoteFilePath, None)
            return True

        except IsmException as ex:
            # 记录错误
            BaseFactory.log.error(context, "An ISM exception occured when download file from " + devIp
                                  + ", local=" + localDirPath)
            # 抛出异常
            errMsg = ex.getErrorMessage()
            errMsg = errMsg.rstrip(u"。").rstrip(".")
            raise BaseFactory.exception.newToolException(u"下载文件失败。原因为" + errMsg + u"。",
                                                         u"请以系统管理员权限运行工具，并在网络和设备状态正常时重试。",
                                                         "File download failed. Cause is " + errMsg + ".",
                                                         "Run the tool with the administrator permission, and retry when the network and device are normal.")

        except Exception:  # 其他异常
            # 记录错误
            BaseFactory.log.error(context, "An exception occured when download file from " + devIp
                                  + ", local=" + localDirPath)
            # 抛出异常
            raise BaseFactory.exception.newToolException(u"操作异常终止，下载文件失败。",
                                                         BaseFactory.const.HELP_DESC_ZH,
                                                         "Operation terminated unexpectedly. File download failed.",
                                                         BaseFactory.const.HELP_DESC_EN)

    '''
    Function: 将本地文件上传到远端设备目录 
    Params: 
        context=工具上下文信息
        localFilePath=本地文件路径
        remoteDirPath=远端设备目录路径
    Return: 操作是否成功：True=成功；False=失败，此时context中错误信息已设置
    '''

    @staticmethod
    def upload(context, localFilePath, remoteDirPath):
        # 获取sftp连接
        conn = Sftp.Conn.getConn(context)
        if None == conn:
            return False  # 错误信息已设置
        # 下载文件
        return Sftp.uploadByConn(context, conn, localFilePath, remoteDirPath)

    '''
    Function: 将本地文件上传到远端设备目录 (供自定义SFTP连接时使用)
    Params: 
        context=工具上下文信息
        conn=自定义sftp连接
        localFilePath=本地文件路径
        remoteDirPath=远端设备目录路径
    Return: 操作是否成功：True=成功；False=失败，此时context中错误信息已设置
    '''

    @staticmethod
    def uploadByConn(context, conn, localFilePath, remoteDirPath):

        # 上传文件
        devIp = ""
        try:
            # 记录日志
            devIp = (BaseFactory.json.toDict(conn.getLoginInfo()))["ip"]
            BaseFactory.log.info(context, "upload file to " + devIp
                                 + ", local=" + localFilePath)
            # 上传文件并返回
            conn.putFile(localFilePath, remoteDirPath, None)
            return True

        except IsmException as ex:
            # 记录错误
            BaseFactory.log.error(context, "An ISM exception occured when upload file to " + devIp
                                  + ". local=" + localFilePath)
            # 抛出异常
            errMsg = ex.getErrorMessage()
            errMsg = errMsg.rstrip(u"。").rstrip(".")
            raise BaseFactory.exception.newToolException(u"上传文件失败。原因为" + errMsg + u"。",
                                                         u"请在网络和设备状态正常时重试。",
                                                         "File upload failed. Cause is " + errMsg + ".",
                                                         "Retry when the network and device are normal.")

        except Exception:  # 其他异常
            # 记录错误
            BaseFactory.log.error(context, "An exception occured when upload file to " + devIp
                                  + ". local=" + localFilePath)
            # 抛出异常
            raise BaseFactory.exception.newToolException(u"操作异常终止，上传文件失败。",
                                                         BaseFactory.const.HELP_DESC_ZH,
                                                         "Operation terminated unexpectedly. File upload failed.",
                                                         BaseFactory.const.HELP_DESC_EN)

    '''
    TLV连接管理类
    '''

    class Conn():

        # 持久化数据保存KEY
        PERSIST_CONN = "SFTP_CONNECTION"

        # 默认的SFTP端口
        SFTPPORT_DEFAULT = 22

        '''
        Function: 获取指定设备的SFTP连接器
        Attention: 上传和下载文件的方法均在connector中，创建connector时connection会自动创建，故直接调用上传和下载的接口接口，无需调用getConnection函数
        '''

        @staticmethod
        def getConnByIP(context, ip, user, pawd, port):

            # 从上下文中获取指定IP的SFTP连接器
            sftpConnector = BaseFactory.persist.getObject(context, Sftp.Conn.PERSIST_CONN, ip)

            if None != sftpConnector:
                # 直接从已有SFTP连接器中获取连接
                BaseFactory.log.info(context, "sftp connector is already existed. ip=" + ip)

                # 返回连接
                return sftpConnector

            else:
                # 创建新的SFTP连接器和连接
                # 获取SFTP连接参数
                connFactory = context.get("connectorFactory")

                # 循环连接（框架异常时直接抛出）
                counter = 0
                MAX_RETRAY_TIME = 3
                while True:
                    counter += 1

                    try:
                        # 创建SFTP连接
                        sftpConnector = connFactory.createSftpConnector(ip, port, user, pawd)

                        # 保存SFTP连接（后续使用时不再创建）
                        BaseFactory.persist.setObject(context, Sftp.Conn.PERSIST_CONN, ip, sftpConnector)
                        BaseFactory.log.info(context, "succeed to create and save sftp connector. ip=" + ip)

                        # 连接正常，则返回连接创建结果
                        return sftpConnector

                    except ToolException as e:  # 工具框架异常：直接抛出异常
                        # 记录错误并直接抛出异常
                        BaseFactory.log.error(context,
                                              "Framework Exception: fail to create sftp connector. ip=" + ip + ", errorid=" + e.getErrorId() + ", errmsg=" + e.getErrMsg() + ", do not retry.")
                        raise BaseFactory.exception.getToolExceptionByErrId(e)

                    except Exception as e:  # 其他异常：继续重试
                        # 记录错误并重试
                        counter = counter + 1
                        BaseFactory.log.error(context, "the " + str(
                            counter) + "th failed to create sftp connector. ip=" + ip + ", errinfo=" + str(
                            e) + ", try again...")

                    # 若三次重试仍未建立SFTP连接，则报错
                    if counter > MAX_RETRAY_TIME:
                        sftpConnector = None
                        BaseFactory.log.error(context,
                                              "fail to create sftp connector. ip=" + ip + ", met the max try time 3.")

                        raise BaseFactory.exception.newToolException(u"创建到设备" + ip + u"的SFTP连接失败。",
                                                                     BaseFactory.const.HELP_DESC_ZH,
                                                                     "Failed to create the SFTP connection to device " + ip + ".",
                                                                     BaseFactory.const.HELP_DESC_EN)

        @staticmethod
        def getConn(context, specificIp=None):
            """获取当前设备的SFTP连接器

            :param context:
            :param specificIp:
            :return:
            """
            if specificIp:
                user = context.get("dev").get("user")
                pawd = context.get("dev").get("pawd")
                sftpPort = context.get("dev").get("sshPort")
                BaseFactory.log.info(context,
                                     "ready to get sftp connector. login "
                                     "info: ip={}, user={}, sftpPort="
                                     "{}".format(specificIp, user, sftpPort))
                return Sftp.Conn.getConnByIP(context, specificIp, user, pawd,
                                             int(sftpPort))

            dev = contextUtil.get_base_dev(context)
            sftpConn = contextUtil.getSftp(context)
            return sftpConn.getSftp(dev)
