# -*- coding: UTF-8 -*-
import time

from cbb.business.operate.fru.common import config
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import common
from cbb.business.operate.fru.common.showtrace import DisplayTraceThread
from cbb.frame.base import baseUtil
from cbb.frame.base import funcUtils
from cbb.frame.context import contextUtil
from cbb.frame.rest import restData
from cbb.frame.rest import restUtil
from cbb.business.operate.checkitems import restore_failover


@funcUtils.fakeProgress(totalSecs=config.CTRL_POWERON_TIME, intervalSec=1,
                        tool_name="poweronCtrl",
                        display_list=[{"time": 60 * 60, "percent": 90},
                                      {"time": 100 * 60, "percent": 100}])
def execute(context, **kwargs):
    """检查控制器状态是否正常

    :param context(dict): python执行上下文
    :param kwargs(dict): 可变参数dict
    :return: dict: 检查结果 ,格式：{"succ":True,"errMsg":"","suggestion":""}
    """
    showPowerOnTraceThread = None
    logger = baseUtil.getLogger(context.get("logger"), __file__)
    try:
        startTime = time.time()
        ctrlId = kwargs.get("ctrId", "")
        if not ctrlId:
            contextUtil.handleSuccess(context)
            logger.logPass()
            return

        contextUtil.initConnection(context)

        showPowerOnTraceThread = DisplayTraceThread(context, config.CTRL_POWERON_TIME)
        showPowerOnTraceThread.start()
        node_flag = ""

        while (time.time() - startTime < config.CTRL_POWERON_TIME):
            baseUtil.safeSleep(config.CHECK_DEFAULT_PERIOD)
            try:
                rest = contextUtil.getRest(context)
            except Exception as e:
                rest = None
                logger.logInfo("[create rest connection] exception: %s" % unicode(e))
            try:
                if rest is None:
                    contextUtil.initConnection(context)
            except Exception as e:
                rest = None
                logger.logInfo("[init rest connection] exception: %s" % e)

            if rest is None:
                continue

            try:
                record = restUtil.CommonRest.getCtrlRecord(rest, ctrlId)
                data = restUtil.CommonRest.getData(record)
            except Exception as e:
                data = None
                logger.logInfo("[get controller record] exception: %s" % unicode(e))
            if data is None:
                continue

            healthStatus = restUtil.CommonRest.getRecordValue(data, restData.RestCfg.Controller.HEALTH_STATUS)
            runningStatus = restUtil.CommonRest.getRecordValue(data, restData.RestCfg.Controller.RUNNING_STATUS)
            healthCheck = restUtil.CommonRest.checkHealthStatus(healthStatus)
            runningCheck = restUtil.CommonRest.checkRunningStatus(runningStatus)
            logger.logInfo("controller health status :" + str(healthStatus))
            logger.logInfo("controller running status :" + str(runningStatus))
            # 检查node是否回切
            node_flag = common.check_node_switch_status(context, ctrlId)
            if all([healthCheck, runningCheck, node_flag]):
                contextUtil.handleSuccess(context)
                return

        if not node_flag:
            lang = contextUtil.getLang(context)
            err_msg, suggestion = common.getMsg(lang, "node.status.error")
            contextUtil.handleFailure(context,
                                      {"flag": False, "errMsg": err_msg,
                                       "suggestion": suggestion})
        else:
            BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.CNTR_REBOOT_FAIL_OR_STATUS_ABNORMAL,
                                                   FuncFactory.LangKey.PUBSUG_CONTACT_TECH_SPT_ENGINEER_FOR_HELP)
            logger.logNoPass("[check_ctrl_health_status] check failed.")
        return

    except Exception as exception:
        contextUtil.handleException(context, exception)
        logger.logException(exception)
        return
    finally:
        if showPowerOnTraceThread:
            showPowerOnTraceThread.stop()
        # 关闭SMB开关
        flag, err_msg, suggestion = restore_failover.execute(context)
        if not flag:
            contextUtil.handleFailure(context,
                                      {"flag": False, "errMsg": err_msg,
                                       "suggestion": suggestion})
