# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2012-2024. All rights reserved.

from cbb.business.operate.checkitems import check_required_hot_patch
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import commonFunction
from cbb.business.operate.fru.common.controller_patch_function import \
    ControllerPatchFunction, REQUIRED_PATCH_LIST_FOR_6U4C_PATCH, BEGIN_TIME_KEY
from cbb.common.query.hardware.hypermetro import is_hypermetro_service
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
import traceback

# 用于无解决补丁时需要拦截的场景，补丁版本比较必不通过
NO_FIX_PATCH = "SPH999"

COMMON_REQUIRED_PATCH_LIST = [
    {
        "product_version": "V500R007C10",
        "required_patch": "V500R007C10SPH013",
        "product_series": "ConvergedStorage",
        "product_models": ["5300 V5", ]
    },
    {
        "product_version": "V500R007C10",
        "required_patch": "V500R007C10SPH019",
        "product_series": "ConvergedStorage",
        "product_models": [
            "18500 V5", "18500F V5", "18800 V5", "18800F V5", "5500 V5",
            "5500F V5", "5600 V5", "5600F V5", "5800 V5", "5800F V5",
            "6800 V5", "6800F V5", "2800 V5", "5300F V5"]
    },
    {
        "product_version": "V500R007C30SPC100",
        "required_patch": "V500R007C30SPH109",
        "product_series": "ConvergedStorage",
        "product_models": [
            "18500 V5", "18500F V5", "18800 V5", "18800F V5", "5500 V5",
            "5500F V5", "5600 V5", "5600F V5", "5800 V5", "5800F V5",
            "6800 V5", "6800F V5", "2800 V5", "5300F V5"],
        "emergency_patch": ["V500R007C30SPH190", ],
    },
    {
        "product_version": "V300R001C01SPC100",
        "required_patch": "V300R001C01SPH106",
        "product_series": "Dorado",
        "product_models": [],
        "emergency_patch": ["V300R001C01SPH170", ],
    },
    {
        "product_version": "V300R001C20",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R001C21",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
        "emergency_patch": ["V300R001C21SPH070", ],
    },
    {
        "product_version": "V300R001C21SPC100",
        "required_patch": "V300R001C21SPH120",
        "product_series": "Dorado",
        "product_models": [],
        "emergency_patch": ["V300R001C21SPH173", ],
    },
    {
        "product_version": "V300R001C30",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R001C30SPC100",
        "required_patch": "V300R001C30SPH109",
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R002C00",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R002C00SPC100",
        "required_patch": "V300R002C00SPH105",
        "product_series": "Dorado",
        "product_models": [],
        "emergency_patch": ["V300R002C00SPH171", ],
    },
    {
        "product_version": "V300R002C10",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R002C10SPC100",
        "required_patch": "V300R002C10SPH119",
        "product_series": "Dorado",
        "product_models": [],
        "emergency_patch": ["V300R002C10SPH182", ],
    },
    {
        "product_version": "V300R002C20",
        "required_patch": "V300R002C20SPH002",
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R002C10",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": ["Dorado NAS"],
    },
    {
        "product_version": "V300R002C10SPC100",
        "required_patch": "V300R002C10SPH112",
        "product_series": "ConvergedStorage",
        "product_models": ["Dorado NAS"],
    },
    {
        "product_version": "V300R002C20",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": ["Dorado NAS"],
    },
]

HYPERMETRO_REQUIRED_PATCH_LIST = [
    {
        "product_version": "V500R007C20",
        "required_patch": "V500R007C20SPH003",
        "product_series": "ConvergedStorage",
        "product_models": []
    },
    {
        "product_version": "V500R007C00SPC100",
        "required_patch": "V500R007C00SPH105",
        "product_series": "ConvergedStorage",
        "product_models": [],
        "black_emergency_patch": ["V300R006C10SPH270", ],
    },
    {
        "product_version": "V300R006C00SPC100",
        "required_patch": "V300R006C00SPH111",
        "product_series": "ConvergedStorage",
        "product_models": []
    },
    {
        "product_version": "V300R006C30",
        "required_patch": "V300R006C30SPH003",
        "product_series": "ConvergedStorage",
        "product_models": []
    },
    {
        "product_version": "V300R006C20",
        "required_patch": "V300R006C20SPH008",
        "product_series": "ConvergedStorage",
        "product_models": []
    },
    {
        "product_version": "V300R006C10SPC100",
        "required_patch": "V300R006C10SPH105",
        "product_series": "ConvergedStorage",
        "product_models": [],
        "black_emergency_patch": ["V300R006C10SPH270", ],
    },
    {
        "product_version": "V300R003C10SPC100",
        "required_patch": "V300R003C10SPH118",
        "product_series": "ConvergedStorage",
        "product_models": [],
        "black_emergency_patch": ["V300R003C10SPH176", ],
    },
    {
        "product_version": "V300R005C00SPC300",
        "required_patch": "V300R005C00SPH308",
        "product_series": "ConvergedStorage",
        "product_models": [],
        "black_emergency_patch": ["V300R005C00SPH371", ],
    },
    {
        "product_version": "V300R003C00SPC100",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R003C00",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R003C20",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R003C20SPC100",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R003C20SPC200",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R005C00",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R005C01",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R006C00",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R006C01",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R006C10",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R003C10",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R003C20",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V500R007C00",
        "required_patch": NO_FIX_PATCH,
        "product_series": "ConvergedStorage",
        "product_models": [],
    },
    {
        "product_version": "V300R001C00SPC100",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R001C20",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R001C21",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
    {
        "product_version": "V300R001C30",
        "required_patch": NO_FIX_PATCH,
        "product_series": "Dorado",
        "product_models": [],
    },
]


def execute(context, is_replace_controller=False):
    """更换控制器前检查版本补丁

    :param context: python上下文
    :param is_replace_controller: 是否是换控场景
    :return:
    """
    try:
        patch_list = COMMON_REQUIRED_PATCH_LIST
        if is_hypermetro_version(context) and is_hypermetro_service(context):
            patch_list = get_hypermetro_patch_list()
        ctrl_patch_func = ControllerPatchFunction(context)
        if ctrl_patch_func.is_patch_scene(is_replace_controller):
            BaseFactory.log.info(context,
                                 "Patch Switch Open, Scene Verify Pass.")
            patch_list = REQUIRED_PATCH_LIST_FOR_6U4C_PATCH
            context[BEGIN_TIME_KEY] = ctrl_patch_func.get_system_current_time()

        # 检查版本补丁
        flag, dev_version, dev_patch, dev_model, required_patch = \
            check_required_hot_patch.execute(context, patch_list)

        if not flag:
            # 检查不通过
            if required_patch and required_patch != NO_FIX_PATCH:
                BaseFactory.result.setResultFailByKey(
                    context, "PATCH_VERSION_LOW", None, required_patch)
            else:
                BaseFactory.result.setResultFailByKey(
                    context, "PATCH_VERSION_LOW_NO_FIX", None, None)
            return
        # 弹框高危提示，做提示框（只有确定按钮）
        if contextUtil.getItem(context, "is_patch_scene"):
            dialog_util = context['dialogUtil']
            lang = contextUtil.getLang(context)
            msg = commonFunction.getRes(lang, "controller_replace_tdm_warning_info")
            dialog_util.showInfoDialog(msg)
        BaseFactory.result.setResultPass(context)
        return
    except Exception:
        BaseFactory.log.error(context, str(traceback.format_exc()))
        BaseFactory.result.setResultFailByKey(
            context, "PUBERR_UNEXPECTED_TOOL_ERROR")
        return


def get_hypermetro_patch_list():
    """获取双活场景下的补丁要求列表

    :param common_list: 通用场景补丁列表
    :return:
    """
    return COMMON_REQUIRED_PATCH_LIST + HYPERMETRO_REQUIRED_PATCH_LIST


def is_hypermetro_version(context):
    """版本是否涉及双活判断版本

    :param context:
    :return:
    """
    cli = contextUtil.getCli(context)
    lang = contextUtil.getLang(context)

    # 获取当前设备的型号/软件版本/补丁
    flag, dev_model, err_msg = cliUtil.getProductModel(cli, lang)
    if not flag:
        raise Exception("can not get product model: %s" % err_msg)
    flag, dev_version, dev_patch = cliUtil.getSystemVersion(cli, lang)
    if not flag:
        raise Exception("can not get product version")
    dev_series = \
        "Dorado" if "dorado" in dev_model.lower() else "ConvergedStorage"

    for patch_info in HYPERMETRO_REQUIRED_PATCH_LIST:
        product_version = patch_info.get("product_version")
        product_series = patch_info.get("product_series")
        if product_series == dev_series and product_version == dev_version:
            return True

    return False
