#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.
"""
@version: SmartKit V200R006C00
@time: 2019/08/09 
@file: enclosure.py 
@function: 
@modify: 
"""
from cbb.business.operate.fru.common import FuncFactory
from cbb.business.operate.fru.common import commonFunction
from cbb.common.conf.v6HighEnd.fullBayConf import EXP_DAE_CONF
from cbb.frame.rest import restUtil
from cbb.frame.rest import restData


def getOriginalDaeNamesByLocs(daeLocs, daeEnclosureType='SMART', backendNetMode='non_share'):
    """Dorado V6 支持硬盘框ID的修改，需要通过硬盘框位置获取到修改前的硬盘框ID，然后作为硬盘框推荐位置算法的输入。

    :param daeLocs: 硬盘框位置列表、元组、集合等可迭代数据结构。
    :param daeEnclosureType:硬盘框类型（SAS/SMART）
    :param backendNetMode:后端组网类型（share/non_share)
    :return: 硬盘框原始ID列表,如硬盘框位置不合法或者为空，返回None或者空列表.
    """
    if not daeLocs:
        return []

    allSupportDaes = EXP_DAE_CONF.get(daeEnclosureType, {}).get(backendNetMode, [])
    daeNames = []
    for daeLoc in daeLocs:
        daeBayName, daeLocU = daeLoc.split('.')
        locationU = int(daeLocU[:-1])
        daeItr = filter(lambda dae: dae.bayName == daeBayName and dae.locationU == locationU, allSupportDaes)
        if list(daeItr):
            daeNames.append(list(daeItr)[0].name)

    return daeNames


def get_all_disk_enc_list(context):
    """获取系统中所有的硬盘框记录

    :param context:
    :return:
    """
    fruList = FuncFactory.getFruListInfo(context,
                                         restData.Enum.ObjEnum.ENCLOSURE)
    if not fruList:
        return fruList

    # 将所有的硬盘框进行筛选
    condition0 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.Enclosure.LOGIC_TYPE,
        restData.Enum.ConditionTypeEnum.EQ,
        restData.Enum.EnclosureTypeEnum.EXP)

    # 支持的硬盘框列表
    encloList_2U_4U = restUtil.Tlv2Rest.getMultiConditionValueList(
        restData.Enum.EnclosureModelEnum.EXPSAS2U_12,
        restData.Enum.EnclosureModelEnum.EXPSAS2U_24,
        restData.Enum.EnclosureModelEnum.EXPSAS4U,
        restData.Enum.EnclosureModelEnum.EXPSAS4U_75,
        restData.Enum.EnclosureModelEnum.EXPFC,
        restData.Enum.EnclosureModelEnum.EXPSAS2U_25,
        restData.Enum.EnclosureModelEnum.EXPSAS2U_25_12GLINK,
        restData.Enum.EnclosureModelEnum.EXPSAS4U_24_NEW,
        restData.Enum.EnclosureModelEnum.EXP_12G_SAS_4U_75,
        restData.Enum.EnclosureModelEnum.CTRL_12GSAS_4U24_EAR_12GLINK,
        restData.Enum.EnclosureModelEnum.EXP2U_JBOF,
        restData.Enum.EnclosureModelEnum.EXP_SAS2U_25,
        restData.Enum.EnclosureModelEnum.EXP_SAS4U_24,
        restData.Enum.EnclosureModelEnum.EXP2U_JBOF,
        restData.Enum.EnclosureModelEnum.EXP_IPSAS_2U_25,
        restData.Enum.EnclosureModelEnum.EXP_IPSAS_2U_12,
        restData.Enum.EnclosureModelEnum.EXP_IPNVMe_2U_36
    )
    condition1 = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.Enclosure.MODEL,
        restData.Enum.ConditionTypeEnum.EQOR,
        encloList_2U_4U)
    conditionList = restUtil.Tlv2Rest.getConditionList(condition0, condition1)
    fruList = restUtil.Tlv2Rest.filter(fruList, conditionList)
    return fruList


def get_high_density_enclosure(context):
    """ 获取系统中的高密框ID列表

    :param context: 上下文
    :return:
    """
    # 所有硬盘框
    all_disk_enc_list = get_all_disk_enc_list(context)

    # 高密框model列表
    high_density_model = restUtil.Tlv2Rest.getMultiConditionValueList(
        restData.Enum.EnclosureModelEnum.EXPSAS4U_75,
        restData.Enum.EnclosureModelEnum.EXP_12G_SAS_4U_75,
    )

    condition = restUtil.Tlv2Rest.getCondition(
        restData.Hardware.Enclosure.MODEL,
        restData.Enum.ConditionTypeEnum.EQOR,
        high_density_model)
    conditionList = restUtil.Tlv2Rest.getConditionList(condition)
    high_density_records = restUtil.Tlv2Rest.filter(all_disk_enc_list,
                                                    conditionList)
    return list(map(lambda record: str(restUtil.Tlv2Rest.getRecordValue(
        record, restData.Hardware.Enclosure.ID)), high_density_records))


def is_4U_ctrl_enc(context):
    """判断控制框框高是否为4U

    :param context:
    :return:
    """
    ctrl_enc_height = commonFunction.getCtrlEncHight(context)
    return ctrl_enc_height == 4


def is_6U_ctrl_enc(context):
    """判断控制框框高是否为6U

    :param context:
    :return:
    """
    ctrl_enc_height = commonFunction.getCtrlEncHight(context)
    return ctrl_enc_height == 6


def is_4C_ctrl_enc(context):
    """判断是否4控控制框

    :param context:
    :return:
    """
    ctrl_enc_height = commonFunction.getCtrlEncHight(context)
    return ctrl_enc_height >= 4
