# coding: utf-8
from cbb.business.operate.fru.common import BaseFactory
from cbb.business.operate.fru.common import FuncFactory
from cbb.frame.rest import restData
from cbb.frame.rest.restUtil import Tlv2Rest


def getCurrentSystemAlarms(context, alarmIds=None, alarmLevels=None, alarmsParms=None):
    """查询所有告警信息

    :param context:
    :param alarmIds: 16进制告警ID或者ID列表
    :param alarmLevels:
    :return:
    """

    if not alarmIds:
        return []

    currentAlarmList = []
    # 获取系统中的所有告警
    retVal = FuncFactory.getSysAlarmsInfo(context)
    if not retVal or not retVal.get("succ", False):
        BaseFactory.result.setResultFailByKeys(context, FuncFactory.LangKey.FUNC_GET_SYS_ALARM_FAIL,
                                               FuncFactory.LangKey.PUBSUG_CONTACT_TECH_SPT_ENGINEER_FOR_HELP)
        return None

    if retVal["info"] is None or not retVal["info"]:
        return currentAlarmList

    unitIds = covertId(context, alarmIds)

    # 获取所有的告警ID
    for alarmInfo in retVal["info"]:
        almId = Tlv2Rest.getRecordValue(alarmInfo, restData.Sys.Alarm.CMO_ALARM_ID)
        # 转换为16进制
        # python2.x默认长整数会加L;python3不区分长整数，只有int. 故手动去掉L
        hexAlmId = hex(almId).rstrip("L")
        BaseFactory.log.info(context, "hexAlmId is : %s" % hexAlmId)
        almLevel = Tlv2Rest.getRecordValue(alarmInfo, restData.Sys.Alarm.CMO_ALARM_LEVEL)

        if alarmLevels and (isinstance(alarmLevels, list) or isinstance(alarmLevels, tuple)
                            or isinstance(alarmLevels, set)) and almLevel not in alarmLevels:
            continue

        if alarmIds and (isinstance(alarmIds, list) or isinstance(alarmIds, tuple)
                         or isinstance(alarmIds, set)) and almId not in unitIds:
            continue

        if alarmsParms:
            params = Tlv2Rest.getRecordValue(alarmInfo, restData.Sys.Alarm.CMO_ALARM_PARMETER)
            BaseFactory.log.info(context, "alarm params is : %s" % str(params))
            if isinstance(alarmIds, list):
                result = len(filter(lambda param: param in params, alarmsParms)) > 0
            else:
                result = alarmsParms in params
            if not result:
                continue

        almSequence = Tlv2Rest.getRecordValue(alarmInfo, restData.Sys.Alarm.CMO_ALARM_SEQUENCE)
        currentAlarmList.append([almSequence, hexAlmId])
    BaseFactory.log.info(context, "currentAlarmList is : %s" % str(currentAlarmList))
    return currentAlarmList


def covertId(context, alarmIds):
    """转换为int ID

    :param context:
    :param alarmIds:
    :return:
    """
    unitIds = []
    try:
        if not alarmIds:
            return unitIds
        for id in alarmIds:
            unitId = int(id, 16)
            unitIds.append(unitId)
        return unitIds
    except Exception as e:
        BaseFactory.log.error(context, "parse hex id to int error : %s" % str(e))
        return unitIds
