# -*- coding: UTF-8 -*-

from cbb.frame.cli.cliUtil import excuteCmdInCliMode
from cbb.frame.cli.cliUtil import getVerticalCliRet
from cbb.frame.cli.cliUtil import queryResultWithNoRecord
from cbb.frame.cli.cliUtil import getHorizontalCliRet, \
    getHorizontalNostandardCliRet
import re


def get_host_info(cli, lang, hostId):
    cmd = "show host general host_id=%s" % hostId
    checkRet = excuteCmdInCliMode(cli, cmd, True, lang)
    cliRet = checkRet[1]
    if checkRet[0] is not True:
        return (False, cliRet, {})

    cliRetLinesList = getVerticalCliRet(checkRet[1])
    for info in cliRetLinesList:
        hostId = info.get("ID")
        opSystem = info.get("Operating System")
        if hostId or opSystem:
            return (True, cliRet, info)

    return (False, cliRet, {})


def get_host_dict(cli, lang):
    '''
    @summary: 获取主机信息
    @return: hostInfo:{ID:{Name:host1,Operating System:Linux}}
    '''
    hostInfo = {}
    cmd = "show host general"
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return (flag, cliRet, errMsg, hostInfo)

    if queryResultWithNoRecord(cliRet):
        return (True, cliRet, errMsg, hostInfo)

    cliRetLinesList = getHorizontalNostandardCliRet(cliRet)
    for info in cliRetLinesList:
        hostId = info.get("ID")
        hostInfo[hostId] = info

    return (True, cliRet, "", hostInfo)


def get_host_initiator_fc(cli, lang, hostId):
    cmd = "show initiator initiator_type=FC host_id=%s" % hostId
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return flag, cliRet, errMsg, []

    initiators = getHorizontalCliRet(cliRet)
    return flag, cliRet, errMsg, initiators


def get_host_initiator_iSCSI(cli, lang, hostId):
    cmd = "show initiator initiator_type=iSCSI host_id=%s" % hostId
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return flag, cliRet, errMsg, []

    initiators = getHorizontalCliRet(cliRet)
    return flag, cliRet, errMsg, initiators


def get_host_initiator_ib(cli, lang, hostId):
    cmd = "show ib_initiator general host_id=%s" % hostId
    flag, cliRet, errMsg = excuteCmdInCliMode(cli, cmd, True, lang)
    if flag is not True:
        return flag, cliRet, errMsg, []

    initiators = getHorizontalCliRet(cliRet)
    return flag, cliRet, errMsg, initiators


def get_patch_value(hot_patch):
    """
    获取补丁的值
    :param hot_patch: 补丁
    :return: 补丁的数字版本
    """
    pattern_hot_patch = re.compile(r"SPH(\d+)", flags=re.IGNORECASE)
    match_hot_path = pattern_hot_patch.search(hot_patch)
    if match_hot_path:
        return int(match_hot_path.group(1))
    return 0
