# coding:utf-8
""" 
@version: Toolkit V200R005C00
@time: 2019/06/06 
@file: logger.py 
@function: 
@modify: 
"""
import logging
import logging.config
import os
import sys
from com.huawei.ism.tool.obase.utils import ApplicationContext


class Logger(object):
    def __init__(self, curFile=__file__):
        try:
            workingPth = ApplicationContext.getInstance().getWorkPath()
            logPthName = os.path.join(workingPth, "log", "py.log")
            loggerName = os.path.split(workingPth)[-1]
        except:
            workingPth = '.'
            logPthName = os.path.join(workingPth, "test.log")
            loggerName = 'test'

        self.logger = logging.getLogger(loggerName)
        fh = logging.FileHandler(logPthName)
        fmt = "[%(asctime)s] [%(levelname)s] [" + loggerName \
              + "][" + curFile + "] %(message)s"
        formatter = logging.Formatter(fmt)
        fh.setFormatter(formatter)
        self.logger.addHandler(fh)
        self.logger.setLevel('DEBUG')

    def getCallBackInfo(self):
        funcBack = sys._getframe().f_back.f_back
        infoFormat = "[%s:%s]"

        if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
            funcName = funcBack.f_code.co_name
            lineNumber = funcBack.f_lineno
            return infoFormat % (str(funcName), str(lineNumber))
        return ''

    def debug(self, msg, *args, **kwargs):
        callBackInfo = self.getCallBackInfo()
        msg = callBackInfo + msg
        self.logger.debug(msg, *args, **kwargs)

    def info(self, msg, *args, **kwargs):
        callBackInfo = self.getCallBackInfo()
        msg = callBackInfo + msg
        self.logger.info(msg, *args, **kwargs)

    def warn(self, msg, *args, **kwargs):
        callBackInfo = self.getCallBackInfo()
        msg = callBackInfo + msg
        self.logger.warn(msg, *args, **kwargs)

    def warning(self, msg, *args, **kwargs):
        callBackInfo = self.getCallBackInfo()
        msg = callBackInfo + msg
        self.logger.warn(msg, *args, **kwargs)

    def error(self, msg, *args, **kwargs):
        callBackInfo = self.getCallBackInfo()
        msg = callBackInfo + msg
        self.logger.error(msg, *args, **kwargs)

    def critical(self, msg, *args, **kwargs):
        callBackInfo = self.getCallBackInfo()
        msg = callBackInfo + msg
        self.logger.critical(msg, *args, **kwargs)


if __name__ == '__main__':
    loger = Logger()
    loger.error("hello world")
