# -*- coding: UTF-8 -*-
from common.log import Log
from common.xmlParser import parseXMLFile
from common.result import setResultFail, setResultSucc
from common.commonFunction import excuteCmd
from common.constant import CMD
from frame.context.contextUtil import setItem, getCli, getLang, getConnectorFactoryObj, getDevObj
from frame.cli.cliUtil import getVerticalCliRet
from frame.cli.cliUtil import getProductVersion, getMsg
import traceback
import os
from com.huawei.ism.tool.obase.exception import PwdException
from common.constant import SCRIPT_RET_CODE


def execute(context):
    '''
    @summary: 框架默认入口函数
    '''
    try:
        initLog(context)
        
        #检查用户名称是否非法（部分关键字作为用户名将影响CLI执行结果判断）
        loginUserName = context.get("dev").getLoginUser().getUserName()
        Log.info("loginUserName is %s" % str(loginUserName))
        
        isPass = checkLoginUserName(loginUserName)
        if not isPass:
            return setResultFail(context, "loginUser.name.check.failure")
        
        isPass, errMsg = checkConnection(context)
        if not isPass:
            return (SCRIPT_RET_CODE.FAIL, errMsg)
           
        if not canExecCliCmd(context):
            return setResultFail(context, "systemStatus.abmormal.errMsg")
            
        #解析标准收集项的配置文件
        (isSuccess, cmd4IBMSxmlInfo) = parseCmd4IBMSxmlFile(context)
        (isSuccess, cmd4ExcelxmlInfo) = parseCmd4ExcelxmlFile(context)
        if not isSuccess:
            return setResultFail(context, "parse.xml.cmdxml.fail.errMsg")
        else:
            setItem(context, "cmd4IBMS", cmd4IBMSxmlInfo)
            setItem(context, "cmd4Excel", cmd4ExcelxmlInfo)
        
    except Exception, ex:
        Log.error("Failed to execute prepare file, because %s" % str(traceback.format_exc()))
        return setResultFail(context, "prepare.fail.errMsg")
        
    return setResultSucc()


def initLog(context):
    Log(context)


def parseCmd4IBMSxmlFile(context):
    isSuccess = True
    cmd4IBMSxmlInfo = None
    try:
        cmd4IBMSxmlFile = os.path.join(context.get("path"), "script", "config", "cmd4IBMS.xml")
        cmd4IBMSxmlInfo = parseXMLFile(cmd4IBMSxmlFile)
    except Exception, ex:
        isSuccess = False
        Log.error("Failed to parse xml file, because %s" % str(traceback.format_exc()))
    finally:
        return (isSuccess, cmd4IBMSxmlInfo)
    
def parseCmd4ExcelxmlFile(context):
    isSuccess = True
    cmd4ExcelxmlInfo = None
    try:
        cmd4ExcelxmlFile = os.path.join(context.get("path"), "script", "config", "cmd4Excel.xml")
        cmd4ExcelxmlInfo = parseXMLFile(cmd4ExcelxmlFile)
    except Exception, ex:
        isSuccess = False
        Log.error("Failed to parse xml file, because %s" % str(traceback.format_exc()))
    finally:
        return (isSuccess, cmd4ExcelxmlInfo)


def canExecCliCmd(context):
    (isSuccess, cliRet, errMsg) = excuteCmd(context, CMD.SHOW_SYSTEM_GENERAL)
    dictList = getVerticalCliRet(cliRet)
    if dictList == [] or dictList[0]["System Name"] == "":
        return False
    return True


RE_CONNECTION_TIMES = 3
def checkConnection(context):
    cliConnection = None
    errMsg = ""
    
    connectorFactory = getConnectorFactoryObj(context)
    devObj = getDevObj(context)
    
    reConnectionTimes = 0
    while cliConnection is None and reConnectionTimes < RE_CONNECTION_TIMES:
        sshConnector = connectorFactory.createSshForwardConnector(devObj)
        try:
            cliConnection = sshConnector.getConnectionForPwdWillExpireBreak()
        except PwdException, ex:
            Log.error("checkConnection failed, because the password expire!")
            errMsg = ex.getErrorMsg()
            return False, errMsg
        except:
            lang = getLang(context)
            errMsg = getMsg(lang, "dev.conn.failure")
        finally:
            reConnectionTimes += 1
            
    if cliConnection is None:
        Log.error("checkConnection failed, because can not create cli connection!")
        return False, errMsg
    else:
        Log.info("checkConnection success!")
        return True, errMsg

          
USER_NAME_BLACK_LIST = ["developer", "diagnose", "error", "password", "upgrade", "minisystem", "storage"]
def checkLoginUserName(loginUserName):
    '''
    @summary: 检查工具登录用户名称是否为特殊用户名
    '''
    
    loginUserName = loginUserName.lower()
    
    for keyWords in USER_NAME_BLACK_LIST:
        if loginUserName.endswith(keyWords):
            return False
    
    return True
