# -*- coding: UTF-8 -*-
from frame.cli.cliUtil import excuteCmdInCliMode, excuteCmdInDeveloperMode,getUserPrivilege, getMsg
from frame.context.contextUtil import initCliConnection, getCli, getLang ,getSftp
import re
from common.constant import PRODUCT_MODEL,CONFIG
from common.log import Log
import time
import os
import traceback

def excuteCmd(context, commond):
    initCliConnection(context)   
    cli = getCli(context)
    lang = getLang(context)
    return excuteCmdInCliMode(cli, commond, True, lang)

def excuteCmdInDeveloper(context, commond):
    initCliConnection(context)   
    cli = getCli(context)
    lang = getLang(context)
    return excuteCmdInDeveloperMode(cli, commond, True, lang)

def getTitleFromXmInfo(xmInfo):
    '''
    @summary: 从xml信息中解析出收集项中对应的cli回显中的字段
    @param xmInfo: 解析xml后的信息(一个嵌套的字典)
    @return: 收集项的title（一个字典列表）
    ''' 
    stdItemTitleListMap = {}
    collectItemNodes = xmInfo["elementChildEles"]
    
    for collectItemNode in collectItemNodes:
        collectItemName = collectItemNode["elementAttrbutes"]["name"]
        cmdNodes = collectItemNode["elementChildEles"]
        
        stdItemTitleList = []
        for cmdNode in cmdNodes:
            if cmdNode["elementName"] != "cmd":
                continue
            
            attrsNode = cmdNode["elementChildEles"][0]
            attrNodes = attrsNode["elementChildEles"]
            for attrNode in attrNodes:
                collectText = attrNode["elementText"]
                stdItemTitleList.append(collectText)
                
        stdItemTitleListMap[collectItemName] = stdItemTitleList 
    
    return  stdItemTitleListMap

def getHorizontalCliTiltle(cliRet):
    '''
    @summary: 按逐行字典的方式获取水平表格形式的cli回显的title
    @param cliRet: cli回显
    @return: cli回显表头title，获取失败返回空集合
    '''
    titleList = []
    try:
        headline = ""
        i = 0
        cliRetList = cliRet.encode("utf8").splitlines()
        for line in cliRetList:
            reg_headline = re.compile("^\s*-+(\s+-+)*\s*$") 
            match_headline = reg_headline.search(line)
            if match_headline:
                headline = match_headline.group()
                break
            i += 1
        if headline == "" or i == 0 or i >= len(cliRetList) - 1:
            return titleList
        
        titleLine = cliRetList[i - 1]
        field_words = cliRetList[(i + 1):]
        reg_split = re.compile("\s*-+\s*")
        tuple_idxs = []
        start_pos = 0
        end_pos = 0
        
        while (start_pos <= len(headline)):
            match = reg_split.search(headline, start_pos)
            if match:
                end_pos = match.end()
                tuple_idxs.append((start_pos, end_pos))
                start_pos = end_pos
            else:
                break
            
        for item in tuple_idxs:
            title = titleLine[item[0]:item[1]].strip()
            if titleList.count(title) == 1:
                continue
            titleList.append(title.decode("utf8"))
    except:
        return titleList
            
    return titleList

CLI_RET_END_FLAG = ":/>"
def getVerticalCliTiltle(cliRet):
    '''
    @summary: 按逐行字典的方式获取垂直表格形式的cli回显的title
    @param cliRet: cli回显
    @return: cli回显表头title，获取失败返回空集合
    '''
    titleList = []
    cliRetList = cliRet.encode("utf8").splitlines()
    for line in cliRetList:
        if CLI_RET_END_FLAG in line:
            break
        if re.search("^-+\r*\n*$", line):
            return titleList    
        fields = line.split(" : ")
        if len(fields) < 2:
            continue
        title = fields[0].strip().decode("utf8")
        if titleList.count(title) == 1:
            continue
        titleList.append(title.decode("utf8"))
    return titleList

def checkSystemNormal(context):
        '''
                    函数名称: checkSystemNormal
                    功能说明: 检验当前设备是否normal
                    输入参数: context
                    输出参数: True, False
        '''
        flag = False
        cmd = "show system general"        
        (isSuccess, cliRet,errMsg) =  excuteCmd(context, cmd)
        if not isSuccess:
            lang = getLang(context)
            errMsg = getMsg(lang, "dev.conn.failure")
            return False ,errMsg
        
        if re.search("System Name", cliRet, re.IGNORECASE):
            flag = True ,errMsg
        else:
            errMsg = getMsg(lang,  'system.abnormal')
            return False ,errMsg
        return flag ,errMsg

def checkUserPrivilege(context, type=None):
        '''
        @summary: 检查用户权限，用户权限为["Super_admin" 或  "Admin"],则返回True，否则返回False
        @param cliRet: context=上下文对象
        @return: userLevel
        '''
        cli = getCli(context)
        lang = getLang(context)
        result = False
        (isSuccess, userLevel,errMsg) = getUserPrivilege(cli, lang)
        if not isSuccess:
            lang = getLang(context)
            errMsg = getMsg(lang, "dev.conn.failure")
            return False ,errMsg
        
        privileges = ["Super_admin", "Admin"]
            
        if userLevel in privileges:
            result = True
        else:
            errMsg = getMsg(lang, "user.level.low")
            return False ,errMsg
        return result,errMsg

def getCurrentDate():
        '''
        @summary: 获取本地当前时间
        @param cliRet: devObj=上下文对象
        @return: localDir
        '''
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result


           
def getLocalDir(context):
        '''
        @summary: 获取用户选择的路径
        @param cliRet:  devObj=上下文对象
        @return: localDir:用户选择的路径
        '''
        localDir = context.get("configFileLocalPath")
        return localDir

       
def deleteRemoteFile(context, type, cliRet):
        '''
        @summary: 删除阵列端生成的文件
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        rec=CLI回显信息
        @return:Bool(True or False)
        '''
        #根据CLI回显信息判断当前环境下，是否允许删除
        tempList = CONFIG.DELETE_REMOTE_DATA_STANDARD
        deleteFlag = True
        for standard in tempList:
            if standard in cliRet:
                deleteFlag = False
                break
            
        if deleteFlag:
            strCmd = "delete file filetype=" + type
                        
            excuteCmd(context, strCmd)
                    
def downloadFile(context, type, cliRet):
        '''
        @summary: 下载收集到得文件信息到本地
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        cliRet=命令执行成功的回显
        @return: True or False
        '''
        try:
            """通过SFTP下载文件，并和框架侧交互，将文件或者文件路径反馈给框架，最终生成档案收集结果"""
            
            devObj = context.get("dev")
            productSn = devObj.deviceSerialNumber
            userlocalDir =getLocalDir(context)
            ip =devObj.getIp()
            
            #当IP为IPV6格式时，工具进行兼容
            ip = str(ip).replace(":",".")
            Log.info("current IP is :%s " %str(ip))
            
            #获取阵列端存放信息的路径和文件名称
            listRemotePaths = getRemotePathAndName(context, cliRet)
            
            #获取时间戳
            productTime = getCurrentDate()                      
            
            localDir = userlocalDir + os.path.sep + ip 
            Log.info("localDir is :%s " %str(localDir))
            if not os.path.exists(localDir):
                os.makedirs(localDir)
                
            #下载运行数据到本地的目录信息
            sftp = getSftp(context)
            for temp in listRemotePaths:
                runningDataName = temp["name"]
                #分离文件名与扩展名
                runDataNamelist = os.path.splitext(runningDataName)
                fileName = runDataNamelist[0]
                fileNameExtension = runDataNamelist[1]
                newRunningDataName = "%s_%s_%s%s" %(str(fileName), str(productSn), str(productTime), str(fileNameExtension))
                
                #阵列文件路径
                serverPath = temp["path"]
                
                #通过SFTP协议将阵列文件下载到本地
                sftp.getFile(str(serverPath),localDir, None)
                
                #更改文件名名称，加上SN号和时间戳
                os.rename(unicode(localDir + os.path.sep + runningDataName), unicode(localDir + os.path.sep + newRunningDataName))                
                Log.info( "get file success, and delete file")
                #删除阵列段文件
                deleteRemoteFile(context, type, cliRet)
                
            return True
        except:
            Log.info("except trace back:" + str(traceback.format_exc()))
            return False
    
def getRemotePathAndName(context, cliRet):
        '''
        @summary: 获取阵列端的文件名称和路径
        @param cliRet:  context=上下文对象
        @return: name:阵列端产生的文件名称
                 path:阵列端产生的文件的路径
        '''
        resultList = []
        cliRetList = cliRet.splitlines()
        for line in cliRetList:
            #判断回显是否正常
            if CONFIG.COLLECT_INFO_RECROD_STANDARD in line:
                tempDict = {}
                tempList = line.split(" : ")
                path = tempList[1]
                tempList1 = path.split("/")
                name = tempList1[-1]
                tempDict["path"] = path
                tempDict["name"] = name
                resultList.append(tempDict)
        
        return resultList
    
def isExistCmdForRec(rec):
        '''
                    根据命令回显信息，判断当前命令是否在系统中存在
                    判断标准：若在回显中出现 '^'符号，则当前命令不存在
        '''
        CLI_NOT_EXIST_FLAG = "^"
        if None == rec:
            return False
        
        if CLI_NOT_EXIST_FLAG in rec:
            return False
        
        return True
    
    
    