# -*- coding: UTF-8 -*-
from frame.context.contextUtil import getResource
from common.constant import SCRIPT_RET_CODE


def setResultFail(context, errMsg, errParam=None):
    errMsg = getErrMsgFromLanguageFile(context, errMsg, errParam)
    return (SCRIPT_RET_CODE.FAIL, errMsg)


def setResultSucc():
    return (SCRIPT_RET_CODE.SUCCESS, "")
    

def setResultPartSucc(context, errMsg, errParam=None):
    errMsg = getErrMsgFromLanguageFile(context, errMsg, errParam)
    return (SCRIPT_RET_CODE.PART_SUCCESS, errMsg)
    

def getErrMsgFromLanguageFile(context, errMsgKey, errParam=None):
    lang = context["lang"]
    errMsg = getResource(context, lang, errMsgKey)
    try:
        if errParam != None:
            errMsg = errMsg % errParam
    except:
        pass
    return errMsg            
            
                
